<?php
	$pego_prefix="pego_";
	$themedir = get_template_directory_uri();
	
	load_theme_textdomain('furniot',get_template_directory() . '/languages');

/***************************************************************  
Javascript files include
***************************************************************/
	function pego_javascripts() {
		wp_enqueue_script('superfish', get_template_directory_uri() . '/js/superfish.js','','',true);
		wp_enqueue_script('inview', get_template_directory_uri() . '/js/inview.js','','',true);
		wp_enqueue_script('modernizr-custom', get_template_directory_uri() . '/js/modernizr.custom.js','','',true);
		wp_enqueue_script('easyTooltip', get_template_directory_uri() . '/js/easyTooltip.js','','',true);
		wp_enqueue_script('flexslider-min', get_template_directory_uri() . '/js/jquery.flexslider-min.js','','',true);
		wp_enqueue_script('backstretch', get_template_directory_uri() . '/js/jquery.backstretch.min.js','','',true);
		wp_enqueue_script('easy-pie-chart', get_template_directory_uri() . '/js/jquery.easy-pie-chart.js','','',true);
		wp_enqueue_script('organictabs', get_template_directory_uri() . '/js/organictabs.jquery.js','','',true);
		wp_enqueue_script('isotope', get_template_directory_uri() . '/js/jquery.isotope.min.js','','',true);
		wp_enqueue_script('fancybox', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.pack.js','','',true);		
		wp_enqueue_script('fancybox-buttons', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-buttons.js','','',true);		
		wp_enqueue_script('fancybox-media', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-media.js','','',true);	
		wp_enqueue_script('cbpFWSlider', get_template_directory_uri() .'/js/jquery.cbpFWSlider.min.js','','',true);					
		wp_enqueue_script('custom', get_template_directory_uri() . '/js/custom.js','','',true);		
		
		
		wp_enqueue_script('like_post', get_template_directory_uri().'/js/post-like.js', array('jquery'), '1.0', 1 );
		wp_localize_script('like_post', 'ajax_var', array(
			'url' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce('ajax-nonce')
		));
	}
	add_action('wp_enqueue_scripts', 'pego_javascripts');	
	
	
	
/***************************************************************  
Style files include
***************************************************************/
	function pego_theme_styles() { 
		global $pego_prefix;
		wp_enqueue_style( 'widgets-style', get_template_directory_uri() . '/css/widgets.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'shortcodes-style', get_template_directory_uri() . '/css/shortcodes.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'blog-portfolio-style', get_template_directory_uri() . '/css/blog-portfolio.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'flexslider-style', get_template_directory_uri() . '/css/flexslider.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'fancybox-default-style', get_template_directory_uri() . '/js/fancybox/jquery.fancybox.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'fancybox-helper-style', get_template_directory_uri() . '/js/fancybox/helpers/jquery.fancybox-buttons.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'default-style', get_template_directory_uri() . '/style.css', array(), '1.0', 'all' );	
		// responsive theme?
		if (get_option($pego_prefix.'responsive_theme') != 'false') {
				wp_enqueue_style( 'media-style', get_template_directory_uri() . '/css/media.css', array(), '1.0', 'all' );	
		}	
			
	}	
	add_action('wp_enqueue_scripts', 'pego_theme_styles');	


/***************************************************************  
Added support for post thumbnails
***************************************************************/
	if ( function_exists( 'add_image_size' ) ) add_theme_support( 'post-thumbnails' );
	
	if ( function_exists( 'add_image_size' ) ) { 
		add_image_size('PortfImg', 470, 313, true);
	}
	
/***************************************************************  
Added support for post formats
***************************************************************/	
add_theme_support( 'post-formats', array( 'image', 'video', 'gallery', 'quote', 'link', 'audio' ) );	
	
add_theme_support( 'automatic-feed-links' );	
	
	
/***************************************************************  
Specify content width
***************************************************************/
	if ( ! isset( $content_width ) ) $content_width = 960;
	
/***************************************************************  
Pagination
***************************************************************/
	function pego_pagination($pages = '', $range = 2)
	{  
		 $showitems = ($range * 2)+1;  

		 global $paged;
		 if(empty($paged)) $paged = 1;

		 if($pages == '')
		 {
			 global $wp_query;
			 $pages = $wp_query->max_num_pages;
			 if(!$pages)
			 {
				 $pages = 1;
			 }
		 }   
			
		 if(1 != $pages)
		 {
			 echo "<div class='pagination'>";
			 if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>First &laquo;</a>";
			 if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>Previous &lsaquo;</a>";

					
				
			 for ($i=1; $i <= $pages; $i++)
			 {
				 if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
				 {
					 echo ($paged == $i)? "<span class='current'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a>";
				 }
			 }
			 

			 if ($paged < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($paged + 1)."'>Next &rsaquo;</a>";  
			 if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>Last &raquo;</a>";
			 echo "</div>\n";
		 }
	}

	
/***************************************************************  
Include php files
***************************************************************/	
	define('PEGO_FILEPATH', get_template_directory());
	define('PEGO_DIRECTORY', get_template_directory_uri());
	define( 'OPTIONS', 'furniot_options' );
	
	require_once (PEGO_FILEPATH . '/admin/admin-functions.php');
	require_once (PEGO_FILEPATH . '/admin/admin-interface.php');
	include("functions/custom-page.php");
	include("functions/custom-portfolio.php");
	include("functions/custom-post.php");
	include("functions/custom-sidebar.php");
	include("functions/custom-colorareas.php");
	include("functions/custom-gallery.php");
	include("functions/custom-faqs.php");
	include_once("pego-pb/pego-pb.php");	
	require_once (PEGO_FILEPATH . '/functions/theme-options.php');
	include("functions/twitteroauth.php");	
	include("functions/widget-twitter.php");
	include("functions/widget-flickr.php");	
	include("functions/widget-contact.php");	
	include("functions/widget-latest-portfolios.php");	
	include("functions/widget-latest-posts.php");	
	include("functions/widget-quick-info.php");
	include("functions/bra_social_media.php");		
	include("functions/soundcloud.php");	
	
/***************************************************************  
Add shortcode for serach form
***************************************************************/
add_shortcode('wpbsearch', 'get_search_form');	

/***************************************************************  
Register main menu
***************************************************************/
	if (function_exists('register_nav_menus')) {
		register_nav_menus (
			array (
				'main_nav' => 'Main Navigation Menu'
			)
		);
	}
	
/***************************************************************  
Get all icons
***************************************************************/	
function pego_get_all_icons() {

	
	$allIcons= array('plus', 'minus', 'info', 'left-thin', 'up-thin', 'right-thin', 'down-thin', 'level-up', 'level-down', 'switch', 'infinity', 'plus-squared', 'minus-squared', 'home', 'keyboard', 'erase', 'pause', 'fast-forward', 'fast-backward', 'to-end', 'to-start', 'hourglass', 'stop', 'up-dir', 'play', 'right-dir','down-dir', 'left-dir', 'adjust', 'cloud', 'star', 'star-empty', 'cup', 'menu', 'moon', 'heart-empty', 'heart', 'note', 'note-beamed', 'layout', 'flag', 'tools', 'cog', 'attention', 'flash', 'record', 'cloud-thunder', 'tape', 'flight', 'mail', 'pencil', 'feather', 'check', 'cancel', 'cancel-circled', 'cancel-squared', 'help', 'quote', 'plus-circled', 'minus-circled', 'right', 'direction', 'forward', 'ccw', 'cw', 'left', 'up', 'down', 'list-add', 'list', 'left-bold', 'right-bold', 'up-bold', 'down-bold', 'user-add', 'help-circled', 'info-circled', 'eye', 'tag', 'upload-cloud', 'reply', 'reply-all', 'code', 'export', 'print', 'retweet', 'comment', 'chat', 'vcard', 'address', 'location', 'map', 'compass', 'trash', 'doc', 'docs', 'doc-landscape', 'archive', 'rss', 'share', 'basket', 'shareable', 'login', 'logout', 'volume', 'resize-full', 'resize-small', 'popup', 'publish', 'window', 'arrow-combo', 'chart-pie', 'language', 'air', 'database', 'drive', 'bucket', 'thermometer', 'down-circled', 'left-circled', 'right-circled', 'up-circled', 'down-open', 'left-open', 'right-open', 'up-open', 'down-open-mini', 'left-open-mini', 'right-open-mini', 'up-open-mini', 'down-open-big', 'left-open-big', 'right-open-big', 'up-open-big', 'progress-0', 'progress-1', 'progress-2', 'progress-3', 'back-in-time', 'network', 'inbox', 'install', 'lifebuoy', 'mouse', 'dot', 'dot-2', 'dot-3', 'suitcase', 'flow-cascade', 'flow-branch', 'flow-tree', 'flow-line', 'flow-parallel', 'brush', 'paper-plane', 'magnet', 'gauge', 'traffic-cone', 'cc', 'cc-by', 'cc-nc', 'cc-nc-eu', 'cc-nc-jp', 'cc-sa', 'cc-nd', 'cc-pd', 'cc-zero', 'cc-share', 'cc-remix', 'github', 'github-circled', 'flickr', 'flickr-circled', 'vimeo', 'vimeo-circled', 'twitter', 'twitter-circled', 'facebook', 'facebook-circled', 'facebook-squared', 'gplus', 'gplus-circled', 'pinterest', 'pinterest-circled', 'tumblr', 'tumblr-circled', 'linkedin', 'linkedin-circled', 'dribbble', 'dribbble-circled', 'stumbleupon', 'stumbleupon-circled', 'lastfm', 'lastfm-circled', 'rdio', 'rdio-circled', 'spotify', 'spotify-circled', 'qq', 'instagram', 'dropbox', 'evernote', 'flattr', 'skype', 'skype-circled', 'renren', 'sina-weibo', 'paypal', 'picasa', 'soundcloud', 'mixi', 'behance', 'google-circles', 'vkontakte', 'smashing', 'db-shape', 'sweden', 'logo-db', 'picture', 'globe', 'leaf', 'graduation-cap', 'mic', 'palette', 'ticket', 'video', 'target', 'music', 'trophy', 'thumbs-up', 'thumbs-down', 'bag', 'user', 'users', 'lamp', 'alert', 'water', 'droplet', 'credit-card', 'monitor', 'briefcase', 'floppy', 'folder', 'doc-text', 'calendar', 'chart-line', 'chart-bar', 'clipboard', 'attach', 'bookmarks', 'book', 'book-open', 'phone', 'megaphone', 'upload', 'download', 'box', 'newspaper', 'mobile','signal', 'camera', 'shuffle', 'loop', 'arrows-ccw', 'light-down', 'light-up', 'mute', 'sound', 'battery', 'search', 'key', 'lock', 'lock-open', 'bell', 'bookmark', 'link', 'back', 'flashlight', 'chart-area', 'clock', 'rocket', 'block');	
	return $allIcons;
}


/***************************************************************  
Reading all the sliders
***************************************************************/
	
	function pego_get_slider_layer() {		
		global $wpdb;
		$values = array();
		// Table name
		$table_name = $wpdb->prefix . "layerslider";	 
		// Get sliders
		$sliders = $wpdb->get_results( "SELECT * FROM $table_name
											WHERE flag_hidden = '0' AND flag_deleted = '0'
											ORDER BY date_c ASC LIMIT 100" );	 
		// Iterate over the sliders
		if( is_array($sliders) ) {
			foreach($sliders as $key => $item) {
				$values[$item->id] = $item->name;	
			}
		}
		return $values;		
	}
	
	
	
/***************************************************************  
Get all sidebars
***************************************************************/	
function pego_get_all_sidebars() {
	$argsSidebars = array('post_type'=> 'sidebars', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
	$allSidebars = get_posts($argsSidebars);	
	$allSidebarss = array();
	$allSidebarss[0]=' ';
	if($allSidebars) {
		foreach($allSidebars as $singleSidebar)
		{ 
			setup_postdata($singleSidebar); 	
			$sidebarTitle = $singleSidebar->post_title;	
			$sidebarName= $singleSidebar->post_name;
			$allSidebarss[$singleSidebar->post_name] = $singleSidebar->post_title;										
		}
	}
	return $allSidebarss;
}
	
	
	
/***************************************************************  
Reading all Contact 7 Forms
***************************************************************/
	function pego_get_contact_forms() {
		$allContactForms7 = array();
		global $wpdb;		
		global $table_prefix;
		$table_prefix = $wpdb->base_prefix;
		$wpdb->tablename = $table_prefix . 'posts';
		$contact_forms7 = $wpdb->get_results( 
				"
				SELECT ID,post_title 
				FROM $wpdb->tablename
				WHERE post_type = 'wpcf7_contact_form'
				"
				);
		foreach ( $contact_forms7 as $contact_form7 ) 
		{	
			$allContactForms7[$contact_form7->ID] = $contact_form7->post_title;	
		}	
		return $allContactForms7;	
	
	}
	
	
/***************************************************************  
Get content from the builder
***************************************************************/										
	function get_pego_pb_content ($postID) {	
		$page_content = get_post_meta($postID,'pego-pb-element-shortcode', true);			
		if(!empty($page_content)){					
			$page_content_area = new DOMDocument();
			$page_content_area->loadXML($page_content);
			
			
			$page_items = $page_content_area->getElementsByTagName( "page-item" );						
			$pego_pb_shortcode_elements='';
			$sizeNumber=0;
			
			foreach( $page_items as $page_item){				
				$currentType = $page_item->getElementsByTagName( "type" );
				//izpis shortcodov
				if ($currentType->item(0)->nodeValue == "Column") {										
					$pego_pb_shortcode_elements = '[column_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" contentalign="'.$page_item->getElementsByTagName( "contentalign" )->item(0)->nodeValue.'" contentfont="'.$page_item->getElementsByTagName( "contentfont" )->item(0)->nodeValue.'" ]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/column_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Separator") {										
					$pego_pb_shortcode_elements = '[separator_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" height="'.$page_item->getElementsByTagName( "height" )->item(0)->nodeValue.'" color="'.$page_item->getElementsByTagName( "color" )->item(0)->nodeValue.'" tip="'.$page_item->getElementsByTagName( "tip" )->item(0)->nodeValue.'"]';	
				
				}
				if ($currentType->item(0)->nodeValue == "Quote") {										
					$pego_pb_shortcode_elements = '[main_quote_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" ]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/main_quote_shortcode]';		
				}	
				if ($currentType->item(0)->nodeValue == "List") {	
					$pego_pb_shortcode_elements = '[list_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" icon="'.$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';	
					//$list_items=$page_item->getElementsByTagName( "list_item" );
					$list_items=$page_item->getElementsByTagName( "list_parent" );
					
					foreach( $list_items as $list_item){
						$pego_pb_shortcode_elements .= '[list_li url="'.$list_item->getElementsByTagName( "list_url" )->item(0)->nodeValue.'"]'.$list_item->getElementsByTagName( "list_item" )->item(0)->nodeValue.'[/list_li]';
						
					}								
					$pego_pb_shortcode_elements .= '[/list_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Button") {										
					$pego_pb_shortcode_elements = '[button_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'"  button_type="'.$page_item->getElementsByTagName( "button_type" )->item(0)->nodeValue.'" url="'.$page_item->getElementsByTagName( "url" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" buttontarget="'.$page_item->getElementsByTagName( "buttontarget" )->item(0)->nodeValue.'"  ]'.$page_item->getElementsByTagName( "caption" )->item(0)->nodeValue.'[/button_shortcode]';		
				}
				
				if ($currentType->item(0)->nodeValue == "ColImage") {										
					$pego_pb_shortcode_elements = '[columnwithicon_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" icon="'.$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'"   counter="'.$page_item->getElementsByTagName( "counter" )->item(0)->nodeValue.'" url="'.$page_item->getElementsByTagName( "url" )->item(0)->nodeValue.'"	button_caption="'.$page_item->getElementsByTagName( "buttonCaption" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/columnwithicon_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Portfolio") {	
					$readtype=$page_item->getElementsByTagName( "read" )->item(0)->nodeValue;
					$width=$page_item->getElementsByTagName( "width" )->item(0)->nodeValue;			
					$text=$page_item->getElementsByTagName( "text" )->item(0)->nodeValue;			
					$relatedInsert = $page_item->getElementsByTagName( "related" )->item(0)->nodeValue;					
					if ($readtype == 'Random') {
						$pego_pb_shortcode_elements = '[portfolio_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'"   title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" width="'.$width.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" checkallcaption="'.$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue.'" checkallurl="'.$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue.'" ]';	
						$portfolio_items=$page_item->getElementsByTagName( "portfolio_items_parent" );									
						$argsPortf= array('post_type'=> 'portfolio', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
						$postsPortf= get_posts($argsPortf);
						$idd=0;
						$allPortf=array();
						foreach($postsPortf as $postPortf)
						{ 
							setup_postdata($postPortf);
							$postslug= $postPortf->post_name;
							$post_title=get_the_title($postPortf->ID);
							$allPortf[$postslug ] = $post_title;	
						}	
						if ($width == 'Third') {
							foreach( $portfolio_items as $portfolio_item){
								$key = array_search($portfolio_item->getElementsByTagName( "portfolio_item" )->item(0)->nodeValue, $allPortf); 
								$pego_pb_shortcode_elements .= '[portfolio_item3 text="'.$text.'" name="'.$key.'"]';
								
							}		
						}
						else if ($width == 'Half') {
							foreach( $portfolio_items as $portfolio_item){
								$key = array_search($portfolio_item->getElementsByTagName( "portfolio_item" )->item(0)->nodeValue, $allPortf); 
								$pego_pb_shortcode_elements .= '[portfolio_item2 text="'.$text.'" name="'.$key.'" ]';
								
							}		
						} else {
							foreach( $portfolio_items as $portfolio_item){
								$key = array_search($portfolio_item->getElementsByTagName( "portfolio_item" )->item(0)->nodeValue, $allPortf); 
								$pego_pb_shortcode_elements .= '[portfolio_item text="'.$text.'" name="'.$key.'"]';
								
							}	
						}
						$pego_pb_shortcode_elements .= '[/portfolio_shortcode]';
					}
					if (($readtype == 'Latest')||($readtype == 'Portfolio Ordering')) {
					
							$key="";							
							if ($relatedInsert != '')
							{							
								$argsPortf= array('post_type'=> 'portfolio', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
								$postsPortf= get_posts($argsPortf);
								$idd=0;
								$allPortf=array();
								$allPortf[0]="";
								foreach($postsPortf as $postPortf)
								{ 
									setup_postdata($postPortf);
									$postslug= $postPortf->post_name;
									$post_title=get_the_title($postPortf->ID);
									$allPortf[$postslug ] = $post_title;	
								}
								$key = array_search($relatedInsert, $allPortf); 
							}
					
						if ($width == 'Third') {
							$pego_pb_shortcode_elements = '[portfolio_items_latest3 checkallcaption="'.$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue.'" checkallurl="'.$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue.'" text="'.$text.'" category="'.$page_item->getElementsByTagName( "category" )->item(0)->nodeValue.'" type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" readtype="'.$page_item->getElementsByTagName( "read" )->item(0)->nodeValue.'" related="'.$key.'" shownumber="'.$page_item->getElementsByTagName( "shownumber" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';	
						}
						else if ($width == 'Half') {
							$pego_pb_shortcode_elements = '[portfolio_items_latest2 checkallcaption="'.$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue.'" checkallurl="'.$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue.'" text="'.$text.'" category="'.$page_item->getElementsByTagName( "category" )->item(0)->nodeValue.'" type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" readtype="'.$page_item->getElementsByTagName( "read" )->item(0)->nodeValue.'" related="'.$key.'" shownumber="'.$page_item->getElementsByTagName( "shownumber" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';	
						}
						else {
							$pego_pb_shortcode_elements = '[portfolio_items_latest checkallcaption="'.$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue.'" checkallurl="'.$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue.'" text="'.$text.'" category="'.$page_item->getElementsByTagName( "category" )->item(0)->nodeValue.'" type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" readtype="'.$page_item->getElementsByTagName( "read" )->item(0)->nodeValue.'" related="'.$key.'" shownumber="'.$page_item->getElementsByTagName( "shownumber" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';	
						}
					}									
					
				}
				if ($currentType->item(0)->nodeValue == "Carousel") {	
					$pego_pb_shortcode_elements = '[carousel_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" carouselcount="'.$page_item->getElementsByTagName( "carouselcount" )->item(0)->nodeValue.'" width="'.$page_item->getElementsByTagName( "width" )->item(0)->nodeValue.'" speed="'.$page_item->getElementsByTagName( "speed" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';	
					$carousel_items=$page_item->getElementsByTagName( "carousel_parent" );
					
					foreach( $carousel_items as $carousel_item){
						$pego_pb_shortcode_elements .= '[carousel_item url="'.$carousel_item->getElementsByTagName( "carousel_url" )->item(0)->nodeValue.'" image="'.$carousel_item->getElementsByTagName( "carousel_image" )->item(0)->nodeValue.'" width="'.$page_item->getElementsByTagName( "width" )->item(0)->nodeValue.'"]';
						
					}								
					$pego_pb_shortcode_elements .= '[/carousel_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Toggle") {	
					$pego_pb_shortcode_elements = '[toggle_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$toggle_items=$page_item->getElementsByTagName( "toggle_parent" );
					
					foreach( $toggle_items as $toggle_item){
						$pego_pb_shortcode_elements .= '[toggle_item  title="'.$toggle_item->getElementsByTagName( "toggle_title" )->item(0)->nodeValue.'"]'.$toggle_item->getElementsByTagName( "toggle_content" )->item(0)->nodeValue.'[/toggle_item]';
						
					}								
					$pego_pb_shortcode_elements .= '[/toggle_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Tab") {	
					$pego_pb_shortcode_elements = '[tab_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$tab_items=$page_item->getElementsByTagName( "tab_parent" );
					
					foreach( $tab_items as $tab_item){
						$pego_pb_shortcode_elements .= '[tab_item  title="'.$tab_item->getElementsByTagName( "tab_title" )->item(0)->nodeValue.'"]'.$tab_item->getElementsByTagName( "tab_content" )->item(0)->nodeValue.'[/tab_item]';
						
					}								
					$pego_pb_shortcode_elements .= '[/tab_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "GoogleMaps") {	
					$st_maps = 0;
					$maps_items=$page_item->getElementsByTagName( "maps_parent" );
					foreach( $maps_items as $maps_item){
						$st_maps++;		
						if ($st_maps == 1) { 
							$lat1 = $maps_item->getElementsByTagName( "maps_lat" )->item(0)->nodeValue;   
							$lng1 = $maps_item->getElementsByTagName( "maps_lng" )->item(0)->nodeValue;   
						}
					}
					
					$pego_pb_shortcode_elements = '[maps_shortcode title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"  type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" fullwidth="'.$page_item->getElementsByTagName( "fullwidth" )->item(0)->nodeValue.'" latitude="'.$lat1.'" longitude="'.$lng1.'" height="'.$page_item->getElementsByTagName( "height" )->item(0)->nodeValue.'" zoom="'.$page_item->getElementsByTagName( "zoom" )->item(0)->nodeValue.'" stmaps="'.$st_maps.'"]';

								
					$st_maps1 = 0;
					foreach( $maps_items as $maps_item){
						$st_maps1++;
							$pego_pb_shortcode_elements .= '[ \''.$maps_item->getElementsByTagName( "maps_pin" )->item(0)->nodeValue.'\', '.$maps_item->getElementsByTagName( "maps_lat" )->item(0)->nodeValue.', '.$maps_item->getElementsByTagName( "maps_lng" )->item(0)->nodeValue.', \''.$maps_item->getElementsByTagName( "maps_address" )->item(0)->nodeValue.'\']';
											
						if ($st_maps != $st_maps1) { $pego_pb_shortcode_elements .= ' , '; }
						
						
					}
					$pego_pb_shortcode_elements .= '[/maps_shortcode]';					
					
				}
				
				if ($currentType->item(0)->nodeValue == "ContactForm") {										
					$pego_pb_shortcode_elements = '[contact_form_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" emailwheretosend="'.$page_item->getElementsByTagName( "email" )->item(0)->nodeValue.'"  title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" ]';		
				}
				if ($currentType->item(0)->nodeValue == "Posts") {	
					$readtype=$page_item->getElementsByTagName( "read" )->item(0)->nodeValue;	
					$width=$page_item->getElementsByTagName( "width" )->item(0)->nodeValue;	
					$showtype=$page_item->getElementsByTagName( "showtype" )->item(0)->nodeValue;								
					if ($readtype == 'Random') {
						$pego_pb_shortcode_elements = '[posts_shortcode checkallcaption="'.$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue.'" checkallurl="'.$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue.'" type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
						$post_items=$page_item->getElementsByTagName( "posts_items_parent" );
							
						$argsPosts = array('post_type'=> 'post', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
						$postsPosts= get_posts($argsPosts);
						$idd=0;
						$allPosts=array();
						foreach($postsPosts as $postPost)
						{ 
							//setup_postdata($postPost);
							$postslug= $postPost->post_name;
							$post_title=get_the_title($postPost->ID);
							$allPosts[$postslug ] = $post_title;	
						}	
						foreach( $post_items as $post_item){
								$key = array_search($post_item->getElementsByTagName( "post_item" )->item(0)->nodeValue, $allPosts); 
								$pego_pb_shortcode_elements .= '[post_item showtype="'.$page_item->getElementsByTagName( "showtype" )->item(0)->nodeValue.'"   width="'.$width.'" name="'.$key.'" summarylength="'.$page_item->getElementsByTagName( "summarylength" )->item(0)->nodeValue.'"]';
						}	
						$pego_pb_shortcode_elements .= '[/posts_shortcode]';
					}
					if ($readtype == 'Latest') {
						$pego_pb_shortcode_elements = '[posts_items_latest checkallcaption="'.$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue.'" checkallurl="'.$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue.'" width="'.$width.'" summarylength="'.$page_item->getElementsByTagName( "summarylength" )->item(0)->nodeValue.'" type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" readtype="'.$page_item->getElementsByTagName( "read" )->item(0)->nodeValue.'" shownumber="'.$page_item->getElementsByTagName( "shownumber" )->item(0)->nodeValue.'" showtype="'.$page_item->getElementsByTagName( "showtype" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';	
						
					}								
				}
				if ($currentType->item(0)->nodeValue == "Blockquote") {										
					$pego_pb_shortcode_elements = '[blockquote_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" icon="'.$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" bordercolor="'.$page_item->getElementsByTagName( "bordercolor" )->item(0)->nodeValue.'" bordersize="'.$page_item->getElementsByTagName( "bordersize" )->item(0)->nodeValue.'" author="'.$page_item->getElementsByTagName( "author" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/blockquote_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Video") {										
					$pego_pb_shortcode_elements = '[video_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'"  title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "iframecode" )->item(0)->nodeValue.'[/video_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Slider") {										
					$values=pego_get_slider_layer();
					$key = array_search($page_item->getElementsByTagName( "alias" )->item(0)->nodeValue, $values);
					$titlee = $page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
					$sizee = $page_item->getElementsByTagName( "size" )->item(0)->nodeValue;
					$fullwidthh = $page_item->getElementsByTagName( "fullwidth" )->item(0)->nodeValue;								
					if (($fullwidthh == 'Yes')&&($sizee == 'full_width')) {	
						$pego_pb_shortcode_elements = '[endmaindivs][layerslider  id="'.$key.'" ][div45][startmaindivs]';	
					}
					else {									
						$pego_pb_shortcode_elements = '[column_wrapp_shortcode_start type="'.$sizee.'"  title="'.$titlee.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"][layerslider  id="'.$key.'" ][column_wrapp_shortcode_end]';	
					}								
				}
				if ($currentType->item(0)->nodeValue == "Testimonials") {	
					$pego_pb_shortcode_elements = '[testimonials_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$testimonials_items=$page_item->getElementsByTagName( "testimonials_parent" );
					
					foreach( $testimonials_items as $testimonials_item){
						$pego_pb_shortcode_elements .= '[testimonials_item under_author="'.$testimonials_item->getElementsByTagName( "testimonials_subtitle" )->item(0)->nodeValue.'" author="'.$testimonials_item->getElementsByTagName( "testimonials_title" )->item(0)->nodeValue.'"]'.$testimonials_item->getElementsByTagName( "testimonials_content" )->item(0)->nodeValue.'[/testimonials_item]';
						
					}								
					$pego_pb_shortcode_elements .= '[/testimonials_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "ProgressBar") {	
					$pego_pb_shortcode_elements = '[progressbar_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$progressbar_items=$page_item->getElementsByTagName( "progressbar_parent" );
					
					foreach( $progressbar_items as $progressbar_item){
						$pego_pb_shortcode_elements .= '[progress_bar  id="'.$progressbar_item->getElementsByTagName( "progressbar_id" )->item(0)->nodeValue.'" color="'.$page_item->getElementsByTagName( "color" )->item(0)->nodeValue.'"   title="'.$progressbar_item->getElementsByTagName( "progressbar_title" )->item(0)->nodeValue.'"   percent="'.$progressbar_item->getElementsByTagName( "progressbar_percent" )->item(0)->nodeValue.'"]';
						
					}								
					$pego_pb_shortcode_elements .= '[/progressbar_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Flexslider") {	
					$pego_pb_shortcode_elements = '[flexslider_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$flexslider_items=$page_item->getElementsByTagName( "flexslider_parent" );
					
					foreach( $flexslider_items as $flexslider_item){
						$pego_pb_shortcode_elements .= '[flexslider_slide  caption="'.$flexslider_item->getElementsByTagName( "flexslider_caption" )->item(0)->nodeValue.'" url="'.$flexslider_item->getElementsByTagName( "flexslider_url" )->item(0)->nodeValue.'"  image="'.$flexslider_item->getElementsByTagName( "flexslider_image" )->item(0)->nodeValue.'" ]';
						
					}								
					$pego_pb_shortcode_elements .= '[/flexslider_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Socials") {	
					$pego_pb_shortcode_elements = '[socials_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" socialstype="'.$page_item->getElementsByTagName( "socialstype" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$socials_items=$page_item->getElementsByTagName( "socials_parent" );
					
					foreach( $socials_items as $socials_item){
						$pego_pb_shortcode_elements .= '[social_item bgcolor="'.$page_item->getElementsByTagName( "bgcolor" )->item(0)->nodeValue.'" url="'.$socials_item->getElementsByTagName( "socials_url" )->item(0)->nodeValue.'" item="'.$socials_item->getElementsByTagName( "socials_item" )->item(0)->nodeValue.'"]';
						
					}								
					$pego_pb_shortcode_elements .= '[/socials_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "ContactForm7") {										
					$values = pego_get_contact_forms();
					$contact_form_title = $page_item->getElementsByTagName( "contactform7" )->item(0)->nodeValue;
					$contact_form_title_above = $page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
					$type = $page_item->getElementsByTagName( "size" )->item(0)->nodeValue;
				
					$key = array_search($contact_form_title, $values); 	
					$pego_pb_shortcode_elements = '[shortcode_contact_form7_wrapper type="'.$type.'" title="'.$contact_form_title_above.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"][contact-form-7 id="'.$key.'" title="'.$contact_form_title.'"][/shortcode_contact_form7_wrapper]';
				}
				if ($currentType->item(0)->nodeValue == "Accordion") {	
					$pego_pb_shortcode_elements = '[accordion_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$accordion_items=$page_item->getElementsByTagName( "accordion_parent" );								
					foreach( $accordion_items as $accordion_item){
						$pego_pb_shortcode_elements .= '[accordion_item  title="'.$accordion_item->getElementsByTagName( "accordion_title" )->item(0)->nodeValue.'"]'.$accordion_item->getElementsByTagName( "accordion_content" )->item(0)->nodeValue.'[/accordion_item]';
						
					}								
					$pego_pb_shortcode_elements .= '[/accordion_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "TeamMember") {	
					$pego_pb_shortcode_elements = '[teammember_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" name="'.$page_item->getElementsByTagName( "name" )->item(0)->nodeValue.'" position="'.$page_item->getElementsByTagName( "position" )->item(0)->nodeValue.'" image="'.$page_item->getElementsByTagName( "image" )->item(0)->nodeValue.'" description="'.$page_item->getElementsByTagName( "description" )->item(0)->nodeValue.'" stevilo="'.$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue.'"  count="'.$page_item->getElementsByTagName( "count" )->item(0)->nodeValue.'"]';	
					$teammember_socials_items=$page_item->getElementsByTagName( "teammember_parent" );
					
					foreach( $teammember_socials_items as $teammember_socials_item){
						$pego_pb_shortcode_elements .= '[teammember_social   count="'.$page_item->getElementsByTagName( "count" )->item(0)->nodeValue.'" item="'.$teammember_socials_item->getElementsByTagName( "teammember_item" )->item(0)->nodeValue.'" url="'.$teammember_socials_item->getElementsByTagName( "teammember_url" )->item(0)->nodeValue.'" title="'.$teammember_socials_item->getElementsByTagName( "teammember_title" )->item(0)->nodeValue.'"]';
						
					}								
					$pego_pb_shortcode_elements .= '[/teammember_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Image") {	
					$pego_pb_shortcode_elements = '[image_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" url="'.$page_item->getElementsByTagName( "url" )->item(0)->nodeValue.'" popup="'.$page_item->getElementsByTagName( "popup" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"  margintop="'.$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue.'"  marginbottom="'.$page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue.'"]';
				}
				if ($currentType->item(0)->nodeValue == "Welcome1") {										
					$pego_pb_shortcode_elements = '[welcome1_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" 	fontcolor="'.$page_item->getElementsByTagName( "fontcolor" )->item(0)->nodeValue.'"  spancolor="'.$page_item->getElementsByTagName( "spancolor" )->item(0)->nodeValue.'"  contentsize="'.$page_item->getElementsByTagName( "contentsize" )->item(0)->nodeValue.'" margintop="'.$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue.'" count="'.$page_item->getElementsByTagName( "count" )->item(0)->nodeValue.'" ]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/welcome1_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Welcome2") {										
					$pego_pb_shortcode_elements = '[welcome3_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" rightcontent="'.$page_item->getElementsByTagName( "rightcontent" )->item(0)->nodeValue.'" leftcontenttitle="'.$page_item->getElementsByTagName( "leftcontenttitle" )->item(0)->nodeValue.'" rightcontenturl="'.$page_item->getElementsByTagName( "rightcontenturl" )->item(0)->nodeValue.'" leftcolor="'.$page_item->getElementsByTagName( "leftcolor" )->item(0)->nodeValue.'" rightcolor="'.$page_item->getElementsByTagName( "rightcolor" )->item(0)->nodeValue.'" fontcolor="'.$page_item->getElementsByTagName( "fontcolor" )->item(0)->nodeValue.'"  fontcolortitle="'.$page_item->getElementsByTagName( "fontcolortitle" )->item(0)->nodeValue.'" fontcolorright="'.$page_item->getElementsByTagName( "fontcolorright" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "leftcontent" )->item(0)->nodeValue.'[/welcome3_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "TwitterUpdates") {										
					$pego_pb_shortcode_elements = '[twitterupdates_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" showtype="'.$page_item->getElementsByTagName( "showtype" )->item(0)->nodeValue.'" username="'.$page_item->getElementsByTagName( "username" )->item(0)->nodeValue.'" icon="'.$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'" number="'.$page_item->getElementsByTagName( "number" )->item(0)->nodeValue.'" bgcolor="'.$page_item->getElementsByTagName( "bgcolor" )->item(0)->nodeValue.'" fontcolor="'.$page_item->getElementsByTagName( "fontcolor" )->item(0)->nodeValue.'" ]';		
				}
				if ($currentType->item(0)->nodeValue == "Heading") {										
					$pego_pb_shortcode_elements = '[heading_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'"    align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/heading_shortcode]';	
				
				}	
				if ($currentType->item(0)->nodeValue == "ContactInfo") {	
					$pego_pb_shortcode_elements = '[contactinfo_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" image="'.$page_item->getElementsByTagName( "image" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" text="'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$contactinfo_items=$page_item->getElementsByTagName( "contactinfo_parent" );
					
					foreach( $contactinfo_items as $contactinfo_item){
						$pego_pb_shortcode_elements .= '[contactinfo_item icon="'.$contactinfo_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'"]'.$contactinfo_item->getElementsByTagName( "desc" )->item(0)->nodeValue.'[/contactinfo_item]';
						
					}								
					$pego_pb_shortcode_elements .= '[/contactinfo_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "PricingColumn") {	
					$pego_pb_shortcode_elements = '[pricing_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" price="'.$page_item->getElementsByTagName( "price" )->item(0)->nodeValue.'" per="'.$page_item->getElementsByTagName( "per" )->item(0)->nodeValue.'" currency="'.$page_item->getElementsByTagName( "currency" )->item(0)->nodeValue.'" url="'.$page_item->getElementsByTagName( "url" )->item(0)->nodeValue.'" urlcaption="'.$page_item->getElementsByTagName( "urlcaption" )->item(0)->nodeValue.'"  best="'.$page_item->getElementsByTagName( "best" )->item(0)->nodeValue.'"]';	
					$pricing_items=$page_item->getElementsByTagName( "pricing_parent" );								
					foreach( $pricing_items as $pricing_item){
						$pego_pb_shortcode_elements .= '[pricing_li]'.$pricing_item->getElementsByTagName( "pricing_item" )->item(0)->nodeValue.'[/pricing_li]';									
					}								
					$pego_pb_shortcode_elements .= '[/pricing_shortcode]';		
				}							
				if ($currentType->item(0)->nodeValue == "2ColTable") {	
					$pego_pb_shortcode_elements = '[coltable_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" color="'.$page_item->getElementsByTagName( "color" )->item(0)->nodeValue.'" buttoncaption="'.$page_item->getElementsByTagName( "buttoncaption" )->item(0)->nodeValue.'" buttonurl="'.$page_item->getElementsByTagName( "buttonurl" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$coltable_items=$page_item->getElementsByTagName( "coltable_parent" );
					
					foreach( $coltable_items as $coltable_item){
						$pego_pb_shortcode_elements .= '[coltable_li left="'.$coltable_item->getElementsByTagName( "coltable_left" )->item(0)->nodeValue.'" right="'.$coltable_item->getElementsByTagName( "coltable_right" )->item(0)->nodeValue.'"]';
						
					}								
					$pego_pb_shortcode_elements .= '[/coltable_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Gallery") {	
					$argsPortf = array('post_type'=> 'gallery', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
					$postsPortf = get_posts($argsPortf);	
					$allGallery = array();
					if($postsPortf) {
						foreach($postsPortf as $postPortf)
						{ 
							setup_postdata($postPortf); 	
							$allGallery[$postPortf->ID] = $postPortf->post_title;	
						}
					}		
					$value = $page_item->getElementsByTagName( "galleryitem" )->item(0)->nodeValue;
					$key = array_search($value, $allGallery); 	
					$pego_pb_shortcode_elements = '[gallery_shortcode1 type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" galleryitem="'.$key.'" width="'.$page_item->getElementsByTagName( "width" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';		
				}
				if ($currentType->item(0)->nodeValue == "Faq") {										
					$pego_pb_shortcode_elements = '[faq_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"   align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';		
				}
				if ($currentType->item(0)->nodeValue == "BGsectionStart") {	
					$argsSec = array('post_type'=> 'backgroundsection', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
					$postsSecs = get_posts($argsSec);	
					$allSections= array();
					if($postsSecs) {
						foreach($postsSecs as $postsSec)
						{ 
							setup_postdata($postsSec); 	
							$allSections[$postsSec->post_name] = $postsSec->post_title;	
						}
					}
					$value=$page_item->getElementsByTagName( "sectiontitle" )->item(0)->nodeValue;	
					$key = array_search($value, $allSections); 	
					$pego_pb_shortcode_elements = '[sectionstart_shortcode section="'.$key.'"]';	
											
				}
				if ($currentType->item(0)->nodeValue == "BGsectionEnd") {						
						$pego_pb_shortcode_elements = '[sectionend_shortcode]';												
				}
				if ($currentType->item(0)->nodeValue == "ColLeftIcon") {										
					$pego_pb_shortcode_elements = '[columnwithicon1_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" icon="'.$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'"  counter="'.$page_item->getElementsByTagName( "counter" )->item(0)->nodeValue.'" url="'.$page_item->getElementsByTagName( "url" )->item(0)->nodeValue.'"   color="'.$page_item->getElementsByTagName( "color" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/columnwithicon1_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "ColTopIcon") {										
					$pego_pb_shortcode_elements = '[columnwithicon2_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" icon="'.$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue.'"  counter="'.$page_item->getElementsByTagName( "counter" )->item(0)->nodeValue.'" url="'.$page_item->getElementsByTagName( "url" )->item(0)->nodeValue.'"  urltarget="'.$page_item->getElementsByTagName( "urltarget" )->item(0)->nodeValue.'"   color="'.$page_item->getElementsByTagName( "color" )->item(0)->nodeValue.'" colorhover="'.$page_item->getElementsByTagName( "colorhover" )->item(0)->nodeValue.'" iconcolor="'.$page_item->getElementsByTagName( "iconcolor" )->item(0)->nodeValue.'" iconcolorhover="'.$page_item->getElementsByTagName( "iconcolorhover" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/columnwithicon2_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "Testimonial2") {	
					$pego_pb_shortcode_elements = '[clientssay_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" image="'.$page_item->getElementsByTagName( "image" )->item(0)->nodeValue.'"  author="'.$page_item->getElementsByTagName( "author" )->item(0)->nodeValue.'" company="'.$page_item->getElementsByTagName( "company" )->item(0)->nodeValue.'" companyurl="'.$page_item->getElementsByTagName( "companyurl" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/clientssay_shortcode]';	
				}
				
				if ($currentType->item(0)->nodeValue == "BigSplashText") {	
				
					$single_portfolio_type1 = get_post_meta($postID, 'single_portfolio_type' , true); 
					$single_portfolio_post_type1 = get_post_type( $postID );


					if (($single_portfolio_type1 == 'Fullwidth item')&&($single_portfolio_post_type1 == 'portfolio')) {
						$pego_pb_shortcode_elements = '[endsinglefoliodiv][bigsplashtext_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" titlefontcolor="'.$page_item->getElementsByTagName( "titlefontcolor" )->item(0)->nodeValue.'" titlefontsize="'.$page_item->getElementsByTagName( "titlefontsize" )->item(0)->nodeValue.'" background="'.$page_item->getElementsByTagName( "background" )->item(0)->nodeValue.'" backgroundtext="'.$page_item->getElementsByTagName( "backgroundtext" )->item(0)->nodeValue.'" backgroundtype="'.$page_item->getElementsByTagName( "backgroundtype" )->item(0)->nodeValue.'" margintop="'.$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue.'" marginbottom="'.$page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'"][startsinglefoliodiv]';
					}
					else {
						$pego_pb_shortcode_elements = '[endmaindivs][bigsplashtext_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" titlefontcolor="'.$page_item->getElementsByTagName( "titlefontcolor" )->item(0)->nodeValue.'" titlefontsize="'.$page_item->getElementsByTagName( "titlefontsize" )->item(0)->nodeValue.'" background="'.$page_item->getElementsByTagName( "background" )->item(0)->nodeValue.'" backgroundtype="'.$page_item->getElementsByTagName( "backgroundtype" )->item(0)->nodeValue.'" backgroundtext="'.$page_item->getElementsByTagName( "backgroundtext" )->item(0)->nodeValue.'"  margintop="'.$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue.'" marginbottom="'.$page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'"][startmaindivs]';
					}	
				}			
				if ($currentType->item(0)->nodeValue == "ImageSlide") {	
					if ( $page_item->getElementsByTagName( "title" )->item(0)->nodeValue != '') {
						$pego_pb_shortcode_elements = '[heading_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'"    align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'[/heading_shortcode][endmaindivs][imageslide_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';
					}
					else {
						$pego_pb_shortcode_elements = '[endmaindivs][imageslide_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'" ]';
					
					}
					
					$imageslide_items=$page_item->getElementsByTagName( "imageslide_parent" );
					
					foreach( $imageslide_items as $imageslide_item){
						$pego_pb_shortcode_elements .= '[imageslide_li]'.$imageslide_item->getElementsByTagName( "imageslide_item" )->item(0)->nodeValue.'[/imageslide_li]';
						
					}								
					$pego_pb_shortcode_elements .= '[/imageslide_shortcode][startmaindivs]';		
				}
				
				if ($currentType->item(0)->nodeValue == "Welcome3") {	
				
					$single_portfolio_type1 = get_post_meta($postID, 'single_portfolio_type' , true); 
					$single_portfolio_post_type1 = get_post_type( $postID );


					if (($single_portfolio_type1 == 'Fullwidth item')&&($single_portfolio_post_type1 == 'portfolio')) {
						$pego_pb_shortcode_elements = '[endsinglefoliodiv][welcome4_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" titlefontcolor="'.$page_item->getElementsByTagName( "titlefontcolor" )->item(0)->nodeValue.'" titlefontsize="'.$page_item->getElementsByTagName( "titlefontsize" )->item(0)->nodeValue.'"  content="'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'" contentfontcolor="'.$page_item->getElementsByTagName( "contentfontcolor" )->item(0)->nodeValue.'" contentfontsize="'.$page_item->getElementsByTagName( "contentfontsize" )->item(0)->nodeValue.'" background="'.$page_item->getElementsByTagName( "background" )->item(0)->nodeValue.'" buttoncaption="'.$page_item->getElementsByTagName( "buttoncaption" )->item(0)->nodeValue.'"  buttonurl="'.$page_item->getElementsByTagName( "buttonurl" )->item(0)->nodeValue.'"  bordercolor="'.$page_item->getElementsByTagName( "bordercolor" )->item(0)->nodeValue.'"	margintop="'.$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue.'"	marginbottom="'.$page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue.'" buttontarget="'.$page_item->getElementsByTagName( "buttontarget" )->item(0)->nodeValue.'"][startsinglefoliodiv]';
					}
					else {					
						$pego_pb_shortcode_elements = '[endmaindivs][welcome4_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" titlefontcolor="'.$page_item->getElementsByTagName( "titlefontcolor" )->item(0)->nodeValue.'" titlefontsize="'.$page_item->getElementsByTagName( "titlefontsize" )->item(0)->nodeValue.'"  content="'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'" contentfontcolor="'.$page_item->getElementsByTagName( "contentfontcolor" )->item(0)->nodeValue.'" contentfontsize="'.$page_item->getElementsByTagName( "contentfontsize" )->item(0)->nodeValue.'" background="'.$page_item->getElementsByTagName( "background" )->item(0)->nodeValue.'" buttoncaption="'.$page_item->getElementsByTagName( "buttoncaption" )->item(0)->nodeValue.'"  buttonurl="'.$page_item->getElementsByTagName( "buttonurl" )->item(0)->nodeValue.'"  bordercolor="'.$page_item->getElementsByTagName( "bordercolor" )->item(0)->nodeValue.'"	margintop="'.$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue.'"	marginbottom="'.$page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue.'" buttontarget="'.$page_item->getElementsByTagName( "buttontarget" )->item(0)->nodeValue.'"][startmaindivs]';
					 } 
				}
				if ($currentType->item(0)->nodeValue == "History") {	
					$pego_pb_shortcode_elements = '[history_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'" align="'.$page_item->getElementsByTagName( "align" )->item(0)->nodeValue.'" heading="'.$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue.'"]';	
					$history_items = $page_item->getElementsByTagName( "history_parent" );
					$st_history = 0;
					$shortcode_history = array();
					
					foreach( $history_items as $history_item){
						$st_history++;
						$shortcode_history[$st_history] =  '[history_item  title="'.$history_item->getElementsByTagName( "history_title" )->item(0)->nodeValue.'"  year="'.$history_item->getElementsByTagName( "history_year" )->item(0)->nodeValue.'"   daymonth="'.$history_item->getElementsByTagName( "history_daymonth" )->item(0)->nodeValue.'"]'.$history_item->getElementsByTagName( "history_content" )->item(0)->nodeValue.'[/history_item]';						
					}
					
					for ($i = $st_history ; $i > 0; $i--) {
						$pego_pb_shortcode_elements .= $shortcode_history[$i];
					}
													
					$pego_pb_shortcode_elements .= '[/history_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "CircleBar") {										
					$pego_pb_shortcode_elements = '[circleprogressbar_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  counter="'.$page_item->getElementsByTagName( "counter" )->item(0)->nodeValue.'" percent="'.$page_item->getElementsByTagName( "percent" )->item(0)->nodeValue.'" ]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/circleprogressbar_shortcode]';		
				}
				if ($currentType->item(0)->nodeValue == "ExtraHeading") {										
					$pego_pb_shortcode_elements = '[extraheading_shortcode type="'.$page_item->getElementsByTagName( "size" )->item(0)->nodeValue.'" title="'.$page_item->getElementsByTagName( "title" )->item(0)->nodeValue.'"  titlesize="'.$page_item->getElementsByTagName( "titlesize" )->item(0)->nodeValue.'" contentsize="'.$page_item->getElementsByTagName( "contentsize" )->item(0)->nodeValue.'" ]'.$page_item->getElementsByTagName( "content" )->item(0)->nodeValue.'[/extraheading_shortcode]';		
				}
				
				$velikost_percent = get_niz_to_show($page_item->getElementsByTagName( "size" )->item(0)->nodeValue);
				$velikost_like_niz = substr($velikost_percent, 0, -1); 
				$integer_velikost = (int)$velikost_like_niz;							
				
				$sizeNumber += $integer_velikost;
				if ($sizeNumber > 100) {
					$sizeNumber=$integer_velikost;
					echo '<div class="clear"></div>';
				}		
				echo do_shortcode($pego_pb_shortcode_elements);		
			}				
		}
	}

	
	/***************************************************************  
Widget areas
***************************************************************/
	function pego_new_widgets_init() {	
	
		register_sidebar(array(
			'name' => 'Blog sidebar',
			'id' => 'blog-sidebar',
			'description'   => 'These are widgets for the sidebar.',
			'before_widget' => '<div id="%1$s" class="widget %2$s" style="margin-bottom:30px;">',
			'after_widget'  => '<div class="clear"></div></div><div class="clear"></div>',
			'before_title'  => '<h3 class="sidebar-title">',
			'after_title'   => '</h3><div class="title_stripes_sidebar"></div><div class="clear"></div>'
		));		
		
		//custom sidebars from admin
		$argsSidebars = array('post_type'=> 'sidebars', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
		$allSidebars = get_posts($argsSidebars);	
	
		if($allSidebars) {
			foreach($allSidebars as $singleSidebar)
			{ 	
				$sidebarTitle = $singleSidebar->post_title;	
				$sidebarName= $singleSidebar->post_name;				
				register_sidebar(array(
					'name' => $sidebarTitle,
					'id' => $sidebarName,
					'description'   => 'These are widgets for the sidebar.',
					'before_widget' => '<div id="%1$s" class="widget %2$s" style="margin-bottom:30px;">',
					'after_widget'  => '</div><div class="clear"></div>',
					'before_title'  => '<h3 class="sidebar-title">',
					'after_title'   => '</h3><div class="title_stripes_sidebar"></div><div class="clear"></div>'
				));				
			}
		}
	
		register_sidebar(array(
			'name' => 'Footer First Column Sidebar',
			'id' => 'first-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Footer Second Column Sidebar',
			'id' => 'second-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Footer  Third Column Sidebar',
			'id' => 'third-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));	
		register_sidebar(array(
			'name' => 'Footer  Fourth Column Sidebar',
			'id' => 'fourth-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Under footer area - left',
			'id' => 'under-footer-area-left',
			'before_widget' => '<div class="under-footer-div fl">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="under-footer-titles">',
			'after_title' => '</div>',
		));
		register_sidebar(array(
			'name' => 'Under footer area - right',
			'id' => 'under-footer-area-right',
			'before_widget' => '<div class="under-footer-div fr">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="under-footer-titles">',
			'after_title' => '</div>',
		));
		register_sidebar(array(
			'name' => 'Under footer area - center',
			'id' => 'under-footer-area-center',
			'before_widget' => '<div class="under-footer-div">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="under-footer-titles">',
			'after_title' => '</div>',
		));
		
		if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {		
			register_sidebar(array(
				'name' => 'WooCommerce Widget Area',
				'id' => 'woocommerce-widget-area',
				'description'   => 'These are widgets for WooCommerce Shop and Products page.',
				'before_widget' => '<div id="%1$s" class="widget %2$s" style="margin-bottom:30px;">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="sidebar-title">',
				'after_title'   => '</h3>'
			));
		}
		
	}
	add_action( 'widgets_init', 'pego_new_widgets_init' );	
	
	
/***************************************************************  
Portfolio likes
***************************************************************/
	
	$timebeforerevote = 1;

	add_action('wp_ajax_nopriv_post-like', 'post_like');
	add_action('wp_ajax_post-like', 'post_like');



	function post_like()
	{
		$nonce = $_POST['nonce'];
	 
		if ( ! wp_verify_nonce( $nonce, 'ajax-nonce' ) )
			die ( 'Busted!');
			
		if(isset($_POST['post_like']))
		{
			$ip = $_SERVER['REMOTE_ADDR'];
			$post_id = $_POST['post_id'];
			
			$meta_IP = get_post_meta($post_id, "voted_IP");

			$voted_IP = $meta_IP[0];
			if(!is_array($voted_IP))
				$voted_IP = array();
			
			$meta_count = get_post_meta($post_id, "votes_count", true);

			if(!hasAlreadyVoted($post_id))
			{
				$voted_IP[$ip] = time();

				update_post_meta($post_id, "voted_IP", $voted_IP);
				update_post_meta($post_id, "votes_count", ++$meta_count);
				
				echo $meta_count;
			}
			else
				echo "already";
		}
		exit;
	}

	function hasAlreadyVoted($post_id)
	{
		global $timebeforerevote;

		$meta_IP = get_post_meta($post_id, "voted_IP");
		$voted_IP = $meta_IP[0];
		if(!is_array($voted_IP))
			$voted_IP = array();
		$ip = $_SERVER['REMOTE_ADDR'];
		
		if(in_array($ip, array_keys($voted_IP)))
		{
			$time = $voted_IP[$ip];
			$now = time();
			
			if(round(($now - $time) / 60) > $timebeforerevote)
				return false;
				
			return true;
		}
		
		return false;
	}

	function getPostLikeLink($post_id)
	{
		$themename = "furniot";

		$vote_count = get_post_meta($post_id, "votes_count", true);

		$output = '<p class="post-like">';
		if(hasAlreadyVoted($post_id))
			$output .= ' <span class="like-heart-wrapper"><span title="'.__('I like this article', $themename).'" class="qtip like icon-heart alreadyvoted"></span></span>';
		else
			$output .= '<a href="#" data-post_id="'.$post_id.'">
						<span class="like-heart-wrapper"><span  title="'.__('I like this article', $themename).'"class="qtip like icon-heart"></span></span>
					</a>';
		$output .= '<span class="count">'.$vote_count.'</span></p>';
		
		return $output;
	}
	
/***************************************************************  
Functions for gettings different atributes from an ID
***************************************************************/
	function pego_get_portf_ID($portf_id) {
		global $wpdb;
		$id=444;
		$id = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$portf_id' AND post_type='portfolio'");
		return $id;
	}
	
	function pego_get_post_ID($post_id) {
		global $wpdb;
		$id=444;
		$id = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_name = '$portf_id' AND post_type='post'");
		return $id;
	}
	
	
/***************************************************************  
Functions for gettings different atributes from an ID
***************************************************************/	
	
	function pego_get_apple_icons() {
		global $pego_prefix;
		if (get_option($pego_prefix.'iphoneicon') != '') {
		?>
			<link rel="apple-touch-icon-precomposed" href="<?php echo get_option($pego_prefix.'iphoneicon'); ?>" />
		<?php
		}
		if (get_option($pego_prefix.'ipadicon') != '') {
		?>
			<link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php  echo get_option($pego_prefix.'ipadicon'); ?>" />
		<?php
		}
		if (get_option($pego_prefix.'iphoneiconretina') != '') {
		?>
			<link rel="apple-touch-icon-precomposed" sizes="114x114"  href="<?php  echo get_option($pego_prefix.'iphoneiconretina'); ?>" />
		<?php
		}
		if (get_option($pego_prefix.'ipadiconretina') != '') {
		?>
		<link rel="apple-touch-icon-precomposed" sizes="144x144"  href="<?php  echo get_option($pego_prefix.'ipadiconretina'); ?>" />
		<?php
		}
	}
	
	
/***************************************************************  
Custom admin logo
***************************************************************/
	function pego_custom_login_logo() {
		$read_logo='';
		$pego_prefix = "pego_";
	   $read_logo = get_option($pego_prefix.'logoadmin');

		if($read_logo != '') {
						echo '<style type="text/css">
				h1 a {background-size:auto !important; background-image:url('.$read_logo.') !important; }
			</style>';	
		}	
		else {
					echo '<style type="text/css">
			h1 a { background-size:auto !important; background-image:url('.get_template_directory_uri().'/images/logo.png) !important;  }
		</style>';
		}
    }
    add_action('login_head', 'pego_custom_login_logo');
	
	


/***************************************************************  
Automatic plugin include
***************************************************************/
	
				/**
			 * This file represents an example of the code that themes would use to register
			 * the required plugins.
			 *
			 * It is expected that theme authors would copy and paste this code into their
			 * functions.php file, and amend to suit.
			 *
			 * @package	   TGM-Plugin-Activation
			 * @subpackage Example
			 * @version	   2.3.6
			 * @author	   Thomas Griffin <thomas@thomasgriffinmedia.com>
			 * @author	   Gary Jones <gamajo@gamajo.com>
			 * @copyright  Copyright (c) 2012, Thomas Griffin
			 * @license	   http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
			 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
			 */

			/**
			 * Include the TGM_Plugin_Activation class.
			 */
			require_once (PEGO_FILEPATH . '/functions/class-tgm-plugin-activation.php');

			add_action( 'tgmpa_register', 'pego_register_required_plugins' );
			/**
			 * Register the required plugins for this theme.
			 *
			 * In this example, we register two plugins - one included with the TGMPA library
			 * and one from the .org repo.
			 *
			 * The variable passed to tgmpa_register_plugins() should be an array of plugin
			 * arrays.
			 *
			 * This function is hooked into tgmpa_init, which is fired within the
			 * TGM_Plugin_Activation class constructor.
			 */
			function pego_register_required_plugins() {

				/**
				 * Array of plugin arrays. Required keys are name and slug.
				 * If the source is NOT from the .org repo, then source is also required.
				 */
				$plugins = array(

					// This is an example of how to include a plugin pre-packaged with a theme
				
				array(
						'name'     				=> 'Layer Slider', // The plugin name
						'slug'     				=> 'LayerSlider', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/layersliderwp-4.6.0.installable.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					),
					
					array(
						'name'     				=> 'Contact Form 7', // The plugin name
						'slug'     				=> 'contact-form-7', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/contact-form-7.3.3.3.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					)

				);

				// Change this to your theme text domain, used for internationalising strings
				$theme_text_domain = 'furniot';

				/**
				 * Array of configuration settings. Amend each line as needed.
				 * If you want the default strings to be available under your own theme domain,
				 * leave the strings uncommented.
				 * Some of the strings are added into a sprintf, so see the comments at the
				 * end of each line for what each argument will be.
				 */
				$config = array(
					'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
					'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
					'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
					'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
					'menu'         		=> 'install-required-plugins', 	// Menu slug
					'has_notices'      	=> true,                       	// Show admin notices or not
					'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
					'message' 			=> '',							// Message to output right before the plugins table
					'strings'      		=> array(
						'page_title'                       			=> __( 'Install Required Plugins', 'furniot' ),
						'menu_title'                       			=> __( 'Install Plugins', 'furniot' ),
						'installing'                       			=> __( 'Installing Plugin: %s', 'furniot' ), // %1$s = plugin name
						'oops'                             			=> __( 'Something went wrong with the plugin API.', 'furniot' ),
						'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
						'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
						'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
						'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
						'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
						'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
						'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
						'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
						'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
						'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
						'return'                           			=> __( 'Return to Required Plugins Installer', 'furniot' ),
						'plugin_activated'                 			=> __( 'Plugin activated successfully.', 'furniot' ),
						'complete' 									=> __( 'All plugins installed and activated successfully. %s', 'furniot' ), // %1$s = dashboard link
						'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
					)
				);

				tgmpa( $plugins, $config );

			}		
		
		
/***************************************************************  
Comment reply
***************************************************************/
	function theme_queue_js(){
	if ( (!is_admin()) && is_singular() && comments_open() && get_option('thread_comments') )
	  wp_enqueue_script( 'comment-reply' );
	}
	add_action('wp_print_scripts', 'theme_queue_js');	
?>