<?php

add_action('init','pego_options');

if (!function_exists('pego_options')) {
function pego_options(){
	
// VARIABLES
$theme_data = wp_get_theme();
$themename = $theme_data->Name;
$themeversion = $theme_data->Version;

$shortname = "pego_";

global $pego_options;
$pego_options = get_option('pego_options');

$GLOBALS['template_path'] = PEGO_DIRECTORY;

//Access the WordPress Categories via an Array
$pego_categories = array();  
$pego_categories_obj = get_categories('hide_empty=0');
foreach ($pego_categories_obj as $pego_cat) {
    $pego_categories[$pego_cat->cat_ID] = $pego_cat->cat_name;}
$categories_tmp = array_unshift($pego_categories, "Select a category:");    
       
//Access the WordPress Pages via an Array
$pego_pages = array();
$pego_pages_obj = get_pages('sort_column=post_parent,menu_order');    
foreach ($pego_pages_obj as $pego_page) {
    $pego_pages[$pego_page->ID] = $pego_page->post_name; }
$pego_pages_tmp = array_unshift($pego_pages, "Select a page:");       

// Image Alignment radio box
$options_thumb_align = array("alignleft" => "Left","alignright" => "Right","aligncenter" => "Center"); 

// Image Links to Options
$options_image_link_to = array("image" => "The Image","post" => "The Post"); 

//Stylesheets Reader
$alt_stylesheet_path = PEGO_FILEPATH . '/css/';
$alt_stylesheets = array();

if ( is_dir($alt_stylesheet_path) ) {
    if ($alt_stylesheet_dir = opendir($alt_stylesheet_path) ) { 
        while ( ($alt_stylesheet_file = readdir($alt_stylesheet_dir)) !== false ) {
            if(stristr($alt_stylesheet_file, ".css") !== false) {
                $alt_stylesheets[] = $alt_stylesheet_file;
            }
        }    
    }
}

//More Options
$uploads_arr = wp_upload_dir();
$all_uploads_path = '';
if(isset($uploads_arr['path'])) $all_uploads_path = $uploads_arr['path'];
$all_uploads = get_option('pego_uploads');


$fontArray = array();
$fontArray = return_google_api_fonts();

$fonts = array();
$fonts[0]=' ';

$stt=1;
foreach ($fontArray as $item) { 
	$fonts[$stt]=$item['family'];	
	$stt++;
}

$all_icons = pego_get_all_icons();

$allPages = array();

$argsPages = array(
	'sort_order' => 'ASC',
	'sort_column' => 'post_title',
	'hierarchical' => 1,
	'exclude' => '',
	'include' => '',
	'meta_key' => '',
	'meta_value' => '',
	'authors' => '',
	'child_of' => 0,
	'parent' => -1,
	'exclude_tree' => '',
	'number' => '',
	'offset' => 0,
	'post_type' => 'page',
	'post_status' => 'publish'
); 
$pagess = get_pages($argsPages);
foreach ($pagess as $singlePagee) { 
	$allPages[$singlePagee->ID]=$singlePagee->post_title;	

}


// Set the Options Array
$options = array();

/**************************** GENERAL SETTINGS start ********************************/	

$options[] = array( "name" => __('General Settings','furniot'),
                    "type" => "heading");
					
//favicon					
$options[] = array( "name" => __('Favicon','furniot'),
					"desc" => __('Upload a favicon for your theme.','furniot'),
					"id" => $shortname."favicon",
					"std" => "",
					"type" => "upload");

//logo					
$options[] = array( "name" => __('Logo settings','furniot'),
					"desc" => __('Logo.','furniot'),
					"id" => $shortname."logo",
					"std" => "",
					"type" => "upload");					
					
//google analytics					
$options[] = array( "name" => __('Google Analytics','furniot'),
					"desc" => __('Insert content for Google Analytics. You must insert the entire GA code - starting with < script > and ending with < / script > (remove spacing from the script tags). ','furniot'),
					"id" => $shortname."google_analytics",
					"std" => "",
					"type" => "textarea");	
					
//google analytics					
$options[] = array( "name" => __('Additional CSS code','furniot'),
					"desc" => __('Insert additional CSS if you want. Style tags will be added automaticly. Inserted code will overwrite the theme one.','furniot'),
					"id" => $shortname."additionalCSS",
					"std" => "",
					"type" => "textarea");	
					
//main template color				
$options[] = array( "name" => __('Main template color','furniot'),
					"desc" => __('Choose the main template color.','furniot'),
					"id" => $shortname."main_template_color",
					"std" => "",
					"type" => "color");		

//secondary template color				
$options[] = array( "name" => __('Secondary template color','furniot'),
					"desc" => __('Choose the secondary template color. This color is used in items where there is more than one color needed(example: button).','furniot'),
					"id" => $shortname."secondary_template_color",
					"std" => "",
					"type" => "color");					

//theme responsivness					
$options[] = array( "name" => __('Make theme responsive?','furniot'),
					"desc" => __('Check this to make theme responsive.','furniot'),
					"id" => $shortname."responsive_theme",
					"std" => "true",
					"type" => "checkbox");
								
					
//global background color					
$options[] = array( "name" => __('Global Background', 'furniot'),
                    "desc" => __('Background color.', 'furniot'),
                    "id" => $shortname."bg_color",
                    "std" => "",
                    "type" => "color");     
	
//global background image		
$options[] = array( 
					"desc" => __('Background image.','furniot'),
					"id" => $shortname."bg_image",
					"std" => "",
					"type" => "upload");
					
//global background tags						
$options[] = array( 
					"desc" => __('Background tags','furniot'),
					"id" => $shortname."bg_tags",
					"std" => "",
					"type" => "text");	

				
//apple iphone icon					
$options[] = array( "name" => __('Apple Iphone & Ipad icons','furniot'),
					"desc" => __('Apple Iphone icon. Dimension for this icon is: 57px X 57px.','furniot'),
					"id" => $shortname."iphoneicon",
					"std" => "",
					"type" => "upload");	
					
//apple iphone icon	retina				
$options[] = array( 
					"desc" => __('Apple Iphone icon with Retina displays. Dimension for this icon is: 114px X 114px.','furniot'),
					"id" => $shortname."iphoneiconretina",
					"std" => "",
					"type" => "upload");	
					
//apple ipad icon					
$options[] = array( 
					"desc" => __('Apple Ipad icon. Dimension for this icon is: 72px X 72px.','furniot'),
					"id" => $shortname."ipadicon",
					"std" => "",
					"type" => "upload");	
					
//apple ipad iconretina				
$options[] = array( 
					"desc" => __('Apple Ipad icon with Retina displays. Dimension for this icon is: 144px X 144px.','furniot'),
					"id" => $shortname."ipadiconretina",
					"std" => "",
					"type" => "upload");
					
//admin logo					
$options[] = array( "name" => __('Custom admin logo','furniot'),
					"desc" => __('Custom logo for admin login.','furniot'),
					"id" => $shortname."logoadmin",
					"std" => "",
					"type" => "upload");	
					
/**************************** GENERAL SETTINGS end ********************************/	
				

$options[] = array( "name" => __('Header Settings','furniot'),
                    "type" => "heading");	


$options[] = array( 
					"desc" => __('Select header to be displayed.','furniot'),
					"id" => $shortname."header_type",
					"std" => "Header#1",
					"type" => "select",
					"options" => array(
						'Header#1' => 'Header#1',
						'Header#2' => 'Header#2',
						'Header#3' => 'Header#3')
					);	


$options[] = array( "name" => __('Header wrapper background', 'furniot'),
                    "desc" => __('Color for the header wrapper background.', 'furniot'),
                    "id" => $shortname."header_bg_color",
                    "std" => "",
                    "type" => "color");  
					
				
$options[] = array( 
					"desc" => __('Image for the header wrapper background.','furniot'),
					"id" => $shortname."header_bg_image",
					"std" => "",
					"type" => "upload");
					

$options[] = array( 
					"desc" => __('Background tags for header wrapper background.','furniot'),
					"id" => $shortname."header_bg_tags",
					"std" => "",
					"type" => "text");	


$options[] = array( "name" => __('Header inside background', 'furniot'),
                    "desc" => __('Color for the header inside background.', 'furniot'),
                    "id" => $shortname."headerinside_bg_color",
                    "std" => "",
                    "type" => "color");  
					
				
$options[] = array( 
					"desc" => __('Image for the header inside background.','furniot'),
					"id" => $shortname."headerinside_bg_image",
					"std" => "",
					"type" => "upload");
					

$options[] = array( 
					"desc" => __('Background tags for header inside background.','furniot'),
					"id" => $shortname."headerinside_bg_tags",
					"std" => "",
					"type" => "text");						
			

$options[] = array( "name" => __('Header#1 Settings','furniot'),
                    "type" => "heading");	
					
$options[] = array( 
                    "desc" => __('Background color', 'furniot'),
                    "id" => $shortname."header1_bg_color",
					"std" => "",
                    "type" => "color");  

$options[] = array( 
					"desc" => __('Icon for search Dimensions: 53px X 29px ','furniot'),
					"id" => $shortname."header1_icon",
					"std" => "",
					"type" => "upload");	

$options[] = array( 
                    "desc" => __('Search placeholder text.', 'furniot'),
                    "id" => $shortname."header2_placeholder",
                    "std" => "",
                    "type" => "text");   

			
$options[] = array( "name" => __('Header#2 Settings','furniot'),
                    "type" => "heading");	

$options[] = array( 
                    "desc" => __('Background color', 'furniot'),
                    "id" => $shortname."header2_bg_color",
					"std" => "",
                    "type" => "color");  
					

$options[] = array( "name" => __('Font','furniot'),
					"desc" => __('Choose font.','furniot'),
					"id" => $shortname."header2_font",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);


$options[] = array( 
                    "desc" => __('Font size [px].', 'furniot'),
                    "id" => $shortname."header2_font_size",
                    "std" => "",
                    "type" => "text");   					


$options[] = array( 
                    "desc" => __('Font color.', 'furniot'),
                    "id" => $shortname."header2_font_color",
                    "std" => "",
                    "type" => "color");  


$options[] = array( 
                    "desc" => __('Color for URLs.', 'furniot'),
                    "id" => $shortname."header2_font_color_url",
                    "std" => "",
                    "type" => "color");  

//footer URL hover color
$options[] = array( 
                    "desc" => __('Color for URLs hover.', 'furniot'),
                    "id" => $shortname."header2_font_color_url_hover",
                    "std" => "",
                    "type" => "color");  		
					

				


$options[] = array( "name" => __('Quick infos','furniot'),
                    "desc" => __('Icons color', 'furniot'),
                    "id" => $shortname."upper_header_left_icons_color",
					"std" => "",
                    "type" => "color");  

$options[] = array( 
					"desc" => __('Icon #1','furniot'),
					"id" => $shortname."upper_header_left_icon1",
					"std" => " ",
					"type" => "select",
					"options" => $all_icons);
					
$options[] = array( 
                    "desc" => __('Icon #1 text', 'furniot'),
                    "id" => $shortname."upper_header_left_icon1_text",
                    "std" => "",
                    "type" => "text");  
					
$options[] = array( 
					"desc" => __('Icon #2','furniot'),
					"id" => $shortname."upper_header_left_icon2",
					"std" => " ",
					"type" => "select",
					"options" => $all_icons);
					
$options[] = array( 
                    "desc" => __('Icon #2 text', 'furniot'),
                    "id" => $shortname."upper_header_left_icon2_text",
                    "std" => "",
                    "type" => "text");  
					
$options[] = array( 
					"desc" => __('Icon #3','furniot'),
					"id" => $shortname."upper_header_left_icon3",
					"std" => " ",
					"type" => "select",
					"options" => $all_icons);
					
$options[] = array( 
                    "desc" => __('Icon #3 text.', 'furniot'),
                    "id" => $shortname."upper_header_left_icon3_text",
                    "std" => "",
                    "type" => "text");  
					
$options[] = array( "name" => __('Social icons','furniot'),
                    "desc" => __('Icons background color', 'furniot'),
                    "id" => $shortname."upper_header_right_icons_color",
					"std" => "",
                    "type" => "color");  	

$options[] = array( 
					"desc" => __('Icons type?','furniot'),
					"id" => $shortname."upper_header_right_icons_type",
					"std" => "Yes",
					"type" => "select",
					"options" => array(
						'light' => 'light',
						'dark' => 'dark')
					);	
	
$social_icon_values = array("aim", "apple", "behance", "blogger", "cargo", "delicious", "deviantart", "digg", "dopplr", "dribbble", "ember", "evernote", "facebook", "flickr", "forrst", "github", "google", "googleplus", "gowalla", "grooveshark", "html5", "icloud", "lastfm", "linkedin", "metacafe", "mixx", "myspace", "netvibes", "newsvine", "orkut", "paypal", "picasa", "pinterest", "plurk", "posterous", "reddit", "rss", "skype", "stumbleupon", "technorati", "tumblr", "twitter", "vimeo", "wordpress", "yahoo", "yelp", "youtube", "zerply", "zootool");	
					
$options[] = array( 
					"desc" => __('Icon #1','furniot'),
					"id" => $shortname."upper_header_right_icon1",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #1 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon1_url",
                    "std" => "",
                    "type" => "text");  	
					
$options[] = array( 
					"desc" => __('Icon #2','furniot'),
					"id" => $shortname."upper_header_right_icon2",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #2 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon2_url",
                    "std" => "",
                    "type" => "text");  	
					
$options[] = array( 
					"desc" => __('Icon #3','furniot'),
					"id" => $shortname."upper_header_right_icon3",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #3 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon3_url",
                    "std" => "",
                    "type" => "text");  	
					
$options[] = array( 
					"desc" => __('Icon #4','furniot'),
					"id" => $shortname."upper_header_right_icon4",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #4 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon4_url",
                    "std" => "",
                    "type" => "text");  

$options[] = array( 
					"desc" => __('Icon #5','furniot'),
					"id" => $shortname."upper_header_right_icon5",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #5 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon5_url",
                    "std" => "",
                    "type" => "text");  	

$options[] = array( 
					"desc" => __('Icon #6','furniot'),
					"id" => $shortname."upper_header_right_icon6",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #6 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon6_url",
                    "std" => "",
                    "type" => "text");  

$options[] = array( 
					"desc" => __('Icon #7','furniot'),
					"id" => $shortname."upper_header_right_icon7",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #7 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon7_url",
                    "std" => "",
                    "type" => "text");  

$options[] = array( 
					"desc" => __('Icon #8','furniot'),
					"id" => $shortname."upper_header_right_icon8",
					"std" => " ",
					"type" => "select",
					"options" => $social_icon_values);
					
$options[] = array( 
                    "desc" => __('Icon #8 url', 'furniot'),
                    "id" => $shortname."upper_header_right_icon8_url",
                    "std" => "",
                    "type" => "text");  		


$options[] = array( "name" => __('Header#3 Settings','furniot'),
                    "type" => "heading");	
					
$options[] = array( 
                    "desc" => __('Border color', 'furniot'),
                    "id" => $shortname."header3_border_color",
					"std" => "",
                    "type" => "color");  

$options[] = array( 
                    "desc" => __('Border size [px]', 'furniot'),
                    "id" => $shortname."header3_border_size",
                    "std" => "5",
                    "type" => "text");  						
					
		
/**************************** HEADER SETTINGS end ********************************/	


/**************************** MENU SETTINGS start ********************************/	

$options[] = array( "name" => __('Menu Settings','furniot'),
                    "type" => "heading");	

//menu #1
$options[] = array( "name" => __('Main menu settings','furniot'),
					"desc" => __('Menu  font.','furniot'),
					"id" => $shortname."menu1font",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//menu1 font size
$options[] = array(
                    "desc" => __('Menu - font size [px].', 'furniot'),
                    "id" => $shortname."menu1fontsize",
                    "std" => "",
                    "type" => "text");   					

//menu1 font color
$options[] = array( 
                    "desc" => __('Menu - font color', 'furniot'),
                    "id" => $shortname."menu1fontcolor",
                    "std" => "",
                    "type" => "color"); 
					
$options[] = array( 
                    "desc" => __('Menu - active/hover color', 'furniot'),
                    "id" => $shortname."menu1fontcoloractive",
                    "std" => "",
                    "type" => "color"); 	


$options[] = array( 
                    "desc" => __('Menu - active/hover background color', 'furniot'),
                    "id" => $shortname."menu1backgroundcoloractive",
                    "std" => "",
                    "type" => "color"); 						

//menu1 submenu background color
$options[] = array( 
                    "desc" => __('Menu - submenu  background color.', 'furniot'),
                    "id" => $shortname."menu1subbg",
                    "std" => "",
                    "type" => "color");  

$options[] = array( 
                    "desc" => __('Menu - submenu  border color.', 'furniot'),
                    "id" => $shortname."menu1subborder",
                    "std" => "",
                    "type" => "color");  					
					
//menu1 sub font
$options[] = array( 
					"desc" => __('Menu - submenu font.','furniot'),
					"id" => $shortname."menu1subfont",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//menu1 sub font size
$options[] = array(
                    "desc" => __('Menu - submenu font size [px].', 'furniot'),
                    "id" => $shortname."menu1subfontsize",
                    "std" => "",
                    "type" => "text");   					

//menu1 sub font color
$options[] = array( 
                    "desc" => __('Menu  - submenu font color.', 'furniot'),
                    "id" => $shortname."menu1subfontcolor",
                    "std" => "",
                    "type" => "color");  	
					
				

//menu1 submenu font hover color
$options[] = array( 
                    "desc" => __('Menu - submenu  font hover color.', 'furniot'),
                    "id" => $shortname."menu1subhover",
                    "std" => "",
                    "type" => "color");  
			


/**************************** MENU SETTINGS end ********************************/	

/************************ PAGE TITLES  start ****************************/		
			
$options[] = array( "name" => __('Page Titles Settings','furniot'),
                    "type" => "heading");	
		
					
//Page titles font family
$options[] = array( "name" => __('Page titles font','furniot'),
					"desc" => __('Insert font family for page titles','furniot'),
					"id" => $shortname."fontGooglePageTitles",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//Page titles font size					
$options[] = array( 
					"desc" => __('Insert font size for page titles','furniot'),
					"id" => $shortname."fontSizePageTitles",
					"std" => "",
					"type" => "text");	

//Page titles font color					
$options[] = array( 
					"desc" => __('Insert font color for page titles','furniot'),
					"id" => $shortname."fontColPageTitles",
					"std" => "",
					"type" => "color");	
					
//Page titles font family
$options[] = array( "name" => __('Page titles text font','furniot'),
					"desc" => __('Insert font family for page titles text','furniot'),
					"id" => $shortname."fontGooglePageTitlesText",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//Page titles font size					
$options[] = array( 
					"desc" => __('Insert font size for page titles text','furniot'),
					"id" => $shortname."fontSizePageTitlesText",
					"std" => "",
					"type" => "text");	

//Page titles font color					
$options[] = array( 
					"desc" => __('Insert font color for page titles','furniot'),
					"id" => $shortname."fontColPageTitlesText",
					"std" => "",
					"type" => "color");						
					
/************************ PAGE TITLES  end ****************************/

/************************ HEADING SETTINGS start ****************************/		
			
$options[] = array( "name" => __('Heading settings','furniot'),
                    "type" => "heading");	

		
					
//headings font 
$options[] = array( "name" => __('Headings font','furniot'),
					"desc" => __('Insert font family for H1','furniot'),
					"id" => $shortname."fontGoogleH",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);
					
//headings color				
$options[] = array( 
					"desc" => __('Font color for headings','furniot'),
					"id" => $shortname."fontColH",
					"std" => "",
					"type" => "color");			

//H1 font size					
$options[] = array( 
					"desc" => __('Insert font size for H1','furniot'),
					"id" => $shortname."fontSizeH1",
					"std" => "",
					"type" => "text");	
					
//H2 font size					
$options[] = array( 
					"desc" => __('Insert font size for H2','furniot'),
					"id" => $shortname."fontSizeH2",
					"std" => "",
					"type" => "text");	
					
//H3 font size					
$options[] = array( 
					"desc" => __('Insert font size for H3','furniot'),
					"id" => $shortname."fontSizeH3",
					"std" => "",
					"type" => "text");	
					
//H4 font size					
$options[] = array( 
					"desc" => __('Insert font size for H4','furniot'),
					"id" => $shortname."fontSizeH4",
					"std" => "",
					"type" => "text");	

//H5 font size					
$options[] = array( 
					"desc" => __('Insert font size for H5','furniot'),
					"id" => $shortname."fontSizeH5",
					"std" => "",
					"type" => "text");		

/************************ HEADING SETTINGS END ****************************/	

/**************************** FOOTER SETTINGS start ********************************/	
			
$options[] = array( "name" => __('Footer Settings','furniot'),
                    "type" => "heading");
					
					//footer bg color
$options[] = array( "name" => __('Footer background', 'furniot'),
                    "desc" => __('Color for the footer background.', 'furniot'),
                    "id" => $shortname."footer_bg_color",
                    "std" => "",
                    "type" => "color");  
					
//footer background image					
$options[] = array( 
					"desc" => __('Image for the footer background.','furniot'),
					"id" => $shortname."footer_bg_image",
					"std" => "",
					"type" => "upload");
					
//footer background tags	
$options[] = array( 
					"desc" => __('Background tags for footer background.','furniot'),
					"id" => $shortname."footer_bg_tags",
					"std" => "",
					"type" => "text");
					
//footer widget titles font
$options[] = array( "name" => __('Footer widget titles font','furniot'),
					"desc" => __('Font for footer widget titles.','furniot'),
					"id" => $shortname."footer_widget_titles_font",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//footer widget titles font size
$options[] = array( 
                    "desc" => __('Size for footer widget titles font [px].', 'furniot'),
                    "id" => $shortname."footer_widget_titles_font_size",
                    "std" => "",
                    "type" => "text");   					

//footer widget titles font color
$options[] = array( 
                    "desc" => __('Color for footer widget titles font.', 'furniot'),
                    "id" => $shortname."footer_widget_titles_font_color",
                    "std" => "",
                    "type" => "color");  			

//footer font
$options[] = array( "name" => __('Footer font','furniot'),
					"desc" => __('Choose footer font.','furniot'),
					"id" => $shortname."footer_font",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//footer font size
$options[] = array( 
                    "desc" => __('Size for footer font [px].', 'furniot'),
                    "id" => $shortname."footer_font_size",
                    "std" => "",
                    "type" => "text");   					

//footer font color
$options[] = array( 
                    "desc" => __('Color for footer font.', 'furniot'),
                    "id" => $shortname."footer_font_color",
                    "std" => "",
                    "type" => "color");  

//footer URL color
$options[] = array( 
                    "desc" => __('Color for the footer URLs.', 'furniot'),
                    "id" => $shortname."footer_font_color_url",
                    "std" => "",
                    "type" => "color");  

//footer URL hover color
$options[] = array( 
                    "desc" => __('Color for the footer URL hover.', 'furniot'),
                    "id" => $shortname."footer_font_color_url_hover",
                    "std" => "",
                    "type" => "color");  				
					
//footer top border color
$options[] = array( "name" => __('Footer top  border color', 'furniot'),
                    "desc" => __('Select the color for the footer top border.', 'furniot'),
                    "id" => $shortname."footer_top_border_bg",
                    "std" => "",
                    "type" => "color");    

//footer top border size
$options[] = array( "name" => __('Footer top  border size', 'furniot'),
                    "desc" => __('Select the size for the footer top border [px].', 'furniot'),
                    "id" => $shortname."footer_top_border_size",
                    "std" => "",
                    "type" => "text");   

	
//footer bottom border color
$options[] = array( "name" => __('Footer bottom  border color', 'furniot'),
                    "desc" => __('Select the color for the footer bottom border.', 'furniot'),
                    "id" => $shortname."footer_bottom_border_bg",
                    "std" => "",
                    "type" => "color");    

//footer bottom border size
$options[] = array( "name" => __('Footer bottom  border size', 'furniot'),
                    "desc" => __('Select the size for the footer bottom border. [px]', 'furniot'),
                    "id" => $shortname."footer_bottom_border_size",
                    "std" => "",
                    "type" => "text");   


//under footer bg color
$options[] = array( "name" => __('Under footer background', 'furniot'),
                    "desc" => __('Color for the under footer background.', 'furniot'),
                    "id" => $shortname."under_footer_bg_color",
                    "std" => "",
                    "type" => "color");  
					
//under footer background image					
$options[] = array( 
					"desc" => __('Background Image for the under footer.','furniot'),
					"id" => $shortname."under_footer_bg_image",
					"std" => "",
					"type" => "upload");
					
//under footer background tags	
$options[] = array( 
					"desc" => __('Background tags for under footer','furniot'),
					"id" => $shortname."under_footer_bg_tags",
					"std" => "",
					"type" => "text");

//under footer font
$options[] = array( "name" => __('Under footer font','furniot'),
					"desc" => __('Font for under footer.','furniot'),
					"id" => $shortname."under_footer_font",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);

//under footer font size
$options[] = array(
                    "desc" => __('Size for the under footer font [px].', 'furniot'),
                    "id" => $shortname."under_footer_font_size",
                    "std" => "",
                    "type" => "text");   					

//under footer font color
$options[] = array( 
                    "desc" => __('Color for the under footer font.', 'furniot'),
                    "id" => $shortname."under_footer_font_color",
                    "std" => "",
                    "type" => "color");  

//under footer URL  color
$options[] = array( 
                    "desc" => __('URLs color for the under footer.', 'furniot'),
                    "id" => $shortname."under_footer_font_color_url",
                    "std" => "",
                    "type" => "color");  

//under footer URL hover color
$options[] = array( 
                    "desc" => __('URL hover color for the under footer.', 'furniot'),
                    "id" => $shortname."under_footer_font_color_url_hover",
                    "std" => "",
                    "type" => "color");  				
					
//under footer top border color
$options[] = array( "name" => __('Under footer top  border color', 'furniot'),
                    "desc" => __('Select the color for the under footer top border.', 'furniot'),
                    "id" => $shortname."under_footer_top_border_bg",
                    "std" => "",
                    "type" => "color");    

//under footer top border size
$options[] = array( "name" => __('Under footer top  border size', 'furniot'),
                    "desc" => __('Select the size for the under footer top border. [px]', 'furniot'),
                    "id" => $shortname."under_footer_top_border_size",
                    "std" => "",
                    "type" => "text");   

	
//under footer bottom border color
$options[] = array( "name" => __('Under footer bottom  border color', 'furniot'),
                    "desc" => __('Select the color for the under footer bottom border.', 'furniot'),
                    "id" => $shortname."under_footer_bottom_border_bg",
                    "std" => "",
                    "type" => "color");    

//under footer bottom border size
$options[] = array( "name" => __('Under footer bottom  border size', 'furniot'),
                    "desc" => __('Select the size for the under footer bottom border. [px]', 'furniot'),
                    "id" => $shortname."under_footer_bottom_border_size",
                    "std" => "",
                    "type" => "text");   				
						

/**************************** FOOTER SETTINGS end ********************************/		




	
/************************ CONTENT SETTINGS start ****************************/
		
$options[] = array( "name" => __('Content settings','furniot'),
                    "type" => "heading");	
					
//text font family
$options[] = array( "name" => __('Text font','furniot'),
					"desc" => __('Insert font family for text','furniot'),
					"id" => $shortname."fontGoogleText",
					"std" => " ",
					"type" => "select",
					"options" => $fonts);
					
//Font sizes
$options[] = array( "name" => __('Font sizes. In [] are the default values.','furniot'),
					"desc" => __('Text font size [13]','furniot'),
					"id" => $shortname."fontSizeText",
					"std" => "",
					"type" => "text");	
							
					
/************************ CONTENT SETTINGS end ****************************/
		
				
$options[] = array( "name" => __('404 page Settings','furniot'),
                    "type" => "heading");


$options[] = array( "name" => __('Page 404 settings.','furniot'),
					"desc" => __('Page title','furniot'),
					"id" => $shortname."page404pagetitle",
					"std" => "",
					"type" => "text");

$options[] = array( "desc" => __('Page title text','furniot'),
					"id" => $shortname."page404pagetitletext",
					"std" => "",
					"type" => "text");		

$options[] = array( 
					"desc" => __('Content title','furniot'),
					"id" => $shortname."page404title",
					"std" => "",
					"type" => "text");	
					
$options[] = array( 
					"desc" => __('Text1','furniot'),
					"id" => $shortname."page404text1",
					"std" => "",
					"type" => "text");	
					
$options[] = array( 
					"desc" => __('Text2','furniot'),
					"id" => $shortname."page404text2",
					"std" => "",
					"type" => "text");	
					
$options[] = array( 
					"desc" => __('Image','furniot'),
					"id" => $shortname."page404image",
					"std" => "",
					"type" => "upload");	
					
$options[] = array( 
					"desc" => __('Show search form on 404 page?','furniot'),
					"id" => $shortname."show_search404",
					"std" => "Yes",
					"type" => "select",
					"options" => array(
						'Yes' => 'Yes',
						'No' => 'No')
					);
					
$options[] = array( 
					"desc" => __('List title','furniot'),
					"id" => $shortname."listtitle404",
					"std" => "",
					"type" => "text");	
					
$options[] = array( 
					"desc" => __('List content','furniot'),
					"id" => $shortname."listcontent404",
					"std" => "",
					"type" => "textarea");	
					

$options[] = array( 
					"desc" => __('404 page','furniot'),
					"id" => $shortname."pageFor404",
					"std" => " ",
					"type" => "select",
					"options" => $allPages);	

		
/**************************** PORTFOLIO SETTINGS start ********************************/	

$options[] = array( "name" => __('Portfolio Settings','furniot'),
                    "type" => "heading");
					

$options[] = array( "name" => __('Portfolio 2/3 related options','furniot'),
					"desc" => __('Show related items on 2/3 portfolios.','furniot'),
					"id" => $shortname."twothirdportfolio_show",
					"std" => "true",
					"type" => "checkbox");


$options[] = array(
					"desc" => __('Related title.','furniot'),
					"id" => $shortname."twothirdportfolio_title",
					"std" => __('Related items','furniot'),
					"type" => "text");	
					
$options[] = array( 
					"desc" => __('Related items size.','furniot'),
					"id" => $shortname."twothirdportfolio_itemsize",
					"std" => __('','furniot'),
					"type" => "select",
					"options" => array(
						'Fourth' => 'Fourth',
						'Third' => 'Third',
						'Half' => 'Half')
					);	
$options[] = array( 
					"desc" => __('Number of related items. If left emtpy all related items will be displayed.','furniot'),
					"id" => $shortname."twothirdportfolio_number",
					"std" => __('','furniot'),
					"type" => "text");		
		
										
/**************************** PORTFOLIO SETTINGS end ********************************/		


/**************************** BLOG SETTINGS start ********************************/	

$options[] = array( "name" => __('Blog Settings','furniot'),
                    "type" => "heading");
					
$options[] = array( "name" => __('Blog read more title','furniot'),
					"desc" => __('Input the title for read more button.','furniot'),
					"id" => $shortname."read_more_title",
					"std" => __('&#151; Read more &#151;','furniot'),
					"type" => "text");	
										
/**************************** BLOG SETTINGS end ********************************/	


/**************************** 	TWITTER SETTINGS start ********************************/	

$options[] = array( "name" => __('Twitter settings','furniot'),
                    "type" => "heading");
		
		
$options[] = array( 
					"desc" => __('Consumer Key','furniot'),
					"id" => $shortname."consumerkey",
					"std" => "",
					"type" => "text");	

$options[] = array( 
					"desc" => __('Consumer Secret','furniot'),
					"id" => $shortname."consumersecret",
					"std" => "",
					"type" => "text");	

$options[] = array( 
					"desc" => __('Access Token','furniot'),
					"id" => $shortname."accesstoken",
					"std" => "",
					"type" => "text");	

$options[] = array( 
					"desc" => __('Access Token Secret','furniot'),
					"id" => $shortname."accesstokensecret",
					"std" => "",
					"type" => "text");						

/**************************** 	TWITTER SETTINGS end ********************************/	
	
	
/**************************** WOOCOMMERCE SETTINGS start ********************************/	

	if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {	
		
		$options[] = array( "name" => __('WooCommerce Settings','furniot'),
                    "type" => "heading");
					
		$options[] = array( "name" => __('Shop Title','furniot'),
					"desc" => __('Input the title for the shop.','furniot'),
					"id" => $shortname."shop_title",
					"std" => __('Shop','furniot'),
					"type" => "text");						
					
		$options[] = array( "name" => __('Shop - sidebar position.','furniot'),
					"desc" => __('Select sidebar position. Sidebar will display only if there is at elast one widget inside it.','furniot'),
					"id" => $shortname."shop_sidebar_position",
					"std" => "Left",
					"type" => "select",
					"options" => array(
						'Left' => 'Left',
						'Right' => 'Right')
					);					
	}
	


update_option('template_name',$options); 					  
update_option('pego_themename',$themename);   
update_option('pego_shortname',$shortname);

    }
}





//function that reads fonts
function return_google_api_fonts() { 

	$allFontFromAPI= json_decode('{
 "kind": "webfonts#webfontList",
 "items": [
  {
   "kind": "webfonts#webfont",
   "family": "ABeeZee",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Abel",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Abril Fatface",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aclonica",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Acme",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Actor",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Adamina",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Advent Pro",
   "variants": [
    "100",
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aguafina Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Akronim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aladin",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aldrich",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alegreya",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alegreya SC",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alex Brush",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alfa Slab One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alice",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alike",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alike Angular",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allan",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allerta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allerta Stencil",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allura",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Almendra",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Almendra Display",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Almendra SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amarante",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amaranth",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amatic SC",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amethysta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Anaheim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Andada",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Andika",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Angkor",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Annie Use Your Telescope",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Anonymous Pro",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Antic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Antic Didone",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Antic Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Anton",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arapey",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arbutus",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arbutus Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Architects Daughter",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Archivo Black",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Archivo Narrow",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arimo",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arizonia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Armata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Artifika",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arvo",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Asap",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Asset",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Astloch",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Asul",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Atomic Age",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aubrey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Audiowide",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Autour One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Average",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Average Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Gruesa Libre",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Libre",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Sans Libre",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Serif Libre",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bad Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Balthazar",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bangers",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Basic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Battambang",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Baumans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bayon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Belgrano",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Belleza",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "BenchNine",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bentham",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Berkshire Swash",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bevan",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bigelow Rules",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bigshot One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bilbo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bilbo Swash Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bitter",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Black Ops One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bokor",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bonbon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Boogaloo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bowlby One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bowlby One SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Brawler",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bree Serif",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bubblegum Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bubbler One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Buda",
   "variants": [
    "300"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Buenard",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Butcherman",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Butterfly Kids",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cabin",
   "variants": [
    "regular",
    "italic",
    "500",
    "500italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cabin Condensed",
   "variants": [
    "regular",
    "500",
    "600",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cabin Sketch",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Caesar Dressing",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cagliostro",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Calligraffitti",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cambo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Candal",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cantarell",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cantata One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cantora One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Capriola",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cardo",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin",
    "greek-ext"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carme",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carrois Gothic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carrois Gothic SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carter One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Caudex",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin",
    "greek-ext"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cedarville Cursive",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ceviche One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Changa One",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chango",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chau Philomene One",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chela One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chelsea Market",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chenla",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cherry Cream Soda",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cherry Swash",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chewy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chicle",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chivo",
   "variants": [
    "regular",
    "italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cinzel",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cinzel Decorative",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Clicker Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coda",
   "variants": [
    "regular",
    "800"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coda Caption",
   "variants": [
    "800"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Codystar",
   "variants": [
    "300",
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Combo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Comfortaa",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coming Soon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Concert One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Condiment",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Content",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Contrail One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Convergence",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cookie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Copse",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Corben",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Courgette",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cousine",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coustard",
   "variants": [
    "regular",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Covered By Your Grace",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crafty Girls",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Creepster",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crete Round",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crimson Text",
   "variants": [
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Croissant One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crushed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cuprum",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cutive",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cutive Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Damion",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dancing Script",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dangrek",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dawning of a New Day",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Days One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Delius",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Delius Swash Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Delius Unicase",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Della Respira",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Denk One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Devonshire",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Didact Gothic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Diplomata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Diplomata SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Domine",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Donegal One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Doppio One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dorsa",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dosis",
   "variants": [
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700",
    "800"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dr Sugiyama",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Droid Sans",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Droid Sans Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Droid Serif",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Duru Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dynalight",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "EB Garamond",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Eagle Lake",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Eater",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Economica",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Electrolize",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Elsie",
   "variants": [
    "regular",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Elsie Swash Caps",
   "variants": [
    "regular",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Emblema One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Emilys Candy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Engagement",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Englebert",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Enriqueta",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Erica One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Esteban",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Euphoria Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ewert",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Exo",
   "variants": [
    "100",
    "100italic",
    "200",
    "200italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "500",
    "500italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "800",
    "800italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Expletus Sans",
   "variants": [
    "regular",
    "italic",
    "500",
    "500italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fanwood Text",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fascinate",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fascinate Inline",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Faster One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fasthand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Federant",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Federo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Felipa",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fenix",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Finger Paint",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fjalla One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fjord One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Flamenco",
   "variants": [
    "300",
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Flavors",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fondamento",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fontdiner Swanky",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Forum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Francois One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Freckle Face",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fredericka the Great",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fredoka One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Freehand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fresca",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Frijole",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fruktur",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fugaz One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "GFS Didot",
   "variants": [
    "regular"
   ],
   "subsets": [
    "greek"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "GFS Neohellenic",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "greek"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gabriela",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gafata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Galdeano",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Galindo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gentium Basic",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gentium Book Basic",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Geo",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Geostar",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Geostar Fill",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Germania One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gilda Display",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Give You Glory",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Glass Antiqua",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Glegoo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gloria Hallelujah",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Goblin One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gochi Hand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gorditas",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Goudy Bookletter 1911",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Graduate",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Grand Hotel",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gravitas One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Great Vibes",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Griffy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gruppo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gudea",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Habibi",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hammersmith One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hanalei",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hanalei Fill",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Handlee",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hanuman",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Happy Monkey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Headland One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Henny Penny",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Herr Von Muellerhoff",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Holtwood One SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Homemade Apple",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Homenaje",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell DW Pica",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell DW Pica SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Double Pica",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Double Pica SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell English",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell English SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell French Canon",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell French Canon SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Great Primer",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Great Primer SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Iceberg",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Iceland",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Imprima",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Inconsolata",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Inder",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Indie Flower",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Inika",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Irish Grover",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Istok Web",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Italiana",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Italianno",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jacques Francois",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jacques Francois Shadow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jim Nightshade",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jockey One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jolly Lodger",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Josefin Sans",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Josefin Slab",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Joti One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Judson",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Julee",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Julius Sans One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Junge",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jura",
   "variants": [
    "300",
    "regular",
    "500",
    "600"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Just Another Hand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Just Me Again Down Here",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kameron",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Karla",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kaushan Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kavoon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Keania One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kelly Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kenia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Khmer",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kite One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Knewave",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kotta One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Koulen",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kranky",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kreon",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kristi",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Krona One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "La Belle Aurore",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lancelot",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lato",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "League Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Leckerli One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ledger",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lekton",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lemon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Libre Baskerville",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Life Savers",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lilita One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Limelight",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Linden Hill",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lobster",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lobster Two",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Outline",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Shadow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Sketch",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Solid",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lora",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Love Ya Like A Sister",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Loved by the King",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lovers Quarrel",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Luckiest Guy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lusitana",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lustria",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Macondo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Macondo Swash Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Magra",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Maiden Orange",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mako",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marcellus",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marcellus SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marck Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Margarine",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marko One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marmelad",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marvel",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mate",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mate SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Maven Pro",
   "variants": [
    "regular",
    "500",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "McLaren",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Meddon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "MedievalSharp",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Medula One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Megrim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Meie Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merienda",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merienda One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merriweather",
   "variants": [
    "300",
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merriweather Sans",
   "variants": [
    "300",
    "regular",
    "700",
    "800"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metal",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metal Mania",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metamorphous",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metrophobic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Michroma",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Milonga",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miltonian",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miltonian Tattoo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miniver",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miss Fajardose",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Modern Antiqua",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Molengo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Molle",
   "variants": [
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monda",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monofett",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monoton",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monsieur La Doulaise",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montaga",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montez",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montserrat",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montserrat Alternates",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montserrat Subrayada",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Moul",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Moulpali",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mountains of Christmas",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mouse Memoirs",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mr Bedfort",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mr Dafoe",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mr De Haviland",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mrs Saint Delafield",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mrs Sheppards",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Muli",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mystery Quest",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Neucha",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Neuton",
   "variants": [
    "200",
    "300",
    "regular",
    "italic",
    "700",
    "800"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "New Rocker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "News Cycle",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Niconne",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nixie One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nobile",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nokora",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Norican",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nosifer",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nothing You Could Do",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noticia Text",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noto Sans",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noto Sans UI",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noto Serif",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Cut",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Flat",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "greek",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Oval",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Round",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Slim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Square",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Numans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nunito",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Odor Mean Chey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Offside",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Old Standard TT",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oldenburg",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oleo Script",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oleo Script Swash Caps",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Open Sans",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "800",
    "800italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Open Sans Condensed",
   "variants": [
    "300",
    "300italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oranienbaum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Orbitron",
   "variants": [
    "regular",
    "500",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oregano",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Orienta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Original Surfer",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oswald",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Over the Rainbow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Overlock",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Overlock SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ovo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oxygen",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oxygen Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Sans",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Sans Caption",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Sans Narrow",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Serif",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Serif Caption",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pacifico",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Paprika",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Parisienne",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Passero One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Passion One",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Patrick Hand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Patrick Hand SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Patua One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Paytone One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Peralta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Permanent Marker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Petit Formal Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Petrona",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Philosopher",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Piedra",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pinyon Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pirata One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Plaster",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Play",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Playball",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Playfair Display",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Playfair Display SC",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Podkova",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Poiret One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Poller One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Poly",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pompiere",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pontano Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Port Lligat Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Port Lligat Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Prata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Preahvihear",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Press Start 2P",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Princess Sofia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Prociono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Prosto One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Puritan",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Purple Purse",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quando",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quantico",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quattrocento",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quattrocento Sans",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Questrial",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quicksand",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quintessential",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Qwigley",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Racing Sans One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Radley",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Raleway",
   "variants": [
    "100",
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700",
    "800",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Raleway Dots",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rambla",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rammetto One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ranchers",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rancho",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rationale",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Redressed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Reenie Beanie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Revalia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ribeye",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ribeye Marrow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Righteous",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Risque",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Roboto",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "500",
    "500italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Roboto Condensed",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rochester",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rock Salt",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rokkitt",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Romanesco",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ropa Sans",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rosario",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rosarivo",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rouge Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruda",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rufina",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruge Boogie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruluko",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rum Raisin",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruslan Display",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Russo One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruthie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rye",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sacramento",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sail",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Salsa",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sanchez",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sancreek",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sansita One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sarina",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Satisfy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Scada",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Schoolbell",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Seaweed Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sevillana",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Seymour One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shadows Into Light",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shadows Into Light Two",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shanti",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Share",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Share Tech",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Share Tech Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shojumaru",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Short Stack",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Siemreap",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sigmar One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Signika",
   "variants": [
    "300",
    "regular",
    "600",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Signika Negative",
   "variants": [
    "300",
    "regular",
    "600",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Simonetta",
   "variants": [
    "regular",
    "italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sintony",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sirin Stencil",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Six Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Skranji",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Slackey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Smokum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Smythe",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sniglet",
   "variants": [
    "800"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Snippet",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Snowburst One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sofadi One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sofia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sonsie One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sorts Mill Goudy",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Source Code Pro",
   "variants": [
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Source Sans Pro",
   "variants": [
    "200",
    "200italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Special Elite",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Spicy Rice",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Spinnaker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Spirax",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Squada One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stalemate",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stalinist One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stardos Stencil",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stint Ultra Condensed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stint Ultra Expanded",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stoke",
   "variants": [
    "300",
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Strait",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sue Ellen Francisco",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sunshiney",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Supermercado One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Suwannaphum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Swanky and Moo Moo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Syncopate",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tangerine",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Taprom",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tauri",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Telex",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tenor Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Text Me One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "The Girl Next Door",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tienne",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tinos",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Titan One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Titillium Web",
   "variants": [
    "200",
    "200italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trade Winds",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trocchi",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trochut",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trykker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tulpen One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ubuntu",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "500",
    "500italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ubuntu Condensed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ubuntu Mono",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ultra",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Uncial Antiqua",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Underdog",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unica One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "UnifrakturCook",
   "variants": [
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "UnifrakturMaguntia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unkempt",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unlock",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unna",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "VT323",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vampiro One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Varela",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Varela Round",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vast Shadow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vibur",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vidaloka",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Viga",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Voces",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Volkhov",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vollkorn",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Voltaire",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Waiting for the Sunrise",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wallpoet",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Walter Turncoat",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Warnes",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wellfleet",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wendy One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wire One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yanone Kaffeesatz",
   "variants": [
    "200",
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yellowtail",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yeseva One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yesteryear",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Zeyada",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  }
 ]
}
',true);

return $allFontFromAPI['items'];
}	
	

?>
