<?php
/*
	Plugin Name: ContactForm7 Widget
	Description: ContactForm7 widget.
	Author: PEGO
	Version: 1.0
	Author URI:  
*/
class contactform7_widget extends WP_Widget {
/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
function contactform7_Widget() {
	$widget_options = array(
		'classname' => 'contactform7_widget',
		'description' => __('Custom contactform7 widget.','furniot')
	);
		
	$control_options = array(    //dodama svoje incializirane mere
		'width' => 200,
		'height' => 400,
		'id_base' => 'contactform7_widget'
	);
	$this->WP_Widget( 'contactform7_widget', __('Pego - Contact Form 7','furniot'), $widget_options, $control_options );	
}
function widget( $args, $instance ) {
	
	extract( $args );
	$title = apply_filters('widget_title', $instance['title'] );
	$code = $instance['code'];
	$values = pego_get_contact_forms();
	$key = array_search($code, $values); 	
	$shortcode = '[contact-form-7 id="'.$key.'" title="'.$code.'"]';
	echo $before_widget;
	echo $before_title.$title.$after_title;
	echo do_shortcode($shortcode);
	echo $after_widget;
}
function form( $instance ) {	
		/* Set the default values  */
		$defaults = array(
		'title' => __('Contact form','furniot'),
		'code' => ''
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); 

		$allContactForms7 = array();
		global $wpdb;
		global $table_prefix;
		$table_prefix = $wpdb->base_prefix;
		$wpdb->tablename = $table_prefix . 'posts';
		$contact_forms7 = $wpdb->get_results( 
				"
				SELECT ID,post_title 
				FROM $wpdb->tablename
				WHERE post_type = 'wpcf7_contact_form'
				"
				);
		foreach ( $contact_forms7 as $contact_form7 ) 
		{							
			$allContactForms7[$contact_form7->ID] = $contact_form7->post_title;	
		}										
	 ?>

		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
		Title:
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" 
				 name="<?php echo $this->get_field_name( 'title' ); ?>" 
				 value="<?php echo $instance['title']; ?>" />
		</label>
		
		<label for="<?php echo $this->get_field_id( 'code' ); ?>">
		Contact form:
		   <select name="<?php echo $this->get_field_name('code'); ?>" 
                  id="<?php echo $this->get_field_id('code'); ?>"
                class="widefat">
          <?php 
            foreach ($allContactForms7 as $code)
              {     
              ?>
                <option <?php if ($instance['code'] == $code) echo 'selected="selected"' ?>   value="<?php echo $code; ?>"><?php echo $code; ?></option>
              <?php
              }
              ?>
          </select> 
			</label>
		
			
	<?php
	}
}


/*     Adding widget to widgets_init and registering flickr widget    */
add_action( 'widgets_init', 'contactform7_widgets' );

function contactform7_widgets() {
	register_widget( 'contactform7_Widget' );
}
?>