<?php
/*

	Plugin Name: Latest Portfolios Widget
	Description: Plugin is used for portoflio items.
	Author:
	Version: 1.0
	Author URI: 
 
*/

class latest_portfolio_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
function latest_portfolio_Widget() {

	$widget_options = array(
		'classname' => 'latest_portfolio_widget',
		'description' => __('Custom latest portfolio widget.', "furniot")
	);

	$control_options = array(    //dodama svoje incializirane mere
		'width' => 200,
		'height' => 400,
		'id_base' => 'latest_portfolio_widget'
	);

	$this->WP_Widget( 'latest_portfolio_widget', __('Pego - Latest Portfolio Widget', "furniot"), $widget_options, $control_options );
	
}



function widget( $args, $instance ) {
	
	extract( $args );
	global $post;
	$title = apply_filters('widget_title', $instance['title'] );
	$posts_number = $instance['posts_number'];

	echo $before_widget;
	
	if ( $title )
	{
		echo $before_title;
		echo $title;
		echo $after_title;
	}
	
	$args = array('post_type'=> 'portfolio', 'posts_per_page' => $posts_number, 'order'=> 'DESC', 'orderby' => 'post_date'  );

	$port_query = new WP_Query( $args );
    ?>
	<div class="latest-portfolio-widget-wrapper">
	<?php
	
   if( $port_query->have_posts() ) : while( $port_query->have_posts() ) : $port_query->the_post(); 
				
	?>
	<div class="latest-portfolio-widget-single tooltip">							
		<?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'single-post-thumbnail' ); ?>
		<a href="<?php the_permalink();?>" title="<?php the_title(); ?>">						
			<?php echo get_the_post_thumbnail($post->ID,'WidgetImage', array('alt' => '', 'title' => '')); ?>
		</a>							
	</div>		
	<?php endwhile; endif; wp_reset_postdata(); ?>	
	<div class="clearfix"></div>		
	</div>
	<?php 
	echo $after_widget;	
}


function form( $instance ) {  

	/* Set the default values  */
		$defaults = array(
		'title' => 'Portfolio Items',
		'posts_number' => '6',
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); 

	 ?>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>">
		<?php _e('Title:', "furniot"); ?>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'title' ); ?>" 
				 name="<?php echo $this->get_field_name( 'title' ); ?>" 
				 value="<?php echo $instance['title']; ?>" />
		</label>
																													
		<label for="<?php echo $this->get_field_id( 'posts_number' ); ?>">
		<?php _e('Number of items:','furniot'); ?>
		<input class="widefat" type="text" id="<?php echo $this->get_field_id( 'posts_number' ); ?>" 
				 name="<?php echo $this->get_field_name( 'posts_number' ); ?>" 
				 value="<?php echo $instance['posts_number']; ?>" />
		</label>		
	<?php
	}
}
/*     Adding widget to widgets_init and registering flickr widget    */
add_action( 'widgets_init', 'latest_portfolio_widgets' );

function latest_portfolio_widgets() {
	register_widget( 'latest_portfolio_Widget' );
}
?>