<?php
	add_action('init', 'pego_pb_scripts');
	function pego_pb_scripts(){	
		wp_enqueue_style('pego-pb-style',get_template_directory_uri().'/pego-pb/css/pego-pb-style.css');	
		wp_enqueue_style('colorpickercss',get_template_directory_uri().'/pego-pb/css/colorpicker.css');	
		if(is_admin()){				
			wp_deregister_script('pego-pg-scripts');
			wp_register_script('pego-pg-scripts', get_template_directory_uri().'/pego-pb/js/pego-pg-scripts.js', false, '1.0', true);					
			wp_enqueue_script('pego-pg-scripts');		
			wp_enqueue_script('colorpickerjs', get_template_directory_uri().'/pego-pb/js/colorpicker.js', false, '1.0', true);				
		}	
	}	
	
	function set_nonce(){	
		wp_nonce_field( plugin_basename( __FILE__ ), 'myplugin_noncename');		
	}

	add_action('save_post','save_option_meta');
	function save_option_meta($post_id){
		if(defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE) return;
		if(!isset($_POST['myplugin_noncename'])) return;
		if(!wp_verify_nonce($_POST['myplugin_noncename'], plugin_basename( __FILE__ ))) return;
		
		//if('page' == $_POST['post_type']){		
			if(!current_user_can('edit_page', $post_id)) return;			
			save_page_option_meta($post_id);			
		//}
	}
	
	function pego_pb_save_data($post_id, $new_data, $old_data, $name){

		if($new_data == $old_data){
		
			add_post_meta($post_id, $name, $new_data, true);
			
		}else if(!$new_data){
		
			delete_post_meta($post_id, $name, $old_data);
			
		}else if($new_data != $old_data){

			update_post_meta($post_id, $name, $new_data, $old_data);
			
		}
	}	
	
	//call for shortcodes
	include_once('shortcodes.php');	 
	
	/* pego builder START */
	
		$pego_page_elements = array(
		"Pego PB element" => array(
			'type'=>'pego-pb-element',
			'item'=>'pego-pb-element-type' ,
			'size'=>'pego-pb-element-size', 
			'shortcode' => 'pego-pb-element-shortcode',			
			'name'=>array(		
				'Column'=>array(
					'header'=>array(
						'title'=> 'Column title',
						'name'=> 'pego-pb-element-column-title',
						'type'=> 'text'),						
					'column-text'=>array(
						'title'=> 'Column Text',
						'name'=> 'pego-pb-element-column-text',
						'type'=> 'textarea')
				),
				'Separator' =>array(
					'color'=>array(
						'title'=> 'Color',
						'name'=> 'pego-pb-element-separator-color',
						'type'=> 'color'),
					'type' =>array(
						'title'=> 'Type',
						'name'=> 'pego-pb-element-separator-type',
						'std' => '',
						'type' => 'select',
						'options' => array(
							'solid' => 'solid',
							'double' => 'double',
							'groove' => 'groove',
							'dotted' => 'dotted',
							'dashed' => 'dashed')
					),					
					'height' =>array(
						'title'=> 'Height',
						'name'=> 'pego-pb-element-separator-height',
						'type'=> 'inputtext'	
					)					
				),
				'List'=>array(
					'header'=>array(
						'title'=> 'List title',
						'name'=> 'pego-pb-element-list-title',
						'type'=> 'text'),	
					'icon'=>array(
						'title'=> 'List icon',
						'name'=> 'pego-pb-element-list-icon',
						'type'=> 'upload'),	
					'num'=>array(
						'title'=> 'Number of list elements',
						'name'=> 'pego-pb-element-list-num',
						'type'=> 'text'),
					'list-item-element'=>array(
						'title'=> 'List item',
						'name'=> 'pego-pb-element-list-item',
						'type'=> 'text'),
					'list-item-element-url'=>array(
						'title'=> 'List item',
						'name'=> 'pego-pb-element-list-item-url',
						'type'=> 'text')						
				),
				'Button'=>array(
					'caption'=>array(
						'title'=> 'Button Caption',
						'name'=> 'pego-pb-element-button-caption',
						'type'=> 'text'),						
					'url'=>array(
						'title'=> 'Button Url',
						'name'=> 'pego-pb-element-button-url',
						'type'=> 'text'),
					'color'=>array(
						'title'=> 'Button Color',
						'name'=> 'pego-pb-element-button-color',
						'type'=> 'color'),
					'type' =>array(
						'title'=> 'Button Type',
						'name'=> 'pego-pb-element-button-type',
						'std' => '',
						'type' => 'select',
						'options' => array(
							'default' => 'default',
							'green' => 'green',
							'red' => 'red')
					)	
				),
			  'ColImage'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-columnwithicon-title',
						'type'=> 'text'),	
				    'ColumnsType' =>array(
						'title'=> 'Type',
						'name'=> 'pego-pb-element-columnwithicon-type',
						'std' => '',
						'type' => 'select',
						'options' => array(
							'type1' => 'type1',
							'type2' => 'type2',
							'type3' => 'type3')
					),	
					'content'=>array(
						'title'=> 'Content',
						'name'=> 'pego-pb-element-columnwithicon-content',
						'type'=> 'text'),	
					'icon'=>array(
						'title'=> 'Icon',
						'name'=> 'pego-pb-element-columnwithicon-icon',
						'type'=> 'upload'),	
					'iconhover'=>array(
						'title'=> 'Icon',
						'name'=> 'pego-pb-element-columnwithicon-iconhover',
						'type'=> 'upload'),	
					'url'=>array(
						'title'=> 'Url',
						'name'=> 'pego-pb-element-columnwithicon-url',
						'type'=> 'text'),
					'color'=>array(
						'title'=> 'Button Color',
						'name'=> 'pego-pb-element-columnwithicon-buttontype',
						'type'=> 'color'),
					'type' =>array(
						'title'=> 'Button Type',
						'name'=> 'pego-pb-element-columnwithicon-buttontype',
						'std' => '',
						'type' => 'select',
						'options' => array(
							'small' => 'small',
							'medium' => 'medium',
							'big' => 'big')),
					'button_caption'=>array(
						'title'=> 'Button Caption',
						'name'=> 'pego-pb-element-columnwithicon-buttonCaption',
						'type'=> 'text'),					
				),
				'Portfolio'=>array(
					'header'=>array(
						'title'=> 'Portfolio items title',
						'name'=> 'pego-pb-element-portfolio-items-title',
						'type'=> 'text'),
					'portfolio-item-size'=>array(
						'title'=> 'Portfolio item',
						'name'=> 'pego-pb-element-portfolio-size-item',
						'type'=> 'select'),	
					'portfolio-item-read'=>array(
						'title'=> 'Portfolio items read',
						'name'=> 'pego-pb-element-portfolio-item-read',
						'type'=> 'select'),	
					'number-of-portfolios'=>array(
						'title'=> 'Number of portfolios',
						'name'=> 'pego-pb-element-portfolio-items-show-number',
						'type'=> 'text'),	
					'num'=>array(
						'title'=> 'Number of list portfolio items',
						'name'=> 'pego-pb-element-portfolio-items-num',
						'type'=> 'text'),
					'portfolio-item-element'=>array(
						'title'=> 'Portfolio item',
						'name'=> 'pego-pb-element-portfolio-items-item',
						'type'=> 'select'),
					'portfolio-item-category'=>array(
						'title'=> 'Portfolio category',
						'name'=> 'pego-pb-element-portfolio-items-category',
						'type'=> 'select'),
					'portfolio-item-element-showing-type'=>array(
						'title'=> 'Showing type',
						'name'=> 'pego-pb-element-portfolio-items-showing-type',
						'type'=> 'select')					
				),
				'Carousel'=>array(
					'header'=>array(
						'title'=> 'Carousel title',
						'name'=> 'pego-pb-element-carousel-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of carousel elements',
						'name'=> 'pego-pb-element-carousel-num',
						'type'=> 'text'),
					'width'=>array(
						'title'=> 'Carousel element width',
						'name'=> 'pego-pb-element-carousel-width',
						'type'=> 'text'),
					'carousel-item-element'=>array(
						'title'=> 'Carousel item',
						'name'=> 'pego-pb-element-carousel-image',
						'type'=> 'upload'),
					'carousel-item-element-url'=>array(
						'title'=> 'Carousel item',
						'name'=> 'pego-pb-element-carousel-url',
						'type'=> 'text')						
				),
				'Toggle'=>array(
					'header'=>array(
						'title'=> 'Toggle title',
						'name'=> 'pego-pb-element-toggle-main-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of toggle elements',
						'name'=> 'pego-pb-element-toggle-num',
						'type'=> 'text'),
					'toggle-title'=>array(
						'title'=> 'Toggle item',
						'name'=> 'pego-pb-element-toggle-title',
						'type'=> 'text'),
					'toggle-content'=>array(
						'title'=> 'Toggle content',
						'name'=> 'pego-pb-element-toggle-content',
						'type'=> 'textarea'),
					'toggle-status'=>array(
						'title'=> 'Toggle content',
						'name'=> 'pego-pb-element-toggle-status',
						'type'=> 'text')						
				),
				'Tab'=>array(
					'header'=>array(
						'title'=> 'Tab title',
						'name'=> 'pego-pb-element-tab-main-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of tab elements',
						'name'=> 'pego-pb-element-tab-num',
						'type'=> 'text'),
					'tab-title'=>array(
						'title'=> 'tab item',
						'name'=> 'pego-pb-element-tab-title',
						'type'=> 'text'),
					'tab-content'=>array(
						'title'=> 'tab content',
						'name'=> 'pego-pb-element-tab-content',
						'type'=> 'textarea')						
				),
				'GoogleMaps'=>array(
					'latitude'=>array(
						'title'=> 'Latitude',
						'name'=> 'pego-pb-element-maps-latitude',
						'type'=> 'text'),						
					'longitude'=>array(
						'title'=> 'Longitude',
						'name'=> 'pego-pb-element-maps-longitude',
						'type'=> 'text'),
					'height'=>array(
						'title'=> 'Maps Height',
						'name'=> 'pego-pb-element-maps-height',
						'type'=> 'text'),
					'title'=>array(
						'title'=> 'Maps Title',
						'name'=> 'pego-pb-element-maps-title',
						'type'=> 'text')						
				),
				'Posts'=>array(
					'header'=>array(
						'title'=> 'Posts items title',
						'name'=> 'pego-pb-element-posts-items-title',
						'type'=> 'text'),
					'posts-item-size'=>array(
						'title'=> 'Post item',
						'name'=> 'pego-pb-element-posts-size-item',
						'type'=> 'select'),	
					'posts-item-read'=>array(
						'title'=> 'Post items read',
						'name'=> 'pego-pb-element-posts-item-read',
						'type'=> 'select'),	
					'number-of-posts'=>array(
						'title'=> 'Number of posts',
						'name'=> 'pego-pb-element-posts-items-show-number',
						'type'=> 'text'),	
					'summary-length'=>array(
						'title'=> 'Summary length',
						'name'=> 'pego-pb-element-posts-items-summary-length',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of posts items',
						'name'=> 'pego-pb-element-posts-items-num',
						'type'=> 'text'),
					'posts-item-element'=>array(
						'title'=> 'Post  item',
						'name'=> 'pego-pb-element-posts-items-item',
						'type'=> 'select')						
				),
				'Blockquote'=>array(
					'header'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-quote1-title',
						'type'=> 'text'),						
					'quote-text'=>array(
						'title'=> 'Quote Text',
						'name'=> 'pego-pb-element-quote1-text',
						'type'=> 'textarea'),
					'quote-icon'=>array(
						'title'=> 'Quote Icon',
						'name'=> 'pego-pb-element-quote1-icon',
						'type'=> 'textarea')
						
				),
				'Video'=>array(
					'header'=>array(
						'title'=> 'Video title',
						'name'=> 'pego-pb-element-video-title',
						'type'=> 'text'),						
					'video-iframe'=>array(
						'title'=> 'Video Iframe',
						'name'=> 'pego-pb-element-video-iframe',
						'type'=> 'textarea')
				),
				'Slider'=>array(
					'title'=>array(
						'title'=> 'Slider alias',
						'name'=> 'pego-pb-element-slider-alias',
						'type'=> 'select')
				),
				'Testimonials'=>array(
					'header'=>array(
						'title'=> 'Testimonials title',
						'name'=> 'pego-pb-element-testimonials-main-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of testimonial elements',
						'name'=> 'pego-pb-element-testimonials-num',
						'type'=> 'text'),
					'testimonials-title'=>array(
						'title'=> 'testimonials item',
						'name'=> 'pego-pb-element-testimonials-title',
						'type'=> 'text'),
					'testimonials-content'=>array(
						'title'=> 'testimonials content',
						'name'=> 'pego-pb-element-testimonials-content',
						'type'=> 'textarea')						
				),
				'ProgressBar'=>array(
					'header'=>array(
						'title'=> 'Progress bar title',
						'name'=> 'pego-pb-element-progressbar-main-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of progress bar elements',
						'name'=> 'pego-pb-element-progressbar-num',
						'type'=> 'text'),
					'progressbar-title'=>array(
						'title'=> 'progressbar item',
						'name'=> 'pego-pb-element-progressbar-title',
						'type'=> 'text'),
					'progressbar-id'=>array(
						'title'=> 'progressbar id',
						'name'=> 'pego-pb-element-progressbar-id',
						'type'=> 'text'),
					'progressbar-color'=>array(
						'title'=> 'progressbar color',
						'name'=> 'pego-pb-element-progressbar-color',
						'type'=> 'text')						
				),
				'Flexslider'=>array(
					'header'=>array(
						'title'=> 'Flexslider title',
						'name'=> 'pego-pb-element-flexslider-main-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of flexslider elements',
						'name'=> 'pego-pb-element-flexslider-num',
						'type'=> 'text'),
					'flexslider-caption'=>array(
						'title'=> 'flexslider item',
						'name'=> 'pego-pb-element-flexslider-caption',
						'type'=> 'text'),
					'flexslider-image'=>array(
						'title'=> 'flexslider image',
						'name'=> 'pego-pb-element-flexslider-image',
						'type'=> 'text'),
					'flexslider-url'=>array(
						'title'=> 'flexslider url',
						'name'=> 'pego-pb-element-flexslider-url',
						'type'=> 'text')						
				),
				'Socials'=>array(
					'header'=>array(
						'title'=> 'Socials title',
						'name'=> 'pego-pb-element-socials-title',
						'type'=> 'text'),
					'socials-type'=>array(
						'title'=> '',
						'name'=> 'pego-pb-element-socials-type',
						'type'=> 'select'),	
					'bg-color'=>array(
						'title'=> 'bg color',
						'name'=> 'pego-pb-element-socials-bgcolor',
						'type'=> 'text'),	
					'num'=>array(
						'title'=> 'Number of social elements',
						'name'=> 'pego-pb-element-socials-num',
						'type'=> 'text'),
					'socials-item-element'=>array(
						'title'=> 'Socials item',
						'name'=> 'pego-pb-element-socials-item',
						'type'=> 'select'),
					'socials-item-element-url'=>array(
						'title'=> 'Social item url',
						'name'=> 'pego-pb-element-socials-item-url',
						'type'=> 'text')						
				),
				'ContactForm7'=>array(
					'title'=>array(
						'title'=> 'Contact form 7',
						'name'=> 'pego-pb-element-contactform7',
						'type'=> 'select')
				),
				'Accordion'=>array(
					'header'=>array(
						'title'=> 'Accordion title',
						'name'=> 'pego-pb-element-accordion-main-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of accordion elements',
						'name'=> 'pego-pb-element-accordion-num',
						'type'=> 'text'),
					'accordion-title'=>array(
						'title'=> 'Accordion item',
						'name'=> 'pego-pb-element-accordion-title',
						'type'=> 'text'),
					'accordion-content'=>array(
						'title'=> 'Accordion content',
						'name'=> 'pego-pb-element-accordion-content',
						'type'=> 'textarea')						
				),
				'TeamMember'=>array(
					'name'=>array(
						'title'=> 'Name',
						'name'=> 'pego-pb-element-teammember-name',
						'type'=> 'text'),	
					'position'=>array(
						'title'=> 'Position',
						'name'=> 'pego-pb-element-teammember-position',
						'type'=> 'text'),	
					'description'=>array(
						'title'=> 'Description',
						'name'=> 'pego-pb-element-teammember-description',
						'type'=> 'textarea'),	
					'showtype'=>array(
						'title'=> 'Description',
						'name'=> 'pego-pb-element-teammember-showtype',
						'type'=> 'text'),	
					'image'=>array(
						'title'=> 'Image',
						'name'=> 'pego-pb-element-teammember-image',
						'type'=> 'upload'),	
					'num'=>array(
						'title'=> 'Number of socials',
						'name'=> 'pego-pb-element-teammember-num',
						'type'=> 'text'),
					'teammember-item-socials'=>array(
						'title'=> 'Socials item',
						'name'=> 'pego-pb-element-teammember-socials-item',
						'type'=> 'select'),
					'teammember-item-socials-url'=>array(
						'title'=> 'Social item url',
						'name'=> 'pego-pb-element-teammember-socials-item-url',
						'type'=> 'text')						
				),
				'Image'=>array(
					'header'=>array(
						'title'=> 'Image title',
						'name'=> 'pego-pb-element-image-title',
						'type'=> 'text'),	
					'image_url'=>array(
						'title'=> 'image',
						'name'=> 'pego-pb-element-image-url',
						'type'=> 'upload'),										
				),
				'Welcome1'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-welcomequote-title',
						'type'=> 'text'),						
					'subtitle'=>array(
						'title'=> 'Subtitle',
						'name'=> 'pego-pb-element-welcomequote-subtitle',
						'type'=> 'text'),
					'content'=>array(
						'title'=> 'Content',
						'name'=> 'pego-pb-element-welcomequote-content',
						'type'=> 'textarea'),
					'url_text'=>array(
						'title'=> 'Url text',
						'name'=> 'pego-pb-element-welcomequote-url-text',
						'type'=> 'text'),
					'url_value'=>array(
						'title'=> 'Url value',
						'name'=> 'pego-pb-element-welcomequote-url-value',
						'type'=> 'text'),
					'color1'=>array(
						'title'=> ' Backgorund Color #1',
						'name'=> 'pego-pb-element-welcomequote-bgcolor1',
						'type'=> 'color'),
					'color2'=>array(
						'title'=> ' Backgorund Color #2',
						'name'=> 'pego-pb-element-welcomequote-bgcolor2',
						'type'=> 'color'),
					'fontcolor'=>array(
						'title'=> ' Font Color',
						'name'=> 'pego-pb-element-welcomequote-fontcolor',
						'type'=> 'color')
				),			
				'Welcome2'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-welcome3quote-title',
						'type'=> 'text'),						
					'subtitle'=>array(
						'title'=> 'Subtitle',
						'name'=> 'pego-pb-element-welcome3quote-subtitle',
						'type'=> 'text'),
					'content'=>array(
						'title'=> 'Content',
						'name'=> 'pego-pb-element-welcome3quote-content',
						'type'=> 'textarea'),
					'url_text'=>array(
						'title'=> 'Url text',
						'name'=> 'pego-pb-element-welcome3quote-url-text',
						'type'=> 'text'),
					'url_value'=>array(
						'title'=> 'Url value',
						'name'=> 'pego-pb-element-welcome3quote-url-value',
						'type'=> 'text'),
					'color1'=>array(
						'title'=> ' Backgorund Color #1',
						'name'=> 'pego-pb-element-welcome3quote-bgcolor1',
						'type'=> 'color'),
					'color2'=>array(
						'title'=> ' Backgorund Color #2',
						'name'=> 'pego-pb-element-welcome3quote-bgcolor2',
						'type'=> 'color'),
					'fontcolor'=>array(
						'title'=> ' Font Color',
						'name'=> 'pego-pb-element-welcome3quote-fontcolor',
						'type'=> 'color')
				),
				'TwitterUpdates'=>array(
					'type' =>array(
						'title'=> 'Type',
						'name'=> 'pego-pb-element-twitter-updates',
						'std' => '',
						'type' => 'select',
						'options' => array(
							'type1' => 'type1',
							'type2' => 'type2')),						
					'twitter username'=>array(
						'title'=> 'Twitter Username',
						'name'=> 'pego-pb-element-twitter-updates-username',
						'type'=> 'text'),
					'twitter number'=>array(
						'title'=> 'Twitter Number',
						'name'=> 'pego-pb-element-twitter-updates-number',
						'type'=> 'text'),
					'icon'=>array(
						'title'=> 'Icon',
						'name'=> 'pego-pb-element-twitter-updates-icon',
						'type'=> 'upload'),
					'bg_color'=>array(
						'title'=> ' Backgorund Color #1',
						'name'=> 'pego-pb-element-twitter-updates-bgcolor',
						'type'=> 'color'),
					'fontcolor'=>array(
						'title'=> ' Font Color',
						'name'=> 'pego-pb-element-twitter-updates-fontcolor',
						'type'=> 'color')
				),
				'Heading' =>array(
					'content'=>array(
						'title'=> 'Content',
						'name'=> 'pego-pb-element-heading-content',
						'type'=> 'text'),
					'type' =>array(
						'title'=> 'Type',
						'name'=> 'pego-pb-element-heading-type',
						'std' => '',
						'type' => 'select',
						'options' => array(
							'Heading1' => 'Heading1',
							'Heading2' => 'Heading2',
							'Heading3' => 'Heading3',
							'Heading4' => 'Heading4',
							'Heading5' => 'Heading5')
					)					
				),
				'ContactInfo'=>array(
					'header'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-contactinfo-title',
						'type'=> 'text'),	
					'icon'=>array(
						'title'=> 'List icon',
						'name'=> 'pego-pb-element-contactinfo-content',
						'type'=> 'textarea'),	
					'num'=>array(
						'title'=> 'Number of contact info elements',
						'name'=> 'pego-pb-element-contactinfo-num',
						'type'=> 'text')						
				),
				'PricingColumn'=>array(
					'title'=>array(
						'title'=> 'title',
						'name'=> 'pego-pb-element-pricing-title',
						'type'=> 'text'),	
					'price'=>array(
						'title'=> 'price',
						'name'=> 'pego-pb-element-pricing-price',
						'type'=> 'text'),	
					'per'=>array(
						'title'=> 'per',
						'name'=> 'pego-pb-element-pricing-per',
						'type'=> 'text'),
					'color'=>array(
						'title'=> ' color',
						'name'=> 'pego-pb-element-pricing-color',
						'type'=> 'color'),						
					'url'=>array(
						'title'=> 'url',
						'name'=> 'pego-pb-element-pricing-url',
						'type'=> 'text'),
					'urlcaption'=>array(
						'title'=> 'url caption',
						'name'=> 'pego-pb-element-pricing-url-caption',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of pricing rows',
						'name'=> 'pego-pb-element-pricing-num',
						'type'=> 'text')					
				),
				'2ColTable'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-coltable-title',
						'type'=> 'text'),
					'num'=>array(
						'title'=> 'Number of table rows',
						'name'=> 'pego-pb-element-coltable-num',
						'type'=> 'text')						
				),
				'Gallery'=>array(
					'title'=>array(
						'title'=> 'Gallery',
						'name'=> 'pego-pb-element-gallery',
						'type'=> 'select')
				),
				'Faq'=>array(
					'faq'=>array(
						'title'=> 'Faq title',
						'name'=> 'pego-pb-element-faq-title',
						'type'=> 'text')
				),
				'BGsectionStart'=>array(
					'title'=>array(
						'title'=> 'BGsectionStart',
						'name'=> 'pego-pb-element-bgsectionstart',
						'type'=> 'select')
				),
				'BGsectionEnd'=>array(
					'title'=>array(
						'title'=> 'BGsectionEnd',
						'name'=> 'pego-pb-element-bgsectionend',
						'type'=> 'select')
				),
			  'ColLeftIcon'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-columnwithicon1-title',
						'type'=> 'text')			
				),
			  'ColTopIcon'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-columnwithicon2-title',
						'type'=> 'text')			
				),
			  'Testimonial2'=>array(
					'header'=>array(
						'title'=> 'title',
						'name'=> 'pego-pb-element-clientssay-main-title',
						'type'=> 'text'),
					'clientssay-content'=>array(
						'title'=> 'clientssay content',
						'name'=> 'pego-pb-element-clientssay-content',
						'type'=> 'textarea')						
				),
			  'BigSplashText'=>array(
					'header'=>array(
						'title'=> 'title',
						'name'=> 'pego-pb-element-bigsplashtext-title',
						'type'=> 'text')						
				),
				'ImageSlide'=>array(
					'header'=>array(
						'title'=> 'Image slide',
						'name'=> 'pego-pb-element-imageslide-title',
						'type'=> 'text')						
				),				
			  'Welcome3'=>array(
					'header'=>array(
						'title'=> 'title',
						'name'=> 'pego-pb-element-welcome3-title',
						'type'=> 'text')						
				),
				'History'=>array(
					'header'=>array(
						'title'=> 'History',
						'name'=> 'pego-pb-element-history-title',
						'type'=> 'text')						
				),
			  'CircleBar'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-circleprogressbar-title',
						'type'=> 'text')			
				),	
			  'ExtraHeading'=>array(
					'title'=>array(
						'title'=> 'Title',
						'name'=> 'pego-pb-element-extraheading-title',
						'type'=> 'text')			
				)					
			)
		)		
	);
	
	add_action('add_meta_boxes', 'add_pego_page_options');
	
	function add_pego_page_options(){	
		add_meta_box('page-option', __('Page Builder','furniot'), 'add_pego_page_option',
			'page', 'normal', 'high');		
		add_meta_box('post-option', __('Post Builder','furniot'), 'add_pego_page_option',
			'post', 'normal', 'high');	
		add_meta_box('portfolio-option', __('Portfolio Builder','furniot'), 'add_pego_page_option',
			'portfolio', 'normal', 'high');	
	}
	
	function add_pego_page_option(){	
		global $post, $pego_page_elements;		
		echo '<div id="pego-pb-main-div">';
		echo '<div id="pego-pb-inside-main-div">';		
		set_nonce();
		foreach( $pego_page_elements as $pego_page_element ){
			if( $pego_page_element['type'] == 'pego-pb-element' ){				
				$pego_page_element['value'] = get_post_meta($post->ID, $pego_page_element['shortcode'], true);				
				fill_select_and_default_build_elements($pego_page_element);	
				elements_on_board($pego_page_element);	
			
			}else{
				//mogoe se rabi kasneje za ostala polja
			}
			echo "<div class='clear'></div>";		
		}				
		echo '</div>';
		echo '</div>';
		
	}
	
	function save_page_option_meta($post_id){
	
		global $pego_page_elements;
	//	$edit_meta_boxes = $pego_page_elements;
		
		foreach ($pego_page_elements as $pego_page_element){
			if( $pego_page_element['type'] == 'pego-pb-element' ){	
				$pego_pb_element_count = 0;
				if(isset($_POST[$pego_page_element['size']])){				
					$pego_pb_element_count = sizeof($_POST[$pego_page_element['size']]);					
				}
				
				$pego_pb_columns_count=0;
				$pego_pb_faq_count=0;
				$pego_pb_maps_count=0;
				$pego_pb_quote1_count=0;
				$pego_pb_separator_count=0;
				$pego_pb_list_count=0;
				$pego_pb_imageslide_count=0;
				$pego_pb_coltable_count=0;
				$pego_pb_pricing_count=0;
				$pego_pb_contactinfo_count=0;
				$pego_pb_image_count=0;
				$pego_pb_teammember_count=0;
				$pego_pb_quoterotator_count=0;
				$pego_pb_socials_count=0;
				$pego_pb_toggle_count=0;
				$pego_pb_accordion_count=0;
				$pego_pb_tab_count=0;
				$pego_pb_verticallist_count=0;
				$pego_pb_progressbar_count=0;
				$pego_pb_flexslider_count=0;
				$pego_pb_testimonials_count=0;
				$pego_pb_clientssay_count=0;
				$pego_pb_portfolio_count=0;
				$pego_pb_circleprogressbar_count=0;
				$pego_pb_extraheading_count=0;
				$pego_pb_history_count=0;
				$pego_pb_posts_count=0;
				$pego_pb_carousel_count=0;
				$pego_pb_button_count=0;
				$pego_pb_slider_count=0;
				$pego_pb_gallery_count=0;
				$pego_pb_section_count=0;
				$pego_pb_sectionend_count=0;
				$pego_pb_contactform7_count=0;
				$pego_pb_columnwithicon_count=0;
				$pego_pb_columnwithicon1_count=0;
				$pego_pb_columnwithicon2_count=0;
				$pego_pb_video_count=0;
				$pego_pb_welcomequote1_count=0;
				$pego_pb_welcomequote2_count=0;
				$pego_pb_welcomequote3_count=0;
				$pego_pb_splash_count=0;
				$pego_pb_bigsplashtext_count=0;
				$pego_pb_bigsplash_count=0;
				$pego_pb_bigsplash2_count=0;
				$pego_pb_welcome3_count=0;
				$pego_pb_twitter_updates_count = 0;
				$pego_pb_heading_count=0;
				$pego_pb_twitter_updates_elements='';
				$teammember_count=1;
				$list_items_count=1;
				$imageslide_items_count=1;
				$coltable_items_count=1;
				$pricing_items_count=1;
				$contactinfo_items_count=1;
				$socials_count=1;
				$toggle_items_count=1;
				$accordion_items_count=1;
				$tab_items_count=1;
				$maps_items_count=1;
				$verticallist_items_count=1;
				$progressbar_items_count=1;
				$flexslider_items_count=1;
				$testimonials_items_count=1;
				$quoterotator_items_count=1;
				$portfolio_items_count=1;
				$posts_items_count=1;
				$carousel_items_count=1;
				$history_items_count = 1;
				$pego_pb_shortcode_elements = '';
				for($i=0; $i<$pego_pb_element_count; $i++){				
					$read_build_type = $_POST[$pego_page_element['item']][$i];
					$pego_pb_size_of_build_element = $_POST[$pego_page_element['size']][$i];
					$item_content = $pego_page_element['name'][$read_build_type];				
					//check every type
					if ($read_build_type == 'Column') {
							$pego_pb_columns_count++;
							$naslov_stolpca = htmlspecialchars($_POST['pego-pb-element-column-title'][$pego_pb_columns_count]);
							$naslov_stolpcaa = htmlspecialchars($_POST['pego-pb-element-column-title-align'][$pego_pb_columns_count]);
							$naslov_stolpcah = htmlspecialchars($_POST['pego-pb-element-column-title-heading'][$pego_pb_columns_count]);
							$vrednost_stolpca = htmlspecialchars($_POST['pego-pb-element-column-text'][$pego_pb_columns_count]);							
							$vrednost_stolpcaContentsize = htmlspecialchars($_POST['pego-pb-element-column-contentfont'][$pego_pb_columns_count]);							
							$vrednost_stolpca_align = htmlspecialchars($_POST['pego-pb-element-column-text-align'][$pego_pb_columns_count]);							
							$pego_pb_shortcode_elements .='<page-item><type>Column</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$naslov_stolpca.'</title><content>'.$vrednost_stolpca.'</content><align>'.$naslov_stolpcaa.'</align><heading>'.$naslov_stolpcah.'</heading><contentalign>'.$vrednost_stolpca_align.'</contentalign><contentfont>'.$vrednost_stolpcaContentsize.'</contentfont></page-item>';																		
					}					
					if ($read_build_type == 'Separator') {										
							$pego_pb_separator_count++;							
							$barva_seperatorja = htmlspecialchars($_POST['pego-pb-element-separator-color'][$pego_pb_separator_count]);	
							$tip_seperatorja = htmlspecialchars($_POST['pego-pb-element-separator-type'][$pego_pb_separator_count]);
							$velikost_seperatorja = htmlspecialchars($_POST['pego-pb-element-separator-height'][$pego_pb_separator_count]);
							$pego_pb_shortcode_elements .='<page-item><type>Separator</type><height>'.$velikost_seperatorja.'</height><color>'.$barva_seperatorja.'</color><tip>'.$tip_seperatorja.'</tip><size>'.$pego_pb_size_of_build_element.'</size></page-item>';																		
					}
					if ($read_build_type == 'List') {										
							$pego_pb_list_count++;	
							$pego_pb_list_items_number = htmlspecialchars($_POST['pego-pb-element-list-num'][$pego_pb_list_count]);	
							$pego_pb_list_items_icon = htmlspecialchars($_POST['pego-pb-element-list-icon'][$pego_pb_list_count]);	
							$pego_pb_list_items_title = htmlspecialchars($_POST['pego-pb-element-list-title'][$pego_pb_list_count]);
							$pego_pb_list_items_title_align = htmlspecialchars($_POST['pego-pb-element-list-title-align'][$pego_pb_list_count]);
							$pego_pb_list_items_title_heading = htmlspecialchars($_POST['pego-pb-element-list-title-heading'][$pego_pb_list_count]);
							$list_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>List</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_list_items_title.'</title><icon>'.$pego_pb_list_items_icon.'</icon><stevilo>'.$pego_pb_list_items_number.'</stevilo><align>'.$pego_pb_list_items_title_align.'</align><heading>'.$pego_pb_list_items_title_heading.'</heading>';
							$list_items_count++;
							if ($pego_pb_list_items_number > 0) {								
								for($st=0; $st<$pego_pb_list_items_number; $st++){
									$list_shortcode .= '<list_parent>';									
									$pego_pb_list_items_item = htmlspecialchars($_POST['pego-pb-element-list-item'][$list_items_count]);	
									$pego_pb_list_items_item_url = htmlspecialchars($_POST['pego-pb-element-list-item-url'][$list_items_count]);	
									$list_shortcode .= '<list_item>'.$pego_pb_list_items_item.'</list_item><list_url>'.$pego_pb_list_items_item_url.'</list_url>';
									$list_shortcode .= '</list_parent>';									
									$list_items_count++;
								}
								$pego_pb_shortcode_elements .= $list_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Button') {
							$pego_pb_button_count++;
							$pego_pb_button_caption = htmlspecialchars($_POST['pego-pb-element-button-caption'][$pego_pb_button_count]);
							$pego_pb_button_url = htmlspecialchars($_POST['pego-pb-element-button-url'][$pego_pb_button_count]);
							$pego_pb_button_type= htmlspecialchars($_POST['pego-pb-element-button-type'][$pego_pb_button_count]);
							$pego_pb_button_target= htmlspecialchars($_POST['pego-pb-element-button-target'][$pego_pb_button_count]);
							$pego_pb_button_align= htmlspecialchars($_POST['pego-pb-element-button-align'][$pego_pb_button_count]);
							$pego_pb_shortcode_elements .='<page-item><type>Button</type><size>'.$pego_pb_size_of_build_element.'</size><caption>'.$pego_pb_button_caption.'</caption><url>'.$pego_pb_button_url.'</url><button_type>'.$pego_pb_button_type.'</button_type><align>'.$pego_pb_button_align.'</align><buttontarget>'.$pego_pb_button_target.'</buttontarget></page-item>';																		
					}	
					if ($read_build_type == 'ColImage') {
							$pego_pb_columnwithicon_count++;
							$pego_pb_columnwithicon_title = htmlspecialchars($_POST['pego-pb-element-columnwithicon-title'][$pego_pb_columnwithicon_count]);
							$pego_pb_columnwithicon_url = htmlspecialchars($_POST['pego-pb-element-columnwithicon-url'][$pego_pb_columnwithicon_count]);
							$pego_pb_columnwithicon_icon = htmlspecialchars($_POST['pego-pb-element-columnwithicon-icon'][$pego_pb_columnwithicon_count]);
							$pego_pb_columnwithicon_content= htmlspecialchars($_POST['pego-pb-element-columnwithicon-content'][$pego_pb_columnwithicon_count]);
							$pego_pb_columnwithicon_buttonCaption= htmlspecialchars($_POST['pego-pb-element-columnwithicon-buttonCaption'][$pego_pb_columnwithicon_count]);
							$pego_pb_shortcode_elements .='<page-item><type>ColImage</type><size>'.$pego_pb_size_of_build_element.'</size><counter>'.$pego_pb_columnwithicon_count.'</counter><title>'.$pego_pb_columnwithicon_title.'</title><url>'.$pego_pb_columnwithicon_url.'</url><content>'.$pego_pb_columnwithicon_content.'</content><icon>'.$pego_pb_columnwithicon_icon.'</icon><buttonCaption>'.$pego_pb_columnwithicon_buttonCaption.'</buttonCaption></page-item>';																		
					}	
					if ($read_build_type == 'Portfolio') {
							$pego_pb_portfolio_count++;	
							$pego_pb_portfolio_items_title= htmlspecialchars($_POST['pego-pb-element-portfolio-items-title'][$pego_pb_portfolio_count]);	
							$pego_pb_portfolio_items_title_heading = htmlspecialchars($_POST['pego-pb-element-portfolio-items-title-heading'][$pego_pb_portfolio_count]);	
							$pego_pb_portfolio_items_title_align = htmlspecialchars($_POST['pego-pb-element-portfolio-items-title-align'][$pego_pb_portfolio_count]);	
							$pego_pb_portfolio_items_show_number = htmlspecialchars($_POST['pego-pb-element-portfolio-items-show-number'][$pego_pb_portfolio_count]);
							$pego_pb_portfolio_items_number = htmlspecialchars($_POST['pego-pb-element-portfolio-items-num'][$pego_pb_portfolio_count]);
							$pego_pb_portfolio_items_size = htmlspecialchars($_POST['pego-pb-element-portfolio-size-item'][$pego_pb_portfolio_count]);									
							$pego_pb_portfolio_items_read = htmlspecialchars($_POST['pego-pb-element-portfolio-item-read'][$pego_pb_portfolio_count]);									
							$pego_pb_portfolio_items_category = htmlspecialchars($_POST['pego-pb-element-portfolio-items-category'][$pego_pb_portfolio_count]);											
							$pego_pb_portfolio_items_related= htmlspecialchars($_POST['pego-pb-element-portfolio-items-related'][$pego_pb_portfolio_count]);									
							$pego_pb_portfolio_items_text= htmlspecialchars($_POST['pego-pb-element-portfolio-item-text'][$pego_pb_portfolio_count]);									
							$pego_pb_portfolio_items_checkall_caption= htmlspecialchars($_POST['pego-pb-element-portfolio-item-text-checkall-caption'][$pego_pb_portfolio_count]);									
							$pego_pb_portfolio_items_checkall_url= htmlspecialchars($_POST['pego-pb-element-portfolio-item-text-checkall-url'][$pego_pb_portfolio_count]);									
							$portfolio_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Portfolio</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_portfolio_items_title.'</title><stevilo>'.$pego_pb_portfolio_items_number.'</stevilo><width>'.$pego_pb_portfolio_items_size.'</width><read>'.$pego_pb_portfolio_items_read.'</read><shownumber>'.$pego_pb_portfolio_items_show_number.'</shownumber><category>'.$pego_pb_portfolio_items_category.'</category><related>'.$pego_pb_portfolio_items_related.'</related><align>'.$pego_pb_portfolio_items_title_align.'</align><heading>'.$pego_pb_portfolio_items_title_heading.'</heading><text>'.$pego_pb_portfolio_items_text.'</text><checkallcaption>'.$pego_pb_portfolio_items_checkall_caption.'</checkallcaption><checkallurl>'.$pego_pb_portfolio_items_checkall_url.'</checkallurl>';
							$portfolio_items_count++;
							if ($pego_pb_portfolio_items_number > 0) {								
								for($st=0; $st<$pego_pb_portfolio_items_number; $st++){
									$portfolio_shortcode .= '<portfolio_items_parent>';									
									$pego_pb_portfolio_items_item = htmlspecialchars($_POST['pego-pb-element-portfolio-items-item'][$portfolio_items_count]);	
									$portfolio_shortcode .= '<portfolio_item>'.$pego_pb_portfolio_items_item.'</portfolio_item>';
									$portfolio_shortcode .= '</portfolio_items_parent>';									
									$portfolio_items_count++;
								}
								$pego_pb_shortcode_elements .= $portfolio_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';				
					}
					if ($read_build_type == 'Carousel') {										
							$pego_pb_carousel_count++;	
							$pego_pb_carousel_items_number = htmlspecialchars($_POST['pego-pb-element-carousel-num'][$pego_pb_carousel_count]);
							$pego_pb_carousel_items_title = htmlspecialchars($_POST['pego-pb-element-carousel-title'][$pego_pb_carousel_count]);
							$pego_pb_carousel_items_title_heading = htmlspecialchars($_POST['pego-pb-element-carousel-title-heading'][$pego_pb_carousel_count]);
							$pego_pb_carousel_items_title_align = htmlspecialchars($_POST['pego-pb-element-carousel-title-align'][$pego_pb_carousel_count]);
							$pego_pb_carousel_items_width = htmlspecialchars($_POST['pego-pb-element-carousel-width'][$pego_pb_carousel_count]);
							$pego_pb_carousel_items_speed = htmlspecialchars($_POST['pego-pb-element-carousel-speed'][$pego_pb_carousel_count]);
							$carousel_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Carousel</type><size>'.$pego_pb_size_of_build_element.'</size><stevilo>'.$pego_pb_carousel_items_number.'</stevilo><title>'.$pego_pb_carousel_items_title.'</title><carouselcount>'.$pego_pb_carousel_count.'</carouselcount><width>'.$pego_pb_carousel_items_width.'</width><speed>'.$pego_pb_carousel_items_speed.'</speed><align>'.$pego_pb_carousel_items_title_align.'</align><heading>'.$pego_pb_carousel_items_title_heading.'</heading>';
							$carousel_items_count++;
							if ($pego_pb_carousel_items_number > 0) {								
								for($st=0; $st<$pego_pb_carousel_items_number; $st++){
									$carousel_shortcode .= '<carousel_parent>';									
									$pego_pb_carousel_image = htmlspecialchars($_POST['pego-pb-element-carousel-image'][$carousel_items_count]);	
									$pego_pb_carousel_url = htmlspecialchars($_POST['pego-pb-element-carousel-url'][$carousel_items_count]);	
									$carousel_shortcode .= '<carousel_image>'.$pego_pb_carousel_image.'</carousel_image><carousel_url>'.$pego_pb_carousel_url.'</carousel_url>';
									$carousel_shortcode .= '</carousel_parent>';									
									$carousel_items_count++;
								}
								$pego_pb_shortcode_elements .= $carousel_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Toggle') {										
							$pego_pb_toggle_count++;	
							$pego_pb_toggle_number = htmlspecialchars($_POST['pego-pb-element-toggle-num'][$pego_pb_toggle_count]);	
							$pego_pb_toggle_main_title = htmlspecialchars($_POST['pego-pb-element-toggle-main-title'][$pego_pb_toggle_count]);
							$pego_pb_toggle_main_title_heading = htmlspecialchars($_POST['pego-pb-element-toggle-main-title-heading'][$pego_pb_toggle_count]);
							$pego_pb_toggle_main_title_align = htmlspecialchars($_POST['pego-pb-element-toggle-main-title-align'][$pego_pb_toggle_count]);
							$toggle_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Toggle</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_toggle_main_title.'</title><stevilo>'.$pego_pb_toggle_number.'</stevilo><align>'.$pego_pb_toggle_main_title_align.'</align><heading>'.$pego_pb_toggle_main_title_heading.'</heading>';
							$toggle_items_count++;
							if ($pego_pb_toggle_number > 0) {								
								for($st=0; $st<$pego_pb_toggle_number; $st++){
									$toggle_shortcode .= '<toggle_parent>';									
									$pego_pb_toggle_title = htmlspecialchars($_POST['pego-pb-element-toggle-title'][$toggle_items_count]);	
									$pego_pb_toggle_content = htmlspecialchars($_POST['pego-pb-element-toggle-content'][$toggle_items_count]);	
									//$pego_pb_toggle_status = htmlspecialchars($_POST['pego-pb-element-toggle-status'][$toggle_items_count]);	
									$toggle_shortcode .= '<toggle_title>'.$pego_pb_toggle_title.'</toggle_title><toggle_content>'.$pego_pb_toggle_content.'</toggle_content>';
									$toggle_shortcode .= '</toggle_parent>';									
									$toggle_items_count++;
								}
								$pego_pb_shortcode_elements .= $toggle_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Tab') {	
							$pego_pb_tab_count++;	
							$pego_pb_tab_number = htmlspecialchars($_POST['pego-pb-element-tab-num'][$pego_pb_tab_count]);	
							$pego_pb_tab_main_title = htmlspecialchars($_POST['pego-pb-element-tab-main-title'][$pego_pb_tab_count]);
							$pego_pb_tab_main_title_heading = htmlspecialchars($_POST['pego-pb-element-tab-main-title-heading'][$pego_pb_tab_count]);
							$pego_pb_tab_main_title_align = htmlspecialchars($_POST['pego-pb-element-tab-main-title-align'][$pego_pb_tab_count]);
							$tab_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Tab</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_tab_main_title.'</title><stevilo>'.$pego_pb_tab_number.'</stevilo><align>'.$pego_pb_tab_main_title_align.'</align><heading>'.$pego_pb_tab_main_title_heading.'</heading>';
							$tab_items_count++;
							if ($pego_pb_tab_number > 0) {								
								for($st=0; $st<$pego_pb_tab_number; $st++){
									$tab_shortcode .= '<tab_parent>';									
									$pego_pb_tab_title = htmlspecialchars($_POST['pego-pb-element-tab-title'][$tab_items_count]);	
									$pego_pb_tab_content = htmlspecialchars($_POST['pego-pb-element-tab-content'][$tab_items_count]);	
									$tab_shortcode .= '<tab_title>'.$pego_pb_tab_title.'</tab_title><tab_content>'.$pego_pb_tab_content.'</tab_content>';
									$tab_shortcode .= '</tab_parent>';									
									$tab_items_count++;
								}
								$pego_pb_shortcode_elements .= $tab_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'GoogleMaps') {
							$pego_pb_maps_count++;
							$pego_pb_maps_number = htmlspecialchars($_POST['pego-pb-element-maps-num'][$pego_pb_maps_count]);

													
							$pego_pb_maps_height = htmlspecialchars($_POST['pego-pb-element-maps-height'][$pego_pb_maps_count]);							
							$pego_pb_maps_title = htmlspecialchars($_POST['pego-pb-element-maps-title'][$pego_pb_maps_count]);							
							$pego_pb_maps_title_heading = htmlspecialchars($_POST['pego-pb-element-maps-title-heading'][$pego_pb_maps_count]);							
							$pego_pb_maps_title_align = htmlspecialchars($_POST['pego-pb-element-maps-title-align'][$pego_pb_maps_count]);							
							$pego_pb_maps_fullwidth= htmlspecialchars($_POST['pego-pb-element-maps-fullwidth'][$pego_pb_maps_count]);							
							$pego_pb_maps_zoom= htmlspecialchars($_POST['pego-pb-element-maps-zoom'][$pego_pb_maps_count]);							
							$pego_pb_shortcode_elements .='<page-item><type>GoogleMaps</type><size>'.$pego_pb_size_of_build_element.'</size><fullwidth>'.$pego_pb_maps_fullwidth.'</fullwidth><height>'.$pego_pb_maps_height.'</height><title>'.$pego_pb_maps_title.'</title><align>'.$pego_pb_maps_title_align.'</align><heading>'.$pego_pb_maps_title_heading.'</heading><stevilo>'.$pego_pb_maps_number.'</stevilo><zoom>'.$pego_pb_maps_zoom.'</zoom>';
							$maps_shortcode = '';
							$maps_items_count++;
							if ($pego_pb_maps_number > 0) {								
								for($st=0; $st<$pego_pb_maps_number; $st++){
									$maps_shortcode .= '<maps_parent>';										
									$pego_pb_maps_pin = htmlspecialchars($_POST['pego-pb-element-maps-pin'][$maps_items_count]);	
									$pego_pb_maps_lat = htmlspecialchars($_POST['pego-pb-element-maps-lat'][$maps_items_count]);	
									$pego_pb_maps_lng = htmlspecialchars($_POST['pego-pb-element-maps-lng'][$maps_items_count]);	
									$pego_pb_maps_address = htmlspecialchars($_POST['pego-pb-element-maps-address'][$maps_items_count]);	
									$maps_shortcode .= '<maps_address>'.$pego_pb_maps_address.'</maps_address><maps_lat>'.$pego_pb_maps_lat.'</maps_lat><maps_lng>'.$pego_pb_maps_lng.'</maps_lng><maps_pin>'.$pego_pb_maps_pin.'</maps_pin>';
									$maps_shortcode .= '</maps_parent>';									
									$maps_items_count++;
								}
								$pego_pb_shortcode_elements .= $maps_shortcode;
							}
							
							$pego_pb_shortcode_elements .= '</page-item>';																		
					}
					if ($read_build_type == 'Posts') {
							$pego_pb_posts_count++;	
							$pego_pb_posts_items_title = htmlspecialchars($_POST['pego-pb-element-posts-items-title'][$pego_pb_posts_count]);	
							$pego_pb_posts_items_title_heading = htmlspecialchars($_POST['pego-pb-element-posts-items-title-heading'][$pego_pb_posts_count]);	
							$pego_pb_posts_items_title_align = htmlspecialchars($_POST['pego-pb-element-posts-items-title-align'][$pego_pb_posts_count]);	
							$pego_pb_posts_items_show_number = htmlspecialchars($_POST['pego-pb-element-posts-items-show-number'][$pego_pb_posts_count]);
							$pego_pb_posts_items_summary_length = htmlspecialchars($_POST['pego-pb-element-posts-items-summary-length'][$pego_pb_posts_count]);
							$pego_pb_posts_items_number = htmlspecialchars($_POST['pego-pb-element-posts-items-num'][$pego_pb_posts_count]);
							$pego_pb_posts_items_type = htmlspecialchars($_POST['pego-pb-element-posts-item-type'][$pego_pb_posts_count]);						
							$pego_pb_posts_items_size = htmlspecialchars($_POST['pego-pb-element-posts-size-item'][$pego_pb_posts_count]);						
							$pego_pb_posts_items_read = htmlspecialchars($_POST['pego-pb-element-posts-item-read'][$pego_pb_posts_count]);									
							$pego_pb_posts_items_checkall_caption= htmlspecialchars($_POST['pego-pb-element-posts-item-checkall-caption'][$pego_pb_posts_count]);									
							$pego_pb_posts_items_checkall_url = htmlspecialchars($_POST['pego-pb-element-posts-item-checkall-url'][$pego_pb_posts_count]);									
							$posts_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Posts</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_posts_items_title.'</title><stevilo>'.$pego_pb_posts_items_number.'</stevilo><width>'.$pego_pb_posts_items_size.'</width><showtype>'.$pego_pb_posts_items_type.'</showtype><read>'.$pego_pb_posts_items_read.'</read><shownumber>'.$pego_pb_posts_items_show_number.'</shownumber><summarylength>'.$pego_pb_posts_items_summary_length.'</summarylength><align>'.$pego_pb_posts_items_title_align.'</align><heading>'.$pego_pb_posts_items_title_heading.'</heading><checkallcaption>'.$pego_pb_posts_items_checkall_caption.'</checkallcaption><checkallurl>'.$pego_pb_posts_items_checkall_url.'</checkallurl>';
							$posts_items_count++;
							if ($pego_pb_posts_items_number > 0) {								
								for($stPosts=0; $stPosts<$pego_pb_posts_items_number; $stPosts++){
									$posts_shortcode .= '<posts_items_parent>';									
									$pego_pb_posts_items_item = htmlspecialchars($_POST['pego-pb-element-posts-items-item'][$posts_items_count]);
								//$key = array_search('vegetable', $items); 									
									$posts_shortcode .= '<post_item>'.$pego_pb_posts_items_item.'</post_item>';
									$posts_shortcode .= '</posts_items_parent>';									
									$posts_items_count++;
								}
								$pego_pb_shortcode_elements .= $posts_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';				
					}
					if ($read_build_type == 'Blockquote') {
							$pego_pb_quote1_count++;
							$pego_pb_quote1_title = htmlspecialchars($_POST['pego-pb-element-quote1-title'][$pego_pb_quote1_count]);
							$pego_pb_quote1_title_heading = htmlspecialchars($_POST['pego-pb-element-quote1-title-heading'][$pego_pb_quote1_count]);
							$pego_pb_quote1_title_align = htmlspecialchars($_POST['pego-pb-element-quote1-title-align'][$pego_pb_quote1_count]);
							$pego_pb_quote1_content = htmlspecialchars($_POST['pego-pb-element-quote1-text'][$pego_pb_quote1_count]);							
							$pego_pb_quote1_icon = htmlspecialchars($_POST['pego-pb-element-quote1-icon'][$pego_pb_quote1_count]);							
							$pego_pb_quote1_border_size = htmlspecialchars($_POST['pego-pb-element-quote1-border-size'][$pego_pb_quote1_count]);							
							$pego_pb_quote1_border_color = htmlspecialchars($_POST['pego-pb-element-quote1-border-color'][$pego_pb_quote1_count]);							
							$pego_pb_quote1_author = htmlspecialchars($_POST['pego-pb-element-quote1-author'][$pego_pb_quote1_count]);							
							$pego_pb_shortcode_elements .='<page-item><type>Blockquote</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_quote1_title.'</title><author>'.$pego_pb_quote1_author.'</author><content>'.$pego_pb_quote1_content.'</content><icon>'.$pego_pb_quote1_icon.'</icon><bordercolor>'.$pego_pb_quote1_border_color.'</bordercolor><bordersize>'.$pego_pb_quote1_border_size.'</bordersize><align>'.$pego_pb_quote1_title_align.'</align><heading>'.$pego_pb_quote1_title_heading.'</heading></page-item>';																		
					}	
					if ($read_build_type == 'Video') {
							$pego_pb_video_count++;
							$pego_pb_video_title= htmlspecialchars($_POST['pego-pb-element-video-title'][$pego_pb_video_count]);
							$pego_pb_video_title_heading= htmlspecialchars($_POST['pego-pb-element-video-title-heading'][$pego_pb_video_count]);
							$pego_pb_video_title_align= htmlspecialchars($_POST['pego-pb-element-video-title-align'][$pego_pb_video_count]);
							$pego_pb_video_iframe = htmlspecialchars($_POST['pego-pb-element-video-iframe'][$pego_pb_video_count]);							
							$pego_pb_shortcode_elements .='<page-item><type>Video</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_video_title.'</title><iframecode>'.$pego_pb_video_iframe.'</iframecode><align>'.$pego_pb_video_title_align.'</align><heading>'.$pego_pb_video_title_heading.'</heading></page-item>';																		
					}	
					if ($read_build_type == 'Slider') {
							$pego_pb_slider_count++;
							$pego_pb_slider_alias = htmlspecialchars($_POST['pego-pb-element-slider-alias'][$pego_pb_slider_count]);						
							$pego_pb_slider_title = htmlspecialchars($_POST['pego-pb-element-slider-title'][$pego_pb_slider_count]);						
							$pego_pb_slider_title_align = htmlspecialchars($_POST['pego-pb-element-slider-title-align'][$pego_pb_slider_count]);						
							$pego_pb_slider_title_heading = htmlspecialchars($_POST['pego-pb-element-slider-title-heading'][$pego_pb_slider_count]);						
							$pego_pb_slider_fullwidth= htmlspecialchars($_POST['pego-pb-element-slider-fullwidth'][$pego_pb_slider_count]);						
							$pego_pb_shortcode_elements .='<page-item><type>Slider</type><size>'.$pego_pb_size_of_build_element.'</size><alias>'.$pego_pb_slider_alias.'</alias><fullwidth>'.$pego_pb_slider_fullwidth.'</fullwidth><title>'.$pego_pb_slider_title.'</title><align>'.$pego_pb_slider_title_align.'</align><heading>'.$pego_pb_slider_title_heading.'</heading></page-item>';																		
					}
					if ($read_build_type == 'Testimonials') {	
							$pego_pb_testimonials_count++;	
							$pego_pb_testimonials_number = htmlspecialchars($_POST['pego-pb-element-testimonials-num'][$pego_pb_testimonials_count]);	
							$pego_pb_testimonials_main_title = htmlspecialchars($_POST['pego-pb-element-testimonials-main-title'][$pego_pb_testimonials_count]);
							$pego_pb_testimonials_main_title_heading = htmlspecialchars($_POST['pego-pb-element-testimonials-main-title-heading'][$pego_pb_testimonials_count]);
							$pego_pb_testimonials_main_title_align = htmlspecialchars($_POST['pego-pb-element-testimonials-main-title-align'][$pego_pb_testimonials_count]);
							$testimonials_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Testimonials</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_testimonials_main_title.'</title><stevilo>'.$pego_pb_testimonials_number.'</stevilo><align>'.$pego_pb_testimonials_main_title_align.'</align><heading>'.$pego_pb_testimonials_main_title_heading.'</heading>';
							$testimonials_items_count++;
							if ($pego_pb_testimonials_number > 0) {								
								for($st=0; $st<$pego_pb_testimonials_number; $st++){
									$testimonials_shortcode .= '<testimonials_parent>';									
									$pego_pb_testimonials_title = htmlspecialchars($_POST['pego-pb-element-testimonials-title'][$testimonials_items_count]);	
									$pego_pb_testimonials_subtitle = htmlspecialchars($_POST['pego-pb-element-testimonials-subtitle'][$testimonials_items_count]);	
									$pego_pb_testimonials_content = htmlspecialchars($_POST['pego-pb-element-testimonials-content'][$testimonials_items_count]);	
									$testimonials_shortcode .= '<testimonials_title>'.$pego_pb_testimonials_title.'</testimonials_title><testimonials_subtitle>'.$pego_pb_testimonials_subtitle.'</testimonials_subtitle><testimonials_content>'.$pego_pb_testimonials_content.'</testimonials_content>';
									$testimonials_shortcode .= '</testimonials_parent>';									
									$testimonials_items_count++;
								}
								$pego_pb_shortcode_elements .= $testimonials_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'ProgressBar') {	
							$pego_pb_progressbar_count++;	
							$pego_pb_progressbar_number = htmlspecialchars($_POST['pego-pb-element-progressbar-num'][$pego_pb_progressbar_count]);	
							$pego_pb_progressbar_main_title = htmlspecialchars($_POST['pego-pb-element-progressbar-main-title'][$pego_pb_progressbar_count]);
							$pego_pb_progressbar_main_title_heading = htmlspecialchars($_POST['pego-pb-element-progressbar-main-title-heading'][$pego_pb_progressbar_count]);
							$pego_pb_progressbar_main_title_align = htmlspecialchars($_POST['pego-pb-element-progressbar-main-title-align'][$pego_pb_progressbar_count]);
							$pego_pb_progressbar_color = htmlspecialchars($_POST['pego-pb-element-progressbar-color'][$pego_pb_progressbar_count]);
							$progressbar_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>ProgressBar</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_progressbar_main_title.'</title><align>'.$pego_pb_progressbar_main_title_align.'</align><heading>'.$pego_pb_progressbar_main_title_heading.'</heading><stevilo>'.$pego_pb_progressbar_number.'</stevilo><color>'.$pego_pb_progressbar_color.'</color>';
							$progressbar_items_count++;
							if ($pego_pb_progressbar_number > 0) {								
								for($st=0; $st<$pego_pb_progressbar_number; $st++){
									$progressbar_shortcode .= '<progressbar_parent>';									
									$pego_pb_progressbar_title = htmlspecialchars($_POST['pego-pb-element-progressbar-title'][$progressbar_items_count]);	
									$pego_pb_progressbar_percent = htmlspecialchars($_POST['pego-pb-element-progressbar-percent'][$progressbar_items_count]);	
									$pego_pb_progressbar_id = htmlspecialchars($_POST['pego-pb-element-progressbar-id'][$progressbar_items_count]);	
									$progressbar_shortcode .= '<progressbar_title>'.$pego_pb_progressbar_title.'</progressbar_title><progressbar_id>'.$pego_pb_progressbar_id.'</progressbar_id><progressbar_percent>'.$pego_pb_progressbar_percent.'</progressbar_percent>';
									$progressbar_shortcode .= '</progressbar_parent>';									
									$progressbar_items_count++;
								}
								$pego_pb_shortcode_elements .= $progressbar_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Flexslider') {	
							$pego_pb_flexslider_count++;	
							$pego_pb_flexslider_number = htmlspecialchars($_POST['pego-pb-element-flexslider-num'][$pego_pb_flexslider_count]);	
							$pego_pb_flexslider_main_title = htmlspecialchars($_POST['pego-pb-element-flexslider-main-title'][$pego_pb_flexslider_count]);
							$pego_pb_flexslider_main_title_heading = htmlspecialchars($_POST['pego-pb-element-flexslider-main-title-heading'][$pego_pb_flexslider_count]);
							$pego_pb_flexslider_main_title_align = htmlspecialchars($_POST['pego-pb-element-flexslider-main-title-align'][$pego_pb_flexslider_count]);
							$flexslider_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Flexslider</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_flexslider_main_title.'</title><stevilo>'.$pego_pb_flexslider_number.'</stevilo><align>'.$pego_pb_flexslider_main_title_align.'</align><heading>'.$pego_pb_flexslider_main_title_heading.'</heading>';
							$flexslider_items_count++;
							if ($pego_pb_flexslider_number > 0) {								
								for($st=0; $st<$pego_pb_flexslider_number; $st++){
									$flexslider_shortcode .= '<flexslider_parent>';									
									$pego_pb_flexslider_caption = htmlspecialchars($_POST['pego-pb-element-flexslider-caption'][$flexslider_items_count]);	
									$pego_pb_flexslider_image = htmlspecialchars($_POST['pego-pb-element-flexslider-image'][$flexslider_items_count]);	
									$pego_pb_flexslider_url = htmlspecialchars($_POST['pego-pb-element-flexslider-url'][$flexslider_items_count]);	
									$flexslider_shortcode .= '<flexslider_caption>'.$pego_pb_flexslider_caption.'</flexslider_caption><flexslider_url>'.$pego_pb_flexslider_url.'</flexslider_url><flexslider_image>'.$pego_pb_flexslider_image.'</flexslider_image>';
									$flexslider_shortcode .= '</flexslider_parent>';									
									$flexslider_items_count++;
								}
								$pego_pb_shortcode_elements .= $flexslider_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Socials') {										
							$pego_pb_socials_count++;	
							$pego_pb_socials_number = htmlspecialchars($_POST['pego-pb-element-socials-num'][$pego_pb_socials_count]);	
							$pego_pb_socials_title = htmlspecialchars($_POST['pego-pb-element-socials-title'][$pego_pb_socials_count]);
							$pego_pb_socials_title_heading = htmlspecialchars($_POST['pego-pb-element-socials-title-heading'][$pego_pb_socials_count]);
							$pego_pb_socials_title_align = htmlspecialchars($_POST['pego-pb-element-socials-title-align'][$pego_pb_socials_count]);
							$pego_pb_socials_type = htmlspecialchars($_POST['pego-pb-element-socials-type'][$pego_pb_socials_count]);
							$pego_pb_socials_bgcolor = htmlspecialchars($_POST['pego-pb-element-socials-bgcolor'][$pego_pb_socials_count]);
							$socials_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Socials</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_socials_title.'</title><socialstype>'.$pego_pb_socials_type.'</socialstype><bgcolor>'.$pego_pb_socials_bgcolor.'</bgcolor><stevilo>'.$pego_pb_socials_number.'</stevilo><align>'.$pego_pb_socials_title_align.'</align><heading>'.$pego_pb_socials_title_heading.'</heading>';
							$socials_count++;
							if ($pego_pb_socials_number > 0) {								
								for($st=0; $st<$pego_pb_socials_number; $st++){
									$socials_shortcode .= '<socials_parent>';									
									$pego_pb_socials_item = htmlspecialchars($_POST['pego-pb-element-socials-item'][$socials_count]);	
									$pego_pb_socials_item_url = htmlspecialchars($_POST['pego-pb-element-socials-item-url'][$socials_count]);	
									$socials_shortcode .= '<socials_item>'.$pego_pb_socials_item.'</socials_item><socials_url>'.$pego_pb_socials_item_url.'</socials_url>';
									$socials_shortcode .= '</socials_parent>';									
									$socials_count++;
								}
								$pego_pb_shortcode_elements .= $socials_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'ContactForm7') {
							$pego_pb_contactform7_count++;
							$pego_pb_contactform7_title = htmlspecialchars($_POST['pego-pb-element-contactform7-title'][$pego_pb_contactform7_count]);						
							$pego_pb_contactform7_title_align = htmlspecialchars($_POST['pego-pb-element-contactform7-title-align'][$pego_pb_contactform7_count]);						
							$pego_pb_contactform7_title_heading = htmlspecialchars($_POST['pego-pb-element-contactform7-title-heading'][$pego_pb_contactform7_count]);						
							$pego_pb_contactform7 = htmlspecialchars($_POST['pego-pb-element-contactform7'][$pego_pb_contactform7_count]);						
							$pego_pb_shortcode_elements .='<page-item><type>ContactForm7</type><size>'.$pego_pb_size_of_build_element.'</size><contactform7>'.$pego_pb_contactform7.'</contactform7><title>'.$pego_pb_contactform7_title.'</title><align>'.$pego_pb_contactform7_title_align.'</align><heading>'.$pego_pb_contactform7_title_heading.'</heading></page-item>';																		
					}
					if ($read_build_type == 'Accordion') {										
							$pego_pb_accordion_count++;	
							$pego_pb_accordion_number = htmlspecialchars($_POST['pego-pb-element-accordion-num'][$pego_pb_accordion_count]);	
							$pego_pb_accordion_main_title = htmlspecialchars($_POST['pego-pb-element-accordion-main-title'][$pego_pb_accordion_count]);
							$pego_pb_accordion_main_title_heading = htmlspecialchars($_POST['pego-pb-element-accordion-main-title-heading'][$pego_pb_accordion_count]);
							$pego_pb_accordion_main_title_align = htmlspecialchars($_POST['pego-pb-element-accordion-main-title-align'][$pego_pb_accordion_count]);
							$accordion_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>Accordion</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_accordion_main_title.'</title><stevilo>'.$pego_pb_accordion_number.'</stevilo><align>'.$pego_pb_accordion_main_title_align.'</align><heading>'.$pego_pb_accordion_main_title_heading.'</heading>';
							$accordion_items_count++;
							if ($pego_pb_accordion_number > 0) {								
								for($st=0; $st<$pego_pb_accordion_number; $st++){
									$accordion_shortcode .= '<accordion_parent>';									
									$pego_pb_accordion_title = htmlspecialchars($_POST['pego-pb-element-accordion-title'][$accordion_items_count]);	
									$pego_pb_accordion_content = htmlspecialchars($_POST['pego-pb-element-accordion-content'][$accordion_items_count]);
									$accordion_shortcode .= '<accordion_title>'.$pego_pb_accordion_title.'</accordion_title><accordion_content>'.$pego_pb_accordion_content.'</accordion_content>';
									$accordion_shortcode .= '</accordion_parent>';									
									$accordion_items_count++;
								}
								$pego_pb_shortcode_elements .= $accordion_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'TeamMember') {										
							$pego_pb_teammember_count++;	
							$pego_pb_teammember_number = htmlspecialchars($_POST['pego-pb-element-teammember-num'][$pego_pb_teammember_count]);	
							$pego_pb_teammember_image= htmlspecialchars($_POST['pego-pb-element-teammember-image'][$pego_pb_teammember_count]);	
							$pego_pb_teammember_name= htmlspecialchars($_POST['pego-pb-element-teammember-name'][$pego_pb_teammember_count]);	
							$pego_pb_teammember_position= htmlspecialchars($_POST['pego-pb-element-teammember-position'][$pego_pb_teammember_count]);	
							$pego_pb_teammember_description = htmlspecialchars($_POST['pego-pb-element-teammember-description'][$pego_pb_teammember_count]);
							$teammember_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>TeamMember</type><size>'.$pego_pb_size_of_build_element.'</size><count>'.$pego_pb_teammember_count.'</count><image>'.$pego_pb_teammember_image.'</image><stevilo>'.$pego_pb_teammember_number.'</stevilo><name>'.$pego_pb_teammember_name.'</name><position>'.$pego_pb_teammember_position.'</position><description>'.$pego_pb_teammember_description.'</description>';
							$teammember_count++;
							if ($pego_pb_teammember_number > 0) {								
								for($st=0; $st<$pego_pb_teammember_number; $st++){
									$teammember_shortcode .= '<teammember_parent>';									
									$pego_pb_element_teammember_socials_item= htmlspecialchars($_POST['pego-pb-element-teammember-socials-item'][$teammember_count]);	
									$pego_pb_element_teammember_socials_item_url= htmlspecialchars($_POST['pego-pb-element-teammember-socials-item-url'][$teammember_count]);		
									$pego_pb_element_teammember_socials_item_title= htmlspecialchars($_POST['pego-pb-element-teammember-socials-item-title'][$teammember_count]);		
									$teammember_shortcode .= '<teammember_item>'.$pego_pb_element_teammember_socials_item.'</teammember_item><teammember_title>'.$pego_pb_element_teammember_socials_item_title.'</teammember_title><teammember_url>'.$pego_pb_element_teammember_socials_item_url.'</teammember_url>';
									$teammember_shortcode .= '</teammember_parent>';									
									$teammember_count++;
								}
								$pego_pb_shortcode_elements .= $teammember_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Image') {										
							$pego_pb_image_count++;	
							$pego_pb_image_url = htmlspecialchars($_POST['pego-pb-element-image-url'][$pego_pb_image_count]);	
							$pego_pb_image_title = htmlspecialchars($_POST['pego-pb-element-image-title'][$pego_pb_image_count]);
							$pego_pb_image_title_heading = htmlspecialchars($_POST['pego-pb-element-image-title-heading'][$pego_pb_image_count]);
							$pego_pb_image_title_align = htmlspecialchars($_POST['pego-pb-element-image-title-align'][$pego_pb_image_count]);
							$pego_pb_image_popup = htmlspecialchars($_POST['pego-pb-element-image-popup'][$pego_pb_image_count]);
							$pego_pb_image_margintop = htmlspecialchars($_POST['pego-pb-element-image-margintop'][$pego_pb_image_count]);
							$pego_pb_image_marginbottom = htmlspecialchars($_POST['pego-pb-element-image-marginbottom'][$pego_pb_image_count]);
							$pego_pb_shortcode_elements .='<page-item><type>Image</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_image_title.'</title><align>'.$pego_pb_image_title_align.'</align><heading>'.$pego_pb_image_title_heading.'</heading><url>'.$pego_pb_image_url.'</url><popup>'.$pego_pb_image_popup.'</popup><margintop>'.$pego_pb_image_margintop.'</margintop><marginbottom>'.$pego_pb_image_marginbottom.'</marginbottom>';						
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'Welcome1') {
							$pego_pb_welcomequote1_count++;						
							$pego_pb_welcomequote1_content = htmlspecialchars($_POST['pego-pb-element-welcomequote1-content'][$pego_pb_welcomequote1_count]);
							$pego_pb_welcomequote1_fontcolor = htmlspecialchars($_POST['pego-pb-element-welcomequote1-fontcolor'][$pego_pb_welcomequote1_count]);
							$pego_pb_welcomequote1_spancolor = htmlspecialchars($_POST['pego-pb-element-welcomequote1-spancolor'][$pego_pb_welcomequote1_count]);
							$pego_pb_welcomequote1_contentsize = htmlspecialchars($_POST['pego-pb-element-welcomequote1-contentsize'][$pego_pb_welcomequote1_count]);
							$pego_pb_welcomequote1_margintop = htmlspecialchars($_POST['pego-pb-element-welcomequote1-margintop'][$pego_pb_welcomequote1_count]);
							
							$pego_pb_shortcode_elements .='<page-item><type>Welcome1</type><size>'.$pego_pb_size_of_build_element.'</size><content>'.$pego_pb_welcomequote1_content.'</content><fontcolor>'.$pego_pb_welcomequote1_fontcolor.'</fontcolor><spancolor>'.$pego_pb_welcomequote1_spancolor.'</spancolor><contentsize>'.$pego_pb_welcomequote1_contentsize.'</contentsize><count>'.$pego_pb_welcomequote1_count.'</count><margintop>'.$pego_pb_welcomequote1_margintop.'</margintop></page-item>';																		
					}
					if ($read_build_type == 'Welcome2') {
							$pego_pb_welcomequote3_count++;
							$pego_pb_welcomequote3_leftcontenttitle = htmlspecialchars($_POST['pego-pb-element-welcomequote3-leftcontenttitle'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_leftcontent = htmlspecialchars($_POST['pego-pb-element-welcomequote3-leftcontent'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_rightcontent = htmlspecialchars($_POST['pego-pb-element-welcomequote3-rightcontent'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_rightcontenturl = htmlspecialchars($_POST['pego-pb-element-welcomequote3-rightcontenturl'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_leftcolor = htmlspecialchars($_POST['pego-pb-element-welcomequote3-leftcolor'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_rightcolor = htmlspecialchars($_POST['pego-pb-element-welcomequote3-rightcolor'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_rightcolor = htmlspecialchars($_POST['pego-pb-element-welcomequote3-rightcolor'][$pego_pb_welcomequote3_count]);
							$pego_pb_welcomequote3_fontcolor = htmlspecialchars($_POST['pego-pb-element-welcomequote3-fontcolor'][$pego_pb_welcomequote3_count]);	
							$pego_pb_welcomequote3_fontcolortitle = htmlspecialchars($_POST['pego-pb-element-welcomequote3-fontcolortitle'][$pego_pb_welcomequote3_count]);	
							$pego_pb_welcomequote3_fontcolorright = htmlspecialchars($_POST['pego-pb-element-welcomequote3-fontcolorright'][$pego_pb_welcomequote3_count]);	
							$pego_pb_shortcode_elements .='<page-item><type>Welcome2</type><size>'.$pego_pb_size_of_build_element.'</size><leftcontent>'.$pego_pb_welcomequote3_leftcontent.'</leftcontent><leftcontenttitle>'.$pego_pb_welcomequote3_leftcontenttitle.'</leftcontenttitle><rightcontent>'.$pego_pb_welcomequote3_rightcontent.'</rightcontent><rightcontenturl>'.$pego_pb_welcomequote3_rightcontenturl.'</rightcontenturl><leftcolor>'.$pego_pb_welcomequote3_leftcolor.'</leftcolor><rightcolor>'.$pego_pb_welcomequote3_rightcolor.'</rightcolor><fontcolor>'.$pego_pb_welcomequote3_fontcolor.'</fontcolor><fontcolortitle>'.$pego_pb_welcomequote3_fontcolortitle.'</fontcolortitle><fontcolorright>'.$pego_pb_welcomequote3_fontcolorright.'</fontcolorright></page-item>';																		
					}
					if ($read_build_type == 'TwitterUpdates') {
							$pego_pb_twitter_updates_count++;
							$pego_pb_twitter_updates_username = htmlspecialchars($_POST['pego-pb-element-twitter-updates-username'][$pego_pb_twitter_updates_count]);
							$pego_pb_twitter_updates_type = htmlspecialchars($_POST['pego-pb-element-twitter-updates-type'][$pego_pb_twitter_updates_count]);
							$pego_pb_twitter_updates_number = htmlspecialchars($_POST['pego-pb-element-twitter-updates-number'][$pego_pb_twitter_updates_count]);
							$pego_pb_twitter_updates_icon = htmlspecialchars($_POST['pego-pb-element-twitter-updates-icon'][$pego_pb_twitter_updates_count]);
							$pego_pb_twitter_updates_bgcolor = htmlspecialchars($_POST['pego-pb-element-twitter-updates-bgcolor'][$pego_pb_twitter_updates_count]);
							$pego_pb_twitter_updates_fontcolor = htmlspecialchars($_POST['pego-pb-element-twitter-updates-fontcolor'][$pego_pb_twitter_updates_count]);						
							$pego_pb_shortcode_elements .='<page-item><type>TwitterUpdates</type><size>'.$pego_pb_size_of_build_element.'</size><username>'.$pego_pb_twitter_updates_username.'</username><showtype>'.$pego_pb_twitter_updates_type.'</showtype><number>'.$pego_pb_twitter_updates_number.'</number><icon>'.$pego_pb_twitter_updates_icon.'</icon><bgcolor>'.$pego_pb_twitter_updates_bgcolor.'</bgcolor><fontcolor>'.$pego_pb_twitter_updates_fontcolor.'</fontcolor></page-item>';																		
					}
					if ($read_build_type == 'Heading') {										
							$pego_pb_heading_count++;
							$pego_pb_heading_content = htmlspecialchars($_POST['pego-pb-element-heading-content'][$pego_pb_heading_count]);	
							$pego_pb_heading_content_align = htmlspecialchars($_POST['pego-pb-element-heading-content-align'][$pego_pb_heading_count]);	
							$pego_pb_heading_content_heading = htmlspecialchars($_POST['pego-pb-element-heading-content-heading'][$pego_pb_heading_count]);	
							$pego_pb_shortcode_elements .='<page-item><type>Heading</type><align>'.$pego_pb_heading_content_align.'</align><heading>'.$pego_pb_heading_content_heading.'</heading><content>'.$pego_pb_heading_content.'</content><size>'.$pego_pb_size_of_build_element.'</size></page-item>';																		
					}
					if ($read_build_type == 'ContactInfo') {										
							$pego_pb_contactinfo_count++;	
							$pego_pb_contactinfo_items_number = htmlspecialchars($_POST['pego-pb-element-contactinfo-num'][$pego_pb_contactinfo_count]);	
							$pego_pb_contactinfo_items_content = htmlspecialchars($_POST['pego-pb-element-contactinfo-content'][$pego_pb_contactinfo_count]);	
							$pego_pb_contactinfo_items_title = htmlspecialchars($_POST['pego-pb-element-contactinfo-title'][$pego_pb_contactinfo_count]);
							$pego_pb_contactinfo_items_title_heading = htmlspecialchars($_POST['pego-pb-element-contactinfo-title-heading'][$pego_pb_contactinfo_count]);
							$pego_pb_contactinfo_items_title_align = htmlspecialchars($_POST['pego-pb-element-contactinfo-title-align'][$pego_pb_contactinfo_count]);
							$pego_pb_contactinfo_items_image = htmlspecialchars($_POST['pego-pb-element-contactinfo-image'][$pego_pb_contactinfo_count]);
							$contactinfo_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>ContactInfo</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_contactinfo_items_title.'</title><content>'.$pego_pb_contactinfo_items_content.'</content><stevilo>'.$pego_pb_contactinfo_items_number.'</stevilo><align>'.$pego_pb_contactinfo_items_title_align.'</align><heading>'.$pego_pb_contactinfo_items_title_heading.'</heading><image>'.$pego_pb_contactinfo_items_image.'</image>';
							$contactinfo_items_count++;
							if ($pego_pb_contactinfo_items_number > 0) {								
								for($st=0; $st<$pego_pb_contactinfo_items_number; $st++){
									$contactinfo_shortcode .= '<contactinfo_parent>';									
									$pego_pb_contactinfo_items_icon = htmlspecialchars($_POST['pego-pb-element-contactinfo-item-icon'][$contactinfo_items_count]);	
									$pego_pb_contactinfo_items_desc = htmlspecialchars($_POST['pego-pb-element-contactinfo-item-desc'][$contactinfo_items_count]);	
									$contactinfo_shortcode .= '<icon>'.$pego_pb_contactinfo_items_icon.'</icon><desc>'.$pego_pb_contactinfo_items_desc.'</desc>';
									$contactinfo_shortcode .= '</contactinfo_parent>';									
									$contactinfo_items_count++;
								}
								$pego_pb_shortcode_elements .= $contactinfo_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'PricingColumn') {										
							$pego_pb_pricing_count++;	
							$pego_pb_pricing_number = htmlspecialchars($_POST['pego-pb-element-pricing-num'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_title = htmlspecialchars($_POST['pego-pb-element-pricing-title'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_price = htmlspecialchars($_POST['pego-pb-element-pricing-price'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_price_currency = htmlspecialchars($_POST['pego-pb-element-pricing-price-currency'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_per = htmlspecialchars($_POST['pego-pb-element-pricing-per'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_url = htmlspecialchars($_POST['pego-pb-element-pricing-url'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_url_caption = htmlspecialchars($_POST['pego-pb-element-pricing-url-caption'][$pego_pb_pricing_count]);	
							$pego_pb_pricing_best = htmlspecialchars($_POST['pego-pb-element-pricing-best'][$pego_pb_pricing_count]);	
							$pricing_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>PricingColumn</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_pricing_title.'</title><price>'.$pego_pb_pricing_price.'</price><stevilo>'.$pego_pb_pricing_number.'</stevilo><per>'.$pego_pb_pricing_per.'</per><url>'.$pego_pb_pricing_url.'</url><urlcaption>'.$pego_pb_pricing_url_caption.'</urlcaption><currency>'.$pego_pb_pricing_price_currency.'</currency><best>'.$pego_pb_pricing_best.'</best>';
							$pricing_items_count++;
							if ($pego_pb_pricing_number > 0) {								
								for($st=0; $st<$pego_pb_pricing_number; $st++){
									$pricing_shortcode .= '<pricing_parent>';									
									$pego_pb_pricing_item = htmlspecialchars($_POST['pego-pb-element-pricing-item'][$pricing_items_count]);	
									$pricing_shortcode .= '<pricing_item>'.$pego_pb_pricing_item.'</pricing_item>';
									$pricing_shortcode .= '</pricing_parent>';									
									$pricing_items_count++;
								}
								$pego_pb_shortcode_elements .= $pricing_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == '2ColTable') {										
							$pego_pb_coltable_count++;	
							$pego_pb_coltable_items_number = htmlspecialchars($_POST['pego-pb-element-coltable-num'][$pego_pb_coltable_count]);		
							$pego_pb_coltable_items_title = htmlspecialchars($_POST['pego-pb-element-coltable-title'][$pego_pb_coltable_count]);
							$pego_pb_coltable_items_title_heading = htmlspecialchars($_POST['pego-pb-element-coltable-title-heading'][$pego_pb_coltable_count]);
							$pego_pb_coltable_items_title_align = htmlspecialchars($_POST['pego-pb-element-coltable-title-align'][$pego_pb_coltable_count]);
							$pego_pb_coltable_items_buttoncaption = htmlspecialchars($_POST['pego-pb-element-coltable-buttoncaption'][$pego_pb_coltable_count]);
							$pego_pb_coltable_items_buttonurl = htmlspecialchars($_POST['pego-pb-element-coltable-buttonurl'][$pego_pb_coltable_count]);
							$pego_pb_coltable_items_color = htmlspecialchars($_POST['pego-pb-element-coltable-color'][$pego_pb_coltable_count]);
							$coltable_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>2ColTable</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_coltable_items_title.'</title>
							<stevilo>'.$pego_pb_coltable_items_number.'</stevilo><buttoncaption>'.$pego_pb_coltable_items_buttoncaption.'</buttoncaption><buttonurl>'.$pego_pb_coltable_items_buttonurl.'</buttonurl><color>'.$pego_pb_coltable_items_color.'</color><align>'.$pego_pb_coltable_items_title_align.'</align><heading>'.$pego_pb_coltable_items_title_heading.'</heading>';
							$coltable_items_count++;
							if ($pego_pb_coltable_items_number > 0) {								
								for($st=0; $st<$pego_pb_coltable_items_number; $st++){
									$coltable_shortcode .= '<coltable_parent>';									
									$pego_pb_coltable_items_itemleft = htmlspecialchars($_POST['pego-pb-element-coltable-leftside'][$coltable_items_count]);	
									$pego_pb_coltable_items_itemright = htmlspecialchars($_POST['pego-pb-element-coltable-rightside'][$coltable_items_count]);	
									$coltable_shortcode .= '<coltable_left>'.$pego_pb_coltable_items_itemleft.'</coltable_left><coltable_right>'.$pego_pb_coltable_items_itemright.'</coltable_right>';
									$coltable_shortcode .= '</coltable_parent>';									
									$coltable_items_count++;
								}
								$pego_pb_shortcode_elements .= $coltable_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';															
					}
					if ($read_build_type == 'Gallery') {
							$pego_pb_gallery_count++;
							$pego_pb_gallery = htmlspecialchars($_POST['pego-pb-element-gallery'][$pego_pb_gallery_count]);	
							$pego_pb_gallery_width = htmlspecialchars($_POST['pego-pb-element-gallery-width'][$pego_pb_gallery_count]);					
							$pego_pb_gallery_title = htmlspecialchars($_POST['pego-pb-element-gallery-title'][$pego_pb_gallery_count]);	
							$pego_pb_gallery_title_heading = htmlspecialchars($_POST['pego-pb-element-gallery-title-heading'][$pego_pb_gallery_count]);	
							$pego_pb_gallery_title_align = htmlspecialchars($_POST['pego-pb-element-gallery-title-align'][$pego_pb_gallery_count]);	
							$pego_pb_shortcode_elements .='<page-item><type>Gallery</type><size>'.$pego_pb_size_of_build_element.'</size><galleryitem>'.$pego_pb_gallery.'</galleryitem><width>'.$pego_pb_gallery_width.'</width><title>'.$pego_pb_gallery_title.'</title><align>'.$pego_pb_gallery_title_align.'</align><heading>'.$pego_pb_gallery_title_heading.'</heading></page-item>';																		
					}
					if ($read_build_type == 'Faq') {
							$pego_pb_faq_count++;
							$naslov_stolpca = htmlspecialchars($_POST['pego-pb-element-faq-title'][$pego_pb_faq_count]);
							$naslov_stolpca_align = htmlspecialchars($_POST['pego-pb-element-faq-title-align'][$pego_pb_faq_count]);							
							$naslov_stolpca_heading = htmlspecialchars($_POST['pego-pb-element-faq-title-heading'][$pego_pb_faq_count]);								
							$pego_pb_shortcode_elements .='<page-item><type>Faq</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$naslov_stolpca.'</title><align>'.$naslov_stolpca_align.'</align><heading>'.$naslov_stolpca_heading.'</heading></page-item>';																		
					}
					if ($read_build_type == 'BGsectionStart') {
							$pego_pb_section_count++;
							$pego_pb_section = htmlspecialchars($_POST['pego-pb-element-bgsectionstart'][$pego_pb_section_count]);	
							$pego_pb_shortcode_elements .='<page-item><type>BGsectionStart</type><size>'.$pego_pb_size_of_build_element.'</size><sectiontitle>'.$pego_pb_section.'</sectiontitle></page-item>';																		
					}	
					if ($read_build_type == 'BGsectionEnd') {
							$pego_pb_sectionend_count++;
							$pego_pb_sectionend = htmlspecialchars($_POST['pego-pb-element-bgsectionend'][$pego_pb_sectionend_count]);	
							$pego_pb_shortcode_elements .='<page-item><type>BGsectionEnd</type><size>'.$pego_pb_size_of_build_element.'</size><sectiontitle>'.$pego_pb_sectionend.'</sectiontitle></page-item>';																		
					}	
					if ($read_build_type == 'ColLeftIcon') {
							$pego_pb_columnwithicon1_count++;
							$pego_pb_columnwithicon1_title = htmlspecialchars($_POST['pego-pb-element-columnwithicon1-title'][$pego_pb_columnwithicon1_count]);
							$pego_pb_columnwithicon1_url = htmlspecialchars($_POST['pego-pb-element-columnwithicon1-url'][$pego_pb_columnwithicon1_count]);
							$pego_pb_columnwithicon1_icon = htmlspecialchars($_POST['pego-pb-element-columnwithicon1-icon'][$pego_pb_columnwithicon1_count]);						
							$pego_pb_columnwithicon1_content= htmlspecialchars($_POST['pego-pb-element-columnwithicon1-content'][$pego_pb_columnwithicon1_count]);
							$pego_pb_columnwithicon1_color= htmlspecialchars($_POST['pego-pb-element-columnwithicon1-color'][$pego_pb_columnwithicon1_count]);
							$pego_pb_shortcode_elements .='<page-item><type>ColLeftIcon</type><size>'.$pego_pb_size_of_build_element.'</size><counter>'.$pego_pb_columnwithicon1_count.'</counter><title>'.$pego_pb_columnwithicon1_title.'</title><url>'.$pego_pb_columnwithicon1_url.'</url><content>'.$pego_pb_columnwithicon1_content.'</content><icon>'.$pego_pb_columnwithicon1_icon.'</icon><color>'.$pego_pb_columnwithicon1_color.'</color></page-item>';																		
					}	
					if ($read_build_type == 'ColTopIcon') {
							$pego_pb_columnwithicon2_count++;
							$pego_pb_columnwithicon2_title = htmlspecialchars($_POST['pego-pb-element-columnwithicon2-title'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_url = htmlspecialchars($_POST['pego-pb-element-columnwithicon2-url'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_url_target = htmlspecialchars($_POST['pego-pb-element-columnwithicon2-urltarget'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_icon = htmlspecialchars($_POST['pego-pb-element-columnwithicon2-icon'][$pego_pb_columnwithicon2_count]);						
							$pego_pb_columnwithicon2_content= htmlspecialchars($_POST['pego-pb-element-columnwithicon2-content'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_color= htmlspecialchars($_POST['pego-pb-element-columnwithicon2-color'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_colorhover= htmlspecialchars($_POST['pego-pb-element-columnwithicon2-colorhover'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_color_icon= htmlspecialchars($_POST['pego-pb-element-columnwithicon2-color-icon'][$pego_pb_columnwithicon2_count]);
							$pego_pb_columnwithicon2_color_iconhover= htmlspecialchars($_POST['pego-pb-element-columnwithicon2-color-iconhover'][$pego_pb_columnwithicon2_count]);
							$pego_pb_shortcode_elements .='<page-item><type>ColTopIcon</type><size>'.$pego_pb_size_of_build_element.'</size><counter>'.$pego_pb_columnwithicon2_count.'</counter><title>'.$pego_pb_columnwithicon2_title.'</title><url>'.$pego_pb_columnwithicon2_url.'</url><content>'.$pego_pb_columnwithicon2_content.'</content><icon>'.$pego_pb_columnwithicon2_icon.'</icon><color>'.$pego_pb_columnwithicon2_color.'</color><colorhover>'.$pego_pb_columnwithicon2_colorhover.'</colorhover><iconcolor>'.$pego_pb_columnwithicon2_color_icon.'</iconcolor><iconcolorhover>'.$pego_pb_columnwithicon2_color_iconhover.'</iconcolorhover><urltarget>'.$pego_pb_columnwithicon2_url_target.'</urltarget></page-item>';																		
					}
					if ($read_build_type == 'Testimonial2') {	
							$pego_pb_clientssay_count++;	
							$pego_pb_clientssay_image = htmlspecialchars($_POST['pego-pb-element-clientssay-image'][$pego_pb_clientssay_count]);
							$pego_pb_clientssay_content = htmlspecialchars($_POST['pego-pb-element-clientssay-content'][$pego_pb_clientssay_count]);
							$pego_pb_clientssay_author = htmlspecialchars($_POST['pego-pb-element-clientssay-author'][$pego_pb_clientssay_count]);
							$pego_pb_clientssay_company = htmlspecialchars($_POST['pego-pb-element-clientssay-company'][$pego_pb_clientssay_count]);
							$pego_pb_clientssay_companyurl = htmlspecialchars($_POST['pego-pb-element-clientssay-companyurl'][$pego_pb_clientssay_count]);
							$pego_pb_shortcode_elements .='<page-item><type>Testimonial2</type><size>'.$pego_pb_size_of_build_element.'</size><image>'.$pego_pb_clientssay_image.'</image><content>'.$pego_pb_clientssay_content.'</content><author>'.$pego_pb_clientssay_author.'</author><company>'.$pego_pb_clientssay_company.'</company><companyurl>'.$pego_pb_clientssay_companyurl.'</companyurl>';								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}
					if ($read_build_type == 'BigSplashText') {
							$pego_pb_bigsplashtext_count++;						
							$pego_pb_bigsplashtext_title = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-title'][$pego_pb_bigsplashtext_count]);
							$pego_pb_bigsplashtext_titlefontcolor = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-titlefontcolor'][$pego_pb_bigsplashtext_count]);
							$pego_pb_bigsplashtext_titlefontsize = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-titlefontsize'][$pego_pb_bigsplashtext_count]);			
							$pego_pb_bigsplashtext_titlealign = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-title-align'][$pego_pb_bigsplashtext_count]);			
							$pego_pb_bigsplashtext_background_type = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-background-type'][$pego_pb_bigsplashtext_count]);									
							$pego_pb_bigsplashtext_background = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-background'][$pego_pb_bigsplashtext_count]);									
							$pego_pb_bigsplashtext_backgroundText = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-backgroundtext'][$pego_pb_bigsplashtext_count]);									
							$pego_pb_bigsplashtext_margintop = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-margintop'][$pego_pb_bigsplashtext_count]);									
							$pego_pb_bigsplashtext_marginbottom = htmlspecialchars($_POST['pego-pb-element-bigsplashtext-marginbottom'][$pego_pb_bigsplashtext_count]);									
							$pego_pb_shortcode_elements .='<page-item><type>BigSplashText</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_bigsplashtext_title.'</title><titlefontcolor>'.$pego_pb_bigsplashtext_titlefontcolor.'</titlefontcolor><titlefontsize>'.$pego_pb_bigsplashtext_titlefontsize.'</titlefontsize><background>'.$pego_pb_bigsplashtext_background.'</background><backgroundtext>'.$pego_pb_bigsplashtext_backgroundText.'</backgroundtext><margintop>'.$pego_pb_bigsplashtext_margintop.'</margintop><marginbottom>'.$pego_pb_bigsplashtext_marginbottom.'</marginbottom><backgroundtype>'.$pego_pb_bigsplashtext_background_type.'</backgroundtype><align>'.$pego_pb_bigsplashtext_titlealign.'</align></page-item>';																		
					}
					
					if ($read_build_type == 'ImageSlide') {										
							$pego_pb_imageslide_count++;	
							$pego_pb_imageslide_number = htmlspecialchars($_POST['pego-pb-element-imageslide-num'][$pego_pb_imageslide_count]);								
							$pego_pb_imageslide_title = htmlspecialchars($_POST['pego-pb-element-imageslide-title'][$pego_pb_imageslide_count]);
							$pego_pb_imageslide_title_align = htmlspecialchars($_POST['pego-pb-element-imageslide-title-align'][$pego_pb_imageslide_count]);
							$pego_pb_imageslide_title_heading = htmlspecialchars($_POST['pego-pb-element-imageslide-title-heading'][$pego_pb_imageslide_count]);
							$imageslide_shortcode='';
							$pego_pb_shortcode_elements .='<page-item><type>ImageSlide</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_imageslide_title.'</title><stevilo>'.$pego_pb_imageslide_number.'</stevilo><align>'.$pego_pb_imageslide_title_align.'</align><heading>'.$pego_pb_imageslide_title_heading.'</heading>';
							$imageslide_items_count++;
							if ($pego_pb_imageslide_number > 0) {								
								for($st=0; $st<$pego_pb_imageslide_number; $st++){
									$imageslide_shortcode .= '<imageslide_parent>';									
									$pego_pb_imageslide_item = htmlspecialchars($_POST['pego-pb-element-imageslide-item'][$imageslide_items_count]);		
									$imageslide_shortcode .= '<imageslide_item>'.$pego_pb_imageslide_item.'</imageslide_item>';
									$imageslide_shortcode .= '</imageslide_parent>';									
									$imageslide_items_count++;
								}
								$pego_pb_shortcode_elements .= $imageslide_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}					
					if ($read_build_type == 'Welcome3') {
							$pego_pb_welcome3_count++;						
							$pego_pb_welcome3_title = htmlspecialchars($_POST['pego-pb-element-welcome3-title'][$pego_pb_welcome3_count]);
							$pego_pb_welcome3_titlefontcolor = htmlspecialchars($_POST['pego-pb-element-welcome3-titlefontcolor'][$pego_pb_welcome3_count]);
							$pego_pb_welcome3_titlefontsize = htmlspecialchars($_POST['pego-pb-element-welcome3-titlefontsize'][$pego_pb_welcome3_count]);			
							$pego_pb_welcome3_content = htmlspecialchars($_POST['pego-pb-element-welcome3-content'][$pego_pb_welcome3_count]);
							$pego_pb_welcome3_contentfontcolor = htmlspecialchars($_POST['pego-pb-element-welcome3-contentfontcolor'][$pego_pb_welcome3_count]);
							$pego_pb_welcome3_contentfontsize = htmlspecialchars($_POST['pego-pb-element-welcome3-contentfontsize'][$pego_pb_welcome3_count]);		
							$pego_pb_welcome3_background = htmlspecialchars($_POST['pego-pb-element-welcome3-background'][$pego_pb_welcome3_count]);																		
							$pego_pb_welcome3_bordercolor = htmlspecialchars($_POST['pego-pb-element-welcome3-bordercolor'][$pego_pb_welcome3_count]);																		
							$pego_pb_welcome3_buttonurl = htmlspecialchars($_POST['pego-pb-element-welcome3-buttonurl'][$pego_pb_welcome3_count]);																		
							$pego_pb_welcome3_buttontarget = htmlspecialchars($_POST['pego-pb-element-welcome3-buttontarget'][$pego_pb_welcome3_count]);																		
							$pego_pb_welcome3_buttoncaption = htmlspecialchars($_POST['pego-pb-element-welcome3-buttoncaption'][$pego_pb_welcome3_count]);																		
							$pego_pb_welcome3_margintop = htmlspecialchars($_POST['pego-pb-element-welcome3-margintop'][$pego_pb_welcome3_count]);										
							$pego_pb_welcome3_marginbottom = htmlspecialchars($_POST['pego-pb-element-welcome3-marginbottom'][$pego_pb_welcome3_count]);										
							$pego_pb_shortcode_elements .='<page-item><type>Welcome3</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_welcome3_title.'</title><titlefontcolor>'.$pego_pb_welcome3_titlefontcolor.'</titlefontcolor><titlefontsize>'.$pego_pb_welcome3_titlefontsize.'</titlefontsize><content>'.$pego_pb_welcome3_content.'</content><contentfontcolor>'.$pego_pb_welcome3_contentfontcolor.'</contentfontcolor><contentfontsize>'.$pego_pb_welcome3_contentfontsize.'</contentfontsize><background>'.$pego_pb_welcome3_background.'</background><margintop>'.$pego_pb_welcome3_margintop.'</margintop><marginbottom>'.$pego_pb_welcome3_marginbottom.'</marginbottom><bordercolor>'.$pego_pb_welcome3_bordercolor.'</bordercolor><buttoncaption>'.$pego_pb_welcome3_buttoncaption.'</buttoncaption><buttonurl>'.$pego_pb_welcome3_buttonurl.'</buttonurl><buttontarget>'.$pego_pb_welcome3_buttontarget.'</buttontarget></page-item>';																		
					}
					if ($read_build_type == 'History') {	
							$pego_pb_history_count++;	
							$pego_pb_history_num = htmlspecialchars($_POST['pego-pb-element-history-num'][$pego_pb_history_count]);
							$pego_pb_history_title = htmlspecialchars($_POST['pego-pb-element-history-title'][$pego_pb_history_count]);						
							$pego_pb_history_title_heading = htmlspecialchars($_POST['pego-pb-element-history-title-heading'][$pego_pb_history_count]);		
							$pego_pb_history_title_align = htmlspecialchars($_POST['pego-pb-element-history-title-align'][$pego_pb_history_count]);					
							$history_shortcode = '';
							$pego_pb_shortcode_elements .='<page-item><type>History</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_history_title.'</title><stevilo>'.$pego_pb_history_num.'</stevilo><align>'.$pego_pb_history_title_align.'</align><heading>'.$pego_pb_history_title_heading.'</heading>';
							$history_items_count++;
							if ($pego_pb_history_num > 0) {								
								for($st=0; $st<$pego_pb_history_num; $st++){
									$history_shortcode .= '<history_parent>';									
									$pego_pb_historychild_title = htmlspecialchars($_POST['pego-pb-element-history-titleinner'][$history_items_count]);	
									$pego_pb_historychild_content = htmlspecialchars($_POST['pego-pb-element-history-content'][$history_items_count]);	
									$pego_pb_historychild_year = htmlspecialchars($_POST['pego-pb-element-history-year'][$history_items_count]);	
									$pego_pb_historychild_daymonth = htmlspecialchars($_POST['pego-pb-element-history-daymonth'][$history_items_count]);	
									
									$history_shortcode .= '<history_title>'.$pego_pb_historychild_title.'</history_title><history_content>'.$pego_pb_historychild_content.'</history_content><history_year>'.$pego_pb_historychild_year.'</history_year><history_daymonth>'.$pego_pb_historychild_daymonth.'</history_daymonth>';
									$history_shortcode .= '</history_parent>';									
									$history_items_count++;
								}
								$pego_pb_shortcode_elements .= $history_shortcode;
							}								
							$pego_pb_shortcode_elements .='</page-item>';																		
					}	
					if ($read_build_type == 'CircleBar') {
							$pego_pb_circleprogressbar_count++;
							$pego_pb_circleprogressbar_title = htmlspecialchars($_POST['pego-pb-element-circleprogressbar-title'][$pego_pb_circleprogressbar_count]);
							$pego_pb_circleprogressbar_percent = htmlspecialchars($_POST['pego-pb-element-circleprogressbar-percent'][$pego_pb_circleprogressbar_count]);
							$pego_pb_circleprogressbar_content = htmlspecialchars($_POST['pego-pb-element-circleprogressbar-content'][$pego_pb_circleprogressbar_count]);
							
							$pego_pb_shortcode_elements .='<page-item><type>CircleBar</type><size>'.$pego_pb_size_of_build_element.'</size><counter>'.$pego_pb_circleprogressbar_count.'</counter><title>'.$pego_pb_circleprogressbar_title.'</title><percent>'.$pego_pb_circleprogressbar_percent.'</percent><content>'.$pego_pb_circleprogressbar_content.'</content></page-item>';																		
					}
					if ($read_build_type == 'ExtraHeading') {
							$pego_pb_extraheading_count++;
							$pego_pb_extraheading_title = htmlspecialchars($_POST['pego-pb-element-extraheading-title'][$pego_pb_extraheading_count]);
							$pego_pb_extraheading_content = htmlspecialchars($_POST['pego-pb-element-extraheading-content'][$pego_pb_extraheading_count]);
							$pego_pb_extraheading_titlesize = htmlspecialchars($_POST['pego-pb-element-extraheading-titlesize'][$pego_pb_extraheading_count]);
							$pego_pb_extraheading_contentsize = htmlspecialchars($_POST['pego-pb-element-extraheading-contentsize'][$pego_pb_extraheading_count]);
							
							$pego_pb_shortcode_elements .='<page-item><type>ExtraHeading</type><size>'.$pego_pb_size_of_build_element.'</size><title>'.$pego_pb_extraheading_title.'</title><content>'.$pego_pb_extraheading_content.'</content><titlesize>'.$pego_pb_extraheading_titlesize.'</titlesize><contentsize>'.$pego_pb_extraheading_contentsize.'</contentsize></page-item>';																		
					}
					
				}
				$pego_pb_shortcode_elements_old = get_post_meta($post_id, $pego_page_element['shortcode'], true);
				$pego_pb_shortcode_elements = '<pego-builder>'.$pego_pb_shortcode_elements.'</pego-builder>';
				pego_pb_save_data($post_id, $pego_pb_shortcode_elements, $pego_pb_shortcode_elements_old, $pego_page_element['shortcode']);
				
			}			
		}
	}
	
	function fill_select_and_default_build_elements($args){
	
		extract($args);	
		?>	
			<div class="pego-pb-element-single-item">
				<div class="pego-pb-head">
					<div class="pego-pb-logo">
						<img src="<?php echo get_template_directory_uri(); ?>/pego-pb/images/pego-pb-logo.png" alt="Pego page builder logo">
					</div>
					<div class="pego-pb-title">
						<h2><?php _e('Page Builder','furniot'); ?></h2>
						<p><?php _e('Visual page customization with only clicks.','furniot'); ?> </p>
					</div>
					<div class="clear"></div>
				</div>
					
				<div class="pego-pb-element-single-item-input">
					<div class="pego-pb-add-element" id="add_Column"><?php _e('Add Column','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Separator"><?php _e('Add Separator','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_List"><?php _e('Add List','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Button"><?php _e('Add Button','furniot'); ?></div>					
					<div class="pego-pb-add-element" id="add_Portfolio"><?php _e('Add Portfolio Items','furniot'); ?></div> 
					<div class="pego-pb-add-element" id="add_Posts"><?php _e('Add Posts Items','furniot'); ?></div> 
					<div class="pego-pb-add-element" id="add_Toggle"><?php _e('Add Toggle','furniot'); ?></div> 
					<div class="pego-pb-add-element" id="add_Carousel"><?php _e('Add Carousel Items','furniot'); ?></div>  				
					<div class="pego-pb-add-element" id="add_Tab"><?php _e('Add Tab','furniot'); ?></div> 
					<div class="pego-pb-add-element" id="add_GoogleMaps"><?php _e('Add Google Maps','furniot'); ?></div> 
					<div class="pego-pb-add-element" id="add_ContactForm7"><?php _e('Add Contact Form 7','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_ContactInfo"><?php _e('Add Contact Info','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Blockquote"><?php _e('Add Blockquote','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Image"><?php _e('Add Image','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Video"><?php _e('Add Video','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Slider"><?php _e('Add Slider','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Testimonials"><?php _e('Add Testimonials','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_ProgressBar"><?php _e('Add Progress bar','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Flexslider"><?php _e('Add Flexslider','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Socials"><?php _e('Add Socials','furniot'); ?></div>					
					<div class="pego-pb-add-element" id="add_Accordion"><?php _e('Add Accordion','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_TeamMember"><?php _e('Add Team Member','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Welcome1"><?php _e('Add Welcome1','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Welcome2"><?php _e('Add Welcome2','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_TwitterUpdates"><?php _e('Add Twitter Updates','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Heading"><?php _e('Add Heading','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_PricingColumn"><?php _e('Add Pricing Column','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_2ColTable"><?php _e('Add 2Col Table','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Gallery"><?php _e('Add Gallery','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Faq"><?php _e('Add Faq','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_BGsectionStart"><?php _e('BG section - START','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_BGsectionEND"><?php _e('BG section - END','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_ColLeftIcon"><?php _e('Add Column with left icon','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_ColTopIcon"><?php _e('Add Column with top icon','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_ColImage"><?php _e('Add Column with image','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_Testimonial2"><?php _e('Add Testimonial2','furniot'); ?></div>				
					<div class="pego-pb-add-element" id="add_BigSplashText"><?php _e('Add Big Splash Text','furniot'); ?></div>					
					<div class="pego-pb-add-element" id="add_ImageSlide"><?php _e('Add Image Slide','furniot'); ?></div>					
					<div class="pego-pb-add-element" id="add_Welcome3"><?php _e('Add Welcome3','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_History"><?php _e('Add History','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_CircleBar"><?php _e('Add Circle bar','furniot'); ?></div>
					<div class="pego-pb-add-element" id="add_ExtraHeading"><?php _e('Add Extra heading','furniot'); ?></div>
					<br class="clear">
				</div>
				<br class="clear">
			</div>
			<div class="pego-pb-default-elements" id="pego-pb-default-elements">
<!-- DEFAULT ELEMENTS start-->
				<?php				
				//for columns start
				izrisi_dosedanje_brez_name('one_fifth', 'Column');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
							dodaj_heading(__("Column",'furniot'));
							$title_value="";
							$id='pego-pb-element-column-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));

							$id='pego-pb-element-column-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-column-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$content_value="";
							$id='pego-pb-element-column-text';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));	

							
							$id='pego-pb-element-column-contentfont[]';  
							$text_type='text';
							dodaj_text(__('Content font size','furniot'), "", $id, $text_type, __('Input content font size. If empty default font size set in Theme Options will be set. [px]','furniot'));
							
							$id='pego-pb-element-column-text-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Text alignment",'furniot'), $values, "left", $id, __('Choose type of content alignment.','furniot'));	

					?>				
					</div>
				</div>
				<?php
				//for columns end				
				//for separator start
				izrisi_dosedanje_brez_name('one_fifth', 'Separator');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Separator",'furniot'));
							$value="5";
							$id='pego-pb-element-separator-height[]';
							$text_type='text';
							dodaj_text(__('Height','furniot'), $value, $id, $text_type, __('Input the height[number of pixels] for the separator.','furniot'));			

							$id='pego-pb-element-separator-type';
							$values = array("solid", "double", "groove", "dotted", "dashed");
							dodaj_select(__("Type",'furniot'), $values, "solid", $id, __('Choose a type of the separator. Default is solid type.','furniot'));				
							
							$value="";
							$id='pego-pb-element-separator-color';
							dodaj_color_picker(__('Color','furniot'), $value, $id, __('Set color for seperator.','furniot'));
							//dodaj_js_for_colorpicker($id, $value);							
							

					?>					
					</div>
				</div>	
				<?php
				//for separator end				
				//for list start
				izrisi_dosedanje_brez_name('one_fifth', 'List');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("List",'furniot'));
							$title_value="";
							$id='pego-pb-element-list-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
					
							$id='pego-pb-element-list-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-list-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-list-icon';
							$value='';
							$title=__('Icon','furniot');
							dodaj_upload($title, $id, $value, __('Upload an icon for list icon marker.','furniot'));	
							
							$id='pego-pb-element-list-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_list($title, $id, 0, $currentItems, '', null);										

					?>					
					</div>
				</div>	
				<?php
				//for list end	
				//for buttons start
				izrisi_dosedanje_brez_name('one_fifth', 'Button');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
							dodaj_heading(__("Button",'furniot'));
							$title_value="";
							$id='pego-pb-element-button-caption[]';
							$text_type='text';
							dodaj_text(__('Caption','furniot'), $title_value, $id, $text_type, __('Insert the caption that will appear on the button.','furniot'));
											
							$title_value="";
							$id='pego-pb-element-button-url[]';
							$text_type='text';
							dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Insert an url where the button will link.','furniot'));
							
							$id='pego-pb-element-button-type';
							$values = array("default", "blue", "green", "orange", "pink", "black", "grey");
							dodaj_select(__("Type",'furniot'), $values, "default", $id, __('Choose the button color type.','furniot'));	
							
							$id='pego-pb-element-button-target';
							$values = array("_self", "_blank");
							dodaj_select(__("Target",'furniot'), $values, "_self", $id, __('Choose button target.','furniot'));	
							
							$id='pego-pb-element-button-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Alignment",'furniot'), $values, "left", $id, __('Choose the alignment of the button regarding the area he is in.','furniot'));	
											
					?>				
					</div>
				</div>
				<?php
				//for buttons end		
				//for columns with icon start
				izrisi_dosedanje_brez_name('one_fifth', 'ColImage');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Column with image",'furniot'));	
							$title_value="";
							$id='pego-pb-element-columnwithicon-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$title_value="";
							$id='pego-pb-element-columnwithicon-url[]';
							$text_type='text';
							dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Input an url where the column will link. [optional]','furniot'));		
							
							$id='pego-pb-element-columnwithicon-icon';
							$value='';
							$title=__('Image','furniot');
							dodaj_upload($title, $id, $value, __('Upload an image to be shown.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-columnwithicon-buttonCaption[]';
							$text_type='text';
							dodaj_text(__('Read more caption','furniot'), $title_value, $id, $text_type, __('Insert the caption that will appear for the read more.','furniot'));
							
							$content_value=" ";
							$id='pego-pb-element-columnwithicon-content';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));
							
											
					?>				
					</div>
				</div>
				<?php
				//for columns with icon end		
				//for portoflio items start
				izrisi_dosedanje_brez_name('one_fourth', 'Portfolio');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Portfolio",'furniot'));					
							$title_value="";
							$id='pego-pb-element-portfolio-items-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-portfolio-items-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-portfolio-items-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$id='pego-pb-element-portfolio-item-text';
							$values = array("Yes", "No");
							dodaj_select(__("Show portfolio text?",'furniot'), $values, "Yes", $id, __('Select Yes to show portfolio text under thumbnail.','furniot'));	
							
							$id='pego-pb-element-portfolio-item-read';
							$values = array("Latest", "Random", "Portfolio Ordering");
							dodaj_select(__("Item read",'furniot'), $values, "Latest", $id, __('Select in which order the items should be read. Random means that the items you will select below, will be shown.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-portfolio-items-show-number[]';
							$text_type='text';
							dodaj_text(__('Number of items to show','furniot'), $title_value, $id, $text_type, __('Select how many items you want to show. The options is not used for Random ordering, that one takes as many as you choose below. If you want to display all enter -1.','furniot'));	
							
							$id='pego-pb-element-portfolio-size-item';
							$values = array("Half", "Third", "Fourth");
							dodaj_select(__("Item size",'furniot'), $values, "Fourth", $id, __('Select the single shown item size. The sizes named present the size of the item regarding the entire window.','furniot'));	
							
							$id='pego-pb-element-portfolio-items-category';
							$terms = get_terms("portfolio_categories");
							$allcats=array();
							$allcats[]="All";
							foreach ( $terms as $term ) { 
								$allcats[]=$term->name;
							}
							dodaj_select(__("Category",'furniot'), $allcats, "All", $id, __('Select a category from which item will be taken.','furniot'));			

							$argsPortf = array('post_type'=> 'portfolio', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
							$postsPortf = get_posts($argsPortf);
							$idd=0;
							$values=array();
							$values[0]="";
							foreach($postsPortf as $postPortf)
							{ 
								setup_postdata($postPortf);
								$portf_slug= $postPortf->post_name;
								$portf_title=get_the_title($postPortf->ID);
								$values[$portf_slug ] = $portf_title;						

							}
							$id='pego-pb-element-portfolio-items-related';
																
							dodaj_select(__("Related to",'furniot'), $values, "", $id, __('Choose item, which related will be shown.','furniot'));			

							
							$title_value="";
							$id=' pego-pb-element-portfolio-item-text-checkall-caption[]';
							$text_type='text';
							dodaj_text(__('Check all - caption','furniot'), $title_value, $id, $text_type, __('Input caption for "check all" [optional].','furniot'));	
							
							
							$title_value="";
							$id=' pego-pb-element-portfolio-item-text-checkall-url[]';
							$text_type='text';
							dodaj_text(__('Check all - url','furniot'), $title_value, $id, $text_type, __('Input url for "check all" [optional].','furniot'));	
							
							$id='pego-pb-element-portfolio-items-num';
							//get portf items
							$argsPortf = array('post_type'=> 'portfolio', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
							$postsPortf = get_posts($argsPortf);
							$idd=0;
							$values=array();
							$title='Items';
							foreach($postsPortf as $postPortf)
							{ 
								setup_postdata($postPortf);
								$portf_slug= $postPortf->post_name;
								$portf_title=get_the_title($postPortf->ID);
								$values[$portf_slug ] = $portf_title;						

							}
							dodaj_dinamicni_portfolio_select($title, $id, $values, "", 0, '', null);									

							
					

					?>					
					</div>
				</div>	
				<?php
				//for portfolio end	
				//for carousel start
				izrisi_dosedanje_brez_name('one_fourth', 'Carousel');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
							dodaj_heading(__("Carousel",'furniot'));
							$title_value="";
							$id='pego-pb-element-carousel-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-carousel-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-carousel-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-carousel-width[]';
							$text_type='text';
							dodaj_text(__('Single element width','furniot'), $title_value, $id, $text_type, __('Click in the input and write width of a single carousel element. If the area for the carousel is smaller, the items will fit to it. Height will be adjusted itself.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-carousel-speed[]';
							$text_type='text';
							dodaj_text(__('Speed','furniot'), $title_value, $id, $text_type, __('Click in the input and write speed for the carousel sliding. If empty carousel will not slide automaticly.','furniot'));
							
							$id='pego-pb-element-carousel-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_carousel($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for carousel end	
				//for toggle start
				izrisi_dosedanje_brez_name('one_fifth', 'Toggle');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Toggle",'furniot'));							
							$title_value="";
							$id='pego-pb-element-toggle-main-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
					
							$id='pego-pb-element-toggle-main-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-toggle-main-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-toggle-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_toggle($title, $id, 0, $currentItems, '', null);						

					?>					
					</div>
				</div>	
				<?php
				//for toggle end	
				//for tab start
				izrisi_dosedanje_brez_name('one_half', 'Tab');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Tab",'furniot'));
							$title_value="";
							$id='pego-pb-element-tab-main-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-tab-main-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-tab-main-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-tab-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_tab($title, $id, 0, $currentItems, '',null);									

					?>					
					</div>
				</div>	
				<?php
				//for tab end	
				//for google maps start
				izrisi_dosedanje_brez_name('one_fifth', 'GoogleMaps');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Google maps",'furniot'));
							$title_value="";
							$id='pego-pb-element-maps-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-maps-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-maps-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$id='pego-pb-element-maps-fullwidth';
							$values = array("No", "Yes");
							dodaj_select(__("Fullwidth?",'furniot'), $values, "No", $id, __('Choose yes to have map displayed fullwidth, with no margins. This will be used only if with of the map element is set to 100%','furniot'));															
							$title_value="250";
							$id='pego-pb-element-maps-height[]';
							$text_type='text';
							dodaj_text(__('Height','furniot'), $title_value, $id, $text_type, __('Insert the height[number of pixels] for the map.','furniot'));							
							
															
							$title_value="10";
							$id='pego-pb-element-maps-zoom[]';
							$text_type='text';
							dodaj_text(__('Zoom','furniot'), $title_value, $id, $text_type, __('Insert number for zoom. Zoom is used only if one location is set.','furniot'));	
							
							$id='pego-pb-element-maps-num';
							$currentItems='';
							$title=__('Map locations','furniot');
							dodaj_dinamicni_maps($title, $id, 0, $currentItems, '',null);	
					?>				
					</div>
				</div>
				<?php
				//for google maps end					
				//for posts items start
				izrisi_dosedanje_brez_name('one_fourth', 'Posts');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Posts",'furniot'));							
							$title_value="";
							$id='pego-pb-element-posts-items-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-posts-items-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-posts-items-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$id='pego-pb-element-posts-item-read';
							$values = array("Random", "Latest");
							dodaj_select(__("Post item read",'furniot'), $values, "Random", $id, __('Select in which order the items should be read. Random means that the items you will select below, will be shown.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-posts-items-show-number[]';
							$text_type='text';
							dodaj_text(__('Number of items to show','furniot'), $title_value, $id, $text_type, __('Select how many items you want to show. The options is not used for Random ordering, that one takes as many as you choose below.','furniot'));	
							
							$title_value="150";
							$id='pego-pb-element-posts-items-summary-length[]';
							$text_type='text';
							dodaj_text(__('Summary length','furniot'), $title_value, $id, $text_type, __('Insert the lenght of the post content summary that will be shown on the items.','furniot'));	
							
							$id='pego-pb-element-posts-size-item';
							$values = array("Half", "Third", "Fourth");
							dodaj_select(__("Item size",'furniot'), $values, "Fourth", $id, __('Select the single shown item size. The sizes named present the size of the item regarding the entire window.','furniot'));		
							
							$id='pego-pb-element-posts-item-type';
							$values = array("Type1", "Type2");
							dodaj_select(__("Show Type",'furniot'), $values, "Type1", $id, __('Choose the showing type for the post items. Both are described in the documentation.','furniot'));	
										
							$title_value="";
							$id='pego-pb-element-posts-item-checkall-caption[]';
							$text_type='text';
							dodaj_text(__('Check all - caption','furniot'), $title_value, $id, $text_type, __('Input caption for "check all" [optional].','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-posts-item-checkall-url[]';
							$text_type='text';
							dodaj_text(__('Check all - url','furniot'), $title_value, $id, $text_type, __('Input url for "check all" [optional].','furniot'));	
							
							$id='pego-pb-element-posts-items-num';
							//get portf items
							$argsPosts = array('post_type'=> 'post', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
							$postsPosts= get_posts($argsPosts);
							$idd=0;
							$values=array();
							$title='Items';
							foreach($postsPosts as $postPost)
							{ 
								setup_postdata($postPost);
								$postslug= $postPost->post_name;
								$post_title=get_the_title($postPost->ID);
								$values[$postslug ] = $post_title;						

							}							
							dodaj_dinamicni_post_select($title, $id, $values, "", 0, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for posts end		
				//for quote1 
				izrisi_dosedanje_brez_name('one_fifth', 'Blockquote');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php	
							dodaj_heading(__("Blockquote",'furniot'));
							$title_value="";
							$id='pego-pb-element-quote1-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-quote1-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-quote1-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$content_value="";
							$id='pego-pb-element-quote1-text';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content for the blockquote. [optional]','furniot'));
							
							$title_value="";
							$id='pego-pb-element-quote1-author[]';
							$text_type='text';
							dodaj_text(__('Author','furniot'), $title_value, $id, $text_type, __('Click in the input and write an author of the blockquote. [optional]','furniot'));
							
							$id='pego-pb-element-quote1-icon';
							$value='';
							$title=__('Icon','furniot');
							dodaj_upload($title, $id, $value, __('Upload an icon for blockquote icon.','furniot'));

							$value="";
							$id='pego-pb-element-quote1-border-color';
							dodaj_color_picker(__('Border color','furniot'), $value, $id, __('Set color for border.','furniot'));	

							$title_value="0";
							$id='pego-pb-element-quote1-border-size[]';
							$text_type='text';
							dodaj_text(__('Border size','furniot'), $title_value, $id, $text_type, __('Click in the input and write the border size.','furniot'));							

					?>				
					</div>
				</div>
				<?php
				//for quote1 end	
				//for video start
				izrisi_dosedanje_brez_name('one_fifth', 'Video');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Video",'furniot'));
							$title_value="";
							$id='pego-pb-element-video-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-video-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-video-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$content_value="";
							$id='pego-pb-element-video-iframe';
							$text_type='textarea';	
							dodaj_text(__('Iframe','furniot'), $content_value, $id, $text_type, __('Insert the iframe code of the video.','furniot'));					

					?>				
					</div>
				</div>
				<?php
				//for video end		
				//for slider start
				izrisi_dosedanje_brez_name('full_width', 'Slider');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
						dodaj_heading(__("Layer slider",'furniot'));	
						$title_value="";							
						$id='pego-pb-element-slider-alias';
						$values = array();
					  //get all slides
/*
						global $wpdb;
						global $table_prefix;
						$table_prefix = $wpdb->base_prefix;
						$wpdb->tablename = $table_prefix . 'revslider_sliders';
						$revolution_sliders = $wpdb->get_results( 
								"
								SELECT title,alias 
								FROM $wpdb->tablename
								"
								);
						foreach ( $revolution_sliders as $revolution_slider ) 
						{
							$values[$revolution_slider->alias] = $revolution_slider->title;	
						}	
*/											
						$values= pego_get_slider_layer();							
						dodaj_select(__("Choose slider",'furniot'), $values, "", $id, __('Choose one of the layer slider to be shown. At least one needs to be created in the admin -> LayerSlider.','furniot'));
						
						$title_value="";
						$id='pego-pb-element-slider-title[]';
						$text_type='text';
						dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
						
						$id='pego-pb-element-slider-title-heading';
						$values = array("h1", "h2", "h3", "h4", "h5");
						dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
						
						$id='pego-pb-element-slider-title-align';
						$values = array("left", "center", "right");
						dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
						
						$id='pego-pb-element-slider-fullwidth';
						$values = array("No", "Yes");
						dodaj_select(__("Fullwidth?",'furniot'), $values, "No", $id, __('Choose yes to have slider displayed fullwidth, with no margins. This will be used only if with of the slider element is set to 100%','furniot'));
							
					?>				
					</div>
				</div>
				<?php
				//for slider end	
				//for testimonials start
				izrisi_dosedanje_brez_name('one_half', 'Testimonials');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Testimonials",'furniot'));	
							$title_value="";
							$id='pego-pb-element-testimonials-main-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-testimonials-main-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-testimonials-main-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-testimonials-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_testimonials($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for testimonials end	
				//for progress bar start
				izrisi_dosedanje_brez_name('one_fifth', 'ProgressBar');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Progress bar",'furniot'));	
							$title_value="";
							$id='pego-pb-element-progressbar-main-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-progressbar-main-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-progressbar-main-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$value="E74C3C";
							$id='pego-pb-element-progressbar-color';
							dodaj_color_picker(__('Color','furniot'), $value, $id, __('Set color for progress bar background.','furniot'));
					
							$id='pego-pb-element-progressbar-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_progressbar($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for progress bar end		
				//for flexslider start
				izrisi_dosedanje_brez_name('one_half', 'Flexslider');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Flexslider",'furniot'));	
							$title_value="";
							$id='pego-pb-element-flexslider-main-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-flexslider-main-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-flexslider-main-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-flexslider-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_flexslider($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for flexslider end
				//for socials start
				izrisi_dosedanje_brez_name('one_fifth', 'Socials');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Socials",'furniot'));	
							$title_value="";
							$id='pego-pb-element-socials-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-socials-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-socials-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
							
							$id='pego-pb-element-socials-type';
							$values = array("dark", "light");
							dodaj_select(__("Type",'furniot'), $values, "dark", $id, __('Choose the type of icons you want to use.','furniot'));
							
							$value="";
							$id='pego-pb-element-socials-bgcolor';
							dodaj_color_picker(__('Background Color','furniot'), $value, $id, __('Set color for socials background. [optional]','furniot'));
							
							$id='pego-pb-element-socials-num';
							$currentItems='';
							$title=__('Socials items','furniot');
							dodaj_dinamicni_socials($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for socials end		
				//for contact form 7 start
				izrisi_dosedanje_brez_name('one_half', 'ContactForm7');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
						dodaj_heading(__("Contact form 7",'furniot'));
						$title_value="";
						$id='pego-pb-element-contactform7-title[]';
						$text_type='text';
						dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
						
						$id='pego-pb-element-contactform7-title-heading';
						$values = array("h1", "h2", "h3", "h4", "h5");
						dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
						
						$id='pego-pb-element-contactform7-title-align';
						$values = array("left", "center", "right");
						dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
						
						$title_value="";							
						$id='pego-pb-element-contactform7';
						$allContactForms7 = array();
						global $wpdb;
						global $table_prefix;
						$table_prefix = $wpdb->base_prefix;
						$wpdb->tablename = $table_prefix . 'posts';
						$contact_forms7 = $wpdb->get_results( 
								"
								SELECT ID,post_title 
								FROM $wpdb->tablename
								WHERE post_type = 'wpcf7_contact_form'
								"
								);
						foreach ( $contact_forms7 as $contact_form7 ) 
						{							
							$allContactForms7[$contact_form7->ID] = $contact_form7->post_title;	
						}								
						dodaj_select(__("Choose Contact Form 7",'furniot'), $allContactForms7, "", $id, __('Choose one of the Contact forms 7 to be shown. At least one needs to be created in the admin -> Contact.','furniot'));
							
					?>				
					</div>
				</div>
				<?php
				//for contact form 7 end	
				//for accordion start
				izrisi_dosedanje_brez_name('one_fifth', 'Accordion');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Accordion",'furniot'));
							$title_value="";
							$id='pego-pb-element-accordion-main-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-accordion-main-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-accordion-main-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-accordion-num';
							$currentItems='';
							$title=__('Accordion items','furniot');
							dodaj_dinamicni_accordion($title, $id, 0, $currentItems, '', null);									

					?>					
					</div>
				</div>	
				<?php
				//for accordion end		
				//for team member start
				izrisi_dosedanje_brez_name('one_fifth', 'TeamMember');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Team Member",'furniot'));	
							$title_value="";
							$id='pego-pb-element-teammember-name[]';
							$text_type='text';
							dodaj_text(__('Name','furniot'), $title_value, $id, $text_type, __('Insert a name for the team member.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-teammember-position[]';
							$text_type='text';
							dodaj_text(__('Position','furniot'), $title_value, $id, $text_type, __('Insert a position for the team member.','furniot'));
							
							$content_value="";
							$id='pego-pb-element-teammember-description';
							$text_type='textarea';	
							dodaj_text(__('Description','furniot'), $content_value, $id, $text_type, __('Insert a description of the team member.','furniot'));
					
							$id='pego-pb-element-teammember-image';
							$value='';
							$title=__('Image','furniot');
							dodaj_upload($title, $id, $value, __('Upload an image.','furniot'));
														
							
							$id='pego-pb-element-teammember-num';
							$currentItems='';
							$title=__('Socials','furniot');
							dodaj_dinamicni_teammember($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for team member end	
				//for image start
				izrisi_dosedanje_brez_name('one_fifth', 'Image');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Image",'furniot'));	
							$title_value="";
							$id='pego-pb-element-image-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-image-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-image-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-image-url';
							$value='';
							$title=__('Image','furniot');
							dodaj_upload($title, $id, $value, 'Upload an image.');

							$id='pego-pb-element-image-popup';
							$values = array("No", "Yes");
							dodaj_select(__("Pop up image on click?",'furniot'), $values, "No", $id, __('Select Yes if you want the image to have a pop up to fullsize.','furniot'));

							$title_value="";
							$id='pego-pb-element-image-margintop[]';
							$text_type='text';
							dodaj_text(__('Margin top','furniot'), $title_value, $id, $text_type, __('Input margin top for image. Insert only number without px [optional]','furniot'));
							
							$title_value="";
							$id='pego-pb-element-image-marginbottom[]';
							$text_type='text';
							dodaj_text(__('Margin bottom','furniot'), $title_value, $id, $text_type, __('Input margin bottom for image. Insert only number without px [optional]','furniot'));
							
					?>					
					</div>
				</div>	
				<?php
				//for image end	
				//for welcome quote start
				izrisi_dosedanje_brez_name('full_width', 'Welcome1');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Welcome quote - design #1",'furniot'));							
									
														
							$title_value="";
							$id='pego-pb-element-welcomequote1-content';
							$text_type='textarea';
							dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input the content for the welcome quote.','furniot'));
														
							$value="3d3d3f";
							$id='pego-pb-element-welcomequote1-fontcolor';
							dodaj_color_picker(__('Font color for content','furniot'), $value, $id, __('Set color for content.','furniot'));	
							
							$value="";
							$id='pego-pb-element-welcomequote1-spancolor';
							dodaj_color_picker(__('Span color ','furniot'), $value, $id, __('Set color for content inside SPAN. If empty main template color will be set.','furniot'));	
							
							$title_value="30";
							$id='pego-pb-element-welcomequote1-contentsize[]';
							$text_type='text';
							dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input font size for the content.','furniot'));

							$title_value="0";
							$id='pego-pb-element-welcomequote1-margintop[]';
							$text_type='text';
							dodaj_text(__('Margin top','furniot'), $title_value, $id, $text_type, __('Input margin top.','furniot'));							
					?>				
					</div>
				</div>
				<?php
				//for welcome quote end					
				//for welcome quote start
				izrisi_dosedanje_brez_name('full_width', 'Welcome2');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Welcome quote - design #3",'furniot'));	
						
							$title_value="";
							$id='pego-pb-element-welcomequote3-leftcontenttitle[]';
							$text_type='text';
							dodaj_text(__('Left area title','furniot'), $title_value, $id, $text_type, __('Input the title for the left side area.','furniot'));
						
							$title_value="";
							$id='pego-pb-element-welcomequote3-leftcontent';
							$text_type='textarea';
							dodaj_text(__('Left content','furniot'), $title_value, $id, $text_type, __('Input the content for the left side area.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-welcomequote3-rightcontent[]';
							$text_type='text';
							dodaj_text(__('Right content','furniot'), $title_value, $id, $text_type, __('Input the content for the right side area.','furniot'));
							
							
							$title_value="";
							$id='pego-pb-element-welcomequote3-rightcontenturl[]';
							$text_type='text';
							dodaj_text(__('Right content url','furniot'), $title_value, $id, $text_type, __('Input the url for the right side area.','furniot'));	

							$value="";
							$id='pego-pb-element-welcomequote3-leftcolor';
							dodaj_color_picker(__('Left area background color ','furniot'), $value, $id, __('Set color for left side background.','furniot'));

							$value="";
							$id='pego-pb-element-welcomequote3-rightcolor';
							dodaj_color_picker('Right button background color ', $value, $id, 'Set color for button on the right side.');	

							$value="";
							$id='pego-pb-element-welcomequote3-fontcolortitle';
							dodaj_color_picker(__('Left side title - font color ','furniot'), $value, $id, __('Set color for left side title font color.','furniot'));	
							
							$value="";
							$id='pego-pb-element-welcomequote3-fontcolor';
							dodaj_color_picker(__('Left side - font color ','furniot'), $value, $id, __('Set color for left side font color.','furniot'));							

							$value="";
							$id='pego-pb-element-welcomequote3-fontcolorright';
							dodaj_color_picker(__('Right side - font color ','furniot'), $value, $id, __('Set color for right side font color.','furniot'));	
					?>				
					</div>
				</div>
				<?php
				//welcome quote end
				//twitter updates start
				izrisi_dosedanje_brez_name('full_width', 'TwitterUpdates');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Twitter updates",'furniot'));	
							$id='pego-pb-element-twitter-updates-type';
							$values = array("type1", "type2");
							dodaj_select(__("Type",'furniot'), $values, "type1", $id, __('Choose the type of the twitter updates. Both types are descibed in the documantation.','furniot'));	
	
							
							$title_value="";
							$id='pego-pb-element-twitter-updates-username[]';
							$text_type='text';
							dodaj_text(__('Username','furniot'), $title_value, $id, $text_type, __('Insert the Twiiter username, from which twwets will be displayed.','furniot'));	
	
							
							$title_value="";
							$id='pego-pb-element-twitter-updates-number[]';
							$text_type='text';
							dodaj_text(__('Number of tweets','furniot'), $title_value, $id, $text_type, __('Choose number of tweets to be shown.','furniot'));	
							
							$id='pego-pb-element-twitter-updates-icon';
							$value='';
							$title=__('Icon','furniot');
							dodaj_upload($title, $id, $value, __('Upload an icon you want to use for the tweet updates.','furniot'));	
												

							$value="";
							$id='pego-pb-element-twitter-updates-bgcolor';
							dodaj_color_picker(__('Background color','furniot'), $value, $id, __('Set color for tweet updates background.','furniot'));	

							$value="";
							$id='pego-pb-element-twitter-updates-fontcolor';
							dodaj_color_picker(__('Font color','furniot'), $value, $id, __('Set color for tweet updates font.','furniot'));							
					?>				
					</div>
				</div>
				<?php
				//for welcome quote end	
				//for heading start
				izrisi_dosedanje_brez_name('one_fifth', 'Heading');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Heading",'furniot'));	
							$value="";
							$id='pego-pb-element-heading-content[]';
							$text_type='text';
							dodaj_text(__('Content','furniot'), $value, $id, $text_type, __('Insert the content for the heading.','furniot'));

							$id='pego-pb-element-heading-content-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-heading-content-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					?>					
					</div>
				</div>	
				<?php
				//for heading end	
				//for contactinfo start
				izrisi_dosedanje_brez_name('one_fifth', 'ContactInfo');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Contact info",'furniot'));
							$title_value="";
							$id='pego-pb-element-contactinfo-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
					
							$id='pego-pb-element-contactinfo-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-contactinfo-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-contactinfo-image';
							$value='';
							$title=__('Contact info image:','furniot');
							dodaj_upload($title, $id, $value, __('Upload an image forr the contact info. [optional]','furniot'));	
					
							$content_value="";
							$id='pego-pb-element-contactinfo-content';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Insert content that will appear before the icons with text.','furniot'));
							
							$id='pego-pb-element-contactinfo-num';
							$currentItems='';
							$title=__('Icons with text','furniot');
							dodaj_dinamicni_contactinfo($title, $id, 0, $currentItems, '', null);									

					?>					
					</div>
				</div>	
				<?php
				//for contactinfo end	
				//for pricing start
				izrisi_dosedanje_brez_name('one_fifth', 'PricingColumn');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Pricing column",'furniot'));
							$title_value="";
							$id='pego-pb-element-pricing-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-pricing-price[]';
							$text_type='text';
							dodaj_text(__('Price','furniot'), $title_value, $id, $text_type, __('Click in the input and write a price for the pricing column.','furniot'));							
							
							$title_value="";
							$id='pego-pb-element-pricing-price-currency[]';
							$text_type='text';
							dodaj_text(__('Currency','furniot'), $title_value, $id, $text_type, __('Click in the input and write currency for the pricing column.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-pricing-per[]';
							$text_type='text';
							dodaj_text(__('Per','furniot'), $title_value, $id, $text_type, __('Click in the input and write a text fot the "per".','furniot'));
															
							$title_value="";
							$id='pego-pb-element-pricing-url[]';
							$text_type='text';
							dodaj_text(__('Button url','furniot'), $title_value, $id, $text_type, __('Click in the input and write an url for the pricing column.','furniot'));
							
							$id='pego-pb-element-pricing-best';
							$values = array("No", "Yes");
							dodaj_select(__("Best price?",'furniot'), $values, "No", $id, __('Choose Yes to make column more highlighted than others.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-pricing-url-caption[]';
							$text_type='text';
							dodaj_text(__('Button caption','furniot'), $title_value, $id, $text_type, __('Click in the input and write an url captionfor the pricing column.','furniot'));
							
							$id='pego-pb-element-pricing-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_pricing($title, $id, 0, $currentItems, '', null);						

					?>					
					</div>
				</div>	
				<?php
				//for pricing end
				//for 2coltable start
				izrisi_dosedanje_brez_name('full_width', '2ColTable');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("2 columns table",'furniot'));
							$title_value="";
							$id='pego-pb-element-coltable-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
										
							$id='pego-pb-element-coltable-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-coltable-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
										
							$title_value="";
							$id='pego-pb-element-coltable-buttoncaption[]';  
							$text_type='text';
							dodaj_text(__('Button caption','furniot'), $title_value, $id, $text_type, __('Click in the input and write caption for the button. [optional]','furniot'));
							
							$title_value="";
							$id='pego-pb-element-coltable-buttonurl[]';  
							$text_type='text';
							dodaj_text(__('Button url','furniot'), $title_value, $id, $text_type, __('Click in the input and write link for the button. [optional]','furniot'));
																		
							
							$id='pego-pb-element-coltable-color';
							$values = array("default", "blue", "red", "orange", "pink", "black", "grey");
							dodaj_select(__("Type",'furniot'), $values, "default", $id, __('Choose the color type for the button.','furniot'));	

							$id='pego-pb-element-coltable-num';
							$currentItems='';
							$title=__('Contents','furniot');
							dodaj_dinamicni_coltable($title, $id, 0, $currentItems, '', null);								

					?>					
					</div>
				</div>	
				<?php
				//for 2coltable end	
				//for gallery start
				izrisi_dosedanje_brez_name('full_width', 'Gallery');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
						dodaj_heading(__("Gallery",'furniot'));
						
						$title_value="";
						$id='pego-pb-element-gallery-title[]';
						$text_type='text';
						dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
						
						$id='pego-pb-element-gallery-title-heading';
						$values = array("h1", "h2", "h3", "h4", "h5");
						dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
						
						$id='pego-pb-element-gallery-title-align';
						$values = array("left", "center", "right");
						dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));
						
						
						$argsPortf = array('post_type'=> 'gallery', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
						$postsPortf = get_posts($argsPortf);	
						$allGallery = array();
						if($postsPortf) {
							foreach($postsPortf as $postPortf)
							{ 
								setup_postdata($postPortf); 	
								$allGallery[$postPortf->ID] = $postPortf->post_title;	
							}
						}						
						$id='pego-pb-element-gallery';
						dodaj_select(__("Gallery",'furniot'), $allGallery, "half", $id, __('Choose a gallery to be displayed.','furniot'));
						
						$id='pego-pb-element-gallery-width';
						$values = array("half", "third", "fourth");
						dodaj_select(__("Single item width",'furniot'), $values, "", $id, __('Choose width of a single gallery item.','furniot'));
							
					?>				
					</div>
				</div>
				<?php
				//for gallery end	
				//for faq start
				izrisi_dosedanje_brez_name('full_width', 'Faq');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
							dodaj_heading(__("Faq",'furniot'));
							$title_value="";
							$id='pego-pb-element-faq-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));	

							$id='pego-pb-element-faq-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-faq-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	

					?>				
					</div>
				</div>
				<?php
				//for faq end	
				//for bg section start
				izrisi_dosedanje_brez_name('full_width', 'BGsectionStart');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
						dodaj_heading(__("Background sections",'furniot'));
						
												
						$argsSec = array('post_type'=> 'backgroundsection', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
						$postsSecs = get_posts($argsSec);	
						$allSections= array();
						if($postsSecs) {
							foreach($postsSecs as $postsSec)
							{ 
								setup_postdata($postsSec); 	
								$allSections[$postsSec->ID] = $postsSec->post_title;	
							}
						}						
						$id='pego-pb-element-bgsectionstart';
						dodaj_select(__("Bg section",'furniot'), $allSections, "", $id, __('Choose section start.','furniot'));
							
					?>				
					</div>
				</div>
				<?php
				//for bg section end	
				//for bg sectionend start
				izrisi_dosedanje_brez_name('full_width', 'BGsectionEnd');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php			
						dodaj_heading(__("Background sections end",'furniot'));
		
					?>				
					</div>
				</div>
				<?php
				//for bg sectionend end		
				//for columns with left icon start
				izrisi_dosedanje_brez_name('one_fifth', 'ColLeftIcon');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Column with left icon",'furniot'));	
							$title_value="";
							$id='pego-pb-element-columnwithicon1-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
																		
							$title_value="";
							$id='pego-pb-element-columnwithicon1-url[]';
							$text_type='text';
							dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Input an url where the column will link. [optional]','furniot'));		
							
							
							$id='pego-pb-element-columnwithicon1-icon';
							$values = array("128340", "128318", "59146");
							dodaj_select_icon(__("Icon",'furniot'), $values, "", $id, __('Select an icon.','furniot'));
							
							$value="373737";
							$id='pego-pb-element-columnwithicon1-color';
							dodaj_color_picker(__('Color','furniot'), $value, $id, __('Set icon color.','furniot'));								
							
							
														
							$content_value="";
							$id='pego-pb-element-columnwithicon1-content';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));											
					?>				
					</div>
				</div>
				<?php
				//for columns with left icon end	
				//for columns with top icon start
				izrisi_dosedanje_brez_name('one_fifth', 'ColTopIcon');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Column with top icon",'furniot'));	
							$title_value="";
							$id='pego-pb-element-columnwithicon2-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
																		
							$title_value="";
							$id='pego-pb-element-columnwithicon2-url[]';
							$text_type='text';
							dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Input an url where the column will link. [optional]','furniot'));

							$id='pego-pb-element-columnwithicon2-urltarget';
							$values = array("_self", "_blank");
							dodaj_select(__("Url target",'furniot'), $values, "_self", $id, __('Choose url target.','furniot'));								
							
							
							$id='pego-pb-element-columnwithicon2-icon';
							$values = array("128340", "128318", "59146");
							dodaj_select_icon(__("Icon",'furniot'), $values, "", $id, __('Select an icon.','furniot'));
							
							$value="ffffff";
							$id='pego-pb-element-columnwithicon2-color-icon';
							dodaj_color_picker(__('Icon color','furniot'), $value, $id, __('Set icon color.','furniot'));	
							
							$value="ffffff";
							$id='pego-pb-element-columnwithicon2-color-iconhover';
							dodaj_color_picker(__('Icon hover color','furniot'), $value, $id, __('Set icon hover color.','furniot'));	
							
							$value="3d3d3f";
							$id='pego-pb-element-columnwithicon2-color';
							dodaj_color_picker(__('Icon background color','furniot'), $value, $id, __('Set icon background color.','furniot'));

							$value="E74C3C";
							$id='pego-pb-element-columnwithicon2-colorhover';
							dodaj_color_picker(__('Icon hover background color','furniot'), $value, $id, __('Set icon hover background color. ','furniot'));							
																											
							$content_value="";
							$id='pego-pb-element-columnwithicon2-content';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));											
					?>				
					</div>
				</div>
				<?php
				//for columns with icon end	
				//for clients say start
				izrisi_dosedanje_brez_name('one_fifth', 'Testimonial2');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Clients say..",'furniot'));	
							
							$id='pego-pb-element-clientssay-image';
							$value='';
							$title=__('Image','furniot');
							dodaj_upload($title, $id, $value, 'Upload image. Size is 70px X 70px.');
							
							$content_value="";
							$id='pego-pb-element-clientssay-content';
							$text_type='textarea';	
							dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));			
							
																					
							$title_value="";
							$id='pego-pb-element-clientssay-author[]';
							$text_type='text';
							dodaj_text(__('Author','furniot'), $title_value, $id, $text_type, __('Click in the input and write an author. [optional]','furniot'));
							
							$title_value="";
							$id='pego-pb-element-clientssay-company[]';
							$text_type='text';
							dodaj_text(__('Authors company','furniot'), $title_value, $id, $text_type, __('Click in the input and write authors company. [optional]','furniot'));
					
							$title_value="";
							$id='pego-pb-element-clientssay-companyurl[]';
							$text_type='text';
							dodaj_text(__('Authors company URL','furniot'), $title_value, $id, $text_type, __('Click in the input and write authors company URL. [optional]','furniot'));

					?>					
					</div>
				</div>	
				<?php
				//for clients say end					
				//for big splash text start
				izrisi_dosedanje_brez_name('full_width', 'BigSplashText');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Big Splash Text",'furniot'));							
									
							$title_value="";
							$id='pego-pb-element-bigsplashtext-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Input title for big splash.','furniot'));							
										
							$value="373737";
							$id='pego-pb-element-bigsplashtext-titlefontcolor';
							dodaj_color_picker(__('Font color for title','furniot'), $value, $id, __('Set color for title.','furniot'));	
							
							$title_value="48";
							$id='pego-pb-element-bigsplashtext-titlefontsize[]';
							$text_type='text';
							dodaj_text(__('Title font size','furniot'), $title_value, $id, $text_type, __('Input font size for the title.','furniot'));	
							
							$id='pego-pb-element-bigsplashtext-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));
							
							$id='pego-pb-element-bigsplashtext-background';
							$value='';
							$title=__('Background image','furniot');
							dodaj_upload($title, $id, $value, 'Upload an image for big splash background.');
							
							$id='pego-pb-element-bigsplashtext-background-type';
							$values = array("Static", "Parallax");
							dodaj_select(__("Background type",'furniot'), $values, "Static", $id, __('Select type for the background image','furniot'));
							
							$id='pego-pb-element-bigsplashtext-backgroundtext';
							$value='';
							$title=__('Background image behind text','furniot');
							dodaj_upload($title, $id, $value, 'Upload an image for big splash behind text background. Image will be put on repeat.');
							
							$title_value="";
							$id='pego-pb-element-bigsplashtext-margintop[]';
							$text_type='text';
							dodaj_text(__('BigSplashText margin top','furniot'), $title_value, $id, $text_type, __('Input margin top for big splash.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-bigsplashtext-marginbottom[]';
							$text_type='text';
							dodaj_text(__('BigSplashText margin bottom','furniot'), $title_value, $id, $text_type, __('Input margin bottom for big splash.','furniot'));	
									
					?>				
					</div>
				</div>
				<?php
				//for big splash text end	
					
				//for image slide start
				izrisi_dosedanje_brez_name('full_width', 'ImageSlide');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("Image slide",'furniot'));
							$title_value="";
							$id='pego-pb-element-imageslide-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
					
							$id='pego-pb-element-imageslide-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-imageslide-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
					
							
							$id='pego-pb-element-imageslide-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_imageslide($title, $id, 0, $currentItems, '', null);										

					?>					
					</div>
				</div>	
				<?php
				//for image slide end					
				//for welcome3 start
				izrisi_dosedanje_brez_name('full_width', 'Welcome3');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Welcome #3",'furniot'));							
									
							$title_value="";
							$id='pego-pb-element-welcome3-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Input title.','furniot'));							
										
							$value="3D3D3F";
							$id='pego-pb-element-welcome3-titlefontcolor';
							dodaj_color_picker(__('Font color for title','furniot'), $value, $id, __('Set color for title.','furniot'));	
							
							$title_value="36";
							$id='pego-pb-element-welcome3-titlefontsize[]';
							$text_type='text';
							dodaj_text(__('Title font size','furniot'), $title_value, $id, $text_type, __('Input font size for the title.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-welcome3-content';
							$text_type='textarea';
							dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input content.','furniot'));							
										
							$value="E74C3C";
							$id='pego-pb-element-welcome3-contentfontcolor';
							dodaj_color_picker(__('Font color for content','furniot'), $value, $id, __('Set color for content.','furniot'));	
							
							$title_value="22";
							$id='pego-pb-element-welcome3-contentfontsize[]';
							$text_type='text';
							dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input font size for the content.','furniot'));	
								
							$id='pego-pb-element-welcome3-background';
							$value="FAFAFA";
							dodaj_color_picker(__('Color for background','furniot'), $value, $id, __('Set color for background.','furniot'));	
							
							$id='pego-pb-element-welcome3-bordercolor';
							$value="E0DFDF";
							dodaj_color_picker(__('Border color','furniot'), $value, $id, __('Set color for border.','furniot'));	

							$title_value="";
							$id='pego-pb-element-welcome3-buttoncaption[]';
							$text_type='text';
							dodaj_text(__('Button caption','furniot'), $title_value, $id, $text_type, __('Input button caption.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-welcome3-buttonurl[]';
							$text_type='text';
							dodaj_text(__('Button url','furniot'), $title_value, $id, $text_type, __('Input button url.','furniot'));	
							
							$id='pego-pb-element-welcome3-buttontarget';
							$values = array("_self", "_blank");
							dodaj_select(__("Button target",'furniot'), $values, "_self", $id, __('Choose button target.','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-welcome3-margintop[]';
							$text_type='text';
							dodaj_text(__('Welcome #3 margin top','furniot'), $title_value, $id, $text_type, __('Input margin top. [optional]','furniot'));	

							$title_value="";
							$id='pego-pb-element-welcome3-marginbottom[]';
							$text_type='text';
							dodaj_text(__('Welcome #3 margin bottom','furniot'), $title_value, $id, $text_type, __('Input margin bottom. [optional]','furniot'));								
									
					?>				
					</div>
				</div>
				<?php
				//for welcome3 end	
				//for hstory start
				izrisi_dosedanje_brez_name('full_width', 'History');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php								
							dodaj_heading(__("History",'furniot'));
							$title_value="";
							$id='pego-pb-element-history-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
							
							$id='pego-pb-element-history-title-heading';
							$values = array("h1", "h2", "h3", "h4", "h5");
							dodaj_select(__("Title heading",'furniot'), $values, "h1", $id, __('Choose type of title heading.','furniot'));		
							
							$id='pego-pb-element-history-title-align';
							$values = array("left", "center", "right");
							dodaj_select(__("Title alignment",'furniot'), $values, "left", $id, __('Choose type of title alignment.','furniot'));	
					
							$id='pego-pb-element-history-num';
							$currentItems='';
							$title=__('Items','furniot');
							dodaj_dinamicni_history($title, $id, 0, $currentItems, '',null);									

					?>					
					</div>
				</div>	
				<?php
				//for history end	
				//for cirlce progress bar
				izrisi_dosedanje_brez_name('one_fourth', 'CircleBar');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Circle bar",'furniot'));	
							$title_value="";
							$id='pego-pb-element-circleprogressbar-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-circleprogressbar-percent[]';
							$text_type='text';
							dodaj_text(__('Percent','furniot'), $title_value, $id, $text_type, __('Click in the input and write percent number.','furniot'));
							
							$title_value="";
							$id='pego-pb-element-circleprogressbar-content';
							$text_type='textarea';
							dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input content [optional].','furniot'));	
							
																			
					?>				
					</div>
				</div>
				<?php
				//for circle progress bar end	
				//for extra heading start
				izrisi_dosedanje_brez_name('one_fourth', 'ExtraHeading');
				?>
				<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">							
					<?php		
							dodaj_heading(__("Extra heading",'furniot'));	
							$title_value="";
							$id='pego-pb-element-extraheading-title[]';
							$text_type='text';
							dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
														
							$title_value="";
							$id='pego-pb-element-extraheading-content';
							$text_type='textarea';
							dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input content [optional].','furniot'));	
							
							$title_value="";
							$id='pego-pb-element-extraheading-titlesize[]';
							$text_type='text';
							dodaj_text(__('Title font size','furniot'), $title_value, $id, $text_type, __('Input title size. Input only number, without px.','furniot'));
														
							$title_value="";
							$id='pego-pb-element-extraheading-contentsize[]';
							$text_type='text';
							dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input content size. Input only number, without px.','furniot'));
							
																			
					?>				
					</div>
				</div>
				<?php
				//for extra heading end					
			     ?>
				<br class="clear">
			</div>
		<?php
	}	

	// chosen elements
	function elements_on_board( $args1){	
		extract($args1);		
		?>	
		
			<div class="pego-pb-element-on-board" id="pego-pb-element-on-board">
				<div class="bi_slo_lahko_bek">
					<div class="pego-pb-element-on-board-wrapper" id="pego-pb-element-on-board-wrapper">					
					<?php					
						if($value != ''){						
							$xml = new DOMDocument();
							$xml->loadXML($value);
							$page_items = $xml->getElementsByTagName( "page-item" );
							foreach( $page_items as $page_item){				
								$currentType = $page_item->getElementsByTagName( "type" );
								$tip=$currentType->item(0)->nodeValue ;
								$velikost= $page_item->getElementsByTagName( "size" )->item(0)->nodeValue;
								$velikost_za_prikaz=get_niz_to_show($velikost);	
								$stevilo_list_itemov=2;		
								$stevilo_imageslide_itemov=2;		
								$stevilo_coltable_itemov=2;		
								$stevilo_pricing_itemov=2;		
								$stevilo_contactinfo_itemov=2;		
								$stevilo_socials_itemov=2;		
								$stevilo_carousel_itemov=2;		
								$stevilo_posts_itemov=2;		
								$stevilo_portfolio_itemov=2;		
								$stevilo_toggle_itemov=2;		
								$stevilo_accordion_itemov=2;		
								$stevilo_tab_itemov=2;		
								$stevilo_map_itemov=2;		
								$stevilo_progressbar_itemov=2;		
								$stevilo_flexslider_itemov=2;		
								$stevilo_testimonials_itemov=2;		
								$stevilo_quoterotator_itemov=2;		
								$stevilo_teammember_itemov=2;		
								$stevilo_verticallist_itemov=2;		
								$stevilo_history_itemov=2;		
								?>	
								<div class="pego-pb-single-element <?php echo $velikost; ?>" id="pego-pb-single-element"  rel="<?php echo $tip; ?>">
									<div class="pego-pb-element-frontend" id="pego-pb-element-frontend" > 									
										
										
										<div class="celotni-box">
											<div class="procenti-box">
												<div class="pego-pb-component-procent"><?php echo $velikost_za_prikaz; ?></div>	
											</div>
											<div class="arrows-box">
												<div class="pego-pb-decrease-element-size <?php echo $tip; ?>Type"></div>
												<div class="pego-pb-increase-element-size <?php echo $tip; ?>Type"></div>
											</div>
											<div class="name-box">
												<div class="pego-pb-component-name"><?php echo $tip; ?></div>
											</div>
											<div class="delete-box">
												<a title="Delete"><div class="pego-pb-delete-element" id="pego-pb-delete-element"></div></a>	
											</div>
											<div class="edit1-box">
												<a title="Edit"><div rel="pego-pb-inside-element-box" id="pego-pb-inside-an-element" class="pego-pb-element-edit"></div></a>
											</div>											
										</div>
										
										
										<div class="clear"></div>												
										<input type="hidden" id="pego-pb-element-type" value="<?php echo $tip; ?>" name="pego-pb-element-type[]">
										<input type="hidden" id="pego-pb-element-size" class="pego-pb-element-size" value="<?php echo $velikost; ?>" name="pego-pb-element-size[]">
									</div>										
									<div class="pego-pb-inside-an-element" id="pego-pb-inside-an-element">												
									<?php
										if ($tip == "Column") {			
											dodaj_heading(__("Column",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-column-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-column-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-column-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));												
											
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-column-text';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "contentfont" )->item(0)->nodeValue;
											$id='pego-pb-element-column-contentfont[]';  
											$text_type='text';
											dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input content font size. If empty default font size set in Theme Options will be set. [px]','furniot'));
											
											$id='pego-pb-element-column-text-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "contentalign" )->item(0)->nodeValue;
											dodaj_select(__("Text alignment",'furniot'), $values, $value, $id, __('Choose type of content alignment.','furniot'));	
										}
										if ($tip == 'Separator') {
											dodaj_heading(__("Separator",'furniot'));	
											$value=$page_item->getElementsByTagName( "height" )->item(0)->nodeValue;
											$id='pego-pb-element-separator-height[]';
											$text_type='text';
											dodaj_text(__('Height','furniot'), $value, $id, $text_type, __('Input the height[number of pixels] for the separator.','furniot'));		
											
											$id='pego-pb-element-separator-type';
											$value=$page_item->getElementsByTagName( "tip" )->item(0)->nodeValue;
											$values = array("solid", "double", "groove", "dotted", "dashed");
											dodaj_select(__("Type",'furniot'), $values, $value, $id, __('Choose a type of the separator. Default is solid type.','furniot'));											
											
											
											$value=$page_item->getElementsByTagName( "color" )->item(0)->nodeValue;
											$id='pego-pb-element-separator-color';
											dodaj_color_picker(__('Color','furniot'), $value, $id, __('Set color for seperator.','furniot'));
										}
										if ($tip == 'List') {			
											dodaj_heading(__("List",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-list-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-list-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-list-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));
											
											$id='pego-pb-element-list-icon';
											$value=$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
											$title=__('Icon','furniot');
											dodaj_upload($title, $id, $value, __('Upload an icon for list icon marker.','furniot'));	
										
											$id='pego-pb-element-list-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$list_items=$page_item->getElementsByTagName( "list_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_list($title, $id, $value, $currentItems, $stevilo_list_itemov, $list_items);
											$stevilo_list_itemov = $stevilo_list_itemov + $value;  //just a test
										}
										if ($tip == "Button") {	
											dodaj_heading(__("Button",'furniot'));		
											$title_value=$page_item->getElementsByTagName( "caption" )->item(0)->nodeValue;
											$id='pego-pb-element-button-caption[]';  
											$text_type='text';
											dodaj_text(__('Caption','furniot'), $title_value, $id, $text_type, __('Insert the caption that will appear on the button.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "url" )->item(0)->nodeValue;
											$id='pego-pb-element-button-url[]';  
											$text_type='text';
											dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Insert an url where the button will link.','furniot'));
											
																				
											$id='pego-pb-element-button-type';
											$value=$page_item->getElementsByTagName( "button_type" )->item(0)->nodeValue;
											$values = array("default", "blue", "green", "orange", "pink", "black", "grey");
											dodaj_select(__("Type",'furniot'), $values, $value, $id, __('Choose the button color type.','furniot'));	
											
											$id='pego-pb-element-button-target';
											$value=$page_item->getElementsByTagName( "buttontarget" )->item(0)->nodeValue;
											$values = array("_self", "_blank");
											dodaj_select(__("Target",'furniot'), $values, $value, $id, __('Choose button target.','furniot'));	
											
											$id='pego-pb-element-button-align';
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											$values = array("left", "center", "right");
											dodaj_select(__("Type",'furniot'), $values, $value, $id, __('Choose the alignment of the button regarding the area he is in.','furniot'));		
																					
										}										
										if ($tip == "ColImage") {
											dodaj_heading(__("Column with image",'furniot'));		
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
																										
											$title_value=$page_item->getElementsByTagName( "url" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon-url[]';
											$text_type='text';
											dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Input an url where the column will link. [optional]','furniot'));	
											
											$id='pego-pb-element-columnwithicon-icon';
											$value=$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
											$title=__('Image','furniot');
											dodaj_upload($title, $id, $value, __('Upload an image to be shown','furniot'));	
																						
											$title_value=$page_item->getElementsByTagName( "buttonCaption" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon-buttonCaption[]';
											$text_type='text';
											dodaj_text(__('Read more caption','furniot'), $title_value, $id, $text_type, __('Insert the caption that will appear for the read more.','furniot'));
											
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon-content';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));								
																		
										}
										if ($tip == 'Portfolio') {			
											dodaj_heading(__("Portfolio",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-portfolio-items-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-portfolio-items-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-portfolio-items-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-portfolio-item-text';
											$values = array("Yes", "No");
											$value=$page_item->getElementsByTagName( "text" )->item(0)->nodeValue;
											dodaj_select(__("Show portfolio text?",'furniot'), $values, $value, $id, __('Select Yes to show portfolio text under thumbnail.','furniot'));	
											
											$id='pego-pb-element-portfolio-item-read';
											$value=$page_item->getElementsByTagName( "read" )->item(0)->nodeValue;
											$values = array("Latest", "Random", "Portfolio Ordering");
											dodaj_select(__("Item read",'furniot'), $values, $value, $id, __('Select in which order the items should be read. Random means that the items you will select below, will be shown.','furniot'));		

											$title_value=$page_item->getElementsByTagName( "shownumber" )->item(0)->nodeValue;
											$id='pego-pb-element-portfolio-items-show-number[]';
											$text_type='text';
											dodaj_text(__('Number of items to show','furniot'), $title_value, $id, $text_type, __('Select how many items you want to show. The options is not used for Random ordering, that one takes as many as you choose below. If you want to display all enter -1.','furniot'));	
											
											$id='pego-pb-element-portfolio-size-item';
											$value=$page_item->getElementsByTagName( "width" )->item(0)->nodeValue;
											$values = array("Half", "Third", "Fourth");
											dodaj_select(__("Item size",'furniot'), $values, $value, $id, __('Select the single shown item size. The sizes named present the size of the item regarding the entire window.','furniot'));		
																		
											$id='pego-pb-element-portfolio-items-category';
											$terms = get_terms("portfolio_categories");
											$value=$page_item->getElementsByTagName( "category" )->item(0)->nodeValue;
											$allcats=array();
											$allcats[]="All";
											foreach ( $terms as $term ) { 
												$allcats[]=$term->name;
											}
											dodaj_select(__("Category",'furniot'), $allcats, $value, $id, __('Select a category from which item will be taken.','furniot'));	
											
											$argsPortf = array('post_type'=> 'portfolio', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
											$postsPortf = get_posts($argsPortf);
											$values=array();
											$values[0]="";
											foreach($postsPortf as $postPortf)
											{ 
												setup_postdata($postPortf);
												$portf_slug= $postPortf->post_name;
												$portf_title=get_the_title($postPortf->ID);
												$values[$portf_slug ] = $portf_title;						

											}

											$id='pego-pb-element-portfolio-items-related';
											$value=$page_item->getElementsByTagName( "related" )->item(0)->nodeValue;											
											dodaj_select(__("Related to",'furniot'), $values, $value, $id, __('Choose item, which related will be shown.','furniot'));	
											
											
											$title_value=$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue;		
											$id=' pego-pb-element-portfolio-item-text-checkall-caption[]';
											$text_type='text';
											dodaj_text(__('Check all - caption','furniot'), $title_value, $id, $text_type, __('Input caption for "check all" [optional].','furniot'));	
											
											
											$title_value=$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue;		
											$id=' pego-pb-element-portfolio-item-text-checkall-url[]';
											$text_type='text';
											dodaj_text(__('Check all - url','furniot'), $title_value, $id, $text_type, __('Input url for "check all" [optional].','furniot'));	
											
											$id='pego-pb-element-portfolio-items-num';
											//get portf items
											$argsPortf = array('post_type'=> 'portfolio', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
											$postsPortf = get_posts($argsPortf);
											$idd=0;
											$values=array();
											foreach($postsPortf as $postPortf)
											{ 
												setup_postdata($postPortf);
												$portf_slug= $postPortf->post_name;
												$portf_title=get_the_title($postPortf->ID);
												$values[$portf_slug ] = $portf_title;						

											}
											$title=__('Portfolio items','furniot');
											$num=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$portfolio_items=$page_item->getElementsByTagName( "portfolio_items_parent" );	
											dodaj_dinamicni_portfolio_select($title, $id, $values, "", $num,  $stevilo_portfolio_itemov, $portfolio_items);
											$stevilo_portfolio_itemov = $stevilo_portfolio_itemov + $value;  //just a test	
											

										}
										if ($tip == 'Carousel') {
											dodaj_heading(__("Carousel",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-carousel-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));					

											$id='pego-pb-element-carousel-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-carousel-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "width" )->item(0)->nodeValue;
											$id='pego-pb-element-carousel-width[]';
											$text_type='text';
											dodaj_text(__('Single element width','furniot'), $title_value, $id, $text_type, __('Click in the input and write width of a single carousel element. If the area for the carousel is smaller, the items will fit to it. Height will be adjusted itself.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "speed" )->item(0)->nodeValue;
											$id='pego-pb-element-carousel-speed[]';
											$text_type='text';
											dodaj_text(__('Speed','furniot'), $title_value, $id, $text_type, __('Click in the input and write speed for the carousel sliding. If empty carousel will not slide automaticly.','furniot'));
										
											$id='pego-pb-element-carousel-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$carousel_items=$page_item->getElementsByTagName( "carousel_parent" );
											$title=__('Carousel items','furniot');
											$currentItems='';											
											dodaj_dinamicni_carousel($title, $id, $value, $currentItems, $stevilo_carousel_itemov, $carousel_items);	
											$stevilo_carousel_itemov = $stevilo_carousel_itemov + $value;  //just a test
										}
										if ($tip == 'Toggle') {			
											dodaj_heading(__("Toggle",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-toggle-main-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-toggle-main-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-toggle-main-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-toggle-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$toggle_items=$page_item->getElementsByTagName( "toggle_parent" );
											$title=__('Toggle items','furniot');
											$currentItems='';											
											dodaj_dinamicni_toggle($title, $id, $value, $currentItems, $stevilo_toggle_itemov, $toggle_items);	
											$stevilo_toggle_itemov = $stevilo_toggle_itemov + $value;  //just a test
										}
										if ($tip == 'Tab') {			
											dodaj_heading(__("Tab",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-tab-main-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-tab-main-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-tab-main-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-tab-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$tab_items=$page_item->getElementsByTagName( "tab_parent" );
											$title=__('Tab items','furniot');
											$currentItems='';											
											dodaj_dinamicni_tab($title, $id, $value, $currentItems, $stevilo_tab_itemov, $tab_items);	
											$stevilo_tab_itemov = $stevilo_tab_itemov + $value;  //just a test
										}
										if ($tip == "GoogleMaps") {	
											dodaj_heading(__("Google maps",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-maps-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));		

											$id='pego-pb-element-maps-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-maps-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-maps-fullwidth';
											$values = array("No", "Yes");
											$value=$page_item->getElementsByTagName( "fullwidth" )->item(0)->nodeValue;
											dodaj_select(__("Fullwidth?",'furniot'), $values, $value, $id, __('Choose yes to have map displayed fullwidth, with no margins. This will be used only if with of the map element is set to 100%','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "height" )->item(0)->nodeValue;
											$id='pego-pb-element-maps-height[]';  
											$text_type='text';	
											dodaj_text(__('Height','furniot'), $title_value, $id, $text_type, __('Insert the height[number of pixels] for the map.','furniot'));
										
											$title_value=$page_item->getElementsByTagName( "zoom" )->item(0)->nodeValue;
											$id='pego-pb-element-maps-zoom[]';  
											$text_type='text';
											dodaj_text(__('Zoom','furniot'), $title_value, $id, $text_type, __('Insert number for zoom. Zoom is used only if one location is set.','furniot'));	
											
											

											$id='pego-pb-element-maps-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$map_items=$page_item->getElementsByTagName( "maps_parent" );
											$title=__('Map locations','furniot');
											$currentItems='';											
											dodaj_dinamicni_maps($title, $id, $value, $currentItems, $stevilo_map_itemov, $map_items);	
											$stevilo_map_itemov = $stevilo_map_itemov + $value;  //just a test											

										}
										if ($tip == 'Posts') {			
											dodaj_heading(__("Posts",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-posts-items-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-posts-items-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-posts-items-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-posts-item-read';
											$value=$page_item->getElementsByTagName( "read" )->item(0)->nodeValue;
											$values = array("Random", "Latest");
											dodaj_select(__("Item read",'furniot'), $values, $value, $id, __('Select in which order the items should be read. Random means that the items you will select below, will be shown.','furniot'));		

											$title_value=$page_item->getElementsByTagName( "shownumber" )->item(0)->nodeValue;
											$id='pego-pb-element-posts-items-show-number[]';
											$text_type='text';
											dodaj_text(__('Number of items to show','furniot'), $title_value, $id, $text_type, __('Select how many items you want to show. The options is not used for Random ordering, that one takes as many as you choose below.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "summarylength" )->item(0)->nodeValue;
											$id='pego-pb-element-posts-items-summary-length[]';
											$text_type='text';
											dodaj_text(__('Summary length','furniot'), $title_value, $id, $text_type, __('Insert the lenght of the post content summary that will be shown on the items.','furniot'));
											
											$id='pego-pb-element-posts-size-item';
											$value=$page_item->getElementsByTagName( "width" )->item(0)->nodeValue;
											$values = array("Half", "Third", "Fourth");
											dodaj_select(__("Item size",'furniot'), $values, $value, $id, __('Select the single shown item size. The sizes named present the size of the item regarding the entire window.','furniot'));				
											
											$id='pego-pb-element-posts-item-type';
											$value=$page_item->getElementsByTagName( "showtype" )->item(0)->nodeValue;
											$values = array("Type1", "Type2");
											dodaj_select(__("Show type",'furniot'), $values, $value, $id, __('Choose the showing type for the post items. Both are described in the documentation.','furniot'));	
			
											$title_value=$page_item->getElementsByTagName( "checkallcaption" )->item(0)->nodeValue;;
											$id='pego-pb-element-posts-item-checkall-caption[]';
											$text_type='text';
											dodaj_text(__('Check all - caption','furniot'), $title_value, $id, $text_type, __('Input caption for "check all" [optional].','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "checkallurl" )->item(0)->nodeValue;;
											$id='pego-pb-element-posts-item-checkall-url[]';
											$text_type='text';
											dodaj_text(__('Check all - url','furniot'), $title_value, $id, $text_type, __('Input url for "check all" [optional].','furniot'));	
											
											$id='pego-pb-element-posts-items-num';
											//get portf items
											$argsPortf = array('post_type'=> 'post', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
											$postsPortf = get_posts($argsPortf);
											$idd=0;
											$values=array();
											foreach($postsPortf as $postPortf)
											{ 
												setup_postdata($postPortf);
												$portf_slug= $postPortf->post_name;
												$portf_title=get_the_title($postPortf->ID);
												$values[$portf_slug ] = $portf_title;						

											}
											$title='Post items';
											$num=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$post_items=$page_item->getElementsByTagName( "posts_items_parent" );	
											dodaj_dinamicni_post_select($title, $id, $values, "", $num,  $stevilo_posts_itemov, $post_items );
											$stevilo_posts_itemov = $stevilo_posts_itemov + $value;  //just a test										
										}
										if ($tip == "Blockquote") {		
											dodaj_heading(__("Blockquote",'furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-quote1-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-quote1-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-quote1-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-quote1-text';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type , __('Click in the textarea and write content for the blockquote. [optional]','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "author" )->item(0)->nodeValue;
											$id='pego-pb-element-quote1-author[]';  
											$text_type='text';
											dodaj_text(__('Author','furniot'), $title_value, $id, $text_type, __('Click in the input and write an author of the blockquote. [optional]','furniot'));
											
											$id='pego-pb-element-quote1-icon';
											$value=$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
											$title=__('Icon','furniot');
											dodaj_upload($title, $id, $value, __('Upload an icon for blockquote icon.','furniot'));	

											$value=$page_item->getElementsByTagName( "bordercolor" )->item(0)->nodeValue;
											$id='pego-pb-element-quote1-border-color';
											dodaj_color_picker(__('Border color','furniot'), $value, $id, __('Set color for border.','furniot'));		

											$title_value=$page_item->getElementsByTagName( "bordersize" )->item(0)->nodeValue;
											$id='pego-pb-element-quote1-border-size[]';  
											$text_type='text';
											dodaj_text(__('Border size','furniot'), $title_value, $id, $text_type, __('Click in the input and write the border size.','furniot'));											
										}
										if ($tip == "Video") {	
											dodaj_heading("Video");	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-video-title[]';  
											$text_type='text';
											
											$id='pego-pb-element-video-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-video-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											$content_value=$page_item->getElementsByTagName( "iframecode" )->item(0)->nodeValue;
											$id='pego-pb-element-video-iframe';
											$text_type='textarea';	
											dodaj_text(__('Video Iframe','furniot'), $content_value, $id, $text_type, __('Insert the iframe code of the video.','furniot'));
										}
										if ($tip == "Slider") {		
											dodaj_heading(__("Slider",'furniot'));	
											$value=$page_item->getElementsByTagName( "alias" )->item(0)->nodeValue;
											$id='pego-pb-element-slider-alias';  
											$values = array();
										  //get all slides									
											$values= pego_get_slider_layer();
											dodaj_select(__("Choose slider",'furniot'), $values, $value , $id, __('Choose one of the layer slider to be shown. At least one needs to be created in the admin -> LayerSlider.','furniot'));
										
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-slider-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-slider-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-slider-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
										
											$id='pego-pb-element-slider-fullwidth';
											$values = array("No", "Yes");
											$value=$page_item->getElementsByTagName( "fullwidth" )->item(0)->nodeValue;
											dodaj_select(__("Fullwidth?",'furniot'), $values, $value, $id, __('Choose yes to have slider displayed fullwidth, with no margins. This will be used only if with of the slider element is set to 100%','furniot'));
											
										
										}
										if ($tip == 'Testimonials') {			
											dodaj_heading(__("Testimonials",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-testimonials-main-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-testimonials-main-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-testimonials-main-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-testimonials-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$testimonials_items=$page_item->getElementsByTagName( "testimonials_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_testimonials($title, $id, $value, $currentItems, $stevilo_testimonials_itemov, $testimonials_items);	
											$stevilo_testimonials_itemov = $stevilo_testimonials_itemov + $value;  //just a test
										}
										if ($tip == 'ProgressBar') {			
											dodaj_heading(__("Progress bar",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-progressbar-main-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-progressbar-main-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-progressbar-main-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$value=$page_item->getElementsByTagName( "color" )->item(0)->nodeValue;
											$id='pego-pb-element-progressbar-color';
											dodaj_color_picker(__('Color','furniot'), $value, $id, __('Set color for progress bar background.','furniot'));	
											
											$id='pego-pb-element-progressbar-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$progressbar_items=$page_item->getElementsByTagName( "progressbar_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_progressbar($title, $id, $value, $currentItems, $stevilo_progressbar_itemov, $progressbar_items);	
											$stevilo_progressbar_itemov = $stevilo_progressbar_itemov + $value;  //just a test
										}
										if ($tip == 'Flexslider') {			
											dodaj_heading(__("Flexslider",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-flexslider-main-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-flexslider-main-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-flexslider-main-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
																						
											$id='pego-pb-element-flexslider-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$flexslider_items=$page_item->getElementsByTagName( "flexslider_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_flexslider($title, $id, $value, $currentItems, $stevilo_flexslider_itemov, $flexslider_items);	
											$stevilo_flexslider_itemov = $stevilo_flexslider_itemov + $value;  //just a test
										}
										if ($tip == 'Socials') {			
											dodaj_heading(__("Socials",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-socials-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-socials-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-socials-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-socials-type';
											$value=$page_item->getElementsByTagName( "socialstype" )->item(0)->nodeValue;
											$values = array("dark", "light");
											dodaj_select(__("Type",'furniot'), $values, $value, $id, __('Choose the type of icons you want to use.','furniot'));

											$value=$page_item->getElementsByTagName( "bgcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-socials-bgcolor';
											dodaj_color_picker(__('Background Color','furniot'), $value, $id, __('Set color for socials background. [optional]','furniot'));												
										
											$id='pego-pb-element-socials-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$socials_items=$page_item->getElementsByTagName( "socials_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_socials($title, $id, $value, $currentItems, $stevilo_socials_itemov, $socials_items);	
											$stevilo_socials_itemov = $stevilo_socials_itemov + $value;  //just a test
										}
										if ($tip == "ContactForm7") {	
										
											dodaj_heading(__("Contact form 7",'furniot'));
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-contactform7-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-contactform7-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-contactform7-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
										
												
											$value=$page_item->getElementsByTagName( "contactform7" )->item(0)->nodeValue;
											$id='pego-pb-element-contactform7';  
											$allContactForms7 = array();
											global $wpdb;
											global $table_prefix;
											$table_prefix = $wpdb->base_prefix;
											$wpdb->tablename = $table_prefix . 'posts';
											$contact_forms7 = $wpdb->get_results( 
													"
													SELECT ID,post_title 
													FROM $wpdb->tablename
													WHERE post_type = 'wpcf7_contact_form'
													"
													);
											foreach ( $contact_forms7 as $contact_form7 ) 
											{						
												$allContactForms7[$contact_form7->ID] = $contact_form7->post_title;	
											}										
											dodaj_select(__("Choose Contact Form 7",'furniot'), $allContactForms7, $value , $id, __('Choose one of the Contact forms 7 to be shown. At least one needs to be created in the admin -> Contact.','furniot'));
										}
										if ($tip == 'Accordion') {		
											dodaj_heading(__("Accordion",'furniot'));											
											$title_value = $page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-accordion-main-title[]';  
											$id='pego-pb-element-accordion-main-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-accordion-main-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-accordion-main-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-accordion-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$accordion_items=$page_item->getElementsByTagName( "accordion_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_accordion($title, $id, $value, $currentItems, $stevilo_accordion_itemov, $accordion_items);	
											$stevilo_accordion_itemov = $stevilo_accordion_itemov + $value;  //just a test
										}
										if ($tip == 'TeamMember') {			
											dodaj_heading(__("Team member",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "name" )->item(0)->nodeValue;
											$id='pego-pb-element-teammember-name[]';  
											$text_type='text';
											dodaj_text(__('Name','furniot'), $title_value, $id, $text_type, __('Insert a name for the team member.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "position" )->item(0)->nodeValue;
											$id='pego-pb-element-teammember-position[]';  
											$text_type='text';
											dodaj_text(__('Position','furniot'), $title_value, $id, $text_type, __('Insert a position for the team member.','furniot'));	
											
											$content_value=$page_item->getElementsByTagName( "description" )->item(0)->nodeValue;
											$id='pego-pb-element-teammember-description';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Insert a description of the team member.','furniot'));													
											
											$id='pego-pb-element-teammember-image';
											$value=$page_item->getElementsByTagName( "image" )->item(0)->nodeValue;
											$title=__('Image','furniot');
											dodaj_upload($title, $id, $value, __('Upload an image.','furniot'));	
										
												
											$id='pego-pb-element-teammember-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$teammember_items=$page_item->getElementsByTagName( "teammember_parent" );
											$title=__('Socials','furniot');
											$currentItems='';											
											dodaj_dinamicni_teammember($title, $id, $value, $currentItems, $stevilo_teammember_itemov, $teammember_items);	
											$stevilo_teammember_itemov = $stevilo_teammember_itemov + $value;  //just a test
										}
										if ($tip == 'Image') {
											dodaj_heading(__("Image",'furniot'));	
											$title_value = $page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-image-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-image-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-image-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
											
											$id='pego-pb-element-image-url';
											$value=$page_item->getElementsByTagName( "url" )->item(0)->nodeValue;
											$title=__('Image','furniot');
											dodaj_upload($title, $id, $value, __('Upload an image.','furniot'));		
											
											$value=$page_item->getElementsByTagName( "popup" )->item(0)->nodeValue;
											$id='pego-pb-element-image-popup';
											$values = array("No", "Yes");
											dodaj_select(__("Pop up image on click?",'furniot'), $values, $value, $id,__('Select Yes if you want the image to have a pop up to fullsize.','furniot'));	

											
											$title_value = $page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue;
											$id='pego-pb-element-image-margintop[]';
											$text_type='text';
											dodaj_text(__('Margin top','furniot'), $title_value, $id, $text_type, __('Input margin top for image. Insert only number without px [optional]','furniot'));
											
											$title_value = $page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue;
											$id='pego-pb-element-image-marginbottom[]';
											$text_type='text';
											dodaj_text(__('Margin bottom','furniot'), $title_value, $id, $text_type, __('Input margin bottom for image. Insert only number without px [optional]','furniot'));
											
										}
										if ($tip == "Welcome1") {	
											dodaj_heading(__("Welcome quote - design #1",'furniot'));							
																				
											$title_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote1-content';
											$text_type='textarea';
											dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input the content for the welcome quote.','furniot'));
											
											$value=$page_item->getElementsByTagName( "fontcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote1-fontcolor';
											dodaj_color_picker(__('Font color for content','furniot'), $value, $id, __('Set color for content.','furniot'));	
											
											
											$value=$page_item->getElementsByTagName( "spancolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote1-spancolor';
											dodaj_color_picker(__('Span color ','furniot'), $value, $id, __('Set color for content inside SPAN. If empty main template color will be set.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "contentsize" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote1-contentsize[]';
											$text_type='text';
											dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input font size for the content.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote1-margintop[]';
											$text_type='text';
											dodaj_text(__('Margin top','furniot'), $title_value, $id, $text_type, __('Input margin top.','furniot'));	
										}											
										if ($tip == "Welcome2") {	
											dodaj_heading(__("Welcome quote - design #2",'furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "leftcontenttitle" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-leftcontenttitle[]';
											$text_type='text';
											dodaj_text(__('Left side title','furniot'), $title_value, $id, $text_type, __('Input the title for the left side area.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "leftcontent" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-leftcontent';
											$text_type='textarea';
											dodaj_text(__('Left content','furniot'), $title_value, $id, $text_type, __('Input the content for the left side area.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "rightcontent" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-rightcontent[]';
											$text_type='text';
											dodaj_text(__('Right content','furniot'), $title_value, $id, $text_type, __('Input the content for the right side area.','furniot'));
											
											
											$title_value=$page_item->getElementsByTagName( "rightcontenturl" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-rightcontenturl[]';
											$text_type='text';
											dodaj_text(__('Right content url','furniot'), $title_value, $id, $text_type, __('Input the url for the right side area.','furniot'));	

											$value=$page_item->getElementsByTagName( "leftcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-leftcolor';
											dodaj_color_picker(__('Left area background color ','furniot'), $value, $id, __('Set color for left side background.','furniot'));

											$value=$page_item->getElementsByTagName( "rightcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-rightcolor';
											dodaj_color_picker(__('Right button background color ','furniot'), $value, $id, __('Set color for button on the  right side.','furniot'));	

											$value=$page_item->getElementsByTagName( "fontcolortitle" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-fontcolortitle';
											dodaj_color_picker(__('Left side title - font color ','furniot'), $value, $id, __('Set color for left side title font color.','furniot'));		
											
											$value=$page_item->getElementsByTagName( "fontcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcomequote3-fontcolor';
											dodaj_color_picker(__('Left side - font color ','furniot'), $value, $id, __('Set color for left side font color.','furniot'));		

											$value=$page_item->getElementsByTagName( "fontcolorright" )->item(0)->nodeValue;							
											$id='pego-pb-element-welcomequote3-fontcolorright';
											dodaj_color_picker(__('Right side - font color ','furniot'), $value, $id, __('Set color for right side font color.','furniot'));												
										}										
										if ($tip == "TwitterUpdates") {		
											dodaj_heading(__("Twitter updates",'furniot'));	
											$id='pego-pb-element-twitter-updates-type';
											$value=$page_item->getElementsByTagName( "showtype" )->item(0)->nodeValue;
											$values = array("type1", "type2");
											dodaj_select(__("Type",'furniot'), $values, $value, $id, __('Choose the type of the twitter updates. Both types are descibed in the documantation.','furniot'));	
										
											$title_value=$page_item->getElementsByTagName( "username" )->item(0)->nodeValue;
											$id='pego-pb-element-twitter-updates-username[]';  
											$text_type='text';
											dodaj_text(__('Username','furniot'), $title_value, $id, $text_type	, __('Insert the Twiiter username, from which twwets will be displayed.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "number" )->item(0)->nodeValue;
											$id='pego-pb-element-twitter-updates-number[]';  
											$text_type='text';
											dodaj_text(__('Number of tweets','furniot'), $title_value, $id, $text_type, __('Choose number of tweets to be shown.','furniot'));	
											
											$id='pego-pb-element-twitter-updates-icon';
											$value=$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
											$title=__('Icon','furniot');
											dodaj_upload($title, $id, $value, __('Upload an icon you want to use for the tweet updates.','furniot'));	

											$value=$page_item->getElementsByTagName( "bgcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-twitter-updates-bgcolor';
											dodaj_color_picker(__('Background color','furniot'), $value, $id, __('Set color for tweet updates background.','furniot'));		

											$value=$page_item->getElementsByTagName( "fontcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-twitter-updates-fontcolor';
											dodaj_color_picker(__('Font color','furniot'), $value, $id, __('Set color for tweet updates font.','furniot'));												
										}
										if ($tip == 'Heading') {	
											dodaj_heading(__("Heading",'furniot'));	
											$value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-heading-content[]';
											$text_type='text';
											dodaj_text(__('Content','furniot'), $value, $id, $text_type, __('Insert the content for the heading.','furniot'));
											
											$id='pego-pb-element-heading-content-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-heading-content-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
										}
										if ($tip == 'ContactInfo') {			
											dodaj_heading(__("Contact info",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-contactinfo-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-contactinfo-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-contactinfo-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));
											
											$id='pego-pb-element-contactinfo-content';
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Insert content that will appear before the icons with text.','furniot'));
										
											$id='pego-pb-element-contactinfo-image';
											$value=$page_item->getElementsByTagName( "image" )->item(0)->nodeValue;
											$title=__('Contact info image:','furniot');
											dodaj_upload($title, $id, $value, __('Upload an image forr the contact info. [optional].','furniot'));		
											
											$id='pego-pb-element-contactinfo-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$contactinfo_items=$page_item->getElementsByTagName( "contactinfo_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_contactinfo($title, $id, $value, $currentItems, $stevilo_contactinfo_itemov, $contactinfo_items);
											$stevilo_contactinfo_itemov = $stevilo_contactinfo_itemov + $value;  //just a test
										}	
										if ($tip == 'PricingColumn') {			
											dodaj_heading(__("Pricing Column",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-pricing-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "price" )->item(0)->nodeValue;
											$id='pego-pb-element-pricing-price[]';  
											$text_type='text';
											dodaj_text(__('Price','furniot'), $title_value, $id, $text_type, __('Click in the input and write a price for the pricing column.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "currency" )->item(0)->nodeValue;
											$id='pego-pb-element-pricing-price-currency[]';  
											$text_type='text';
											dodaj_text(__('Currency','furniot'), $title_value, $id, $text_type, __('Click in the input and write currency for the pricing column.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "per" )->item(0)->nodeValue;
											$id='pego-pb-element-pricing-per[]';  
											$text_type='text';
											dodaj_text(__('Per','furniot'), $title_value, $id, $text_type, __('Click in the input and write a text for the "per".','furniot'));
											
																						
											$title_value=$page_item->getElementsByTagName( "url" )->item(0)->nodeValue;
											$id='pego-pb-element-pricing-url[]';  
											$text_type='text';
											dodaj_text(__('Button url','furniot'), $title_value, $id, $text_type, __('Click in the input and write an url for the pricing column.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "urlcaption" )->item(0)->nodeValue;
											$id='pego-pb-element-pricing-url-caption[]';  
											$text_type='text';
											dodaj_text(__('Button caption','furniot'), $title_value, $id, $text_type, __('Click in the input and write an url caption for the pricing table.','furniot'));

											$id='pego-pb-element-pricing-best';
											$values = array("No", "Yes");
											$value=$page_item->getElementsByTagName( "best" )->item(0)->nodeValue;
											dodaj_select(__("Best price?",'furniot'), $values, $value, $id, __('Choose Yes to make column more highlighted than others.','furniot'));
										
											$id='pego-pb-element-pricing-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$pricing_items=$page_item->getElementsByTagName( "pricing_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_pricing($title, $id, $value, $currentItems, $stevilo_pricing_itemov, $pricing_items);
											$stevilo_pricing_itemov = $stevilo_pricing_itemov + $value;  //just a test
										}	
										if ($tip == '2ColTable') {			
											dodaj_heading(__("2 column table",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-coltable-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
																		
											$id='pego-pb-element-coltable-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-coltable-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));
																		
											$title_value=$page_item->getElementsByTagName( "buttoncaption" )->item(0)->nodeValue;
											$id='pego-pb-element-coltable-buttoncaption[]';  
											$text_type='text';
											dodaj_text(__('Button caption','furniot'), $title_value, $id, $text_type, __('Click in the input and write caption for the button. [optional]','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "buttonurl" )->item(0)->nodeValue;
											$id='pego-pb-element-coltable-buttonurl[]';  
											$text_type='text';
											dodaj_text(__('Button url','furniot'), $title_value, $id, $text_type, __('Click in the input and write link for the button. [optional]','furniot'));
																						
											$value=$page_item->getElementsByTagName( "color" )->item(0)->nodeValue;
											$id='pego-pb-element-coltable-color';
											$values = array("default", "blue", "red", "orange", "pink", "black", "grey");
											dodaj_select(__("Type",'furniot'), $values, $value, $id, __('Choose the color type for the button.','furniot'));	

											$id='pego-pb-element-coltable-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$coltable_items=$page_item->getElementsByTagName( "coltable_parent" );
											$title=__('Content','furniot');
											$currentItems='';											
											dodaj_dinamicni_coltable($title, $id, $value, $currentItems, $stevilo_coltable_itemov, $coltable_items);
											$stevilo_coltable_itemov = $stevilo_coltable_itemov + $value; 											
										}
										if ($tip == 'Gallery') {
											dodaj_heading(__("Gallery",'furniot'));
											
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-gallery-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-gallery-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-gallery-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));
											
											$argsPortf = array('post_type'=> 'gallery', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
											$postsPortf = get_posts($argsPortf);	
											$allGallery = array();
											if($postsPortf) {
												foreach($postsPortf as $postPortf)
												{ 
													setup_postdata($postPortf); 	
													$allGallery[$postPortf->ID] = $postPortf->post_title;	
												}
											}		
											$value=$page_item->getElementsByTagName( "galleryitem" )->item(0)->nodeValue;											
											$id='pego-pb-element-gallery';
											dodaj_select(__("Gallery",'furniot'), $allGallery, $value, $id, __('Choose a gallery to be displayed.','furniot'));
											
											$id='pego-pb-element-gallery-width';
											$value=$page_item->getElementsByTagName( "width" )->item(0)->nodeValue;		
											$values = array("half", "third", "fourth");
											dodaj_select(__("Single item width",'furniot'), $values, $value, $id, __('Choose width of a single gallery item.','furniot'));
										
										}
										if ($tip == "Faq") {			
											dodaj_heading(__("Faq",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-faq-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));		

											$id='pego-pb-element-faq-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-faq-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));												
										}
										if ($tip == 'BGsectionStart') {											
											dodaj_heading(__("Background sections",'furniot'));
						
												
											$argsSec = array('post_type'=> 'backgroundsection', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
											$postsSecs = get_posts($argsSec);	
											$allSections= array();
											if($postsSecs) {
												foreach($postsSecs as $postsSec)
												{ 
													setup_postdata($postsSec); 	
													$allSections[$postsSec->ID] = $postsSec->post_title;	
												}
											}						
											$id='pego-pb-element-bgsectionstart';
											$value=$page_item->getElementsByTagName( "sectiontitle" )->item(0)->nodeValue;	
											dodaj_select(__("Bg section",'furniot'), $allSections, $value, $id, __('Choose section start.','furniot'));
										}
										if ($tip == 'BGsectionEnd') {											
											dodaj_heading(__("Background sections end",'furniot'));						
										}
										if ($tip == "ColLeftIcon") {
											dodaj_heading(__("Column with left icon",'furniot'));		
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon1-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
															
											$title_value=$page_item->getElementsByTagName( "url" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon1-url[]';
											$text_type='text';
											dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Input an url where the column will link. [optional]','furniot'));	
											
											$id='pego-pb-element-columnwithicon1-icon';
											$value=$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
											$title=__('Icon','furniot');
											$values = array("128340", "128318", "59146");
											dodaj_select_icon(__("Icon",'furniot'), $values, $value, $id, __('Select an icon.','furniot'));
											
											$value=$page_item->getElementsByTagName( "color" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon1-color';
											dodaj_color_picker(__('Color','furniot'), $value, $id, __('Set icon color.','furniot'));	
											
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon1-content';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));								
																		
										}
										if ($tip == "ColTopIcon") {
											dodaj_heading(__("Column with top icon",'furniot'));		
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
															
											$title_value=$page_item->getElementsByTagName( "url" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-url[]';
											$text_type='text';
											dodaj_text(__('Url','furniot'), $title_value, $id, $text_type, __('Input an url where the column will link. [optional]','furniot'));	
											
											$id='pego-pb-element-columnwithicon2-urltarget';
											$value=$page_item->getElementsByTagName( "urltarget" )->item(0)->nodeValue;
											$values = array("_self", "_blank");
											dodaj_select(__("Url target",'furniot'), $values, $value, $id, __('Choose url target.','furniot'));	
											
											$id='pego-pb-element-columnwithicon2-icon';
											$value=$page_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
											$title=__('Icon','furniot');
											$values = array("128340", "128318", "59146");
											dodaj_select_icon(__("Icon",'furniot'), $values, $value, $id, __('Select an icon.','furniot'));
											
											$value=$page_item->getElementsByTagName( "iconcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-color-icon';
											dodaj_color_picker(__('Icon color','furniot'), $value, $id, __('Set icon color.','furniot'));	
											
											$value=$page_item->getElementsByTagName( "iconcolorhover" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-color-iconhover';
											dodaj_color_picker(__('Icon hover color','furniot'), $value, $id, __('Set icon hover color.','furniot'));	
											
											$value=$page_item->getElementsByTagName( "color" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-color';
											dodaj_color_picker(__('Icon background color','furniot'), $value, $id, __('Set icon background color.','furniot'));	
											
											$value=$page_item->getElementsByTagName( "colorhover" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-colorhover';
											dodaj_color_picker(__('Icon hover background color','furniot'), $value, $id, __('Set icon hover background color.','furniot'));	
											
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-columnwithicon2-content';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));								
																		
										}
										if ($tip == "Testimonial2") {
											dodaj_heading(__("Clients say..",'furniot'));	
							
											$id='pego-pb-element-clientssay-image';
											$value=$page_item->getElementsByTagName( "image" )->item(0)->nodeValue;
											$title=__('Image','furniot');
											dodaj_upload($title, $id, $value, 'Upload image. Size is 70px X 70px.');
											
											$content_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-clientssay-content';
											$text_type='textarea';	
											dodaj_text(__('Content','furniot'), $content_value, $id, $text_type, __('Click in the textarea and write content.','furniot'));			
											
																									
											$title_value=$page_item->getElementsByTagName( "author" )->item(0)->nodeValue;
											$id='pego-pb-element-clientssay-author[]';
											$text_type='text';
											dodaj_text(__('Author','furniot'), $title_value, $id, $text_type, __('Click in the input and write an author. [optional]','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "company" )->item(0)->nodeValue;
											$id='pego-pb-element-clientssay-company[]';
											$text_type='text';
											dodaj_text(__('Authors company','furniot'), $title_value, $id, $text_type, __('Click in the input and write authors company. [optional]','furniot'));
									
											$title_value=$page_item->getElementsByTagName( "companyurl" )->item(0)->nodeValue;
											$id='pego-pb-element-clientssay-companyurl[]';
											$text_type='text';
											dodaj_text(__('Authors company URL','furniot'), $title_value, $id, $text_type, __('Click in the input and write authors company URL. [optional]','furniot'));
										}										
										if ($tip == "BigSplashText") {										
											dodaj_heading(__("Big Splash Text",'furniot'));		

											$title_value = $page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-bigsplashtext-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Input title for big splash.','furniot'));							
														
											$value = $page_item->getElementsByTagName( "titlefontcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-bigsplashtext-titlefontcolor';
											dodaj_color_picker(__('Font color for title','furniot'), $value, $id, __('Set color for title.','furniot'));	
											
											$title_value = $page_item->getElementsByTagName( "titlefontsize" )->item(0)->nodeValue;
											$id='pego-pb-element-bigsplashtext-titlefontsize[]';
											$text_type='text';
											dodaj_text(__('Title font size','furniot'), $title_value, $id, $text_type, __('Input font size for the title.','furniot'));	
											
											$id='pego-pb-element-bigsplashtext-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));
											
											$id='pego-pb-element-bigsplashtext-background';
											$value = $page_item->getElementsByTagName( "background" )->item(0)->nodeValue;
											$title=__('Background image','furniot');
											dodaj_upload($title, $id, $value, 'Upload an image for big splash background.');
											
											$value = $page_item->getElementsByTagName( "backgroundtype" )->item(0)->nodeValue;
											$id='pego-pb-element-bigsplashtext-background-type';
											$values = array("Static", "Parallax");
											dodaj_select(__("Background type",'furniot'), $values, $value, $id, __('Select type for the background image','furniot'));
											
											$id='pego-pb-element-bigsplashtext-backgroundtext';
											$value = $page_item->getElementsByTagName( "backgroundtext" )->item(0)->nodeValue;
											$title=__('Background image behind text','furniot');
											dodaj_upload($title, $id, $value, 'Upload an image for big splash behind text background. Image will be put on repeat.');
											
											$title_value = $page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue;
											$id='pego-pb-element-bigsplashtext-margintop[]';
											$text_type='text';
											dodaj_text(__('BigSplashText margin top','furniot'), $title_value, $id, $text_type, __('Input margin top for big splash.','furniot'));	
											
											$title_value = $page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue;
											$id='pego-pb-element-bigsplashtext-marginbottom[]';
											$text_type='text';
											dodaj_text(__('BigSplashText margin bottom','furniot'), $title_value, $id, $text_type, __('Input margin bottom for big splash.','furniot'));	
										}								
										
										if ($tip == 'ImageSlide') {			
											dodaj_heading(__("Image slide",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-imageslide-title[]';  
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-imageslide-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-imageslide-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));
																					
											$id='pego-pb-element-imageslide-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$imageslide_items=$page_item->getElementsByTagName( "imageslide_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_imageslide($title, $id, $value, $currentItems, $stevilo_imageslide_itemov, $imageslide_items);
											$stevilo_imageslide_itemov = $stevilo_imageslide_itemov + $value;  //just a test
										}										
										if ($tip == 'Welcome3') {			
											dodaj_heading(__("Welcome #3",'furniot'));							
													
											$title_value = $page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Input title.','furniot'));							
														
											$value= $page_item->getElementsByTagName( "titlefontcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-titlefontcolor';
											dodaj_color_picker(__('Font color for title','furniot'), $value, $id, __('Set color for title.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "titlefontsize" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-titlefontsize[]';
											$text_type='text';
											dodaj_text(__('Title font size','furniot'), $title_value, $id, $text_type, __('Input font size for the title.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-content';
											$text_type='textarea';
											dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input content.','furniot'));							
														
											$value=$page_item->getElementsByTagName( "contentfontcolor" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-contentfontcolor';
											dodaj_color_picker(__('Font color for content','furniot'), $value, $id, __('Set color for content.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "contentfontsize" )->item(0)->nodeValue;;
											$id='pego-pb-element-welcome3-contentfontsize[]';
											$text_type='text';
											dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input font size for the content.','furniot'));	
												
											$id='pego-pb-element-welcome3-background';
											$value=$page_item->getElementsByTagName( "background" )->item(0)->nodeValue;
											dodaj_color_picker(__('Color for background','furniot'), $value, $id, __('Set color for background.','furniot'));	
											
											$id='pego-pb-element-welcome3-bordercolor';
											$value=$page_item->getElementsByTagName( "bordercolor" )->item(0)->nodeValue;
											dodaj_color_picker(__('Border color','furniot'), $value, $id, __('Set color for border.','furniot'));	

											$title_value=$page_item->getElementsByTagName( "buttoncaption" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-buttoncaption[]';
											$text_type='text';
											dodaj_text(__('Button caption','furniot'), $title_value, $id, $text_type, __('Input button caption.','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "buttonurl" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-buttonurl[]';
											$text_type='text';
											dodaj_text(__('Button url','furniot'), $title_value, $id, $text_type, __('Input button url.','furniot'));

											$id='pego-pb-element-welcome3-buttontarget';
											$value=$page_item->getElementsByTagName( "buttontarget" )->item(0)->nodeValue;
											$values = array("_self", "_blank");
											dodaj_select(__("Button target",'furniot'), $values, $value, $id, __('Choose button target.','furniot'));												
											
											$title_value=$page_item->getElementsByTagName( "margintop" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-margintop[]';
											$text_type='text';
											dodaj_text(__('Welcome #3 margin top','furniot'), $title_value, $id, $text_type, __('Input margin top. [optional]','furniot'));	

											$title_value=$page_item->getElementsByTagName( "marginbottom" )->item(0)->nodeValue;
											$id='pego-pb-element-welcome3-marginbottom[]';
											$text_type='text';
											dodaj_text(__('Welcome #3 margin bottom','furniot'), $title_value, $id, $text_type, __('Input margin bottom. [optional]','furniot'));		
										}
										if ($tip == "History") {										
											dodaj_heading(__("History",'furniot'));
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-history-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title. [optional]','furniot'));
											
											$id='pego-pb-element-history-title-heading';
											$values = array("h1", "h2", "h3", "h4", "h5");
											$value=$page_item->getElementsByTagName( "heading" )->item(0)->nodeValue;
											dodaj_select(__("Title heading",'furniot'), $values, $value, $id, __('Choose type of title heading.','furniot'));		
											
											$id='pego-pb-element-history-title-align';
											$values = array("left", "center", "right");
											$value=$page_item->getElementsByTagName( "align" )->item(0)->nodeValue;
											dodaj_select(__("Title alignment",'furniot'), $values, $value, $id, __('Choose type of title alignment.','furniot'));	
									
											$id='pego-pb-element-history-num';
											$value=$page_item->getElementsByTagName( "stevilo" )->item(0)->nodeValue;
											$history_items=$page_item->getElementsByTagName( "history_parent" );
											$title=__('Items','furniot');
											$currentItems='';											
											dodaj_dinamicni_history($title, $id, $value, $currentItems, $stevilo_history_itemov, $history_items);	
											$stevilo_history_itemov = $stevilo_history_itemov + $value;  //just a test											
										}
										if ($tip == "CircleBar") {
										
											dodaj_heading(__("Circle bar",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-circleprogressbar-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
											
											$title_value=$page_item->getElementsByTagName( "percent" )->item(0)->nodeValue;
											$id='pego-pb-element-circleprogressbar-percent[]';
											$text_type='text';
											dodaj_text(__('Percent','furniot'), $title_value, $id, $text_type, __('Click in the input and write percent number.','furniot'));			


											$title_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-circleprogressbar-content';
											$text_type='textarea';
											dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input content [optional].','furniot'));												
																									
										}	
										if ($tip == "ExtraHeading") {
										
											dodaj_heading(__("Extra heading",'furniot'));	
											$title_value=$page_item->getElementsByTagName( "title" )->item(0)->nodeValue;
											$id='pego-pb-element-extraheading-title[]';
											$text_type='text';
											dodaj_text(__('Title','furniot'), $title_value, $id, $text_type, __('Click in the input and write a title.','furniot'));
																		
											$title_value=$page_item->getElementsByTagName( "content" )->item(0)->nodeValue;
											$id='pego-pb-element-extraheading-content';
											$text_type='textarea';
											dodaj_text(__('Content','furniot'), $title_value, $id, $text_type, __('Input content [optional].','furniot'));	
											
											$title_value=$page_item->getElementsByTagName( "titlesize" )->item(0)->nodeValue;
											$id='pego-pb-element-extraheading-titlesize[]';
											$text_type='text';
											dodaj_text(__('Title font size','furniot'), $title_value, $id, $text_type, __('Input title size. Input only number, without px.','furniot'));
																		
											$title_value=$page_item->getElementsByTagName( "contentsize" )->item(0)->nodeValue;
											$id='pego-pb-element-extraheading-contentsize[]';
											$text_type='text';
											dodaj_text(__('Content font size','furniot'), $title_value, $id, $text_type, __('Input content size. Input only number, without px.','furniot'));												
																									
										}
									?>									
									</div>
								</div>								
								<?php
								
							}									
						}						
					?>
					
					</div>
					<br class="clear">
				</div>
			</div>
			
		<?php
		
	}	
	
	

	function izrisi_dosedanje_brez_name($velikost, $tip){
	
		$velikost_za_prikaz=get_niz_to_show($velikost);			
		?>			
				<div class="pego-pb-single-element <?php echo $velikost; ?>" id="pego-pb-single-element"  rel="<?php echo $tip; ?>">
					<div class="pego-pb-element-frontend" id="pego-pb-element-frontend" > 
										<div class="celotni-box">
											<div class="procenti-box">
												<div class="pego-pb-component-procent"><?php echo $velikost_za_prikaz; ?></div>	
											</div>
											<div class="arrows-box">
												<div class="pego-pb-decrease-element-size <?php echo $tip; ?>Type"></div>
												<div class="pego-pb-increase-element-size <?php echo $tip; ?>Type"></div>
											</div>
											<div class="name-box">
												<div class="pego-pb-component-name"><?php echo $tip; ?></div>
											</div>
											<div class="delete-box">
												<a title="Delete"><div class="pego-pb-delete-element" id="pego-pb-delete-element"></div></a>	
											</div>
											<div class="edit1-box">
												<a title="Edit"><div rel="pego-pb-inside-element-box" id="pego-pb-inside-an-element" class="pego-pb-element-edit"></div></a>
											</div>											
										</div>
										<div class="clear"></div>
										<input type="hidden" id="pego-pb-element-type" value="<?php echo $tip; ?>" name="">
										<input type="hidden" id="pego-pb-element-size" class="pego-pb-element-size" value="<?php echo $velikost; ?>" name="">
									</div>	
				
				
				
		<?php
	
	}
	
	function dodaj_description($desc) {
		if ($desc != '') {
		?>	
			<div class="pego-pb-element-single-item w300">					
				<p class="pego-pb-element-description-p"><?php echo $desc; ?></p>
				<div class="clear"></div>
			</div>
		<?php
		}
	}
	
	function dodaj_text($title, $value, $id, $text_type, $description){
	
		if($text_type=='text')
		{
		?>
		
			<div class="pego-pb-element-single-item w300">	
			
				<h1><?php echo $title; ?></h1>
				<div class="pego-pb-element-single-item-input">
					<input type="text" name="<?php echo $id; ?>" id="<?php echo $id; ?>" value="<?php echo $value; ?>" />
				</div>	
				<div class="clear"></div>
			</div>
			<?php dodaj_description($description); ?>
			<div class="clear"></div>			
		<?php
		}
		else {
		?>
			<div class="pego-pb-element-single-item w300">
				<h1><?php echo $title; ?></h1>
				<div class="pego-pb-element-single-item-input">
					<textarea  name="<?php echo $id; ?>[]"  class="<?php echo $id; ?>" id="<?php echo $id; ?>[]" ><?php echo $value; ?></textarea>
				</div>
				<div class="clear"></div>
			</div>
			<?php dodaj_description($description); ?>
			<div class="clear"></div>
			<?php
		}
		
	}
	
	function dodaj_heading($title){
		?>		
			<div class="pego-pb-element-single-item w300title">			
				<h1><?php echo $title; ?></h1>
				<div class="clear"></div>
			</div>			
		<?php
		}
	

	
	function dodaj_select($title, $values, $value, $id, $description){
	?>		
		<div class="pego-pb-element-single-item w300">
			<h1><?php echo $title; ?></h1>
			<div class="pego-pb-element-single-item-input">
				<select name="<?php echo $id; ?>[]" id="<?php echo $id; ?>[]" >
				<?php
				foreach ($values as $single_value)
				{
					if ($single_value == $value) {
						echo '<option selected>'.$single_value.'</option>';
					}
					else {
						echo '<option>'.$single_value.'</option>';
					}
				}
				?>
				</select>
			</div>
			<div class="clear"></div>
		</div>
		<?php dodaj_description($description); ?>
		<div class="clear"></div>			
	<?php		
	}
	
	
	function dodaj_color_picker($title, $value, $id, $description){
		$stil='';
		if ($value != '') {
			$stil= ' style= "background-color:#'.$value.'"; ';
		}
	?>
		
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-element-single-item-input">
			<input class="colorSelector colorSelectorInput"  name="<?php echo $id; ?>[]" id="<?php echo $id; ?>[]" type="text" value="<?php echo $value; ?>" />
			<div class="colorSelector1" <?php echo $stil; ?>></div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description($description); ?>
	<div class="clear"></div>		
	<?php		
	}
	

	function dodaj_js_for_colorpicker ($id, $value) {
	?>
	<script type="text/javascript" language="javascript">
	jQuery(document).ready(function(){
	 jQuery('#<?php echo $id; ?>_picker').children('div').css('backgroundColor', '<?php echo $value; ?>');    
				 jQuery('#<?php echo $id; ?>_picker').ColorPicker({
					color: '<?php echo $value; ?>',
					onShow: function (colpkr) {
						jQuery(colpkr).fadeIn(500);
						return false;
					},
					onHide: function (colpkr) {
						jQuery(colpkr).fadeOut(500);
						return false;
					},
					onChange: function (hsb, hex, rgb) {
						//alert("Spreminjam barvo!");
						jQuery('#<?php echo $id; ?>_picker').children('div').css('backgroundColor', '#'+ hex);
						jQuery('#<?php echo $id; ?>_picker').next('input').attr('value','#'+ hex);
						
					}
				  });
	});
	</script>	
	<?php
	}	
	
	function dodaj_dinamicni_list($title, $id, $value, $currentItems, $stevilo_list_itemov, $list_items){	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-list-item"><?php _e('Add list item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-list-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-list-elements">
				<ul>				
					<li id="pego-pb-list-element" class="pego-pb-item-for-cloning">	
						<?php _e('List item:','furniot'); ?> <input name="pego-pb-element-list-item[]"  class="pego-pb-element-list-item" id="pego-pb-element-list-item[]" />
						<?php _e('List url:','furniot'); ?> <input name="pego-pb-element-list-item-url[]"  class="pego-pb-element-list-item-url" id="pego-pb-element-list-item-url[]" />	
						<div class="clear"></div>
						<div class="pego-pb-remove-list-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($list_items != null) {
				foreach( $list_items as $list_item){
				?>
					<li id="pego-pb-list-element">	
						<?php _e('List item:','furniot'); ?> <input name="pego-pb-element-list-item[]"  class="pego-pb-element-list-item" id="pego-pb-element-list-item[]" value="<?php echo $list_item->getElementsByTagName( "list_item" )->item(0)->nodeValue; ?>" />
						<?php _e('List url:','furniot'); ?> <input name="pego-pb-element-list-item-url[]"  class="pego-pb-element-list-item-url" id="pego-pb-element-list-item-url[]" value="<?php echo $list_item->getElementsByTagName( "list_url" )->item(0)->nodeValue; ?>" />
						<div class="clear"></div>						
						<div class="pego-pb-remove-list-item"><?php _e('Remove item','furniot'); ?></div>  
					</li>
				<?php					
				}	
				}
				?>
				</ul><div class="clear"></div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add/Remove list items. For each you may insert the item and an optional url.','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	
								
	
	
	
	function dodaj_dinamicni_portfolio_select($title, $id, $values, $selected_item, $num, $stevilo_portfolio_itemov, $portfolio_items){	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-portfolio-item"><?php _e('Add portfolio item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-portfolio-items" name='<?php echo $id; ?>[]' value="<?php echo $num; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-portfolio-elements">
				<ul>	
					<li id="pego-pb-portfolio-element"  class="pego-pb-item-for-cloning">
						<select name="pego-pb-element-portfolio-items-item[]"  class="pego-pb-element-portfolio-items-item" id="pego-pb-element-portfolio-items-item[]">
						<?php
						foreach ($values as $single_value)
						{
							if ($single_value == $selected_item) {
								echo '<option selected>'.$single_value.'</option>';
							}
							else {
								echo '<option>'.$single_value.'</option>';
							}
						}
						?>
						</select>	
						<div class="pego-pb-remove-portfolio-item"><?php _e('Remove item','furniot'); ?></div>						
					</li>	
					<?php
						if ($portfolio_items != null) {
							foreach( $portfolio_items as $portfolio_item){
							?>
								<li id="pego-pb-portfolio-element" >
									<select name="pego-pb-element-portfolio-items-item[]"  class="pego-pb-element-portfolio-items-item" id="pego-pb-element-portfolio-items-item[]">
										<?php
										
										foreach ($values as $single_value)
										{
											$currItem = $portfolio_item->getElementsByTagName( "portfolio_item" )->item(0)->nodeValue;
											if ($single_value == $currItem ) {
												echo '<option selected>'.$single_value.'</option>';
											}
											else {
												echo '<option>'.$single_value.'</option>';
											}
										}
										?>
									</select>	
									<div class="pego-pb-remove-portfolio-item"><?php _e('Remove item','furniot'); ?></div>
								</li>
							<?php					
							}
						}						
						?>						
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add items which will be shown. This option will be read only if ordering is set to Random.','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	
	function dodaj_dinamicni_post_select($title, $id, $values, $selected_item, $num, $stevilo_post_itemov, $post_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-posts-item"><?php _e('Add post item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-posts-items" name='<?php echo $id; ?>[]' value="<?php echo $num; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-posts-elements">
				<ul>	
					<li id="pego-pb-posts-element"  class="pego-pb-item-for-cloning">
						<select name="pego-pb-element-posts-items-item[]"  class="pego-pb-element-posts-items-item" id="pego-pb-element-posts-items-item[]">
						<?php
						foreach ($values as $single_value)
						{
							if ($single_value == $selected_item) {
								echo '<option selected>'.$single_value.'</option>';
							}
							else {
								echo '<option>'.$single_value.'</option>';
							}
						}
						?>
						</select>	
						<div class="pego-pb-remove-posts-item"><?php _e('Remove item','furniot'); ?></div>						
					</li>	
					<?php
						if ($post_items != null) {
							foreach( $post_items as $post_item){
							?>
								<li id="pego-pb-posts-element" >
									<select name="pego-pb-element-posts-items-item[]"  class="pego-pb-element-posts-items-item" id="pego-pb-element-posts-items-item[]">
										<?php
										
										foreach ($values as $single_value)
										{
											$currItem = $post_item->getElementsByTagName( "post_item" )->item(0)->nodeValue;
											if ($single_value == $currItem ) {
												echo '<option selected>'.$single_value.'</option>';
											}
											else {
												echo '<option>'.$single_value.'</option>';
											}
										}
										?>
									</select>	
									<div class="pego-pb-remove-posts-item"><?php _e('Remove item','furniot'); ?></div>
								</li>
							<?php					
							}	
						}
						?>						
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add items which will be shown. This option will be read only if ordering is set to Random.','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	
	function dodaj_dinamicni_carousel($title, $id, $value, $currentItems, $stevilo_list_itemov, $carousel_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-carousel-item"><?php _e('Add carousel item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-carousel-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-carousel-elements">
				<ul>				
					<li id="pego-pb-carousel-element"  class="pego-pb-item-for-cloning">	
						<?php _e('Carousel image:','furniot'); ?> <input name="pego-pb-element-carousel-image[]"  class="pego-pb-element-carousel-image" id="pego-pb-element-carousel-image[]" />
						<?php _e('Carousel url:','furniot'); ?> <input name="pego-pb-element-carousel-url[]"  class="pego-pb-element-carousel-url" id="pego-pb-element-carousel-url[]" />	
						<div class="pego-pb-remove-carousel-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($carousel_items != null) {
					foreach( $carousel_items as $carousel_item){
					?>
						<li id="pego-pb-carousel-element" >	
							<?php _e('Carousel image:','furniot'); ?> <input name="pego-pb-element-carousel-image[]"  class="pego-pb-element-carousel-image" id="pego-pb-element-carousel-image[]" value="<?php echo $carousel_item->getElementsByTagName( "carousel_image" )->item(0)->nodeValue; ?>" />
							<?php _e('Carousel url:','furniot'); ?> <input name="pego-pb-element-carousel-url[]"  class="pego-pb-element-carousel-url" id="pego-pb-element-carousel-url[]" value="<?php echo $carousel_item->getElementsByTagName( "carousel_url" )->item(0)->nodeValue; ?>" />					
							<div class="pego-pb-remove-carousel-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add carousel items. For each you have to add an image and an optional url.','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	function dodaj_dinamicni_toggle($title, $id, $value, $currentItems, $stevilo_toggle_itemov, $toggle_items){
	$valuesToggleStatus = array("opened", "closed");
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-toggle-item"><?php _e('Add toggle item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-toggle-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-toggle-elements">
				<ul>				
					<li id="pego-pb-toggle-element" class="pego-pb-item-for-cloning">	
						<?php _e('Single Toggle title:','furniot'); ?> <input name="pego-pb-element-toggle-title[]"  class="pego-pb-element-toggle-title" id="pego-pb-element-toggle-title[]" />
						<?php _e('Single Toggle content:','furniot'); ?> <textarea name="pego-pb-element-toggle-content[]"  class="pego-pb-element-toggle-content" id="pego-pb-element-toggle-content[]" ></textarea>							
						<div class="clear"></div>
						<div class="pego-pb-remove-toggle-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
					if ($toggle_items != null) {
						foreach( $toggle_items as $toggle_item){
						?>
							<li id="pego-pb-toggle-element">	
								<?php _e('Single Toggle title:','furniot'); ?> <input name="pego-pb-element-toggle-title[]"  class="pego-pb-element-toggle-title" id="pego-pb-element-toggle-title[]" value="<?php echo $toggle_item->getElementsByTagName( "toggle_title" )->item(0)->nodeValue; ?>" />
								<?php _e('Single Toggle content:','furniot'); ?> <textarea name="pego-pb-element-toggle-content[]"  class="pego-pb-element-toggle-content" id="pego-pb-element-toggle-content[]" ><?php echo $toggle_item->getElementsByTagName( "toggle_content" )->item(0)->nodeValue; ?></textarea>					
								<div class="clear"></div>
								<div class="pego-pb-remove-toggle-item"><?php _e('Remove item','furniot'); ?></div>  
							</li>
						<?php					
						}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add toggle items. For each add a title and content.','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	
	function dodaj_dinamicni_contactinfo($title, $id, $value, $currentItems, $stevilo_contactinfo_itemov, $contactinfo_items){
	$values = pego_get_all_icons();	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-contactinfo-item"><?php _e('Add contact info item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-contactinfo-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-contactinfo-elements">
				<ul>				
					<li id="pego-pb-contactinfo-element" class="pego-pb-item-for-cloning">	
						<?php _e('Icon:','furniot'); ?> 
						<select name="pego-pb-element-contactinfo-item-icon[]"  class="pego-pb-element-contactinfo-item-icon" id="pego-pb-element-contactinfo-item-icon[]" >
						<?php
							foreach ($values as $single_value)
							{
								echo '<option value="'.$single_value.'">'.$single_value.'</option>';
							}		
							?>
						</select>						
						<?php _e('Description:','furniot'); ?> <textarea name="pego-pb-element-contactinfo-item-desc[]"  class="pego-pb-element-contactinfo-item-desc" id="pego-pb-element-contactinfo-item-desc[]" ></textarea>					
						<div class="clear"></div>
						<div class="pego-pb-remove-contactinfo-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($contactinfo_items != null) {
					foreach( $contactinfo_items as $contactinfo_item){
					?>
						<li id="pego-pb-contactinfo-element">	
							<?php _e('Icon:','furniot'); ?> 
							<select name="pego-pb-element-contactinfo-item-icon[]"  class="pego-pb-element-contactinfo-item-icon" id="pego-pb-element-contactinfo-item-icon[]" >
							<?php
								$currentSocial=$contactinfo_item->getElementsByTagName( "icon" )->item(0)->nodeValue;
								foreach ($values as $single_value)
								{
									if( $single_value == $currentSocial) {
										echo '<option value="'.$single_value.'" selected>'.$single_value.'</option>';
									}
									else {
										echo '<option value="'.$single_value.'">'.$single_value.'</option>';
									}
								}		
								?>
							</select>	
							<?php _e('Description:','furniot'); ?> <textarea name="pego-pb-element-contactinfo-item-desc[]"  class="pego-pb-element-contactinfo-item-desc" id="pego-pb-element-contactinfo-item-desc[]" ><?php echo $contactinfo_item->getElementsByTagName( "desc" )->item(0)->nodeValue; ?></textarea>							
							<div class="clear"></div>						
							<div class="pego-pb-remove-contactinfo-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul><div class="clear"></div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add/Remove contact info item that includes an icon and description.','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	
	
	function dodaj_dinamicni_tab($title, $id, $value, $currentItems, $stevilo_tab_itemov, $tab_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-tab-item"><?php _e('Add tab item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-tab-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-tab-elements">
				<ul>				
					<li id="pego-pb-tab-element" class="pego-pb-item-for-cloning">	
						<?php _e('Single Tab title:','furniot'); ?> <input name="pego-pb-element-tab-title[]"  class="pego-pb-element-tab-title" id="pego-pb-element-tab-title[]" />
						<?php _e('Single Tab content:','furniot'); ?> <textarea name="pego-pb-element-tab-content[]"  class="pego-pb-element-tab-content" id="pego-pb-element-tab-content[]" ></textarea>							
						<div class="clear"></div>
						<div class="pego-pb-remove-tab-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($tab_items != null) {
					foreach( $tab_items as $tab_item){
					?>
						<li id="pego-pb-tab-element" >	
							Single Tab title: <input name="pego-pb-element-tab-title[]"  class="pego-pb-element-tab-title" id="pego-pb-element-tab-title[]" value="<?php echo $tab_item->getElementsByTagName( "tab_title" )->item(0)->nodeValue; ?>" />
							Single Tab content: <textarea name="pego-pb-element-tab-content[]"  class="pego-pb-element-tab-content" id="pego-pb-element-tab-content[]" ><?php echo $tab_item->getElementsByTagName( "tab_content" )->item(0)->nodeValue; ?></textarea>						
							<div class="clear"></div>
							<div class="pego-pb-remove-tab-item">Remove item</div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add tab items. For each add a title and content.,','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	
	function dodaj_dinamicni_testimonials($title, $id, $value, $currentItems, $stevilo_testimonials_itemov, $testimonials_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-testimonials-item"><?php _e('Add testimonial item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-testimonials-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-testimonials-elements">
				<ul>				
					<li id="pego-pb-testimonials-element" class="pego-pb-item-for-cloning">	
						<?php _e('Author:','furniot'); ?> <input name="pego-pb-element-testimonials-title[]"  class="pego-pb-element-testimonials-title" id="pego-pb-element-testimonials-title[]" />
						<?php _e('Under author text:','furniot'); ?> <input name="pego-pb-element-testimonials-subtitle[]"  class="pego-pb-element-testimonials-subtitle" id="pego-pb-element-testimonials-subtitle[]" />
						<?php _e('Content:','furniot'); ?> <textarea name="pego-pb-element-testimonials-content[]"  class="pego-pb-element-testimonials-content" id="pego-pb-element-testimonials-content[]" ></textarea>							
						<div class="clear"></div>
						<div class="pego-pb-remove-testimonials-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($testimonials_items != null) {
					foreach( $testimonials_items as $testimonials_item){
					?>
						<li id="pego-pb-testimonials-element">	
							<?php _e('Author:','furniot'); ?> <input name="pego-pb-element-testimonials-title[]"  class="pego-pb-element-testimonials-title" id="pego-pb-element-testimonials-title[]" value="<?php echo $testimonials_item->getElementsByTagName( "testimonials_title" )->item(0)->nodeValue; ?>" />
							<?php _e('Under author text:','furniot'); ?> <input name="pego-pb-element-testimonials-subtitle[]"  class="pego-pb-element-testimonials-subtitle" id="pego-pb-element-testimonials-subtitle[]" value="<?php echo $testimonials_item->getElementsByTagName( "testimonials_subtitle" )->item(0)->nodeValue; ?>" />
							<?php _e('Content:','furniot'); ?> <textarea name="pego-pb-element-testimonials-content[]"  class="pego-pb-element-testimonials-content" id="pego-pb-element-testimonials-content[]" ><?php echo $testimonials_item->getElementsByTagName( "testimonials_content" )->item(0)->nodeValue; ?></textarea>						
							<div class="clear"></div>
							<div class="pego-pb-remove-testimonials-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add testimonial items. For each add author and testimonial content.','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	function dodaj_dinamicni_progressbar($title, $id, $value, $currentItems, $stevilo_progressbar_itemov, $progressbar_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-progressbar-item"><?php _e('Add progress bar item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-progressbar-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-progressbar-elements">
				<ul>				
					<li id="pego-pb-progressbar-element" class="pego-pb-item-for-cloning">	
						<?php _e('Single progress bar title:','furniot'); ?> <input name="pego-pb-element-progressbar-title[]"  class="pego-pb-element-progressbar-title" id="pego-pb-element-progressbar-title[]" />
						<?php _e('Single progress bar id:','furniot'); ?> <input name="pego-pb-element-progressbar-id[]"  class="pego-pb-element-progressbar-id" id="pego-pb-element-progressbar-id[]" />
						<?php _e('Single progress bar percent:','furniot'); ?> <input name="pego-pb-element-progressbar-percent[]"  class="pego-pb-element-progressbar-percent" id="pego-pb-element-progressbar-percent[]" />
						<div class="clear"></div>
						<div class="pego-pb-remove-progressbar-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($progressbar_items != null) {
					foreach( $progressbar_items as $progressbar_item){
					?>
						<li id="pego-pb-progressbar-element">	
							<?php _e('Single progress bar title:','furniot'); ?> <input name="pego-pb-element-progressbar-title[]"  class="pego-pb-element-progressbar-title" id="pego-pb-element-progressbar-title[]" value="<?php echo $progressbar_item->getElementsByTagName( "progressbar_title" )->item(0)->nodeValue; ?>" />
							<?php _e('Single progress bar id:','furniot'); ?> <input name="pego-pb-element-progressbar-id[]"  class="pego-pb-element-progressbar-id" id="pego-pb-element-progressbar-id[]" value="<?php echo $progressbar_item->getElementsByTagName( "progressbar_id" )->item(0)->nodeValue; ?>" />
							<?php _e('Single progress bar percent:','furniot'); ?> <input name="pego-pb-element-progressbar-percent[]"  class="pego-pb-element-progressbar-percent" id="pego-pb-element-progressbar-percent[]" value="<?php echo $progressbar_item->getElementsByTagName( "progressbar_percent" )->item(0)->nodeValue; ?>" />
							<div class="clear"></div>
							<div class="pego-pb-remove-progressbar-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add a progress bar. Each one needs to have a title, unique id and percent value(input number only).','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	
	function dodaj_dinamicni_flexslider($title, $id, $value, $currentItems, $stevilo_flexslider_itemov, $flexslider_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-flexslider-item"><?php _e('Add slide','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-flexslider-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-flexslider-elements">
				<ul>				
					<li id="pego-pb-flexslider-element" class="pego-pb-item-for-cloning">	
						<?php _e('Slide caption:','furniot'); ?> <input name="pego-pb-element-flexslider-caption[]"  class="pego-pb-element-flexslider-caption" id="pego-pb-element-flexslider-caption[]" />
						<?php _e('Slide url:','furniot'); ?> <input name="pego-pb-element-flexslider-url[]"  class="pego-pb-element-flexslider-url" id="pego-pb-element-flexslider-url[]" />
						<?php _e('Slide image:','furniot'); ?> <input name="pego-pb-element-flexslider-image[]"  class="pego-pb-element-flexslider-image" id="pego-pb-element-flexslider-image[]" />
						<div class="clear"></div>
						<div class="pego-pb-remove-flexslider-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($flexslider_items != null) {
					foreach( $flexslider_items as $flexslider_item){
					?>
						<li id="pego-pb-flexslider-element">	
							<?php _e('Slide caption:','furniot'); ?> <input name="pego-pb-element-flexslider-caption[]"  class="pego-pb-element-flexslider-caption" id="pego-pb-element-flexslider-caption[]" value="<?php echo $flexslider_item->getElementsByTagName( "flexslider_caption" )->item(0)->nodeValue; ?>" />
							<?php _e('Slide url:','furniot'); ?>  <input name="pego-pb-element-flexslider-url[]"  class="pego-pb-element-flexslider-url" id="pego-pb-element-flexslider-url[]" value="<?php echo $flexslider_item->getElementsByTagName( "flexslider_url" )->item(0)->nodeValue; ?>" />
							<?php _e('Single image:','furniot'); ?> <input name="pego-pb-element-flexslider-image[]"  class="pego-pb-element-flexslider-image" id="pego-pb-element-flexslider-image[]" value="<?php echo $flexslider_item->getElementsByTagName( "flexslider_image" )->item(0)->nodeValue; ?>" />
							<div class="clear"></div>
							<div class="pego-pb-remove-flexslider-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add a slide to the flexslider. Each slide must have an image, caption[optional] and url where it will link[optional].','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	function dodaj_dinamicni_socials($title, $id, $value, $currentItems, $stevilo_socials_itemov, $socials_items){
	$values = array("aim", "apple", "behance", "blogger", "cargo", "delicious", "deviantart", "digg", "dopplr", "dribbble", "ember", "evernote", "facebook", "flickr", "forrst", "github", "google", "googleplus", "gowalla", "grooveshark", "html5", "icloud", "lastfm", "linkedin", "mailto", "metacafe", "mixx", "myspace", "netvibes", "newsvine", "orkut", "paypal", "picasa", "pinterest", "plurk", "posterous", "reddit", "rss", "skype", "stumbleupon", "technorati", "tumblr", "twitter", "vimeo", "wordpress", "yahoo", "yelp", "youtube", "zerply", "zootool");
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-socials-item"><?php _e('Add social item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-socials-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-socials-elements">
				<ul>				
					<li id="pego-pb-socials-element"  class="pego-pb-item-for-cloning">	
						<?php _e('Socials item:','furniot'); ?> 
						<select name="pego-pb-element-socials-item[]"  class="pego-pb-element-socials-item" id="pego-pb-element-socials-item[]" >
						<?php
							foreach ($values as $single_value)
							{
								echo '<option>'.$single_value.'</option>';
							}		
							?>
						</select>
						<?php _e('Socials url:','furniot'); ?> <input name="pego-pb-element-socials-item-url[]"  class="pego-pb-element-socials-item-url" id="pego-pb-element-socials-item-url[]" />	
						<div class="pego-pb-remove-socials-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($socials_items != null) {
					foreach( $socials_items as $socials_item){
					?>
						<li id="pego-pb-socials-element" >	
							<?php _e('Socials item:','furniot'); ?> 
							<select name="pego-pb-element-socials-item[]"  class="pego-pb-element-socials-item" id="pego-pb-element-socials-item[]" >
							<?php
								$currentSocial=$socials_item->getElementsByTagName( "socials_item" )->item(0)->nodeValue;
								foreach ($values as $single_value)
								{
									if( $single_value == $currentSocial) {
										echo '<option selected>'.$single_value.'</option>';
									}
									else {
										echo '<option>'.$single_value.'</option>';
									}
								}		
								?>
							</select>						
							<?php _e('Socials url:','furniot'); ?> <input name="pego-pb-element-socials-item-url[]"  class="pego-pb-element-socials-item-url" id="pego-pb-element-socials-item-url[]" value="<?php echo $socials_item->getElementsByTagName( "socials_url" )->item(0)->nodeValue; ?>" />					
							<div class="pego-pb-remove-socials-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}
				}				
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add a social icon. For each choose the type and the url where it should link.','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	function dodaj_dinamicni_accordion($title, $id, $value, $currentItems, $stevilo_accordion_itemov, $accordion_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-accordion-item"><?php _e('Add accordion item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-accordion-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-accordion-elements">
				<ul>				
					<li id="pego-pb-accordion-element" class="pego-pb-item-for-cloning">	
						<?php _e('Single Accordion title:','furniot'); ?> <input name="pego-pb-element-accordion-title[]"  class="pego-pb-element-accordion-title" id="pego-pb-element-accordion-title[]" />
						<?php _e('Single Accordion content:','furniot'); ?> <textarea name="pego-pb-element-accordion-content[]"  class="pego-pb-element-accordion-content" id="pego-pb-element-accordion-content[]" ></textarea>						
						<div class="clear"></div>
						<div class="pego-pb-remove-accordion-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($accordion_items != null) {
					foreach( $accordion_items as $accordion_item){
					?>
						<li id="pego-pb-accordion-element">	
							<?php _e('Single Accordion title:','furniot'); ?> <input name="pego-pb-element-accordion-title[]"  class="pego-pb-element-accordion-title" id="pego-pb-element-accordion-title[]" value="<?php echo $accordion_item->getElementsByTagName( "accordion_title" )->item(0)->nodeValue; ?>" />
							<?php _e('Single Accordion content:','furniot'); ?> <textarea name="pego-pb-element-accordion-content[]"  class="pego-pb-element-accordion-content" id="pego-pb-element-accordion-content[]" ><?php echo $accordion_item->getElementsByTagName( "accordion_content" )->item(0)->nodeValue; ?></textarea>						
							<div class="clear"></div>
							<div class="pego-pb-remove-accordion-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add accordion item. Each one needs to have a title and content.','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}		
	
	
	function dodaj_dinamicni_teammember($title, $id, $value, $currentItems, $stevilo_teammember_itemov, $teammember_items){
	$iconvalues=pego_get_all_icons();
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-teammember-item"><?php _e('Add social item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-teammember-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-teammember-elements">
				<ul>				
					<li id="pego-pb-teammember-element"  class="pego-pb-item-for-cloning">	
						<?php _e('Socials item:','furniot'); ?> 
						<select name="pego-pb-element-teammember-socials-item[]"  class="pego-pb-element-teammember-socials-item" id="pego-pb-element-teammember-socials-item[]" >
						<?php
						foreach ($iconvalues as $single_value)
						{						
								echo '<option value="'.$single_value.'">'.$single_value.'</option>';						
						}
						?>
						</select>
						<?php _e('Socials url:','furniot'); ?> <input name="pego-pb-element-teammember-socials-item-url[]"  class="pego-pb-element-teammember-socials-item-url" id="pego-pb-element-teammember-socials-item-url[]" />	
						<?php _e('Socials tooltip text:','furniot'); ?> <input name="pego-pb-element-teammember-socials-item-title[]"  class="pego-pb-element-teammember-socials-item-title" id="pego-pb-element-teammember-socials-item-title[]" />	
						<div class="pego-pb-remove-teammember-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($teammember_items != null) {
					foreach( $teammember_items as $teammember_item){
					?>
						<li id="pego-pb-teammember-element" >													
							<?php _e('Icon:','furniot'); ?>
						
						<select name="pego-pb-element-teammember-socials-item[]"  class="pego-pb-element-teammember-socials-item" id="pego-pb-element-teammember-socials-item[]" >
						<?php
						$iconvalue =  $teammember_item->getElementsByTagName( "teammember_item" )->item(0)->nodeValue;
						foreach ($iconvalues as $single_value)
						{						
							if ($single_value == $iconvalue) {
								echo '<option value="'.$single_value.'" selected>'.$single_value.'</option>';
							}
							else {
								echo '<option value="'.$single_value.'">'.$single_value.'</option>';
							}					
						}
						?>
						</select>

							
							<?php _e('Socials url:','furniot'); ?> <input name="pego-pb-element-teammember-socials-item-url[]"  class="pego-pb-element-teammember-socials-item-url" id="pego-pb-element-teammember-socials-item-url[]" value="<?php echo $teammember_item->getElementsByTagName( "teammember_url" )->item(0)->nodeValue; ?>" />					
							<?php _e('Socials tooltip text:','furniot'); ?> <input name="pego-pb-element-teammember-socials-item-title[]"  class="pego-pb-element-teammember-socials-item-title" id="pego-pb-element-teammember-socials-item-title[]" value="<?php echo $teammember_item->getElementsByTagName( "teammember_title" )->item(0)->nodeValue; ?>" />					
							<div class="pego-pb-remove-teammember-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add social icons to a teammember. Choose social type and url where it must link.','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}		
	
	function dodaj_dinamicni_pricing($title, $id, $value, $currentItems, $stevilo_pricing_itemov, $pricing_items){	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-pricing-item"><?php _e('Add pricing item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-pricing-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-pricing-elements">
				<ul>				
					<li id="pego-pb-pricing-element" class="pego-pb-item-for-cloning">	
						<?php _e('Pricing item:','furniot'); ?> <input name="pego-pb-element-pricing-item[]"  class="pego-pb-element-pricing-item" id="pego-pb-element-pricing-item[]" />						
						<div class="clear"></div>
						<div class="pego-pb-remove-pricing-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($pricing_items != null) {
					foreach( $pricing_items as $pricing_item){
					?>
						<li id="pego-pb-pricing-element">	
							<?php _e('Pricing item:','furniot'); ?> <input name="pego-pb-element-pricing-item[]"  class="pego-pb-element-pricing-item" id="pego-pb-element-pricing-item[]" value="<?php echo $pricing_item->getElementsByTagName( "pricing_item" )->item(0)->nodeValue; ?>" />						
							<div class="clear"></div>						
							<div class="pego-pb-remove-pricing-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}
				}					
				?>
				</ul><div class="clear"></div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add/Remove pricing items that present a row in the pricing column. ','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}
	
	
	function dodaj_dinamicni_coltable($title, $id, $value, $currentItems, $stevilo_coltable_itemov, $coltable_items){	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-coltable-item"><?php _e('Add coltable item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-coltable-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-coltable-elements">
				<ul>				
					<li id="pego-pb-coltable-element" class="pego-pb-item-for-cloning">	
						<?php _e('Left side:','furniot'); ?> <input name="pego-pb-element-coltable-leftside[]"  class="pego-pb-element-coltable-leftside" id="pego-pb-element-coltable-leftside[]" />
						<?php _e('Right side:','furniot'); ?> <input name="pego-pb-element-coltable-rightside[]"  class="pego-pb-element-coltable-rightside" id="pego-pb-element-coltable-rightside[]" />	
						<div class="clear"></div>
						<div class="pego-pb-remove-coltable-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($coltable_items != null) {
					foreach( $coltable_items as $coltable_item){
					?>
						<li id="pego-pb-coltable-element">	
							<?php _e('Left side:','furniot'); ?> <input name="pego-pb-element-coltable-leftside[]"  class="pego-pb-element-coltable-leftside" id="pego-pb-element-coltable-leftside[]" value="<?php echo $coltable_item->getElementsByTagName( "coltable_left" )->item(0)->nodeValue; ?>" />
							<?php _e('Right side:','furniot'); ?> <input name="pego-pb-element-coltable-rightside[]"  class="pego-pb-element-coltable-rightside" id="pego-pb-element-coltable-rightside[]" value="<?php echo $coltable_item->getElementsByTagName( "coltable_right" )->item(0)->nodeValue; ?>" />
							<div class="clear"></div>						
							<div class="pego-pb-remove-coltable-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul><div class="clear"></div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add/Remove rows for the table.For each you must insert eh right and the left content.','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	
	function dodaj_dinamicni_quoterotator($title, $id, $value, $currentItems, $stevilo_quoterotator_itemov, $quoterotator_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-quoterotator-item"><?php _e('Add testimonial item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-quoterotator-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-quoterotator-elements">
				<ul>				
					<li id="pego-pb-quoterotator-element" class="pego-pb-item-for-cloning">	
						<?php _e('Author:','furniot'); ?> <input name="pego-pb-element-quoterotator-author[]"  class="pego-pb-element-quoterotator-author" id="pego-pb-element-quoterotator-author[]" />
						<?php _e('Image url [optional]:','furniot'); ?> <input name="pego-pb-element-quoterotator-image[]"  class="pego-pb-element-quoterotator-image" id="pego-pb-element-quoterotator-image[]" />
						<?php _e('Content:','furniot'); ?> <textarea name="pego-pb-element-quoterotator-content[]"  class="pego-pb-element-quoterotator-content" id="pego-pb-element-quoterotator-content[]" ></textarea>							
						<div class="clear"></div>
						<div class="pego-pb-remove-quoterotator-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($quoterotator_items != null) {
					foreach( $quoterotator_items as $quoterotator_item){
					?>
						<li id="pego-pb-quoterotator-element">	
							<?php _e('Author:','furniot'); ?> <input name="pego-pb-element-quoterotator-author[]"  class="pego-pb-element-quoterotator-author" id="pego-pb-element-quoterotator-author[]" value="<?php echo $quoterotator_item->getElementsByTagName( "quoterotator_author" )->item(0)->nodeValue; ?>" />
							<?php _e('Under author text:','furniot'); ?> <input name="pego-pb-element-quoterotator-image[]"  class="pego-pb-element-quoterotator-image" id="pego-pb-element-quoterotator-image[]" value="<?php echo $quoterotator_item->getElementsByTagName( "quoterotator_image" )->item(0)->nodeValue; ?>" />
							<?php _e('Content:','furniot'); ?> <textarea name="pego-pb-element-quoterotator-content[]"  class="pego-pb-element-quoterotator-content" id="pego-pb-element-quoterotator-content[]" ><?php echo $quoterotator_item->getElementsByTagName( "quoterotator_content" )->item(0)->nodeValue; ?></textarea>						
							<div class="clear"></div>
							<div class="pego-pb-remove-quoterotator-item"><?php _e('Remove item','furniot'); ?></div>  
						</li>
					<?php					
					}
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add testimonial items. For each add author and testimonial content.','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	function dodaj_upload($title, $id, $value, $description){	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>	
		<input class="pego-pb-input-for-upload" type="text" id="<?php echo $id; ?>" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		 <input id="upload_image_button" class="upload_image_button" type="button" value="Upload Image"> 
		 <div class="clear"></div>
		 <img style="margin-top:10px; max-width:150px; max-height:150px;" id="upload_image_preview" class="upload_image_preview" src="<?php echo $value; ?>" alt=""> 
		<div class="clear"></div>
		
	</div>
	<?php dodaj_description($description); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	function dodaj_select_icon($title, $values, $value, $id, $description){
	$values=pego_get_all_icons();
	?>		
		<div class="pego-pb-element-single-item w300">
			<h1><?php echo $title; ?></h1>
			<div class="pego-pb-element-single-item-input">
				<select class="iconSize" name="<?php echo $id; ?>[]" id="<?php echo $id; ?>[]" >
				<?php
				foreach ($values as $single_value)
				{
					if ($single_value == $value) {
						echo '<option value="'.$single_value.'" selected>'.$single_value.'</option>';
					}
					else {
						echo '<option value="'.$single_value.'">'.$single_value.'</option>';
					}
				}
				?>
				</select>
			</div>
			<div class="clear"></div>
		</div>
		<?php dodaj_description($description); ?>
		<div class="clear"></div>			
	<?php		
	}
	
	function dodaj_dinamicni_verticallist($title, $id, $value, $currentItems, $stevilo_verticallist_itemov, $verticallist_items){
	$iconvalues=pego_get_all_icons();
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-verticallist-item"><?php _e('Add vertical list item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-verticallist-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-verticallist-elements">
				<ul>				
					<li id="pego-pb-verticallist-element" class="pego-pb-item-for-cloning">
						<?php _e('Icon:','furniot'); ?>
						
						<select class="iconSize" name="pego-pb-element-verticallist-icon[]" id="pego-pb-element-verticallist-icon[]" >
						<?php
						foreach ($iconvalues as $single_value)
						{						
								echo '<option value="'.$single_value.'">'.$single_value.'</option>';						
						}
						?>
						</select>
						
						<?php _e('Title:','furniot'); ?> <input name="pego-pb-element-verticallist-titleinner[]"  class="pego-pb-element-verticallist-titleinner" id="pego-pb-element-verticallist-titleinner[]" />
						<?php _e('Content:','furniot'); ?> <textarea name="pego-pb-element-verticallist-content[]"  class="pego-pb-element-verticallist-content" id="pego-pb-element-verticallist-content[]" ></textarea>							
						<div class="clear"></div>
						<div class="pego-pb-remove-verticallist-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($verticallist_items != null) {
					foreach( $verticallist_items as $verticallist_item){
					?>
						<li id="pego-pb-verticallist-element" >	
							Icon: 
							<?php $iconvalue =  $verticallist_item->getElementsByTagName( "verticallist_icon" )->item(0)->nodeValue; ?>
							
							
							<?php _e('Icon:','furniot'); ?>
						
						<select class="iconSize" name="pego-pb-element-verticallist-icon[]" id="pego-pb-element-verticallist-icon[]" >
						<?php
						foreach ($iconvalues as $single_value)
						{						
							if ($single_value == $iconvalue) {
								echo '<option value="'.$single_value.'" selected>'.$single_value.'</option>';
							}
							else {
								echo '<option value="'.$single_value.'">'.$single_value.'</option>';
							}					
						}
						?>
						</select>
							
							Title: <input name="pego-pb-element-verticallist-titleinner[]"  class="pego-pb-element-verticallist-titleinner" id="pego-pb-element-verticallist-titleinner[]" value="<?php echo $verticallist_item->getElementsByTagName( "verticallist_title" )->item(0)->nodeValue; ?>" />
							Content: <textarea name="pego-pb-element-verticallist-content[]"  class="pego-pb-element-verticallist-content" id="pego-pb-element-verticallist-content[]" ><?php echo $verticallist_item->getElementsByTagName( "verticallist_content" )->item(0)->nodeValue; ?></textarea>						
							<div class="clear"></div>
							<div class="pego-pb-remove-verticallist-item">Remove item</div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add vertical list items. For each add icon, title and content.,','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	function dodaj_dinamicni_imageslide($title, $id, $value, $currentItems, $stevilo_imageslide_itemov, $imageslide_items){	
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-imageslide-item"><?php _e('Add image slide','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-imageslide-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-imageslide-elements">
				<ul>				
					<li id="pego-pb-imageslide-element" class="pego-pb-item-for-cloning">	
						<?php _e('Image url:','furniot'); ?> <input name="pego-pb-element-imageslide-item[]"  class="pego-pb-element-imageslide-item" id="pego-pb-element-imageslide-item[]" />
						<div class="clear"></div>
						<div class="pego-pb-remove-imageslide-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($imageslide_items != null) {
				foreach( $imageslide_items as $imageslidesingle){
				?>
					<li id="pego-pb-imageslide-element">	
						<?php _e('Image url:','furniot'); ?> <input name="pego-pb-element-imageslide-item[]"  class="pego-pb-element-imageslide-item" id="pego-pb-element-imageslide-item[]" value="<?php echo $imageslidesingle->getElementsByTagName( "imageslide_item" )->item(0)->nodeValue; ?>" />
						<div class="clear"></div>						
						<div class="pego-pb-remove-imageslide-item"><?php _e('Remove item','furniot'); ?></div>  
					</li>
				<?php					
				}	
				}
				?>
				</ul><div class="clear"></div>
			</div>
		</div>
		<div class="clear"></div>
	</div>
	<?php dodaj_description(__('Add/Remove image slide items. ','furniot')); ?>
	<div class="clear"></div>		
	<?php		
	}	
	
	
	
	function dodaj_dinamicni_history($title, $id, $value, $currentItems, $stevilo_history_itemov, $history_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-history-item"><?php _e('Add history item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-history-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-history-elements">
				<ul>				
					<li id="pego-pb-history-element" class="pego-pb-item-for-cloning">						
						<?php _e('Title:','furniot'); ?> <input name="pego-pb-element-history-titleinner[]"  class="pego-pb-element-history-titleinner" id="pego-pb-element-history-titleinner[]" />
						<?php _e('Content:','furniot'); ?> <textarea name="pego-pb-element-history-content[]"  class="pego-pb-element-history-content" id="pego-pb-element-history-content[]" ></textarea>	
						<?php _e('Day and month:','furniot'); ?> <input name="pego-pb-element-history-daymonth[]"  class="pego-pb-element-history-daymonth" id="pego-pb-element-history-daymonth[]" />
						<?php _e('Year:','furniot'); ?> <input name="pego-pb-element-history-year[]"  class="pego-pb-element-history-year" id="pego-pb-element-history-year[]" />						
						<div class="clear"></div>
						<div class="pego-pb-remove-history-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($history_items != null) {
					foreach( $history_items as $history_item){
					?>							
						<li id="pego-pb-history-element">
							Title: <input name="pego-pb-element-history-titleinner[]"  class="pego-pb-element-history-titleinner" id="pego-pb-element-history-titleinner[]" value="<?php echo $history_item->getElementsByTagName( "history_title" )->item(0)->nodeValue; ?>" />
							Content: <textarea name="pego-pb-element-history-content[]"  class="pego-pb-element-history-content" id="pego-pb-element-history-content[]" ><?php echo $history_item->getElementsByTagName( "history_content" )->item(0)->nodeValue; ?></textarea>		
							Day and month: <input name="pego-pb-element-history-daymonth[]"  class="pego-pb-element-history-daymonth" id="pego-pb-element-history-daymonth[]" value="<?php echo $history_item->getElementsByTagName( "history_daymonth" )->item(0)->nodeValue; ?>" />
							Year: <input name="pego-pb-element-history-year[]"  class="pego-pb-element-history-year" id="pego-pb-element-history-year[]" value="<?php echo $history_item->getElementsByTagName( "history_year" )->item(0)->nodeValue; ?>" />							
							<div class="clear"></div>
							<div class="pego-pb-remove-history-item">Remove item</div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add history items. For each add title, content and date (day and month together).,','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}
	
	
	function dodaj_dinamicni_maps($title, $id, $value, $currentItems, $stevilo_maps_itemov, $maps_items){
	?>
	<div class="pego-pb-element-single-item w300">
		<h1><?php echo $title; ?></h1>
		<div class="pego-pb-add-maps-item"><?php _e('Add maps item','furniot'); ?></div>		
		<input type="hidden" id="pego-pb-number-of-maps-items" name='<?php echo $id; ?>[]' value="<?php echo $value; ?>" />
		<div class="pego-pb-element-single-item-input">			
			<div id="pego-pb-maps-elements">
				<ul>				
					<li id="pego-pb-maps-element" class="pego-pb-item-for-cloning">						
						<?php _e('Address:','furniot'); ?> <input name="pego-pb-element-maps-address[]"  class="pego-pb-element-maps-address" id="pego-pb-element-maps-address[]" />
						<?php _e('Pin url:','furniot'); ?> <input name="pego-pb-element-maps-pin[]"  class="pego-pb-element-maps-pin" id="pego-pb-element-maps-pin[]" />
						<?php _e('Latitude:','furniot'); ?> <input name="pego-pb-element-maps-lat[]"  class="pego-pb-element-maps-lat" id="pego-pb-element-maps-lat[]" />
						<?php _e('Longitude:','furniot'); ?> <input name="pego-pb-element-maps-lng[]"  class="pego-pb-element-maps-lng" id="pego-pb-element-maps-lng[]" />
						
						<div class="clear"></div>
						<div class="pego-pb-remove-maps-item"><?php _e('Remove item','furniot'); ?></div>
					</li>
				
				<?php
				if ($maps_items != null) {
					foreach( $maps_items as $map_item){
					?>
						<li id="pego-pb-maps-element" >
							Description: <input name="pego-pb-element-maps-address[]"  class="pego-pb-element-maps-address" id="pego-pb-element-maps-address[]" value="<?php echo $map_item->getElementsByTagName( "maps_address" )->item(0)->nodeValue; ?>" />						
							Pin url: <input name="pego-pb-element-maps-pin[]"  class="pego-pb-element-maps-pin" id="pego-pb-element-maps-pin[]" value="<?php echo $map_item->getElementsByTagName( "maps_pin" )->item(0)->nodeValue; ?>" />
							Latitude: <input name="pego-pb-element-maps-lat[]"  class="pego-pb-element-maps-lat" id="pego-pb-element-maps-lat[]" value="<?php echo $map_item->getElementsByTagName( "maps_lat" )->item(0)->nodeValue; ?>" />
							Longitude: <input name="pego-pb-element-maps-lng[]"  class="pego-pb-element-maps-lng" id="pego-pb-element-maps-lng[]" value="<?php echo $map_item->getElementsByTagName( "maps_lng" )->item(0)->nodeValue; ?>" />							
							<div class="clear"></div>
							<div class="pego-pb-remove-maps-item">Remove item</div>  
						</li>
					<?php					
					}	
				}
				?>
				</ul>
			</div>
		</div>
		<div class="clear"></div>
	</div>	
	<?php dodaj_description(__('Add maps items. For each add pin image, latitude, longitude and description.,','furniot')); ?>
	<div class="clear"></div>	
	<?php		
	}	
	
	
	
	
	
	function get_niz_to_show($velikost) {
		$velikost_niz_za_prikaz='20%';
		switch ($velikost) {
			case 'one_fifth':
				$velikost_niz_za_prikaz='20%';
				break;
			case 'one_fourth':
				$velikost_niz_za_prikaz='25%';
				break;
			case 'one_third':
				$velikost_niz_za_prikaz='33%';
				break;
			case 'one_half':
				$velikost_niz_za_prikaz='50%';
				break;
			case 'two_third':
				$velikost_niz_za_prikaz='66%';
				break;
			case 'three_fourth':
				$velikost_niz_za_prikaz='75%';
				break;
			case 'full_width':
				$velikost_niz_za_prikaz='100%';
				break;
		}
		return $velikost_niz_za_prikaz;
				
	}
	
	/* pego builder END */	
?>