<?php
	$pego_prefix="pego_";
	$themedir = get_template_directory_uri();
	
	load_theme_textdomain('sparse',get_template_directory() . '/languages');
	
/***************************************************************  
Javascript files include
***************************************************************/
	function pego_javascripts() {
		wp_enqueue_script('easy-pie-chart', get_template_directory_uri() . '/js/jquery.easy-pie-chart.js','','',true);		
		wp_enqueue_script('tooltip', get_template_directory_uri() . '/js/easyTooltip.js','','',true);		
		wp_enqueue_script('parallax', get_template_directory_uri() . '/js/parallax.js','','',true);		
		wp_enqueue_script('flexslider', get_template_directory_uri() . '/js/jquery.flexslider-min.js','','',true);		
		wp_enqueue_script('modernizr', get_template_directory_uri() . '/js/modernizr.custom.js','','',true);		
		wp_enqueue_script('cbpQTRotator', get_template_directory_uri() . '/js/jquery.cbpQTRotator.min.js','','',true);		
		wp_enqueue_script('backstretch', get_template_directory_uri() . '/js/jquery.backstretch.min.js','','',true);		
		wp_enqueue_script('waypoints', get_template_directory_uri() . '/js/waypoints.js','','',true);		
		wp_enqueue_script('superfish', get_template_directory_uri() . '/js/superfish.js','','',true);		
		wp_enqueue_script('mobilemenu', get_template_directory_uri() . '/js/jquery.mobilemenu.js','','',true);		
		wp_enqueue_script('custom', get_template_directory_uri() . '/js/custom.js','','',true);		
	}
	add_action('wp_enqueue_scripts', 'pego_javascripts');	
	
/***************************************************************  
Style files include
***************************************************************/
	function pego_theme_styles() { 
		global $pego_prefix;
		wp_enqueue_style( 'easy-pie-chart-style', get_template_directory_uri() . '/css/jquery.easy-pie-chart.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'widgets-style', get_template_directory_uri() . '/css/widgets.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'shortcodes-style', get_template_directory_uri() . '/css/shortcodes.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'flexslider-style', get_template_directory_uri() . '/css/flexslider.css', array(), '1.0', 'all' );
		
		$theme_type = get_option($pego_prefix.'theme_type');
		if($theme_type == 'Boxed') {
			wp_enqueue_style( 'boxed-style', get_template_directory_uri() . '/css/boxed.css', array(), '1.0', 'all' );	
		}			
		wp_enqueue_style( 'default-style', get_template_directory_uri() . '/style.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'media-style', get_template_directory_uri() . '/css/media.css', array(), '1.0', 'all' );	
		wp_enqueue_style( 'js_composer_front-style', get_template_directory_uri() . '/wpbakery/js_composer/assets/css/js_composer_front.css', array(), '1.0', 'all' );			
	}	
	add_action('wp_enqueue_scripts', 'pego_theme_styles');

/***************************************************************  
Menu declaration
***************************************************************/
	register_nav_menu( 'primary', __( 'Navigation Menu', 'sparse' ) );

	
	
/***************************************************************  
Widget areas
***************************************************************/
	function pego_new_widgets_init() {	
	
		register_sidebar(array(
			'name' => 'Blog sidebar',
			'id' => 'blog-sidebar',
			'description'   => 'These are widgets for the sidebar.',
			'before_widget' => '<div id="%1$s" class="widget animationClass %2$s" style="margin-bottom:30px;">',
			'after_widget'  => '<div class="clear"></div></div><div class="clear"></div>',
			'before_title'  => '<h3 class="sidebar-title">',
			'after_title'   => '</h3><div class="title_stripes_sidebar"></div><div class="clear"></div>'
		));		
		
		register_sidebar(array(
			'name' => 'Upper header area - left',
			'id' => 'upper-header-area-left',
			'before_widget' => '',
			'after_widget' => '<div class="clear"></div>',
			'before_title' => '<div class="upper-header-titles">',
			'after_title' => '</div>',
		));
		
		register_sidebar(array(
			'name' => 'Upper header area - right',
			'id' => 'upper-header-area-right',
			'before_widget' => '',
			'after_widget' => '<div class="clear"></div>',
			'before_title' => '<div class="upper-header-titles">',
			'after_title' => '</div>',
		));
		
		register_sidebar(array(
			'name' => 'Right to logo area',
			'id' => 'right-to-logo-area',
			'before_widget' => '<div class="right-to-logo-widget">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="right-to-logo-titles">',
			'after_title' => '</div>',
		));	
		
		
		//custom sidebars from admin
		$argsSidebars = array('post_type'=> 'sidebars', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
		$allSidebars = get_posts($argsSidebars);	
	
		if($allSidebars) {
			foreach($allSidebars as $singleSidebar)
			{ 	
				$sidebarTitle = $singleSidebar->post_title;	
				$sidebarName= $singleSidebar->post_name;				
				register_sidebar(array(
					'name' => $sidebarTitle,
					'id' => $sidebarName,
					'description'   => 'These are widgets for the sidebar.',
					'before_widget' => '<div id="%1$s" class="widget animationClass %2$s" style="margin-bottom:30px;">',
					'after_widget'  => '</div><div class="clear"></div>',
					'before_title'  => '<h3 class="sidebar-title">',
					'after_title'   => '</h3><div class="title_stripes_sidebar"></div><div class="clear"></div>'
				));				
			}
		}
		
	
		register_sidebar(array(
			'name' => 'Footer First Column Sidebar',
			'id' => 'first-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget animationClass %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Footer Second Column Sidebar',
			'id' => 'second-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget animationClass %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Footer  Third Column Sidebar',
			'id' => 'third-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget animationClass %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));	
		register_sidebar(array(
			'name' => 'Footer  Fourth Column Sidebar',
			'id' => 'fourth-footer-column-sidebar',
			'before_widget' => '<div id="%1$s" class="widget animationClass %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h1 class="widget-title">',
			'after_title' => '</h1>',
		));
		register_sidebar(array(
			'name' => 'Under footer area - left',
			'id' => 'under-footer-area-left',
			'before_widget' => '<div class="under-footer-div animationClass fl">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="under-footer-titles">',
			'after_title' => '</div>',
		));
		register_sidebar(array(
			'name' => 'Under footer area - right',
			'id' => 'under-footer-area-right',
			'before_widget' => '<div class="under-footer-div animationClass fr">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="under-footer-titles">',
			'after_title' => '</div>',
		));
		register_sidebar(array(
			'name' => 'Under footer area - center',
			'id' => 'under-footer-area-center',
			'before_widget' => '<div class="under-footer-div animationClass">',
			'after_widget' => '</div><div class="clear"></div>',
			'before_title' => '<div class="under-footer-titles">',
			'after_title' => '</div>',
		));
		
		if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {		
			register_sidebar(array(
				'name' => 'WooCommerce Widget Area',
				'id' => 'woocommerce-widget-area',
				'description'   => 'These are widgets for WooCommerce Shop and Products page.',
				'before_widget' => '<div id="%1$s" class="widget %2$s" style="margin-bottom:30px;">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="sidebar-title">',
				'after_title'   => '</h3>'
			));
		}
		
	}
	add_action( 'widgets_init', 'pego_new_widgets_init' );	
	
	
/***************************************************************  
Shortcodes for check and cancel icon
***************************************************************/		
	function pricing_check ( $atts, $content = null ) {
		return	'<div class="iconfont icon-check"></div>';
	}
	add_shortcode('check', 'pricing_check');
	
	
	function pricing_cancel ( $atts, $content = null ) {
		return	'<div class="iconfont icon-cancel"></div>';
	}
	add_shortcode('cancel', 'pricing_cancel');
	
	
	
/***************************************************************  
Include php files
***************************************************************/	
	define('PEGO_FILEPATH', get_template_directory());
	define('PEGO_DIRECTORY', get_template_directory_uri());
	define( 'OPTIONS', 'sparse_options' );
	
	require_once (PEGO_FILEPATH . '/admin/admin-functions.php');
	require_once (PEGO_FILEPATH . '/admin/admin-interface.php');
	include("functions/custom-page.php");
	include("functions/custom-portfolio.php");
	include("functions/custom-post.php");
	include("functions/custom-sidebar.php");
	include("functions/custom-colorareas.php");
	include("functions/custom-pricing-columns.php");
	include("functions/custom-testimonials.php");
	//include("functions/custom-gallery.php");
	//include("functions/custom-faqs.php");	
	require_once (PEGO_FILEPATH . '/functions/theme-options.php');
	include("functions/twitteroauth.php");	
	include("functions/widget-twitter.php");
	include("functions/widget-flickr.php");	
	include("functions/widget-contact.php");	
	include("functions/widget-latest-portfolios.php");	
	include("functions/widget-latest-posts.php");	
	include("functions/widget-quick-info.php");
	include("functions/bra_social_media.php");		
	include("functions/soundcloud.php");	

	
	
	
	
/***************************************************************  
Custom admin logo
***************************************************************/
	function pego_custom_login_logo() {
		$read_logo='';
		$pego_prefix = "pego_";
	   $read_logo = get_option($pego_prefix.'logoadmin');

		if($read_logo != '') {
						echo '<style type="text/css">
				h1 a {background-size:auto !important; background-image:url('.$read_logo.') !important; }
			</style>';	
		}	
		else {
					echo '<style type="text/css">
			h1 a { background-size:auto !important; background-image:url('.get_template_directory_uri().'/images/logo.png) !important;  }
		</style>';
		}
    }
    add_action('login_head', 'pego_custom_login_logo');	
		

/***************************************************************  
Get all pricing columns
***************************************************************/	
function pego_get_all_pc() {	
	//custom sidebars from admin
	$argsPC= array('post_type'=> 'pricing_columns', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
	$allPC = get_posts($argsPC);	
	$allPricingColumns = array();
	if($allPC) {
		foreach($allPC as $singlePC)
		{ 	
			$allPricingColumns[$singlePC->ID] = $singlePC->post_title;						
		}
	return $allPricingColumns;
	}
}
	
/***************************************************************  
Get all testimonials
***************************************************************/	
function pego_get_all_test() {	
	//custom sidebars from admin
	$argsTest= array('post_type'=> 'testimonials', 'posts_per_page' => -1, 'order'=> 'DESC', 'orderby' => 'post_date'  );
	$allTest = get_posts($argsTest);	
	$allTestimonials = array();
	if($allTest) {
		foreach($allTest as $singleTest)
		{ 	
			$allTestimonials[$singleTest->ID] = $singleTest->post_title;						
		}
	return $allTestimonials;
	}
}
	
	
/***************************************************************  
Added support for post thumbnails
***************************************************************/
	if ( function_exists( 'add_image_size' ) ) add_theme_support( 'post-thumbnails' );
	
	if ( function_exists( 'add_image_size' ) ) { 
		add_image_size('TeamImg', 104, 104, true);
	}
	
	
/***************************************************************  
Added support for post formats
***************************************************************/	
add_theme_support( 'post-formats', array( 'image', 'video', 'gallery', 'quote', 'link', 'audio' ) );	
	
add_theme_support( 'automatic-feed-links' );	
		
	
	
/***************************************************************  
Get all icons
***************************************************************/	
function pego_get_all_icons() {

	
	$allIcons= array('no-icon', 'plus', 'minus', 'info', 'left-thin', 'up-thin', 'right-thin', 'down-thin', 'level-up', 'level-down', 'switch', 'infinity', 'plus-squared', 'minus-squared', 'home', 'keyboard', 'erase', 'pause', 'fast-forward', 'fast-backward', 'to-end', 'to-start', 'hourglass', 'stop', 'up-dir', 'play', 'right-dir','down-dir', 'left-dir', 'adjust', 'cloud', 'star', 'star-empty', 'cup', 'menu', 'moon', 'heart-empty', 'heart', 'note', 'note-beamed', 'layout', 'flag', 'tools', 'cog', 'attention', 'flash', 'record', 'cloud-thunder', 'tape', 'flight', 'mail', 'pencil', 'feather', 'check', 'cancel', 'cancel-circled', 'cancel-squared', 'help', 'quote', 'plus-circled', 'minus-circled', 'right', 'direction', 'forward', 'ccw', 'cw', 'left', 'up', 'down', 'list-add', 'list', 'left-bold', 'right-bold', 'up-bold', 'down-bold', 'user-add', 'help-circled', 'info-circled', 'eye', 'tag', 'upload-cloud', 'reply', 'reply-all', 'code', 'export', 'print', 'retweet', 'comment', 'chat', 'vcard', 'address', 'location', 'map', 'compass', 'trash', 'doc', 'docs', 'doc-landscape', 'archive', 'rss', 'share', 'basket', 'shareable', 'login', 'logout', 'volume', 'resize-full', 'resize-small', 'popup', 'publish', 'window', 'arrow-combo', 'chart-pie', 'language', 'air', 'database', 'drive', 'bucket', 'thermometer', 'down-circled', 'left-circled', 'right-circled', 'up-circled', 'down-open', 'left-open', 'right-open', 'up-open', 'down-open-mini', 'left-open-mini', 'right-open-mini', 'up-open-mini', 'down-open-big', 'left-open-big', 'right-open-big', 'up-open-big', 'progress-0', 'progress-1', 'progress-2', 'progress-3', 'back-in-time', 'network', 'inbox', 'install', 'lifebuoy', 'mouse', 'dot', 'dot-2', 'dot-3', 'suitcase', 'flow-cascade', 'flow-branch', 'flow-tree', 'flow-line', 'flow-parallel', 'brush', 'paper-plane', 'magnet', 'gauge', 'traffic-cone', 'cc', 'cc-by', 'cc-nc', 'cc-nc-eu', 'cc-nc-jp', 'cc-sa', 'cc-nd', 'cc-pd', 'cc-zero', 'cc-share', 'cc-remix', 'github', 'github-circled', 'flickr', 'flickr-circled', 'vimeo', 'vimeo-circled', 'twitter', 'twitter-circled', 'facebook', 'facebook-circled', 'facebook-squared', 'gplus', 'gplus-circled', 'pinterest', 'pinterest-circled', 'tumblr', 'tumblr-circled', 'linkedin', 'linkedin-circled', 'dribbble', 'dribbble-circled', 'stumbleupon', 'stumbleupon-circled', 'lastfm', 'lastfm-circled', 'rdio', 'rdio-circled', 'spotify', 'spotify-circled', 'qq', 'instagram', 'dropbox', 'evernote', 'flattr', 'skype', 'skype-circled', 'renren', 'sina-weibo', 'paypal', 'picasa', 'soundcloud', 'mixi', 'behance', 'google-circles', 'vkontakte', 'smashing', 'db-shape', 'sweden', 'logo-db', 'picture', 'globe', 'leaf', 'graduation-cap', 'mic', 'palette', 'ticket', 'video', 'target', 'music', 'trophy', 'thumbs-up', 'thumbs-down', 'bag', 'user', 'users', 'lamp', 'alert', 'water', 'droplet', 'credit-card', 'monitor', 'briefcase', 'floppy', 'folder', 'doc-text', 'calendar', 'chart-line', 'chart-bar', 'clipboard', 'attach', 'bookmarks', 'book', 'book-open', 'phone', 'megaphone', 'upload', 'download', 'box', 'newspaper', 'mobile','signal', 'camera', 'shuffle', 'loop', 'arrows-ccw', 'light-down', 'light-up', 'mute', 'sound', 'battery', 'search', 'key', 'lock', 'lock-open', 'bell', 'bookmark', 'link', 'back', 'flashlight', 'chart-area', 'clock', 'rocket', 'block');	
	return $allIcons;
}

function pego_get_all_icons_codes() {

	
	$allIconsCodes= array('', '\e816', '\e823', '\e819', '\e880', '\e87e', '\e87f','\e884','\e8d4','\e893','\e89a','\e8c8','\e81e','\e81f','\e830','\e83b','\e8c7', '\e8d5','\e8a0','\e8a1', '\e89e','\e89f', '\e86b', '\e89c', '\e883', '\e89b', '\e889', '\e88b', '\e88a', '\e867', '\e8ae', '\e808', '\e809', '\e848', '\e811', '\e8b1', '\e807', '\e805', '\e800', '\e801', '\e810', '\e827', '\e855', '\e854', '\e83e', '\e8b0', '\e89d', '\e8af', '\e8c3', '\e8b2', '\e804', '\e838', '\e839', '\e813', '\e812', '\e814', '\e815', '\e821', '\e835', '\e817', '\e820', '\e88d', '\e84a', '\e834', '\e87d', '\e88f', '\e88e', '\e88c', '\e87c', '\e8ab', '\e898', '\e887', '\e881', '\e886', '\e882', '\e80c',
 '\e822', '\e818', '\e82b', '\e82a', '\e81b', '\e832', '\e833', '\e836', '\e837', '\e83a', '\e81a', '\e81c', '\e83c', '\e84e', '\e84d', '\e84c', '\e84b', '\e849', '\e847', '\e846', '\e845', '\e844', '\e850', '\e852', '\e856', '\e858', '\e857', '\e85b',
 '\e85c', '\e888', '\e865', '\e864', '\e863', '\e862', '\e861', '\e860', '\e8d3', '\e8c1', '\e8bd', '\e8ce', '\e8cf', '\e8d0', '\e8d2', '\e85f', '\e86e', '\e86f', '\e870', '\e871', '\e872', '\e873', '\e874', '\e875', '\e876', '\e877', '\e878', '\e879',
 '\e885', '\e87a', '\e87b', '\e8a2', '\e890', '\e891', '\e894', '\e8a7', '\e8a4', '\e8a3', '\e8ac', '\e8b5', '\e8b6', '\e8b9', '\e8ba', '\e8bb', '\e8b8', '\e8dd', '\e8dc', '\e8db', '\e8da', '\e8d9', '\e8ca', '\e8b3', '\e8c9', '\e8d7', '\e8d6', '\e8f4',
 '\e8f5', '\e8fd', '\e8fc', '\e8fb', '\e8f6', '\e8fa', '\e8f7', '\e8de',  '\e8df', '\e8e0', '\e8e1', '\e8e2', '\e8e3', '\e8f8', '\e8e4', '\e8f3', '\e8f2', '\e8f1', '\e8f0', '\e8ef', '\e8ee', '\e8ed', '\e8ec', '\e8eb', '\e8ea', '\e8e9', '\e8e8', '\e8e7', '\e8e6', '\e8f9', '\e8e5', '\e8fe', '\e8ff', '\e90d', '\e900', '\e901', '\e902', '\e903', '\e904', '\e905', '\e906', '\e907', '\e908', '\e909', '\e90a', '\e90b', '\e90c', '\e90e', '\e90f', '\e910', '\e911', '\e912', '\e913', '\e914', '\e915', '\e916', '\e918', '\e917', '\e919', '\e80e', '\e8ad', '\e8b4', '\e8c2', '\e85d', '\e897', '\e8c0', '\e80d', '\e895', '\e802', '\e8a9', '\e81d', '\e826', '\e859', '\e80a', '\e80b', '\e86a', '\e83f', '\e8bf', '\e8be', '\e8bc', '\e8a6', '\e8b7', '\e8cb', '\e84f', '\e843', '\e85a', '\e8c6', '\e8c5', '\e8cc', '\e82e', '\e828', '\e840', '\e841', '\e853', '\e8cd', '\e824', '\e825', '\e851', '\e842', '\e8a5', '\e8aa', '\e80f', '\e896', '\e899', '\e892', '\e869', '\e868', '\e85e', '\e86d', '\e8a8', '\e803', '\e8d1', '\e82d', '\e82c', '\e83d', '\e829', '\e82f', '\e831', '\e806', '\e8c4', '\e86c', '\e8d8', '\e866');	
	return $allIconsCodes;
}



/***************************************************************  
Reading all Contact 7 Forms
***************************************************************/
	function pego_get_contact_forms() {
		$allContactForms7 = array();
		global $wpdb;		
		global $table_prefix;
		$table_prefix = $wpdb->base_prefix;
		$wpdb->tablename = $table_prefix . 'posts';
		$contact_forms7 = $wpdb->get_results( 
				"
				SELECT ID,post_title 
				FROM $wpdb->tablename
				WHERE post_type = 'wpcf7_contact_form'
				"
				);
		foreach ( $contact_forms7 as $contact_form7 ) 
		{	
			$allContactForms7[$contact_form7->ID] = $contact_form7->post_title;	
		}	
		return $allContactForms7;	
	
	}
	

/***************************************************************  
Reading all layer sliders
***************************************************************/
	
	function pego_get_slider_layer() {		
		global $wpdb;
		$values = array();
		// Table name
		$table_name = $wpdb->prefix . "layerslider";	 
		// Get sliders
		$sliders = $wpdb->get_results( "SELECT * FROM $table_name
											WHERE flag_hidden = '0' AND flag_deleted = '0'
											ORDER BY date_c ASC LIMIT 100" );	 
		// Iterate over the sliders
		if( is_array($sliders) ) {
			foreach($sliders as $key => $item) {
				$values[$item->id] = $item->name;	
			}
		}
		return $values;		
	}
	
/***************************************************************  
Reading all revolution sliders
***************************************************************/
	
	function pego_get_slider_revolution() {		
		global $wpdb;
		$slides=array();
		$slides= $wpdb->get_var("SELECT alias FROM `wp_revslider_sliders`LIMIT 0 , 30");
		return $slides;
	}
	
	
/***************************************************************  
Comment reply
***************************************************************/
	function theme_queue_js(){
	if ( (!is_admin()) && is_singular() && comments_open() && get_option('thread_comments') )
	  wp_enqueue_script( 'comment-reply' );
	}
	add_action('wp_print_scripts', 'theme_queue_js');	

/***************************************************************  
Breadcrumbs
***************************************************************/
	function pego_breadcrumbs() {
	  $delimiter = '&#92;';
	  $name = 'Home'; //text for the 'Home' link
	  $currentBefore = '<span class="current">';
	  $currentAfter = '</span>';
	  if (get_option('pego_separatorBreadcrumbs') != '') {
			$delimiter = get_option('pego_separatorBreadcrumbs');
	  }
	 
	 
	  if ( !is_home() && !is_front_page() || is_paged() ) { 

		global $post;
		$home = home_url();
		echo 'You are here:  <a href="' . $home . '">' . $name . '</a> ' . $delimiter . ' ';
	 
		if ( is_category() ) {
		  global $wp_query;
		  $cat_obj = $wp_query->get_queried_object();
		  $thisCat = $cat_obj->term_id;
		  $thisCat = get_category($thisCat);
		  $parentCat = get_category($thisCat->parent);
		  if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
		 // echo $currentBefore . 'Archive by category &#39;';
		  echo $currentBefore;
		  single_cat_title();
		 // echo '&#39;' . $currentAfter;
		  echo $currentAfter;
	 
		} 
		if (is_tax('portfolio_categories') ) {

		  echo $currentBefore;
		  single_cat_title();
		  echo $currentAfter;
	 
		} elseif( is_day() ) {
		  echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
		  echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
		  echo $currentBefore . get_the_time('d') . $currentAfter;
	 
		} elseif ( is_month() ) {
		  echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
		  echo $currentBefore . get_the_time('F') . $currentAfter;
	 
		} elseif ( is_year() ) {
		  echo $currentBefore . get_the_time('Y') . $currentAfter;
	 
		} elseif ( is_single() ) {
			if (get_post_type() == 'post'){
				$cat = get_the_category();
				foreach($cat as $category) {
					echo  '<a href="'.get_category_link($category->term_id).'" >'.$category->name.'</a> ' . $delimiter . ' ';
				}
			}
			else {
				if (get_post_type() == 'portfolio'){
					$cat = get_the_terms( $post->ID, 'portfolio_categories' );
					foreach($cat as $category) {
						echo  '<a href="'.get_term_link($category->slug, 'portfolio_categories').'" >'.$category->name.'</a> ' . $delimiter . ' ';
					}
				}
			}
		  echo $currentBefore;
		  the_title();
		  echo $currentAfter;
	 
		} elseif ( is_page() && !$post->post_parent ) {
		  echo $currentBefore;
		  the_title();
		  echo $currentAfter;
	 
		} elseif ( is_page() && $post->post_parent ) {
		  $parent_id  = $post->post_parent;
		  $breadcrumbs = array();
		  while ($parent_id) {
			$page = get_page($parent_id);
			$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
			$parent_id  = $page->post_parent;
		  }
		  $breadcrumbs = array_reverse($breadcrumbs);
		  foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
		  echo $currentBefore;
		  the_title();
		  echo $currentAfter;
	 
		} elseif ( is_search() ) {
		  echo $currentBefore . 'Search results for &#39;' . get_search_query() . '&#39;' . $currentAfter;
	 
		} elseif ( is_tag() ) {
		  echo $currentBefore . 'Posts tagged &#39;';
		  single_tag_title();
		  echo '&#39;' . $currentAfter;
	 
		} elseif ( is_author() ) {
		   global $author;
		  $userdata = get_userdata($author);
		  echo $currentBefore . 'Articles posted by ' . $userdata->display_name . $currentAfter;
	 
		} elseif ( is_404() ) {
		  echo $currentBefore . 'Error 404' . $currentAfter;
		}
	 
		if ( get_query_var('paged') ) {
		  if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
		  echo __('Page') . ' ' . get_query_var('paged');
		  if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
		}
	 
	  }
	}
	function pego_display_breadcrumbs() {
	//if (get_option('pego_breadcrumbs_show') =='true' ) {
	?><div class="page-breadcrumbs">
			<div class="breadcrumbs-content">
				<?php pego_breadcrumbs(); ?>
			</div>
		</div>
		<?php
	//	}
	
	}
	
	
	
/***************************************************************  
Automatic plugin include
***************************************************************/
	
				/**
			 * This file represents an example of the code that themes would use to register
			 * the required plugins.
			 *
			 * It is expected that theme authors would copy and paste this code into their
			 * functions.php file, and amend to suit.
			 *
			 * @package	   TGM-Plugin-Activation
			 * @subpackage Example
			 * @version	   2.3.6
			 * @author	   Thomas Griffin <thomas@thomasgriffinmedia.com>
			 * @author	   Gary Jones <gamajo@gamajo.com>
			 * @copyright  Copyright (c) 2012, Thomas Griffin
			 * @license	   http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
			 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
			 */

			/**
			 * Include the TGM_Plugin_Activation class.
			 */
			require_once (PEGO_FILEPATH . '/functions/class-tgm-plugin-activation.php');

			add_action( 'tgmpa_register', 'pego_register_required_plugins' );
			/**
			 * Register the required plugins for this theme.
			 *
			 * In this example, we register two plugins - one included with the TGMPA library
			 * and one from the .org repo.
			 *
			 * The variable passed to tgmpa_register_plugins() should be an array of plugin
			 * arrays.
			 *
			 * This function is hooked into tgmpa_init, which is fired within the
			 * TGM_Plugin_Activation class constructor.
			 */
			function pego_register_required_plugins() {

				/**
				 * Array of plugin arrays. Required keys are name and slug.
				 * If the source is NOT from the .org repo, then source is also required.
				 */
				$plugins = array(

					// This is an example of how to include a plugin pre-packaged with a theme
				
				array(
						'name'     				=> 'Layer Slider', // The plugin name
						'slug'     				=> 'LayerSlider', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/layersliderwp-4.6.3.installable.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					),
									
			     array(
						'name'     				=> 'Revolution Slider', // The plugin name
						'slug'     				=> 'revslider', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/revslider.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					),
					
					array(
						'name'     				=> 'Contact Form 7', // The plugin name
						'slug'     				=> 'contact-form-7', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/contact-form-7.3.5.2.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					),
								  
				  array(
						'name'     				=> 'Ubermenu', // The plugin name
						'slug'     				=> 'ubermenu', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/ubermenu.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					),				  
					
					array(
						'name'     				=> 'Ubermenu-Sticky', // The plugin name
						'slug'     				=> 'ubermenu-sticky', // The plugin slug (typically the folder name)
						'source'   				=> get_stylesheet_directory() . '/lib/plugins/ubermenu-sticky.zip', // The plugin source
						'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
						'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
						'force_activation' 		=> true, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
						'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
						'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
					)

				);

				// Change this to your theme text domain, used for internationalising strings
				$theme_text_domain = 'sparse';

				/**
				 * Array of configuration settings. Amend each line as needed.
				 * If you want the default strings to be available under your own theme domain,
				 * leave the strings uncommented.
				 * Some of the strings are added into a sprintf, so see the comments at the
				 * end of each line for what each argument will be.
				 */
				$config = array(
					'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
					'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
					'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
					'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
					'menu'         		=> 'install-required-plugins', 	// Menu slug
					'has_notices'      	=> true,                       	// Show admin notices or not
					'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
					'message' 			=> '',							// Message to output right before the plugins table
					'strings'      		=> array(
						'page_title'                       			=> __( 'Install Required Plugins', 'sparse' ),
						'menu_title'                       			=> __( 'Install Plugins', 'sparse' ),
						'installing'                       			=> __( 'Installing Plugin: %s', 'sparse' ), // %1$s = plugin name
						'oops'                             			=> __( 'Something went wrong with the plugin API.', 'sparse' ),
						'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
						'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
						'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
						'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
						'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
						'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
						'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
						'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
						'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
						'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
						'return'                           			=> __( 'Return to Required Plugins Installer', 'sparse' ),
						'plugin_activated'                 			=> __( 'Plugin activated successfully.', 'sparse' ),
						'complete' 									=> __( 'All plugins installed and activated successfully. %s', 'sparse' ), // %1$s = dashboard link
						'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
					)
				);

				tgmpa( $plugins, $config );

			}	

		



//function that reads fonts
function return_google_api_fontss() { 

	$allFontFromAPI= json_decode('{
 "kind": "webfonts#webfontList",
 "items": [
  {
   "kind": "webfonts#webfont",
   "family": "ABeeZee",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Abel",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Abril Fatface",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aclonica",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Acme",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Actor",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Adamina",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Advent Pro",
   "variants": [
    "100",
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aguafina Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Akronim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aladin",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aldrich",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alegreya",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alegreya SC",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alex Brush",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alfa Slab One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alice",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alike",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Alike Angular",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allan",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allerta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allerta Stencil",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Allura",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Almendra",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Almendra Display",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Almendra SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amarante",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amaranth",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amatic SC",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Amethysta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Anaheim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Andada",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Andika",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Angkor",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Annie Use Your Telescope",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Anonymous Pro",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Antic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Antic Didone",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Antic Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Anton",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arapey",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arbutus",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arbutus Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Architects Daughter",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Archivo Black",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Archivo Narrow",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arimo",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arizonia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Armata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Artifika",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Arvo",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Asap",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Asset",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Astloch",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Asul",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Atomic Age",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Aubrey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Audiowide",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Autour One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Average",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Average Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Gruesa Libre",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Libre",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Sans Libre",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Averia Serif Libre",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bad Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Balthazar",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bangers",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Basic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Battambang",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Baumans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bayon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Belgrano",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Belleza",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "BenchNine",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bentham",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Berkshire Swash",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bevan",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bigelow Rules",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bigshot One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bilbo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bilbo Swash Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bitter",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Black Ops One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bokor",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bonbon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Boogaloo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bowlby One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bowlby One SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Brawler",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bree Serif",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bubblegum Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Bubbler One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Buda",
   "variants": [
    "300"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Buenard",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Butcherman",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Butterfly Kids",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cabin",
   "variants": [
    "regular",
    "italic",
    "500",
    "500italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cabin Condensed",
   "variants": [
    "regular",
    "500",
    "600",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cabin Sketch",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Caesar Dressing",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cagliostro",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Calligraffitti",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cambo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Candal",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cantarell",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cantata One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cantora One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Capriola",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cardo",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin",
    "greek-ext"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carme",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carrois Gothic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carrois Gothic SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Carter One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Caudex",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin",
    "greek-ext"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cedarville Cursive",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ceviche One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Changa One",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chango",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chau Philomene One",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chela One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chelsea Market",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chenla",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cherry Cream Soda",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cherry Swash",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chewy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chicle",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Chivo",
   "variants": [
    "regular",
    "italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cinzel",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cinzel Decorative",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Clicker Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coda",
   "variants": [
    "regular",
    "800"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coda Caption",
   "variants": [
    "800"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Codystar",
   "variants": [
    "300",
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Combo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Comfortaa",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coming Soon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Concert One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Condiment",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Content",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Contrail One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Convergence",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cookie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Copse",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Corben",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Courgette",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cousine",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Coustard",
   "variants": [
    "regular",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Covered By Your Grace",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crafty Girls",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Creepster",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crete Round",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crimson Text",
   "variants": [
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Croissant One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Crushed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cuprum",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cutive",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Cutive Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Damion",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dancing Script",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dangrek",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dawning of a New Day",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Days One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Delius",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Delius Swash Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Delius Unicase",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Della Respira",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Denk One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Devonshire",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Didact Gothic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Diplomata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Diplomata SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Domine",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Donegal One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Doppio One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dorsa",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dosis",
   "variants": [
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700",
    "800"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dr Sugiyama",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Droid Sans",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Droid Sans Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Droid Serif",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Duru Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Dynalight",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "EB Garamond",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Eagle Lake",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Eater",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Economica",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Electrolize",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Elsie",
   "variants": [
    "regular",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Elsie Swash Caps",
   "variants": [
    "regular",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Emblema One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Emilys Candy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Engagement",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Englebert",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Enriqueta",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Erica One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Esteban",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Euphoria Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ewert",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Exo",
   "variants": [
    "100",
    "100italic",
    "200",
    "200italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "500",
    "500italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "800",
    "800italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Expletus Sans",
   "variants": [
    "regular",
    "italic",
    "500",
    "500italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fanwood Text",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fascinate",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fascinate Inline",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Faster One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fasthand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Federant",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Federo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Felipa",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fenix",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Finger Paint",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fjalla One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fjord One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Flamenco",
   "variants": [
    "300",
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Flavors",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fondamento",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fontdiner Swanky",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Forum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Francois One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Freckle Face",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fredericka the Great",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fredoka One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Freehand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fresca",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Frijole",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fruktur",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Fugaz One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "GFS Didot",
   "variants": [
    "regular"
   ],
   "subsets": [
    "greek"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "GFS Neohellenic",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "greek"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gabriela",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gafata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Galdeano",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Galindo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gentium Basic",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gentium Book Basic",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Geo",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Geostar",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Geostar Fill",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Germania One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gilda Display",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Give You Glory",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Glass Antiqua",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Glegoo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gloria Hallelujah",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Goblin One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gochi Hand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gorditas",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Goudy Bookletter 1911",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Graduate",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Grand Hotel",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gravitas One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Great Vibes",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Griffy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gruppo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Gudea",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Habibi",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hammersmith One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hanalei",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hanalei Fill",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Handlee",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Hanuman",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Happy Monkey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Headland One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Henny Penny",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Herr Von Muellerhoff",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Holtwood One SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Homemade Apple",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Homenaje",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell DW Pica",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell DW Pica SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Double Pica",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Double Pica SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell English",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell English SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell French Canon",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell French Canon SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Great Primer",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "IM Fell Great Primer SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Iceberg",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Iceland",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Imprima",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Inconsolata",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Inder",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Indie Flower",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Inika",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Irish Grover",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Istok Web",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Italiana",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Italianno",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jacques Francois",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jacques Francois Shadow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jim Nightshade",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jockey One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jolly Lodger",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Josefin Sans",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Josefin Slab",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Joti One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Judson",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Julee",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Julius Sans One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Junge",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Jura",
   "variants": [
    "300",
    "regular",
    "500",
    "600"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Just Another Hand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Just Me Again Down Here",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kameron",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Karla",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kaushan Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kavoon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Keania One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kelly Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kenia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Khmer",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kite One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Knewave",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kotta One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Koulen",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kranky",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kreon",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Kristi",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Krona One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "La Belle Aurore",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lancelot",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lato",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "League Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Leckerli One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ledger",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lekton",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lemon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Libre Baskerville",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Life Savers",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lilita One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Limelight",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Linden Hill",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lobster",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lobster Two",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Outline",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Shadow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Sketch",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Londrina Solid",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lora",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Love Ya Like A Sister",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Loved by the King",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lovers Quarrel",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Luckiest Guy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lusitana",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Lustria",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Macondo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Macondo Swash Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Magra",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Maiden Orange",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mako",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marcellus",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marcellus SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marck Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Margarine",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marko One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marmelad",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Marvel",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mate",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mate SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Maven Pro",
   "variants": [
    "regular",
    "500",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "McLaren",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Meddon",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "MedievalSharp",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Medula One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Megrim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Meie Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merienda",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merienda One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merriweather",
   "variants": [
    "300",
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Merriweather Sans",
   "variants": [
    "300",
    "regular",
    "700",
    "800"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metal",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metal Mania",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metamorphous",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Metrophobic",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Michroma",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Milonga",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miltonian",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miltonian Tattoo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miniver",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Miss Fajardose",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Modern Antiqua",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Molengo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Molle",
   "variants": [
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monda",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monofett",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monoton",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Monsieur La Doulaise",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montaga",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montez",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montserrat",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montserrat Alternates",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Montserrat Subrayada",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Moul",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Moulpali",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mountains of Christmas",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mouse Memoirs",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mr Bedfort",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mr Dafoe",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mr De Haviland",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mrs Saint Delafield",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mrs Sheppards",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Muli",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Mystery Quest",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Neucha",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Neuton",
   "variants": [
    "200",
    "300",
    "regular",
    "italic",
    "700",
    "800"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "New Rocker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "News Cycle",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Niconne",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nixie One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nobile",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nokora",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Norican",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nosifer",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nothing You Could Do",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noticia Text",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noto Sans",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noto Sans UI",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Noto Serif",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Cut",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Flat",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "greek",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Oval",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Round",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Slim",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nova Square",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Numans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Nunito",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Odor Mean Chey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Offside",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Old Standard TT",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oldenburg",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oleo Script",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oleo Script Swash Caps",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Open Sans",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "800",
    "800italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Open Sans Condensed",
   "variants": [
    "300",
    "300italic",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oranienbaum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Orbitron",
   "variants": [
    "regular",
    "500",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oregano",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Orienta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Original Surfer",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oswald",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Over the Rainbow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Overlock",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Overlock SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ovo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oxygen",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Oxygen Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Sans",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Sans Caption",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Sans Narrow",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Serif",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "PT Serif Caption",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pacifico",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Paprika",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Parisienne",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Passero One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Passion One",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Patrick Hand",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Patrick Hand SC",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Patua One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Paytone One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Peralta",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Permanent Marker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Petit Formal Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Petrona",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Philosopher",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Piedra",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pinyon Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pirata One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Plaster",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Play",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Playball",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Playfair Display",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Playfair Display SC",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Podkova",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Poiret One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Poller One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Poly",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pompiere",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Pontano Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Port Lligat Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Port Lligat Slab",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Prata",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Preahvihear",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Press Start 2P",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Princess Sofia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Prociono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Prosto One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Puritan",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Purple Purse",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quando",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quantico",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quattrocento",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quattrocento Sans",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Questrial",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quicksand",
   "variants": [
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Quintessential",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Qwigley",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Racing Sans One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Radley",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Raleway",
   "variants": [
    "100",
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700",
    "800",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Raleway Dots",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rambla",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rammetto One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ranchers",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rancho",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rationale",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Redressed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Reenie Beanie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Revalia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ribeye",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ribeye Marrow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Righteous",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Risque",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Roboto",
   "variants": [
    "100",
    "100italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "500",
    "500italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Roboto Condensed",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic",
    "vietnamese"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rochester",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rock Salt",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rokkitt",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Romanesco",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ropa Sans",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rosario",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rosarivo",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rouge Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruda",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rufina",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruge Boogie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruluko",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rum Raisin",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruslan Display",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Russo One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ruthie",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Rye",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sacramento",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sail",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Salsa",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sanchez",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sancreek",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sansita One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sarina",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Satisfy",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Scada",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Schoolbell",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Seaweed Script",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sevillana",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Seymour One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shadows Into Light",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shadows Into Light Two",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shanti",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Share",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Share Tech",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Share Tech Mono",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Shojumaru",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Short Stack",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Siemreap",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sigmar One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Signika",
   "variants": [
    "300",
    "regular",
    "600",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Signika Negative",
   "variants": [
    "300",
    "regular",
    "600",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Simonetta",
   "variants": [
    "regular",
    "italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sintony",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sirin Stencil",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Six Caps",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Skranji",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Slackey",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Smokum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Smythe",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sniglet",
   "variants": [
    "800"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Snippet",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Snowburst One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sofadi One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sofia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sonsie One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sorts Mill Goudy",
   "variants": [
    "regular",
    "italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Source Code Pro",
   "variants": [
    "200",
    "300",
    "regular",
    "500",
    "600",
    "700",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Source Sans Pro",
   "variants": [
    "200",
    "200italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "900",
    "900italic"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Special Elite",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Spicy Rice",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Spinnaker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Spirax",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Squada One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stalemate",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stalinist One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stardos Stencil",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stint Ultra Condensed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stint Ultra Expanded",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Stoke",
   "variants": [
    "300",
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Strait",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sue Ellen Francisco",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Sunshiney",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Supermercado One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Suwannaphum",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Swanky and Moo Moo",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Syncopate",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tangerine",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Taprom",
   "variants": [
    "regular"
   ],
   "subsets": [
    "khmer"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tauri",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Telex",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tenor Sans",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "cyrillic-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Text Me One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "The Girl Next Door",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tienne",
   "variants": [
    "regular",
    "700",
    "900"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tinos",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Titan One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Titillium Web",
   "variants": [
    "200",
    "200italic",
    "300",
    "300italic",
    "regular",
    "italic",
    "600",
    "600italic",
    "700",
    "700italic",
    "900"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trade Winds",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trocchi",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trochut",
   "variants": [
    "regular",
    "italic",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Trykker",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Tulpen One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ubuntu",
   "variants": [
    "300",
    "300italic",
    "regular",
    "italic",
    "500",
    "500italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ubuntu Condensed",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ubuntu Mono",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin-ext",
    "greek",
    "cyrillic-ext",
    "latin",
    "greek-ext",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Ultra",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Uncial Antiqua",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Underdog",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unica One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "UnifrakturCook",
   "variants": [
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "UnifrakturMaguntia",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unkempt",
   "variants": [
    "regular",
    "700"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unlock",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Unna",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "VT323",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vampiro One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Varela",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Varela Round",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vast Shadow",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vibur",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vidaloka",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Viga",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Voces",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Volkhov",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Vollkorn",
   "variants": [
    "regular",
    "italic",
    "700",
    "700italic"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Voltaire",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Waiting for the Sunrise",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wallpoet",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Walter Turncoat",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Warnes",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wellfleet",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wendy One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Wire One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yanone Kaffeesatz",
   "variants": [
    "200",
    "300",
    "regular",
    "700"
   ],
   "subsets": [
    "latin-ext",
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yellowtail",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yeseva One",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin-ext",
    "latin",
    "cyrillic"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Yesteryear",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  },
  {
   "kind": "webfonts#webfont",
   "family": "Zeyada",
   "variants": [
    "regular"
   ],
   "subsets": [
    "latin"
   ]
  }
 ]
}
',true);

return $allFontFromAPI['items'];
}	
	
	
/***************************************************************  
Include Visual Composer
***************************************************************/
	
//	if (!class_exists('WPBakeryVisualComposerAbstract')) {
//	  $dir = dirname(__FILE__) . '/wpbakery/';
//	  $composer_settings = Array(
//		  'APP_ROOT'      => $dir . '/js_composer',
//		  'WP_ROOT'       => dirname( dirname( dirname( dirname($dir ) ) ) ). '/',
//		  'APP_DIR'       => basename( $dir ) . '/js_composer/',
//		  'CONFIG'        => $dir . '/js_composer/config/',
//		  'ASSETS_DIR'    => 'assets/',
//		  'COMPOSER'      => $dir . '/js_composer/composer/',
//		  'COMPOSER_LIB'  => $dir . '/js_composer/composer/lib/',
//		  'SHORTCODES_LIB'  => $dir . '/js_composer/composer/lib/shortcodes/',
//		  'USER_DIR_NAME'  => 'vc_templates', /* Path relative to your current theme, where VC should look for new shortcode templates */
//		  //for which content types Visual Composer should be enabled by default
//		  'default_post_types' => Array('page', 'portfolio', 'post')
//	  );
//	  require_once locate_template('/wpbakery/js_composer/js_composer.php');
//	  $wpVC_setup->init($composer_settings);
//	}	

?>