<?php

// creating backgroundsection 

add_action('init', 'backgroundsection_register');
 
function backgroundsection_register() {
 
	$labels = array(
		'name' => __('BG sections', "sparse"),
		'singular_name' => __('Background section Item',  "sparse"),
		'add_new' => __('Add New',  "sparse"),
		'add_new_item' => __('Add New Background section Item', "sparse"),
		'edit_item' => __('Edit Background section Item', "sparse"),
		'new_item' => __('New Background section Item', "sparse"),
		'view_item' => __('View Background section Item', "sparse"),
		'search_items' => __('Search Background section', "sparse"),
		'not_found' =>  __('Nothing found', "sparse"),
		'not_found_in_trash' => __('Nothing found in Trash', "sparse"),
		'parent_item_colon' => ''
	);
 
	$args = array(
		'labels' => $labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array('title','editor','thumbnail', 'custom-fields')
	  ); 
 
	register_post_type( 'backgroundsection' , $args );
}

//backgroundsection editing

	add_action( 'admin_menu', 'hybrid_create_meta_box_backgroundsection' );
	add_action( 'save_post', 'hybrid_save_meta_data_backgroundsection' );

function hybrid_create_meta_box_backgroundsection() {
	global $theme_name;
	add_meta_box( 'post-meta-boxes_backgroundsection', __('Background section options', "sparse"), 'post_meta_boxes_backgroundsection', 'backgroundsection', 'normal', 'default' );
}


function hybrid_post_meta_boxes_backgroundsection() {
	
	/* Array of the meta box options. */
	$meta_boxes = array(	
			'section_bg_color' => array( 
							'name' => 'section_bg_color', 
							'title' => __(' Section background color.', 'sparse'), 
							'description' => __('Enter a background color for the section. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' ),
			'section_bg_image' => array( 
							'name' => 'section_bg_image', 
							'title' => __(' Section background image.', 'sparse'), 
							'description' => __('Enter image color for the section.[optional]', 'sparse'), 
							'type' => 'text' ),	
			'section_parallax' => array( 
							'name' => 'section_parallax', 
							'title' => __('Make background image parallax?', 'sparse'), 
							'description' => __('Select Yes to make background image parallax. Notice that the background image then needs to be higher then the section itself!', 'sparse'), 
							'type' => "select", 
							'std' => __('Yes','sparse'),
							'options' => array(__('Yes','sparse'),__('No','sparse'))),					
			'section_margin_bottom' => array( 
							'name' => 'section_margin_bottom', 
							'title' => __(' Section margin bottom.', 'sparse'), 
							'description' => __('Enter margin bottom for the section. Insert just number, without px. If empty no margin bottom will be set. [px]', 'sparse'), 
							'type' => 'text' ),
			'section_margin_top' => array( 
							'name' => 'section_margin_top', 
							'title' => __(' Section margin top.', 'sparse'), 
							'description' => __('Enter margin top for the section. Insert just number, without px. If empty no margin top will be set. [px]', 'sparse'), 
							'type' => 'text' ),
			'section_padding_top' => array( 
							'name' => 'section_padding_top', 
							'title' => __(' Section padding top.', 'sparse'), 
							'description' => __('Enter padding top for the section. Insert just number, without px. If empty no padding top will be set. [px]', 'sparse'), 
							'type' => 'text' ),
			'section_padding_bottom' => array( 
							'name' => 'section_padding_bottom', 
							'title' => __(' Section padding bottom.', 'sparse'), 
							'description' => __('Enter padding bottom for the section. Insert just number, without px. If empty no padding bottom will be set. [px]', 'sparse'), 
							'type' => 'text' ),
			'section_border_color' => array( 
							'name' => 'section_border_color', 
							'title' => __(' Section border color.', 'sparse'), 
							'description' => __('Enter color for section border. If color is set border 1px will be set to top and bottom. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' )			
	);

	return apply_filters( 'hybrid_post_meta_boxes_backgroundsection', $meta_boxes );
}




function post_meta_boxes_backgroundsection() {
	global $post;
	$meta_boxes = hybrid_post_meta_boxes_backgroundsection(); ?>

	<table class="form-table">
	<?php foreach ( $meta_boxes as $meta ) :

		$value = get_post_meta( $post->ID, $meta['name'], true );

		if ( $meta['type'] == 'text' )
			get_meta_text_input_backgroundsection( $meta, $value );
		elseif ( $meta['type'] == 'heading' )
			get_meta_heading_backgroundsection( $meta, $value );
		elseif ( $meta['type'] == 'textarea' )
			get_meta_textarea_backgroundsection( $meta, $value );
		elseif ( $meta['type'] == 'select' )
			get_meta_select_backgroundsection( $meta, $value );		
			elseif ( $meta['type'] == 'color' )
			get_meta_color_backgroundsection( $meta, $value );

	endforeach; ?>
	</table>
<?php
}


/**
 * Outputs a text input box with arguments from the
 * parameters.  Used for both the post/page meta boxes.
 *
 * @since 0.3
 * @param array $args
 * @param array string|bool $value
 */
function get_meta_text_input_backgroundsection( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span  style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php echo esc_html( $value );  ?>" size="30" tabindex="30" style="width: 97%;" />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

/**
 * Outputs a select box with arguments from the
 * parameters.  Used for__(' Type:', 'sparse'),  both the post/page meta boxes.
 *
 * @since 0.3
 * @param array $args
 * @param array string|bool $value
 */
function get_meta_select_backgroundsection( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<select style="width:100px;" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
			<?php foreach ( $options as $option ) : ?>
				<option <?php if ( htmlentities( $value, ENT_QUOTES ) == $option ) echo ' selected="selected"'; ?>>
					<?php echo $option; ?>
				</option>
			<?php endforeach; ?>
			</select>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

/**
 * Outputs a textarea with arguments from the
 * parameters.  Used for both the post/page meta boxes.
 *
 * @since 0.3
 * @param array $args
 * @param array string|bool $value
 */
function get_meta_textarea_backgroundsection( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>" cols="60" rows="4" tabindex="30" style="width: 97%;"><?php echo esc_html( $value );  ?></textarea>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_color_backgroundsection( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/admin/css/colorpicker.css" type="text/css" media="screen" />
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/admin/js/colorpicker.js"></script>	
		   #<input type="text" maxlength="6" size="6" name="<?php echo $name; ?>"  id="colorpickerField1" value="<?php echo esc_html( $value );  ?>"  />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}


function get_meta_heading_backgroundsection( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><h1 style="font-size:14px;"><?php echo $title; ?></h1><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>		
	</tr>
	<?php
}


/**
 * Loops through each meta box's set of variables.
 * Saves them to the database as custom fields.
 *
 * @since 0.3
 * @param int $post_id
 */
function hybrid_save_meta_data_backgroundsection( $post_id ) {
	global $post;

		$meta_boxes = array_merge( hybrid_post_meta_boxes_backgroundsection() );

	foreach ( $meta_boxes as $meta_box ) :
		if ( $meta_box['type'] != 'heading' ) {
				
		if ((!isset($_POST[$meta_box['name'] . '_noncename']))  || ( !wp_verify_nonce( $_POST[$meta_box['name'] . '_noncename'], plugin_basename( __FILE__ ) ) ))
			return $post_id;

			if ( 'page' == $_POST['post_type'] && !current_user_can( 'edit_page', $post_id ) )
				return $post_id;

			elseif ( 'post' == $_POST['post_type'] && !current_user_can( 'edit_post', $post_id ) )
				return $post_id;

			$data = stripslashes( $_POST[$meta_box['name']] );

			if ( get_post_meta( $post_id, $meta_box['name'] ) == '' )
				add_post_meta( $post_id, $meta_box['name'], $data, true );

			elseif ( $data != get_post_meta( $post_id, $meta_box['name'], true ) )
				update_post_meta( $post_id, $meta_box['name'], $data );

			elseif ( $data == '' )
				delete_post_meta( $post_id, $meta_box['name'], get_post_meta( $post_id, $meta_box['name'], true ) );
		}
	endforeach;	
}
?>