<?php
//page editing
	add_action( 'admin_menu', 'hybrid_create_meta_box_page' );
   add_action( 'save_post', 'hybrid_save_meta_data_page' );


function hybrid_create_meta_box_page() {
	global $theme_name;

	add_meta_box( 'page-meta-boxes', __('Page settings', "sparse"), 'page_meta_boxes', 'page', 'normal', 'default' );
}


function hybrid_page_meta_boxes() {

	/* Array of the meta box options. */
	$meta_boxes = array(
			'page-title-heading' => array( 
							'name' => 'page_title_heading', 
							'title' => __('Page Titles Options', 'sparse'), 
							'description' => __('Options for page titles.', 'sparse'), 
							'type' => "heading"),
			'show_page_title' => array( 
							'name' => 'show_page_title', 
							'title' => __('Show page title?', 'sparse'), 
							'description' => __('Select Yes to show page title.', 'sparse'), 
							'type' => "select", 
							'std' => __('Yes','sparse'),
							'options' => array(__('Yes','sparse'),__('No','sparse'))),					
			'page_title_height' => array( 
							'name' => 'page_title_height', 
							'title' => __('Page title height', 'sparse'), 
							'description' => __('Input page title height. Enter number only. If empty default(120) will be set. [optional].', 'sparse'), 
							'type' => "text"),	
			'page_title_alternative' => array( 
							'name' => 'page_title_alternative', 
							'title' => __('Page title', 'sparse'), 
							'description' => __('Input page title if you want it to be differnet than the page name is. [optional].', 'sparse'), 
							'type' => "text"),		
			'page_title_bg_color' => array( 
							'name' => 'page_title_bg_color', 
							'title' => __(' Page title background color.', 'sparse'), 
							'description' => __('Enter a background color for the page titles. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' ),
			'page_title_bg_image' => array( 
							'name' => 'page_title_bg_image', 
							'title' => __(' Page title background image.', 'sparse'), 
							'description' => __('Enter a background image for the page titles.[optional]', 'sparse'), 
							'type' => 'text' ),
			'show_page_bg_image_parallax' => array( 
							'name' => 'show_page_bg_image_parallax', 
							'title' => __('Parallax background?', 'sparse'), 
							'description' => __('Select Yes to make the background image for page titles parallax.', 'sparse'), 
							'type' => "select", 
							'std' => __('No','sparse'),
							'options' => array(__('Yes','sparse'),__('No','sparse'))),	
			'page_title_bg_tags' => array( 
							'name' => 'page_title_bg_tags', 
							'title' => __(' Page title background tags.', 'sparse'), 
							'description' => __('Enter background tags for the page titles. To have parallax enter backgound tag: fixed [optional]', 'sparse'), 
							'type' => 'text' ),
			'page_title_text_bg' => array( 
							'name' => 'page_title_text_bg', 
							'title' => __(' Page titles text background color.', 'sparse'), 
							'description' => __('Enter color for page titles text background. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' ),
			'page_title_text_bg1' => array( 
							'name' => 'page_title_text_bg1', 
							'title' => __(' Breadcrumbs background color.', 'sparse'), 
							'description' => __('Enter color for breadcrumbs background. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' ),		
			'page_title_color' => array( 
							'name' => 'page_title_color', 
							'title' => __(' Page titles color.', 'sparse'), 
							'description' => __('Enter color for page titles. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' ),			
			'breadcrumbs_color' => array( 
							'name' => 'breadcrumbs_color', 
							'title' => __(' Breadcrumbs color.', 'sparse'), 
							'description' => __('Enter color for breadcrumbs. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' ),
			'breadcrumbs_color_hover' => array( 
							'name' => 'breadcrumbs_color_hover', 
							'title' => __(' Breadcrumbs hover color.', 'sparse'), 
							'description' => __('Enter color for breadcrumbs hover. Insert it without #. [optional]', 'sparse'), 
							'type' => 'text' )						
		
	);

	return apply_filters( 'hybrid_page_meta_boxes', $meta_boxes );
}

function page_meta_boxes() {
	global $post;
	$meta_boxes = hybrid_page_meta_boxes(); ?>

	<table class="form-table">
	<?php foreach ( $meta_boxes as $meta ) :

		$value = stripslashes( get_post_meta( $post->ID, $meta['name'], true ) );

		if ( $meta['type'] == 'text' )
			get_meta_text_input_page( $meta, $value );
		elseif ( $meta['type'] == 'heading' )
			get_meta_heading( $meta, $value );
		elseif ( $meta['type'] == 'textarea' )
			get_meta_textarea_page( $meta, $value );
		elseif ( $meta['type'] == 'select' )
			get_meta_select_page( $meta, $value );

	endforeach; ?>
	</table>
<?php
}

function get_meta_text_input_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span  style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php echo esc_html( $value );  ?>" size="30" tabindex="30" style="width: 97%;" />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}


function get_meta_select_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<select style="width:90px;" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
			<?php foreach ( $options as $option ) : ?>
				<option <?php if ( htmlentities( $value, ENT_QUOTES ) == $option ) echo ' selected="selected"'; ?>>
					<?php echo $option; ?>
				</option>
			<?php endforeach; ?>
			</select>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}


function get_meta_color_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/functions/css/colorpicker.css" type="text/css" media="screen" />
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/jquery.js"></script>
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/colorpicker.js"></script>	
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/eye.js"></script>
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/functions/js/layout.js?ver=1.0.2"></script>
		   #<input type="text" maxlength="6" size="6" name="<?php echo $name; ?>"  id="colorpickerField1" value="<?php echo esc_html( $value );  ?>"  />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}



function get_meta_textarea_page( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>" cols="60" rows="4" tabindex="30" style="width: 97%;"><?php echo esc_html( $value );  ?></textarea>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_heading( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><h1 style="font-size:14px;"><?php echo $title; ?></h1><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>		
	</tr>
	<?php
}


function hybrid_save_meta_data_page( $post_id ) {
	global $post;
	
	$meta_boxes = array_merge( hybrid_page_meta_boxes() );
	foreach ( $meta_boxes as $meta_box ) :
	if ( $meta_box['type'] != 'heading' ) {	
			
		if ((!isset($_POST[$meta_box['name'] . '_noncename']))  || ( !wp_verify_nonce( $_POST[$meta_box['name'] . '_noncename'], plugin_basename( __FILE__ ) ) ))
			return $post_id;
		

		if ( 'page' == $_POST['post_type'] && !current_user_can( 'edit_page', $post_id ) )
			return $post_id;

		elseif ( 'post' == $_POST['post_type'] && !current_user_can( 'edit_post', $post_id ) )
			return $post_id;

		$data = stripslashes( $_POST[$meta_box['name']] );

		if ( get_post_meta( $post_id, $meta_box['name'] ) == '' )
			add_post_meta( $post_id, $meta_box['name'], $data, true );

		elseif ( $data != get_post_meta( $post_id, $meta_box['name'], true ) )
			update_post_meta( $post_id, $meta_box['name'], $data );

		elseif ( $data == '' )
			delete_post_meta( $post_id, $meta_box['name'], get_post_meta( $post_id, $meta_box['name'], true ) );
	}
	endforeach;	
}
?>