<?php

// creating pricing_columns 

add_action('init', 'pricing_columns_register');
 
function pricing_columns_register() {
 
	$labels = array(
		'name' => __('Pricing columns', "sparse"),
		'singular_name' => __('Pricing columns Item',  "sparse"),
		'add_new' => __('Add New',  "sparse"),
		'add_new_item' => __('Add New Pricing columns Item', "sparse"),
		'edit_item' => __('Edit Pricing columns Item', "sparse"),
		'new_item' => __('New Pricing columns Item', "sparse"),
		'view_item' => __('View Pricing columns Item', "sparse"),
		'search_items' => __('Search Pricing columns', "sparse"),
		'not_found' =>  __('Nothing found', "sparse"),
		'not_found_in_trash' => __('Nothing found in Trash', "sparse"),
		'parent_item_colon' => ''
	);
 
	$args = array(
		'labels' => $labels,
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'query_var' => true,
		'rewrite' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'menu_position' => null,
		'supports' => array('title','editor','thumbnail', 'custom-fields')
	  ); 
 
	register_post_type( 'pricing_columns' , $args );
}

//pricing_columns editing

	add_action( 'admin_menu', 'hybrid_create_meta_box_pricing_columns' );
	add_action( 'save_post', 'hybrid_save_meta_data_pricing_columns' );

function hybrid_create_meta_box_pricing_columns() {
	global $theme_name;
	add_meta_box( 'post-meta-boxes_pricing_columns', __('Pricing columns options', "sparse"), 'post_meta_boxes_pricing_columns', 'pricing_columns', 'normal', 'default' );
}


function hybrid_post_meta_boxes_pricing_columns() {
	
	/* Array of the meta box options. */
	$meta_boxes = array(	
			'pc_type' => array( 
							'name' => 'pc_type', 
							'title' => __('Type', 'sparse'), 
							'description' => __('Select type for pricing column.', 'sparse'), 
							'type' => "select", 
							'std' => __('type1','sparse'),
							'options' => array(__('type1','sparse'),__('type2','sparse'))),
			'pc_name' => array( 
							'name' => 'pc_name', 
							'title' => __(' Pricing column name.', 'sparse'), 
							'description' => __('Enter pricing table name.', 'sparse'), 
							'type' => 'text' ),
			'pc_best' => array( 
							'name' => 'pc_best', 
							'title' => __(' Best price text', 'sparse'), 
							'description' => __('Enter text for best price.', 'sparse'), 
							'type' => 'text' ),	
			'pc_color' => array( 
							'name' => 'pc_color', 
							'title' => __('Colot type?', 'sparse'), 
							'description' => __('Select color type.', 'sparse'), 
							'type' => "select", 
							'std' => __('Green','sparse'),
							'options' => array(__('Grey','sparse'),__('Blue','sparse'),__('Turquoise','sparse'),__('Green','sparse'),__('Orange','sparse'),__('Red','sparse'),__('Black','sparse'))),								
			'pc_legend' => array( 
							'name' => 'pc_legend', 
							'title' => __('Legend?', 'sparse'), 
							'description' => __('Select Yes if you want to mark the column as legend.', 'sparse'), 
							'type' => "select", 
							'std' => __('No','sparse'),
							'options' => array(__('No','sparse'),__('Yes','sparse'))),
			'pc_legend_text' => array( 
							'name' => 'pc_legend_text', 
							'title' => __(' Legend title', 'sparse'), 
							'description' => __('Enter legend title.', 'sparse'), 
							'type' => 'text' ),	
			'pc_price' => array( 
							'name' => 'pc_price', 
							'title' => __(' Price', 'sparse'), 
							'description' => __('Enter price. Enter number only.', 'sparse'), 
							'type' => 'text' ),								
			'pc_price' => array( 
							'name' => 'pc_price', 
							'title' => __(' Price', 'sparse'), 
							'description' => __('Enter price. Enter number only.', 'sparse'), 
							'type' => 'text' ),	
			'pc_currency' => array( 
							'name' => 'pc_currency', 
							'title' => __(' Currency', 'sparse'), 
							'description' => __('Enter currency symbol.', 'sparse'), 
							'type' => 'text' ),	
			'pc_per' => array( 
							'name' => 'pc_per', 
							'title' => __(' Per', 'sparse'), 
							'description' => __('Enter period.', 'sparse'), 
							'type' => 'text' ),	
			'pc_button_caption' => array( 
							'name' => 'pc_button_caption', 
							'title' => __(' Button caption', 'sparse'), 
							'description' => __('Enter button caption.', 'sparse'), 
							'type' => 'text' ),	
			'pc_button_value' => array( 
							'name' => 'pc_button_value', 
							'title' => __(' Button URL', 'sparse'), 
							'description' => __('Enter button URL.', 'sparse'), 
							'type' => 'text' )
	);

	return apply_filters( 'hybrid_post_meta_boxes_pricing_columns', $meta_boxes );
}




function post_meta_boxes_pricing_columns() {
	global $post;
	$meta_boxes = hybrid_post_meta_boxes_pricing_columns(); ?>

	<table class="form-table">
	<?php foreach ( $meta_boxes as $meta ) :

		$value = get_post_meta( $post->ID, $meta['name'], true );

		if ( $meta['type'] == 'text' )
			get_meta_text_input_pricing_columns( $meta, $value );
		elseif ( $meta['type'] == 'heading' )
			get_meta_heading_pricing_columns( $meta, $value );
		elseif ( $meta['type'] == 'textarea' )
			get_meta_textarea_pricing_columns( $meta, $value );
		elseif ( $meta['type'] == 'select' )
			get_meta_select_pricing_columns( $meta, $value );		
			elseif ( $meta['type'] == 'color' )
			get_meta_color_pricing_columns( $meta, $value );

	endforeach; ?>
	</table>
<?php
}


/**
 * Outputs a text input box with arguments from the
 * parameters.  Used for both the post/page meta boxes.
 *
 * @since 0.3
 * @param array $args
 * @param array string|bool $value
 */
function get_meta_text_input_pricing_columns( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span  style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<input type="text" name="<?php echo $name; ?>" id="<?php echo $name; ?>" value="<?php echo esc_html( $value );  ?>" size="30" tabindex="30" style="width: 97%;" />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

/**
 * Outputs a select box with arguments from the
 * parameters.  Used for__(' Type:', 'sparse'),  both the post/page meta boxes.
 *
 * @since 0.3
 * @param array $args
 * @param array string|bool $value
 */
function get_meta_select_pricing_columns( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<select style="width:100px;" name="<?php echo $name; ?>" id="<?php echo $name; ?>">
			<?php foreach ( $options as $option ) : ?>
				<option <?php if ( htmlentities( $value, ENT_QUOTES ) == $option ) echo ' selected="selected"'; ?>>
					<?php echo $option; ?>
				</option>
			<?php endforeach; ?>
			</select>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

/**
 * Outputs a textarea with arguments from the
 * parameters.  Used for both the post/page meta boxes.
 *
 * @since 0.3
 * @param array $args
 * @param array string|bool $value
 */
function get_meta_textarea_pricing_columns( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>
		<td>
			<textarea name="<?php echo $name; ?>" id="<?php echo $name; ?>" cols="60" rows="4" tabindex="30" style="width: 97%;"><?php echo esc_html( $value );  ?></textarea>
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}

function get_meta_color_pricing_columns( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><b><?php echo $title; ?></b><br/><span style="color:#777777;" ><?php echo $description; ?></span></label>
		</th>
		<td>
			<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/admin/css/colorpicker.css" type="text/css" media="screen" />
			<script type="text/javascript" src="<?php echo get_template_directory_uri(); ?>/admin/js/colorpicker.js"></script>	
		   #<input type="text" maxlength="6" size="6" name="<?php echo $name; ?>"  id="colorpickerField1" value="<?php echo esc_html( $value );  ?>"  />
			<input type="hidden" name="<?php echo $name; ?>_noncename" id="<?php echo $name; ?>_noncename" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
		</td>
	</tr>
	<?php
}


function get_meta_heading_pricing_columns( $args = array(), $value = false ) {

	extract( $args ); ?>

	<tr>
		<th style="width:30%;">
			<label for="<?php echo $name; ?>"><h1 style="font-size:14px;"><?php echo $title; ?></h1><span style="color:#777777;"><?php echo $description; ?></span></label>
		</th>		
	</tr>
	<?php
}


/**
 * Loops through each meta box's set of variables.
 * Saves them to the database as custom fields.
 *
 * @since 0.3
 * @param int $post_id
 */
function hybrid_save_meta_data_pricing_columns( $post_id ) {
	global $post;

		$meta_boxes = array_merge( hybrid_post_meta_boxes_pricing_columns() );

	foreach ( $meta_boxes as $meta_box ) :
		if ( $meta_box['type'] != 'heading' ) {
				
		if ((!isset($_POST[$meta_box['name'] . '_noncename']))  || ( !wp_verify_nonce( $_POST[$meta_box['name'] . '_noncename'], plugin_basename( __FILE__ ) ) ))
			return $post_id;

			if ( 'page' == $_POST['post_type'] && !current_user_can( 'edit_page', $post_id ) )
				return $post_id;

			elseif ( 'post' == $_POST['post_type'] && !current_user_can( 'edit_post', $post_id ) )
				return $post_id;

			$data = stripslashes( $_POST[$meta_box['name']] );

			if ( get_post_meta( $post_id, $meta_box['name'] ) == '' )
				add_post_meta( $post_id, $meta_box['name'], $data, true );

			elseif ( $data != get_post_meta( $post_id, $meta_box['name'], true ) )
				update_post_meta( $post_id, $meta_box['name'], $data );

			elseif ( $data == '' )
				delete_post_meta( $post_id, $meta_box['name'], get_post_meta( $post_id, $meta_box['name'], true ) );
		}
	endforeach;	
}
?>