/** 
 * UberMenu Sticky Menu Extension
 * Version 1.2.0
 */

jQuery( document ).ready(function( $ ){

	if( uberMenuStickySettings['mobile'] == '1' || !jQuery.uber_mobile ){
		var $megaMenu = $( "#megaMenu" );
		var offset = parseInt( uberMenuStickySettings['offset'] );
		if( isNaN( offset ) ) offset = 0;

		if( !uberMenuStickySettings['expand_menu_bar'] == 1 ){
			$megaMenu.css( 'max-width', $megaMenu.outerWidth() );
			$( window ).resize( function(){
				$megaMenu.css( 'max-width', $megaMenu.parent().outerWidth() );
			});
		}

		var wrapper = '<div id="megaMenu-sticky-wrapper">';
		if( jQuery.uber_mobile ){
			wrapper = '<div id="megaMenu-sticky-wrapper" class="uber-sticky-mobile" >';
			uberMenuSticky_fullHeight();
			$( window ).resize( function(){ uberMenuSticky_fullHeight(); });
		}

		var scroll_context = uberMenuStickySettings['scroll_context'] === '' ? window : uberMenuStickySettings['scroll_context'];
			$megaMenu.waypoint( 'sticky' , {
			wrapper: wrapper,
			stuckClass: 'ubermenu-sticky',
			offset: offset,
			context: scroll_context
		} );
	}
});

function uberMenuSticky_fullHeight(){
	var window_height = jQuery(window).outerHeight();
	var is_iOS = navigator.userAgent.toLowerCase().match(/(iphone|ipod|ipad)/);
	if( !is_iOS ) window_height = window_height - jQuery( '#megaMenuToggle' ).outerHeight();
	jQuery( '#megaMenu ul.megaMenu' ).height( window_height ); //.css( 'max-height' , max_height );
}


/*
Sticky Elements Shortcut for jQuery Waypoints - v2.0.2
Copyright (c) 2011-2013 Caleb Troughton
Dual licensed under the MIT license and GPL license.
https://github.com/imakewebthings/jquery-waypoints/blob/master/licenses.txt
*/
(function(){(function(t,n){if(typeof define==="function"&&define.amd){return define(["jquery","waypoints"],n)}else{return n(t.jQuery)}})(this,function(t){var n,s;n={wrapper:'<div class="sticky-wrapper" />',stuckClass:"stuck"};s=function(t,n){t.wrap(n.wrapper);return t.parent()};t.waypoints("extendFn","sticky",function(e){var i,r,a;r=t.extend({},t.fn.waypoint.defaults,n,e);i=s(this,r);a=r.handler;r.handler=function(n){var s,e;s=t(this).children(":first");e=n==="down"||n==="right";s.toggleClass(r.stuckClass,e);i.height(e?s.outerHeight():"");if(a!=null){return a.call(this,n)}};i.waypoint(r);return this.data("stuckClass",r.stuckClass)});return t.waypoints("extendFn","unsticky",function(){this.parent().waypoint("destroy");this.unwrap();return this.removeClass(this.data("stuckClass"))})})}).call(this);