var Router = {
	// Inspiration: http://joakimbeng.eu01.aws.af.cm/a-javascript-router-in-20-lines/
	arguments: {},
	app: null,
	
	init: function(options, app) {
		// Make sure we understand where all this content is going
		if (typeof options == 'undefined' || options == '') {
			console.debug('Router defaulting to "' + this.options + '" for target element ID');
		} else {
			this.options = options;
		}
		this.app = app;
		// Empty the args parameter, just in case
		this.arguments = {};
		// Set up routing
		this.startRouting();
	},
	
	currentRoute: function() {
		var url = (location.hash.slice(1) || '/').split('/');
		url.shift();
		this.app.previousRoute = this.app.currentRoute;
		if(typeof this.app.previousRoute === 'undefined') this.app.previousRoute = [];
		this.app.currentRoute = url;
		console.log(this.app.previousRoute, this.app.currentRoute);
		return url[0];
	},
	
	router: function() {
		var url = Router.currentRoute();
		Router.app.routes(url);
		// Set up our output element, and parse the hash to find our path and any additional arguments

	},
	
	startRouting: function() {
		// Set up listeners on hashchange and page load
		window.onhashchange = Router.router;
		window.addEventListener('load', this.router());
		return true;
	},
	
}