DAB['app'] = {
	fetchQueryResponses: function() {
		//This is the context of the application, it's the buttons,
		//the services, taxRates, users, etc.
		var context = DAB.context();
		var repairCats = ['02-16', '02-17', '02-18']; 
		var repairWPI = ['A', 'B', 'C'];
		var allQueries = [];
		context['model']['stateLoaded'] = false;
		var queryTitles = Object.keys(QueryResponses).forEach(function(title, i) {
			var obj = QueryResponses[title];
			var query = Websocket.query(obj['query'], obj['params']);
			allQueries.push(query)
			query.then(function(result) {
				QueryResponses[title] = Utility.parseResponse(result, '', obj['parseBy']);
				afterQuery(title, QueryResponses[title])
			});
		});
		
		Promise.all(allQueries).then(function(res) {
			context['model']['stateLoaded'] = true;
			context['app']['reDraw']();
		})
		
		function afterQuery(title, parsed) {
			switch (title) {
				case 'descCheckBoxes': 
					context['model']['descriptiveCat'] = {};
					var container = context['model']['descriptiveCat'];
					parsed.forEach(function(button) {
						if(!container.hasOwnProperty(button['U_Category'])) container[button['U_Category']] = [];
						container[button['U_Category']].push({
							'id': button['U_Code'],
							'display': button['U_Description']
						})
					})
				break;
				case 'checkBoxes':
					context['model']['servicesCat'] = {};
					context['model']['servicesRepair'] = {
						'A': {},
						'B': {},
						'C': {}
					};
					var container = context['model']['servicesCat'];
					parsed.forEach(function(button) {
						addToContainer(container, button);
						if(repairCats.indexOf(button['U_Category']) !== -1) {
							addRepair(button, button['ItemCode'])
						}
					})
					
					function addRepair(button, code) {
						var serviceRepair = context['model']['servicesRepair'];
						if(serviceRepair.hasOwnProperty(code[3])) {
							var container = serviceRepair[code[3]];
							addToContainer(container, button);
						} else {
							repairWPI.forEach(function(c) {
								var container = serviceRepair[c];
								addToContainer(container, button);
							})
						}
						
					}
					function addToContainer(container, button) {
						if(!container.hasOwnProperty(button['U_Category'])) container[button['U_Category']] = [];
						var display = button['ItemName']
						if(button['ItemCode'][0] === '7') {
							if(display !== null && display.indexOf('Pad:') !== -1) {
								var padIndex = display.indexOf('Pad:')
								display = display.substr(padIndex + 5)
							} 
						}
						container[button['U_Category']].push({
							'id': button['ItemCode'],
							'display': display
						})
					}
				break
			}
		}
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Routing Functions--------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	dispatchRoute: function(route) {
		//This function sets the main view that will be rendered in the main view within the app.
		var context = DAB.context();
		var viewToRender;
		switch(route) {
			case 'login':
				viewToRender = 'loginPage';
				break
			case 'search': 
				viewToRender = 'searchPage';
				break;;
			case 'summary':
				if(context['route'][2] === 'edit') {
					viewToRender = 'clientEditPage';
				} else {
					viewToRender = 'summaryPage';
				}
				break
			case 'addclient':
				viewToRender = 'newClientPage';
				break
			case 'workorder':
				if(context['route'][3] === 'edit') {
					viewToRender = 'clientEditPage';
				} else {
					viewToRender = 'workOrderPage';					
				}
				break;
			case 'users':
				viewToRender = 'usersPage';
				break;
			case 'commissions':
				viewToRender = 'commissionsPage';
				break;
			case 'invoice':
				viewToRender = 'invoicePage';
				break
			case 'pdf':
				viewToRender = 'pdfPage';
				break;
		}
		context['app']['viewToRender'] = context['components'][viewToRender];
	},
	
	reDraw: function() {
		//This is the main function to be called after attributes/models are changed to draw the 
		//view again.
		var context = DAB.context();
		m.render(document.getElementById('header'), context['components']['headers'](context['app']['headerConfiguration']()));
		var view = [context['app']['viewToRender']()]
		if(context['model']['modalOption'] !== '')  {
			var modalOption = context['components']['modal'](context['components']['modalOption'](context['model']['modalOption']));
			view = [modalOption, view];
		}
		if(context['model']['notifications'].length !== 0) {
			view.push(context['components']['notify'](context['model']['notifications']))
		}
		var contentDiv = document.getElementById('content');
		m.render(contentDiv, view);
		context['app']['resizeDiv']();	
	},
	
	addNotification: function(notification, timeout) {
		//notification is the msg to be displayed, timeout is the amount of timeout it'll be on
		var context = DAB.context();
		var notifications = context['model']['notifications']; 
		notifications.push(notification);
		var index = notifications.length - 1
		setTimeout(removeIndex, timeout)
		context['app']['reDraw']();
		function removeIndex() {
			context['model']['notifications'].splice(index, 1);
			context['app']['reDraw']();
		}
	},
	
	setRoute: function(arr) {
		//function which utilizes an array to set the url for page.
		var route = '';
		arr.forEach(function(el) {
			if(el !== '') {
				route += '/';
				route += el;				
			}
		})
		route += '/';
		window.location.hash = route;
	},
	
	appendRoute: function(name) {
		window.location.href += name + '/' 
	},
	
	headerRoute: function(route) {
		var context = DAB.context();
		if(context['route'][0] === 'pdf') {
			var contentDiv = document.getElementById('content');
			contentDiv.classList.remove('overflowtallfix');
		}
		//this function is to make exceptions for routes, such as prompting user if they
		//want to lose their current work;
		if(context['route'][0] !== 'workorder' && context['route'][2] !== 'edit') return setRoute();
		context['model']['modalOption'] = 'confirmModal';
		context['model']['confirmMessage'] = 'Navigating away from document will lose unsaved work';
		context['model']['confirm'] = function() {
			setRoute();
			removeModal();
		}
		context['model']['cancel'] = removeModal
		context['app']['reDraw']();
		
		function removeModal() {
			context['model']['modalOption'] = '';
			context['model']['confirm'] = null;
			context['app']['reDraw']();
		}
		
		function setRoute() {
			context['app']['setRoute'](route);
		}
		console.log(route);
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Login Functions----------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	login: function() {
		var context = DAB.context();
		context['model']['currentModel'] = {
			'username': 's.dix',
			'password': 'pass'
		}
		context['app']['reDraw']();
	},
		
	loginSubmit: function() {
		// var formValidate = app.validateFields('.loginPage');
		// if(formValidate === false) return;
		var context = DAB.context();
		var currentModel = context['model']['currentModel'];
		var user = Websocket.query('GetUserCredentials', { 'User' : currentModel['username'] })
		user.then(function(result) {
			if(result['Data']['Result']['Result']['Rows'].length === 0) {
				// app.notifications('alert', 'Failed to Login!');
				return;
			}
			var userObj = Utility.parseResponse(result, '')[0]
			var hash = userObj['password'];
			var compare = TwinBcrypt.compareSync(currentModel['password'], hash)
			if(compare) {
				window.location.href = '#/search/';
				// app.notifications('success', 'Success!')
				context['model']['currentUser'] = userObj;
				Utility.storage.setObject('userDAB', userObj);
			} else {
				context['app'].addNotification('Failed to Login!', 3000);
			}
		})
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Search Functions---------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	search: function() {
		var context = DAB.context();
		context['model']['clientLoadedCardCode'] = '';
		context['conf']['searchPageConf']();				
		if(context['route'][1] !== '') {
			context['app']['searchTypes']();
		} else {
		}
		context['app']['reDraw']();
	},
	
	searchTypes: function() {
		//This is a context function for the search page
		//these parameters within the searchOptions variable
		//are the ones passed as the config for dataTable component.
		var context = DAB.context();
		var parameters = {};
		var searchOptions = {
			'client': {
				'query': 'GetContactSimple',
				'params': ['firstName', 'lastName', 'email', 'phone', 'cardCode'],
				'colName': ['Client Name', 'Contact First Name', 'Contact Last Name', 
					'Client Code', 'Client Type', 'Phone', 'Email', 'Address', 'City', 'Zip Code'],
				'hiddenCol': [0,5,12,13,14,15]
			},
			'company': {
				'query': 'GetContactCompany',
				'params': ['SearchParam'],
				'colName': ['Client Name', 'Contact First Name', 'Contact Last Name', 
					'Client Code', 'Client Type', 'Phone', 'Email', 'Address', 'City', 'Zip Code'],
				'hiddenCol': [0,5,12,13,14,15]
			},
			'document': {
				'query': 'GetDocumentSimple',
				'params': ['docId', 'poNum', 'sidemark'],
				'colName': ['Status', 'Document #', 'Client', 'Client Id', 'Order Type', 
					'Rec\'d Date', 'Taken By', 'Placed By', 'S/M', 'PO #'],
				'hiddenCol': [0,1]
			},
			'pdf': {
				'query': 'GetSapDocSimple',
				'params': ['cardCode', 'clientName']
			},
			'invoice': {
				'query': 'GetInvoiceSimple',
				'params': ['clientCode', 'company', 'docId'],
				'colName': ['Document #', 'Order Type', 'Client Code', 'Client Name', 'Invoice Date',
				'Total Amount', 'Paid To Date', 'Balance'],
				'hiddenCol': [0,1,2, 8]
			}
		}
		var currentSearch = searchOptions[context['route'][1]];
		if(context['route'].length !== 1) {
			context['model']['tableLoading'] = true;
			var paramToParse = context['route'].splice(2, currentSearch['params'].length);
			paramToParse.forEach(function(el, i) {
				parameters[currentSearch['params'][i]] = el;
			})
			Websocket.query(currentSearch['query'], parameters).then(function(res) {
				var dates = ['createDate', 'dueDate'];
				context['model']['tableLoading'] = false;
				context['app']['reDraw']();
				var data = res['Data']['Result']['Result'];	
				if(context['route'][1] === 'invoice') {
					data['Rows'].map(function(row) {	
						row[7] = Utility.formatDate(row[7]);
						row[8] = Utility.formatDate(row[8]);
						return row;
					})
				}
				data['colNames'] = currentSearch['colName'];							
				if(currentSearch.hasOwnProperty('hiddenCol')) data['hiddenCol'] = currentSearch['hiddenCol'];
				var table = context['components']['tableComponent']({
					'data': data,
					'dataType': 'tableStructure',
					'mountNode': document.getElementById('table_search'),
					'pagination': 10,
					'fnOnRowDbl': context['app']['selectSearchRow']
				})
			})				
		}
	},
	
	selectSearchRow: function(row) {
		//generic binding function for searchRow click
		var context = DAB.context();
		context['model']['selectedRow'] = row;
		switch(context['route'][1]) {
			case 'client':
				context['app']['setRoute'](['summary', row['CardCode']]);	
				break;
			case 'company': 
				context['app']['setRoute'](['summary', row['CardCode']]);	
				break;
			case 'document':
				context['app']['setRoute'](['workorder', row['cardCode'], row['DocEntry']]);	
				break;
			case 'invoice':
				context['app']['setRoute'](['workorder', row['Client Code'], row['woKey']]);	
				break
		}
		
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Client Summary Functions-------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	clientSummary: function() {
		context = DAB.context();
		if(context['model']['clientLoadedCardCode'] !== context['route'][1]) {
			DAB['model']['currentModel'] = {};
			context['model']['headerInfo'] = {};
			context['app']['loadHeader'](context['route'][1]);			
		}
		var workOrders = Websocket.query('WorkOrderFromContact', {'CardCode': context['route'][1]});
		workOrders.then(function(res) {
			var data = res['Data']['Result']['Result'];
			if(data['Rows'].length === 0) {
				context['model']['currentModel']['noResults'] = true;
				return context['app']['reDraw']();
			}
			data['colNames'] = ['Document #', 'Order Type', 
			'Received Date', 'Due Date','Taken By', 'Placed By', 
			'Sidemark', 'Order Status', 'Total', 'Balance', ''];
			data['hiddenCol'] = [0, 2, 13, 14, 15, 16, 17, 18];
			data['Rows'] = data['Rows'].map(function(row) {
				var dates = [4,5];
				dates.forEach(function(dateIndex) {
					row[dateIndex] = Utility.formatDate(row[dateIndex]);
				})
				return row;
			})
			var table = context['components']['tableComponent']({
				'data': data,
				'dataType': 'tableStructure',
				'mountNode': document.getElementById('summary_table'),
				'pagination': 10,
				'sortButtons': [
					{
						'title': 'Document Type:',
						'index': 2,
						'options': [
							['SP', 'Service Proposal'],
							['WO', 'Workorder'],
							['CS', 'Reservice']
						]
					}
				],
				'fnOnRowClick': context['app']['showInfo'],
				'fnOnRowDbl': context['app']['openWO'],
				'clickHide': false,
				'classForRow': classForRow()
			})
			if(context['route'][2] !== '') {
				var parseData = Utility.parseResponse(res);
				var woIndex = context['app']['searchArray'](parseData, 'DocEntry', parseInt(context['route'][2]));
				context['model']['currentModel']['rowSelected'] = parseData[woIndex];
			}
			context['app']['reDraw']()
			
			function classForRow() {
				return [
					{
						'conditions': [['U_DABWOType', 'SP'], ['Status', 'WC']],
						'className': ' finished'
					},
					{
						'conditions': [['Status', 'CL']],
						'className': ' cancelled'
					},
					{
						'conditions': [['Status', 'INV'], ['due', '$0.00']],
						'className': ' finished'
					},
					{
						'conditions': [['Status', 'INV'], ['isDue', 'Y']],
						'className': ' uk-text-danger'
					}
				]
			}
		})
		if(context['route'][2] !== '') {
			var workDesc = Websocket.query('GetDescServWO', {'WorkOrder': context['route'][2]});
			workDesc.then(function(res) {
				var data = res['Data']['Result']['Result'];
				if(data['Rows'].length === 0) {
					return m.render(document.getElementById('summary_row'), [m('hr'), m('h2','No Service Information Recorded'), m('hr')]);
				}
				var dateTypes = [9,10,11,12];
				data.Rows = data.Rows.map(function(row) {
					return row.map(function(cel, i) {
						if(dateTypes.indexOf(i) !== -1) return Utility.formatDate(cel);
						if(i === 2) return formatMsr(row);
						return cel
					})
				})
				data['colNames'] = ['Item #', 'Service Description', 'Size/Qty/LnFt', 'Item Status', 'Due Date',
				'Completion Date']
				data['hiddenCol'] = [3,4,5,6,7,14];
				if(data['Rows'][0][14] === 'SPD') {
					data['colNames'].push('Pickup Date');
					data['colNames'].push('Delivery Date');
				} else {
					data['hiddenCol'].push(11);
					data['hiddenCol'].push(12);
					if(data['Rows'][0][14] === 'ONLO') {
						data['colNames'][4] = 'Service Date';
					}
				}
				data['colNames'].push('Cost');
				var subTable = context['components']['tableComponent']({
					'data': data,
					'dataType': 'tableStructure',
					'mountNode': document.getElementById('summary_row'),
					'pagination': 10
				})
			})
			context['app']['reDraw']();
			
			function formatMsr(row) {
				if(row[7] === 'Square Foot') return row[5] + '\'' + row[6] + '" x '  +  row[3] + '\'' + row[4] + '"';
				if(row[7] === 'Leneal Foot') return row[5] + '\'' + row[6] + '"';
				if(row[7] === 'Percent') return '';
				return row[2];
			}
		}
		context['app']['reDraw']()
	},
	
	loadHeader: function(cardCode) {
		var headerInfo = Websocket.query('GetContactCardCode', {'SearchParam': cardCode});
		headerInfo.then(function(res) {
			var context = DAB.context();
			var info = Utility.parseResponse(res)[0];
			var headerInfo = context['app'].parseHeaderInfo(info);
			context['model']['currentModel']['headerInfo'] = headerInfo;
			context['model']['currentModel']['currentClient'] = info;
			var stickyNotes = Websocket.query('GetContactStickyNotes', {'CardCode': cardCode});
			stickyNotes.then(function(res) {
				var notes = Utility.parseResponse(res);
				context['model']['currentModel']['stickyNotes'] = notes;
				context['model']['clientLoadedCardCode'] = cardCode;
				context['app'].reDraw();	 				
			});
		});
	},
	
	showInfo: function(row) {
		context = DAB.context();
		context['model']['currentModel']['rowSelected'] = row;
		context['app']['setRoute'](['summary', context['route'][1], row['DocEntry']]);
	},
	
	openWO: function(row) {
		context = DAB.context();
		context['app']['setRoute'](['workorder', context['route'][1], row['DocEntry']]);
	},
			
	headerConfiguration: function() {
		//header configuration is how what is displayed on the header is set up.
		//mainTitle is what is shown on the left side of the header, as well as
		//subTitle, routes are setup in such a way to be configs for
		//DAB.components.headers.
		var context = DAB.context();
		var currentUser = context['model']['currentUser'];
		var header = {
			'login': {
				'routes': [],
			},
			'search': {
				'routes': [],
				'mainTitle': 'Main Search',
				'subTitle': 'search application database'
			},
			'summary': {
				'routes': [
					{
						'routeToGo': ['search'],
						'msg': ' Back to Search',
						'subMsg': 'search application database',
						'icon': 'arrow-circle-left'
					}
				],
				'mainTitle': context['route'][1] + ' Summary',
				'subTitle': 'add a new client'
			},
			'addclient': {
				'routes': [
					{
						'routeToGo': ['search'],
						'msg': ' Back to Search',
						'subMsg': 'search application database',
						'icon': 'arrow-circle-left'
					}
				],
				'mainTitle': 'Client Management',
				'subTitle': 'add a new client'
			},
			'workorder': {
				'routes': [
					{
						'routeToGo': ['summary', context['route'][1]],
						'msg': ' Back to Summary',
						'subMsg': 'view client summary',
						'icon': 'arrow-circle-left'
					},
					{
						'routeToGo': ['search'],
						'msg': ' Back to Search',
						'subMsg': 'search for clients',
						'icon': 'arrow-circle-left'
					}
				],
				'mainTitle': 'Enter Document',
				'subTitle': 'Add or Edit Document'
			},
			'users': {
				'routes': [{
					'routeToGo': ['search'],
					'msg': ' Back to Search',
					'subMsg': 'search for clients',
					'icon': 'arrow-circle-left'
				}],
				'mainTitle': 'User Management',
				'subTitle': 'Add or Edit Users'
			},
			'commissions': {
				'routes': [{
					'routeToGo': ['search'],
					'msg': ' Back to Search',
					'subMsg': 'search for clients',
					'icon': 'arrow-circle-left'
				}],
				'mainTitle': 'Commission Management',
				'subTitle': 'manage commissions'
			},
			'invoice': {
				'routes': [{
					'routeToGo': ['search'],
					'msg': ' Back to Search',
					'subMsg': 'search for clients',
					'icon': 'arrow-circle-left'
				}],
				'mainTitle': 'Commission Management',
				'subTitle': 'manage commissions'
			},
			'pdf':  {
				'routes': [{
					'routeToGo': ['search'],
					'msg': ' Back to Search',
					'subMsg': 'search for clients',
					'icon': 'arrow-circle-left'
				}],
				'mainTitle': 'PDF View',
				'subTitle': 'Current PDF'
			}
		}
		var currentConf = header[DAB['currentRoute'][0]];
		if(context['route'][0] !== 'login' && (currentUser['isAdmin'] === 'Y' || currentUser['isManager'] === 'Y')) {
			if(context['route'][0] !== 'commissions') {
				currentConf['routes'].push({
					'routeToGo': ['commissions'],
					'msg': ' Commissions',
					'subMsg': 'manage commissions',
					'icon': 'money'
				});	
			}

			if(currentUser['isAdmin'] === 'Y' && context['route'][0] !== 'users'){
				currentConf['routes'].push({
					'routeToGo': ['users'],
					'msg': ' User Management',
					'subMsg': 'manage user permissions',
					'icon': 'user'
				});	
			}
		}
		currentConf['routes'] = currentConf['routes'].map(function(routeObj) {
			routeObj['fnOnClick'] = context['app']['headerRoute'];
			return routeObj;
		}) 
		if(context['route'][0] !== 'login') {
			currentConf['routes'].push({
				'routeToGo': ['login'],
				'msg': ' Logout',
				'subMsg': 'Log out from application',
				'icon': 'sign-out',
				'fnOnClick': context['app']['headerRoute']
			})
		}
		return currentConf;
	},
	
	logout: function() {
		var context = DAB.context();
		context['model']['currentUser'] = {};
		context['app']['setRoute'](['login']);
	},
	
	addClient: function() {
		var context = DAB.context();
		context['model']['currentClient'] = {};
		context['model']['newClient'] = context['model'].newClientModel();
		context['model']['newNote'] = context['model'].newNoteModel();
		context['app']['reDraw']();
	},
	
	getClientInformation: function(cardCode) {
		var context = DAB.context();
		context['model']['currentClient'] = context['model']['clientModel']();
		context['model']['newNote'] = context['model'].newNoteModel();
		var model = context['model']['currentClient'];
		context['model']['attachmentRetrieve'](model, 'ContactFile', cardCode);
		var queries = ['GetMoreContactInfo', 'GetCustomerAddresses', 'GetCustomerContacts', 'GetContactPersonNotes'];
		var populate = ['ClientInfo', 'Addresses', 'Contacts', 'notes'];
		var main = queries.map(function(query, i) {
			return Websocket.query(query, {'CardCode': cardCode}).then(function(res) {
				parseAfter(res, i);
			})	
		})
		
		Promise.all(main).then(function(res) {
			context['app']['reDraw']();
		})
		
		function parseAfter(res, index) {
			var pop = populate[index];
			var parsed = Utility.parseResponse(res);
			parsed = parsed.map(function(obj) {
				return context['app']['nullsToEmptyString'](obj);
			})
			if(pop === 'ClientInfo') {
				parsed = parsed[0];
				console.log(parsed);
				if(context['route'][0] === 'workorder' && parsed['PermitExp'] !== '') {
					var permitExp = new Date(parsed['PermitExp']);
					var current = new Date(context['app']['rightNow']());
					if(permitExp.getTime() < current.getTime()) {
						context['model']['modalOption'] = 'permitExpired';
						context['app']['reDraw']();
					} else {
						context['currentModel']['workOrderHeader']['hasPermit'] = 'Y';
					}
				}
			}
			model[pop] = parsed;
		}
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------WorkOrder Functions------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	workOrder: function() {
		var context = DAB.context();
		var noNewModel = context['route'][3] === 'edit' || context['previousRoute'][3] === 'edit'
		if(!noNewModel) {
			console.log(context['route'][2])
			context['model']['newNote'] = context['model'].newNoteModel();
			context['model']['currentModel'] = context['model']['newCurrentModel']();
			context['model']['currentModel']['newPayment'] = context['model']['newPaymentModel']();
			context['model']['state'] = context['model']['newCurrentState']();
			context['app']['loadHeader'](context['route'][1]);
			context['model']['baseWorkOrder']();
			if(context['route'][2] !== 'new') {
				context['model']['loadWorkOrder'](context['route'][2])
			}
		}
		context['app']['getClientInformation'](context['route'][1]);
		context['app']['setDropZone']();
		context['app']['reDraw']();
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Job Summary Functions----------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	summaryView: function() {
		var context = DAB.context();
		var summaryType = context['app']['route'][2];
		var clientHeader = context['conf']['clientHeader']();
		if(summaryType === 'contact') {
			var summaryTable = Websocket.query(DAB.wsConfig.repo, 'DAB.Rug.GetDocsContact',
			{'contact': context['app']['route'][3]});
			summaryTable.then(function(res) {
				var data = res['Data']['Result']['Result'];
				if(data['Rows'].length === 0) {
					addNew();
				} else {
					data['Rows'] = data['Rows'].map(function(row) {
						row[3] = Utility.formatDate(row[3]);
						return row;
					})
					data['colNames'] = ['Code', 'Document Type', 'Service Type', 'Date Created'];
					var table = context['components'].tableComponent({
						'data': data,
						'dataType': 'tableStructure',
						'mountNode': document.getElementById('search_component'),
						'pagination': 5,
						// 'fnOnRowDbl': DAB.app.selectJob
					})						
				}
			})
			return [
			context['components']['clientHeader'](clientHeader),
			m('h2', 'New Document'),
			addNewDocumentButton(),
			m('h2', 'Current Documents'),
			m('div', {'id': 'search_component'})]
		}
		
		function addNewDocumentButton() {
			console.log(context['model']['currentModel']['currentClient']);
			return [
				m('button',
					{'className': 'uk-button',
						'onclick': addNew
					},
				'Add New Document'),
				m('hr')
			]
		}
		
		function addNew() {
			window.location.hash = '/rugs/job/' + context['app']['route'][3] + '/new/';
		}
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Users Functions----------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	users: function() {
		var context = DAB.context();
		var query = Websocket.query('GetAppUsers',{});
		context['model']['tableLoading'] = true;
		context['model']['currentModel'] = {
			'data': false,
			'userSelected': '',
			'userObj': {},
			'promise': query
		}
		context['app']['reDraw']();
		query.then(function(res) {
			var data = res['Data']['Result']['Result'];
			res['Data']['Result']['Result']['Columns'].forEach(function(col) {
				console.log(col['Name'])
			})
			data['colNames'] = ['User Id', 'Username', 'First Name', 'Last Name', 'Display Name', 'Is Admin', 'Is Manager', 'Active']
			data['hiddenCol'] = [5,6,7,8,9,10,11,12] 
			context['model']['currentModel']['data'] = data;
			context['model']['tableLoading'] = false;
			context['app']['reDraw']();
			// data['colNames'] = currentSearch['colName'];
			// if(currentSearch.hasOwnProperty('hiddenCol')) data['hiddenCol'] = currentSearch['hiddenCol'];
			
		})
	},
	
	createUserTable: function(el, isInit, context) {
		var context = DAB.context();
		if(context['currentModel']['data'] === false) return; 
		var table = context['components']['tableComponent']({
			'data': context['currentModel']['data'],
			'dataType': 'tableStructure',
			'mountNode': el,
			'pagination': 7,
			'clickHide': false,
			'fnOnRowClick': context['app']['userManagement']
		})			
		
	},
	
	userManagement: function(sel) {
		var context = DAB.context();
		context['currentModel']['issues'] = [];
		context['currentModel']['userSelected'] = sel['User Number'];
		context['currentModel']['userObj'] = context['app']['objectCopy'](sel);
		context['currentModel']['userObj']['password'] = '';
		context['currentModel']['userObj']['password2'] = '';
		context['currentModel']['userObj']['managerSwitch'] = 'N';
		console.log(context['currentModel']['userObj']);
		if(context['currentModel']['userObj']['manager'] === 'Y') {
			context['currentModel']['group'] = [''];
			context['app']['loadGroups'](context['currentModel']['userObj']['key']);
		}
		context['app']['reDraw']();
	},
	
	loadGroups: function(key) {
		var context = DAB.context();
		context['currentModel']['currentGroups'] = 'isLoading';
		Websocket.query('GetManagerGroup', {'managerCode': key}).then(function(res) {
			var groups = Utility.parseResponse(res);
			groups.forEach(function(group, i) {
				if(group['active'] === 'Y') {
					if(i === 0) {
						context['currentModel']['group'][0] = group['userCode']
					} else {
						context['currentModel']['group'].push(group['userCode']);
					}						
				}
			})
			context['currentModel']['currentGroups'] = groups;
			context['app']['reDraw']();
		})
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Commission Functions-----------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	commissions: function() {
		var context = DAB.context();
		context['model']['currentModel'] = {
			'commissionSearch': {
				'sDate': '',
				'eDate': '',
				'document': ''
			},
			'selectedComm': ''
		}
		context['app']['reDraw']();
	},
	
	searchCommission: function(e) {
		var context = DAB.context();
		e.stopPropagation();
		context['currentModel']['lastSearch'] = context['app']['objectCopy'](context['currentModel']['commissionSearch']);
		context['app']['createCommissionTable'](context['currentModel']['commissionSearch']);
	},
	
	createCommissionTable: function(params) {
		var context = DAB.context();
		context['model']['tableLoading'] = true;
		context['app']['reDraw']();
		var query = 'GetCommissionSimple';
		if(context['model']['currentUser']['isManager'] === 'Y') {
			query = 'GetCommissionGroup';
			params['managerCode'] = context['model']['currentUser']['User Number'];
		}
		Websocket.query(query, params).then(function(res) {
			context['model']['tableLoading'] = false;
			context['app']['reDraw']();
			var data = res['Data']['Result']['Result'];
			data['Rows'] = data['Rows'].map(function(row) {
				row[2] = Utility.formatDate(row[2]);
				return row;
			})
			data['colNames'] = ['Completion Date', 'Document', 'Client', 'Item', 'Serv Code', 
			'Serv Name', 'Recipient', 'Comm Type', 'Dist', 'Base Amount', 'Comm %', 
			'Comm % Dist', 'Comm Amt Total', 'Comm Amt Dist']
			data['hiddenCol'] = [0,1] 
			context['model']['table'] = context['components']['tableComponent']({
				'data': data,
				'dataType': 'tableStructure',
				'mountNode': document.getElementById('commission_search'),
				'pagination': 7,
				'clickHide': false,
				'fnOnRowClick': context['app']['selectCommission']
			})			
		})
	},
	
	selectCommission: function(obj) {
		var context = DAB.context();
		context['currentModel']['selectedComm'] = obj;
		context['currentModel']['selectedComm']['overWrite'] = context['model']['currentUser']['User Number'];
		console.log(context['model']['currentUser']['User Number'])
		context['currentModel']['selectedComm']['commOrig'] = context['currentModel']['selectedComm']['commAmt']; 
		context['app']['reDraw']();
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Invoice Functions--------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	invoice: function() {
		var context = DAB.context();
		context['model']['currentModel'] = {
			'paymentApplied': [],
			'newPayment': context['model']['newPaymentModel'](),
			'invoiceDocEntry': '',
			'workOrderHeader': {
				'cardCode': '',
				'viewOnly': false,
				'total': 0,
				'documentName': ''
			}
		}
		Websocket.query('GetInvoiceSingle', {'workorder': context['route'][1]}).then(function(res) {
			var invoice = Utility.parseResponse(res)[0];
			context['model']['currentModel']['invoiceDocEntry'] = invoice['invKey'];
			context['model']['currentModel']['workOrderHeader']['cardCode'] = invoice['Client Code'];
			context['model']['currentModel']['workOrderHeader']['documentName'] = invoice['docName'];
			context['model']['currentModel']['workOrderHeader']['total'] = invoice['total'];
			context['model']['stateLoaded'] = true;
			context['app']['reDraw']();
		})
		context['model']['stateLoaded'] = false;
		context['model']['loadPaidRows'](context['route'][2]);
		context['app']['reDraw']();
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Email Functions----------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	mailTriggerDefinition: function() {
		//these are mail trigger definitions according to different statuses of
		//the workorder process
		var context = DAB.context();
		var emailLater = [];
		var emailNow = null;
		var rightNow = context['app']['rightNow']();
		var header = context['currentModel']['workOrderHeader'];
		var hasNewPayments = context['app']['newPayments']();
		if(header['docType'] === 'SP') {
			emailNow = 'serviceproposal'
		} else {
			workOrderMail();
		}
		
		return [emailNow, emailLater];
		
		function workOrderMail() {
			switch (header['orderType']) {
				case 'ONLO':
					onloEmail();
				break;
				case 'SPD':
					spdEmail();
				break;
				case 'BCC':
				case 'SCC':
					ccEmail();
				break;
			}
			
			function onloEmail() {
				switch(header['docStatus']) {
					case 'CP': 
						emailNow = 'onlocompletion';
						break;
					case 'IC':
						emailNow = 'outstandinginvoice';
						if(hasNewPayments) {
							emailNow = 'paymentconfirmation';
						}
						break;
					default:
						if(header['servTimeStart'] === 0) {
							emailNow = 'onloserviceinfo';
							if(header['scheduledDate'] !== '') {
								emailLater.push(['onloscheduleconfirmation', rightNow, 1600]);												
							}
						} else {
							var scheduledDate = header['scheduledDate'];
							var dayBeforeService = context['app']['futureDate'](scheduledDate, -1);
							emailLater.push(['onloappointmentconfirmation', dayBeforeService, 1500]);		
						}
						break;
				}
			}
			
			function spdEmail() {
				var schedulePickup = header['scheduledPickup'];
				switch(header['docStatus']) {
					case 'CP':
						emailNow = 'pdworkorderdetails';
						var scheduleDelivery = header['scheduledDelivery'];
						if(scheduleDelivery !== '') {
							var dayBeforeDelivery = context['app']['futureDate'](scheduleDelivery, -1);
							emailLater.push(['pddeliveryconfirmation', dayBeforeDelivery, 1500]);						
						}
						break;
					case 'IC':
						emailNow = 'outstandinginvoice';
						if(hasNewPayments) {
							emailNow = 'paymentconfirmation';
						}
						break;
					default:
						emailNow = 'pdserviceinfo';	
						if(schedulePickup !== '') {
							emailLater.push(['pdscheduleconfirmation', context['app']['rightNow'](), 1600]);
							var dayBeforePickup = context['app']['futureDate'](schedulePickup, -1);
							emailLater.push(['pdpickupconfirmation', dayBeforePickup, 1500]);						
						}
						break;
				}
			}
			
			function ccEmail() {
				switch(header['docStatus']) {
					case 'CP': 
						var orderCompleteNow = rightNow;
						if(context['app']['rightNowObj']().getHours() >= 9) {
							orderCompleteNow = context['app']['futureDate'](rightNow, 1);
						}
						emailLater.push(['ccordercomplete', orderCompleteNow, 900]);						
						emailLater.push(['ccremindersevendays', context['app']['futureDate'](rightNow, 7), 900]);
						emailLater.push(['ccreminderthirtydays', context['app']['futureDate'](rightNow, 30), 900]);
						break;
					case 'IC':
						emailNow = 'outstandinginvoice';
						if(hasNewPayments) {
							emailNow = 'paymentconfirmation';
						}
						break;
					default:
						emailNow = 'ccworkorderdetails';	
						break;
				}
			}
		}
	},
	
	newPayments: function() {
		var context = DAB.context();
		var newPayment = false;
		context['currentModel']['paymentApplied'].forEach(function(payment) {
			if(!payment.hasOwnProperty('docEntry')) {
				newPayment = true;
			}
		})
		return newPayment
	},
	
	setContextEmail: function() {
		var context = DAB.context();
		context['workOrderState']['emailConfirm'] = [];
		var emails = context['app']['mailTriggerDefinition']();
		context['workOrderState']['emailConfirm'].push(emails[0]);
		emails[1].forEach(function(emailConf) {
			context['workOrderState']['emailConfirm'].push(emailConf[0]);
		})
		context['workOrderState']['emailNow'] = emails[0];
		context['workOrderState']['emailLater'] = emails[1];
		var testEmail = 'david.sanz@tiger-sheep.com';
		if(context['app']['liveOrTest'] !== 'test') {
			testEmail = 'tsemailtesting@daburns.com';
		}
		var recipient = context['app']['emailRecipient']();
		// context['currentModel']['emailTitle'] = emailTitles[emailType];
		context['currentModel']['toEmail'] = recipient[0]
		// context['currentModel']['reportType'] = reportType;
		var fullName = recipient[1];
		if(fullName === null || fullName === '') {
			fullName = 'Esteemed Customer';
		}
		context['currentModel']['emailName'] = fullName;
		context['currentModel']['emailToUse'] = testEmail;
		context['model']['modalOption'] = 'emailModal';
		context['app']['reDraw']();			
	},
	
	emailRecipient: function() {
		var context = DAB.context();
		var recipient = context['model']['currentClient']['ClientInfo']['Email'];
		var contactId = context['currentModel']['workOrderHeader']['contactSelected']; 
		var name = context['model']['currentClient']['ClientInfo']['Name'];
		if(contactId !== '') {	
			var contactSelected = context['app']['findInArray'](context['model']['currentClient']['Contacts'], 'ID', contactId);
			if(contactSelected['Email'] !== '') {
				recipient = contactSelected['Email'];
			}
			name = contactSelected['First'] + ' ' + contactSelected['Last'];
		}
		return [recipient, name];
	},
	
	postEmail: function() {
		var context = DAB.context();
		var emailNow = context['workOrderState']['emailNow'];
		var rightNowProperty = context['app']['setEmailByTemplate'](emailNow);
		if(rightNowProperty !== null && context['workOrderState']['emailConfirm'].indexOf(emailNow) !== -1) {
			Websocket.mail.apply(null, rightNowProperty);			
		}
		if(context['workOrderState']['emailLater'].length !== 0) {
			context['workOrderState']['emailLater'].forEach(function(conf) {
				if(context['workOrderState']['emailConfirm'].indexOf(conf[0]) !== -1) {
					var properties = context['app']['setEmailByTemplate'](conf[0]);
					context['app']['scheduleEmail'](properties, conf[1], conf[2], conf[0]);					
				}
			});
		}
		context['model']['standardPostSave']();
	},
	
	scheduleEmail: function(conf, date, time, name) {
		var context = DAB.context();
		var baseRequest = {
			'Type': 'SendMailTemplate',
			'Repo': conf[0],
			'MailAccount': conf[1],
			'Template': conf[2],
			'Params': conf[3]
		}
		var fields = {
			'U_ConfigName': 'ScheduledEmail',
			'U_Params': JSON.stringify(baseRequest),
			'U_TimeStampDate': date,
			'U_TimeStampTime': time,
			'U_TSWorkOrderKey': context['currentModel']['workOrderHeader']['key'],
			'U_TSEmailName': name
		}
		var xml = {
			'UserTableEntry': {
				'Name': '@TSEMAILSCHEDULE',
				'Row': {
					'Fields': fields
				}
			}
		}
		var findKey = context['app']['findInArray'](context['currentModel']['qEmails'], 'emailName', name);
		if(findKey) {
			xml['UserTableEntry']['Row']['Key'] = findKey;
		}
		var parsed = Utility.objectToXML(xml, 'Objects');
		console.log(parsed);
		Websocket.direct(parsed, 'false', 'xml').then(function(res) {
			console.log(res);
		})
	},
	
	cancelEmails: function() {
		var context = DAB.context();
		context['currentModel']['qEmails'].forEach(function(emails) {
			var xml = {
				'UserTableEntry': {
					'Name': '@TSEMAILSCHEDULE',
					'Row': {
						'Key': emails['key'],
						'Fields': {
							'U_TimeStampDate': '01-01-1900'
						}
					}
				}
			}
			var parsed = Utility.objectToXML(xml, 'Objects');
			console.log(parsed);
			Websocket.direct(parsed, 'false', 'xml').then(function(res) {
				console.log(res);
			})			
		})
	},
	
	setEmailByTemplate: function(template) {
		var context = DAB.context();
		if(template === null) {
			return null;
		}
		var emailProps = {
			'ToEmail': context['currentModel']['emailToUse'],
			'fullName': context['currentModel']['emailName'],
			'WONumber': context['currentModel']['workOrderHeader']['documentName']
		}
		var reportType = null;
		switch(context['currentModel']['workOrderHeader']['orderType']) {
			case 'SCC':
			case 'BCC':
				reportType = 'CustCash';
			break;
			case 'SPD':
				reportType = 'CustPick';
			break;
			case 'ONLO':
				reportType = 'CustOnlo';
			break;
		}
		var extraEmailProps = context['conf']['extraEmailProps'](template);
		var propRetrieve = context['conf']['propsReturn'](extraEmailProps);
		propRetrieve.forEach(function(prop) {
			emailProps[prop[0]] = prop[1];
		})
		var documentProps = {
			'DocKey': parseInt(context['currentModel']['sapDocEntry']),
			'ObjectId': '17',
			'ReportType': reportType,
			'Format': 'Email'
		}
		var smtpProps = context['conf']['emailProps']();
		var propsSanitized = context['app']['baseProps'](documentProps, emailProps);
		return [smtpProps['db'], smtpProps['SMTP'], template, propsSanitized];
	},
	
	baseProps: function(documentList, props) {
		var properties = {
			'DocumentList': {},
			'RequiredProps1': {}
		}
		Object.keys(documentList).forEach(function(colName) {
			properties['DocumentList'][colName] = documentList[colName]
		});
		Object.keys(props).forEach(function(colName) {
			properties['RequiredProps1'][colName] = props[colName]
		});
		var propArray = [];
		Object.keys(properties).forEach(function(prop) {
			Object.keys(properties[prop]).forEach(function(colName) {
				var type = 'String';
				if(colName === 'DocKey') type = 'Int';
				propArray.push({
					'Name': prop + '.' + colName,
					'Type': type,
					'Value': properties[prop][colName]
				})
			})
		})
		console.log(propArray)
		return propArray
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Rug Input Functions------------------------------------------|
	//--------------------------------------------------------------------------------------------|

	selectionChange: function(modelToChange, modelAttr, attrName, value) {
		var context = DAB.context();
		modelToChange[modelAttr] = value;
		var drivers = {
			'pickupDriver': 'commissionPickup',
			'deliveryDriver': 'commissionDelivery'
		}
		if(Object.keys(drivers).indexOf(attrName) !== -1) {
			context['currentModel']['currentJobs'].forEach(function(job) {
				job[drivers[attrName]]['base'] = modelToChange.slice();
			})
			context['app']['reDraw']();
		}
 	},
	
	spToWorkOrder: function(e) {
		var context = DAB.context();
		context['model']['toInvoice'] = false;
		context['model']['transitionTo'] = 'WO';
		context['model']['currentModel']['workOrderHeader']['docStatus'] = 'WC';
		context['app']['saveOrder'](e);
	},
	
	toInvoice: function(e) {
		e.stopPropagation();
		var context = DAB.context();
		context['model']['fnPostVerify'] = context['app']['setInvoice'];
		context['app']['verifyWorkOrder'](e);
	},
	
	setInvoice: function() {
		var context = DAB.context();
		context['workOrderState']['docStatusPrev'] = context['currentModel']['workOrderHeader']['docStatus'];
		context['currentModel']['workOrderHeader']['docStatus'] = 'IC';
		context['model']['modalOnRemove'] = context['app']['revertState'];
		context['model']['toInvoice'] = true;
		context['app']['setContextEmail']();
	},
	
	saveView: function(e) {
		e.stopPropagation();
		var context = DAB.context();
		context['model']['toInvoice'] = false;
		context['model']['fnPostVerify'] = context['app']['saveOrder'];
		context['model']['fnPostSave'] = context['app']['viewDocument'];
		context['app']['verifyWorkOrder'](e);
	},
	
	saveEmail: function(e) {
		e.stopPropagation();
		var context = DAB.context();
		context['model']['toInvoice'] = false;
		context['model']['fnPostVerify'] = context['app']['setContextEmail'];
		context['app']['verifyWorkOrder'](e);
	},
	
	revertState: function() {
		var context = DAB.context();
		context['currentModel']['workOrderHeader']['docStatus'] = context['workOrderState']['docStatusPrev'];
	},
	
	viewDocument: function(soKey) {
		var context = DAB.context();
		var woHeader = context['currentModel']['workOrderHeader'];
		context['app']['setRoute'](['pdf', woHeader['orderType'], 'Print', soKey]);
	},
	
	saveWorkOrder: function(e) {
		e.stopPropagation();
		var context = DAB.context();
		context['model']['fnPostVerify'] = context['app']['saveOrder'];
		context['app']['verifyWorkOrder'](e);
	},
	
	verifyWorkOrder: function(e) {
		var context = DAB.context();
		// return context['app']['saveOrder']();
		context['currentModel']['required'] = [];
		context['currentModel']['recommended'] = [];
		var recommended = context['currentModel']['recommended'];
		var header = context['currentModel']['workOrderHeader']
		var cantSubmit = {
			'all': ['placedBy'],
			'SPD': ['pickupAddress', 'deliveryAddress'],
			'ONLO': ['serviceAddress']
		}
		cantSubmit['all'].forEach(function(attr) {
			if(header[attr] === '') {
				context['currentModel']['required'].push(attr);
			}
		})
		if(cantSubmit.hasOwnProperty(header['orderType'])) {
			cantSubmit[header['orderType']].forEach(function(attr) {
				if(context['app']['objIsEmpty'](header[attr]) && attr === 'placedBy') {
					context['currentModel']['required'].push(attr);
				} else if(context['app']['objIsEmpty'](header[attr])){
					var title = attr.substr(0, attr.indexOf('Address'));
					context['currentModel']['required'].push([context['app']['capitalizeFirstLetter'](title) + 
						' Address', title, context['currentModel']['workOrderHeader']]);
				}
			})
		}
		if(header['orderType'] === 'SCC' || header['orderType'] === 'BCC') {
			context['currentModel']['currentJobs'].forEach(function(job) {
				if(job['header']['isDelivery'] === 'Y') {
					context['currentModel']['required'].push([job['header']['title'] + 
						' Delivery Address', 'item', job]);
				}
			});
		}
		if(header['orderType'] === 'ONLO' || header['orderType'] === 'SPD') {
			var timeRange = [
				[
					'servTimeStart', 
					'servTimeEnd'
				],
				[
					'pickupTimeStart', 
					'pickupTimeEnd'
				],
				[
					'deliveryTimeStart', 
					'deliveryTimeEnd'
				]
			]
			
			timeRange.forEach(function(range) {
				rangeCheck(range);
			})
			
			function rangeCheck(arr) {
				if(context['currentModel']['workOrderHeader'][arr[0]] !== 0) {
					if(context['currentModel']['workOrderHeader'][arr[1]] === 0) {
						context['currentModel']['required'].push(arr[1]);
					}
				} else if(context['currentModel']['workOrderHeader'][arr[1]] !== 0) {
					if(context['currentModel']['workOrderHeader'][arr[0]] === 0) {
						context['currentModel']['required'].push(arr[0]);
					}
				}
			}
		}
		// if(header['orderType'] === 'ONLO' && header['docType'] !== 'SP') {
			// context['currentModel']['currentJobs'].forEach(function(job, index) {
				// if(job['header']['dateDue'] === '') {
					// if(recommended.length === 0) {
						// recommended.push([])
					// }
					// recommended[0].push({
						// 'index': index,
						// 'field': 'dateDue'
					// })
				// } 
			// })
		// }
		if(context['currentModel']['required'].length === 0) {
			if(recommended.length !== 0) {
				context['model']['modalOption'] = 'recommendedModal';
				return context['app']['reDraw']();
			}
			context['model']['modalOption'] = '';
			context['model']['fnPostVerify']();
			// context['app']['saveOrder']();
		} else {
			context['model']['modalOption'] = 'requiredModal';
			context['app']['reDraw']();			
		}
	},
	
	cancelOrder: function(e) {
		e.stopPropagation();
		var context = DAB.context();
		var currentUser = context['model']['currentUser'];
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		workOrderHeader['docStatus'] = 'CL';
		workOrderHeader['cancelledBy'] = currentUser['User Number'];
		workOrderHeader['cancelledDate'] = context['app']['rightNow']();
		context['currentModel']['currentJobs'].forEach(context['app']['cancelItem']);
		// context['app']['setJobPrice']();
		context['app']['saveOrder']();
		context['app']['cancelEmails']();
	},
	
	cancelItem: function(item) {
		item['header']['status'] = 'CL';
		var serviceContainers = ['additionalServices', 'mainServices'];
		serviceContainers.forEach(function(cName) {
			item[cName].forEach(function(serv) {
				serv['status'] = 'CL';
				serv['active'] = 'N';
				serv['rate'] = 0;
				console.log(serv);
			})
		})
	},
	
	//this is where we write to the backend
	saveOrder: function() {
		// e.stopPropagation();
		var context = DAB.context();
		if(context['model']['toInvoice'] === true) {
			context['app']['invoiceState']();
		}
		context['model']['modalOption'] = '';
		context['model']['fnPostVerify'] = null;
		context['model']['stateLoaded'] = false;
		context['app']['reDraw']();
		context['model']['routeToGo'] = ['summary', context['route'][1]];
		context['model']['writeWorkOrder']();
	},
			
	invoicePayment: function(e) {
		var context = DAB.context();
		e.stopPropagation();
		context['model']['modalOption'] = 'invoicePanel';
		context['app']['reDraw']();
	},
	
	cloneAsWO: function(e) {
		var context = DAB.context();
		e.stopPropagation();
		if(context['model']['docStatus'] === 'IC') {
			context['model']['transitionTo'] = 'WO';			
		} else {
			context['model']['transitionTo'] = context['model']['currentModel']['workOrderHeader']['docType'];
		}
		context['model']['setWorkOrderCopy'](context['currentModel']);
		context['model']['setCloneState'](context['currentModel']);
		context['model']['currentModel']['workOrderHeader']['viewOnly'] = false;
		context['model']['currentModel']['workOrderHeader']['documentName'] = ('Cloned from ' + 
		context['model']['currentModel']['workOrderHeader']['documentName']);
		context['model']['transitionTo'] = '';
		context['app']['reDraw']();
	},
	
	cloneAsCS: function(e) {
		var context = DAB.context();
		e.stopPropagation();
		context['model']['transitionTo'] = 'CS';
		context['model']['setWorkOrderCopy'](context['currentModel']);
		// context['model']['setCloneState'](context['currentModel']);
		var docName = context['model']['currentModel']['workOrderHeader']['documentName']
		context['model']['currentModel']['workOrderHeader']['docType'] = 'CS';
		context['model']['currentModel']['workOrderHeader']['documentName'] = 'CS' +
		docName.substr(docName.indexOf('-'));
		context['model']['currentModel']['workOrderHeader']['viewOnly'] = false;
		context['app']['setJobPrice']();
		context['model']['transitionTo'] = '';
		context['app']['reDraw']();
	},
	
	createNewJob: function(type) {
		var context = DAB.context();
		if(context['model']['state']['jobOpen'] === null) {				
			context['model']['currentModel']['currentJobs'].push(context['model'].newJobModel(type));
			context['model']['state']['jobOpen'] = context['model']['currentModel']['currentJobs'].length - 1; 
			context['app']['reDraw']();
			var job = document.getElementById('current_job');
			context['app']['scrollTo'](job);
		} else {
			context['app']['alertMessage']('Current item must be collapsed before adding new item');
		}
	},
	
	selectJob: function(job) {
		var context = DAB.context();
		var contactCode =  context['app']['route'][3];
		var jobCode = job['Code'];
		window.location.hash = '/rugs/job/' + contactCode + '/' + jobCode + '/';
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Backend Retrieval functions----------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	pdf: function() {
		var context = DAB.context();
		context['model']['stateLoaded'] = false;
		context['app']['reDraw']();
		var contentDiv = document.getElementById('content');
		contentDiv.classList.add('overflowtallfix');
		var pdf = context['app']['retrieveCrystal'](context['route'][1], context['route'][2], context['route'][3]);
		pdf.then(function(res) {
			context['model']['pdf'] = res;
			context['model']['stateLoaded'] = true;
			context['model']['fnPostSave'] = null;
			context['app']['reDraw']();
		})
	},
	
	retrieveCrystal: function(type, format, docEntry) {
		var docType;
		if(['SCC', 'BCC'].indexOf(type) !== -1) {
			docType = 'Cash';
		} else if(type ==='SPD') {
			docType = 'Pick';
		} else if(type === 'OL') {
			docType = 'Onlo'
		}
		var parameters = {
			'DocKey': parseInt(docEntry),
			'ObjectId': '17',
			'ReportType': docType,
			'Format': format
		};  
		var parameterJSON = Object.keys(parameters).map(function(paramName) {
			var params =  {
				'Name': paramName,
				'Value': parameters[paramName]
			}
			// if(paramName === 'DocKey@') params['Type'] = 'Int';
			return params;
		})
		var crystal = Websocket.crystal('', 'TSWorkOrder', 'PortableDocFormat', parameterJSON)
		return crystal;
	},
	
	createCrystalView: function(res) {
		newwindow = window.open('data:application/pdf;base64,' + res['FileData'], 
		res['FileName'],'height=1500,width=1060');
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Model Attribute functions------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	selectContactWO: function(id) {
		var context = DAB.context();
		context['currentModel']['workOrderHeader']['contactSelected'] = id;
		context['model']['state']['contactSelection'] = false;
		context['app']['reDraw']();
	},
	
	invoiceState: function() {
		var context = DAB.context();
		context['currentModel']['workOrderHeader']['dateInvoice'] = context['app']['rightNow']();
		context['currentModel']['currentJobs'].forEach(function(job) {
			if(job['header']['active'] !== 'N' && job['header']['status'] !== 'COMP') {
				context['app']['setJobComplete'](job);				
				var servCont = ['mainServices', 'additionalServices'];
				var pickDeliver = ['commissionPickup', 'commissionDelivery'];
				servCont.forEach(function(cont) {
					job[cont].forEach(function(service) {
						if(service['cancelled'] === 'N') {
							pickDeliver.forEach(function(attr) {
								if(job[attr]['base'][0] !== '') {
									job[attr][service['uniqueId']] = job[attr]['base'].slice();
								}
								context['app']['commissionCreate'](service, attr, job);
							})
							context['app']['commissionCreate'](service, 'commissionAOS', job);
						}
					})
				})
			}
		})
	},
	
	setJobComplete: function(job) {
		var context = DAB.context();
		console.log('complete');
		job['header']['status'] = 'COMP';
		if(job['header']['dateComplete'] === '') {
			job['header']['dateComplete'] = context['app']['rightNow']();			
		}
		if(job['header']['dateDue'] === '') job['header']['dateDue'] = context['app']['rightNow'](); 
		var servCont = ['mainServices', 'additionalServices'];
		servCont.forEach(function(cont) {
			job[cont].forEach(function(service) {
				if(service['cancelled'] !== 'Y') {
					if(service['status'] !== 'COMP') {
						service['status'] = 'COMP';
						if(service['dateComplete'] === '') {
							service['dateComplete'] = DAB['app']['rightNow']();
						} 
						if(job['commissionWork'].hasOwnProperty('workBy') && cont === 'mainServices') {
							if(job['commissionWork']['workBy'][0] !== '') {
								job['commissionWork'][service['uniqueId']] = job['commissionWork']['workBy'].slice();
							}
						} 
						context['app']['commissionCreate'](service, 'commissionWork', job);
					} 
				} 
			})
		})	
	},
	
	commissionCreate: function(service, type, jobObj) {
		var context = DAB.context();
		if(service['type'] === 'headerItem') return;
		var commissionArray = jobObj[type][service['uniqueId']];
		var commDef = QueryResponses['commissions'][service['id']];
		var rule = 'NET';
		var commCol;
		if(type === 'commissionAOS') {
			commCol = 'salesComm';
		} else if(type === 'commissionWork') {
			commCol = 'commPerc';	
			rule = commDef['commRule'];
		} else if(type === 'commissionPickup') {
			commCol = 'pickupComm';
		} else if(type === 'commissionDelivery') {
			commCol = 'delComm';
		}
		console.log(service);
		var rate = service['rate'];
		var discRate = 0;
		switch(rule) {
			case 'BASE':
				discRate = service['discountRate'];
			break;
			case 'CC-R':
				discRate = context['app']['searchForDiscount']('normal', 'SCC', service['id']);
			break;
			case 'CC-W':
				discRate = context['app']['searchForDiscount']('wholesale', 'SCC', service['id']);
			break;
			case 'GROSS':
				discRate = 0;
			break;
			case 'NET':
				discRate = service['discountRate'];
			break;
			case 'NONE':
				rate = 0;
			break;
		};
		console.log(discRate);
		var length = 1;
		if(typeof commissionArray === 'undefined') {
			return;
		}
		if(typeof commissionArray === 'string') {
			createCommission(commissionArray, 0);
		} else {
			length = commissionArray.length;
			commissionArray.forEach(function(c, i) {
				createCommission(c, i);
			});						
		}
		
		function createCommission(c, i) {
			var user = context['app']['findInArray'](QueryResponses['allUsers'], 'commId', c);
			var strI = i.toString();
			var commObj = findCommission(c, strI);
			if(commObj) {
				c = commObj;
			} else {
				c = newCommObject(c, strI);
			}
			var isUserCommRug = user['Rug Pad comm Receivable'] === 'Y';
			if(service['id'].indexOf('7') !== -1 && !isUserCommRug) return;
			c['measure'] = service['quantity'];
			c['rate'] = (1 - discRate) * (commDef[commCol] * .01) 
						* service['rate'];
			c['itemId'] = service['id'];
			c['commTot'] = c['measure'] * c['rate']
			c['commDist'] = length;
			c['rateDist'] = c['rate'] / c['commDist']
			c['commAmt'] = c['commTot'] /  c['commDist'];
			c['dateSet'] = context['app']['rightNow']();
			console.log(c);
		}
		
		function newCommObject(c, i) {
			var comm = {
				'type': type,
				'description': i,
				'id': service['uniqueId'],
				'user': c,
				'key': ''
			}
			jobObj['commissions'].push(comm);
			return comm;
		}
		
		function findCommission(c, i) {
			var cObj = false;
			jobObj['commissions'].forEach(function(comm) {
				if(service['uniqueId'] === comm['id'] 
				&& i === comm['description'] 
				&& type === comm['type']) {
					comm['user'] = c;
					cObj = comm;
				}
			})
			return cObj;
		}
	},
	
	cancelNewAddress: function(attr) {
		var context =  DAB.context();
		console.log('woo', attr);
		context['workOrderState'][attr + 'State'] = '';
		context['model']['currentModel'][attr + 'AddressNew'] = {};
		context['app']['reDraw']();
	},
	
	selectAddressWO: function(id, model, attr) {
		var context =  DAB.context();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var currentAddresses = context['model']['currentClient']['Addresses'];
		var findAddress = context['app']['findInArray'](context['model']['currentClient']['Addresses'], 'ID', id);
		findAddress['key'] = '';
		if(model[attr + 'Address'].hasOwnProperty('key') && model[attr + 'Address']['key'] !== '') {
			findAddress['key'] = model[attr + 'Address']['key'];
		}
		findAddress['subKey'] = '';
		setAddress(attr, findAddress);
		// if(attr === 'pickup' &&  workOrderHeader['deliveryAddrKey'] === '') setAddress('delivery', findAddress)
		function setAddress(attr, obj) {
			model[attr + 'AddrKey'] = id;	
			model[attr + 'Address'] = context['app']['objectCopy'](obj);
		}
		context['workOrderState'][attr + 'State'] = '';
		context['app']['reDraw']();
	},
	
	setDateInput: function(el, model, modelAttr) {
		el.addEventListener('focusout', submitDate);
		var context = DAB.context();
		function submitDate(e) {
			e.stopPropagation();
			var date = this.value;
			var dateObj = new Date(date);
			console.log(dateObj);
			if(dateObj.toString() === 'Invalid Date') {
				model[modelAttr] = '';
			} else {
				model[modelAttr] = Utility.formatDate(dateObj);
			}
			if(e.relatedTarget !== null) {
				context['model']['dateOption'] = '';
				el.removeEventListener('focusout', submitDate);
			}
			context['app']['reDraw']();
		}
	},
	
	resetModalAdd: function() {
		var context = DAB.context();
		var reset;
		if(context['model']['modalOption'] === 'newAddressComponent') {
			reset = 'newAddress';
		} else if(context['model']['modalOption'] === 'newContactComponent'){
			reset = 'newContactWO';
		}
		context['model']['modalAttrOption'] = '';
		context['model'][reset] = '';
		context['model']['modalOption'] = '';
		context['model']['requiresVerification'] = {};
		context['app']['reDraw']();
	},
	
	saveNewElement: function() {
		var context = DAB.context();
		var woHeader = context['model']['currentModel']['workOrderHeader'];
		var element;
		if(context['model']['modalOption'] === 'newAddressComponent') {
			element = 'newAddress';
		} else if(context['model']['modalOption'] === 'newContactComponent'){
			element = 'newContactWO';
		}
		console.log(element);
		var needsVefication = false;
		var requiredFields = {
			'newAddress': ['AddressName', 'Address', 'City', 'State','Zipcode'],
			'newContactWO': ['lastName', 'firstName']
		};
		var pushTo = {
			'newAddress': 'addresses',
			'newContactWO': 'contacts'
		}
		var verify = {};
		requiredFields[element].forEach(function(field) {
			if(context['model'][element][field] === '') {
				needsVefication = true;
				context['model']['requiresVerification'][field] = true;
			}
		})
		if(needsVefication === true) return context['app']['reDraw']();
		context['model']['currentModel'][pushTo[element]].push(context['model'][element]);
		if(element === 'newContactWO') {
			context['model']['currentModel']['contactMethods'].push([]);
		}
		woHeader[context['model']['modalAttrOption']] = context['model'][element]['Code'];
		context['app']['resetModalAdd']();
	},
	
	fnOnAttrChange: function(attr) {
		var context = DAB.context();
		var jobObj = context['jobOpen'];
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		switch (attr) {
			case 'orderType':
				context['model']['currentModel']['discountSet'] = false;
				context['app']['setJobPrice']();
			break
			case 'jobType':
				if(workOrderHeader[attr] === 'residential') {
					workOrderHeader['serviceContact'] = '';
					workOrderHeader['billingContact'] = '';
					workOrderHeader['serviceContactPhone'] = '';
					workOrderHeader['billingContactPhone'] = '';
				} else {
					context['app']['setClientModels']()
				}		
			break;
			case 'materialSelect':
				if(['furnJob', 'onloFurnJob'].indexOf(context['jobOpen']['header']['type']) !== -1) {
					if(jobObj['mainServices'].length !== 0 ) {
						var copyOver = ['ftWidth', 'inWidth', 'ftHeight', 'inHeight', 'unitTotal', 'quantity'];
						var currentService = context['app']['findInArray'](jobObj['mainServices'], 'cancelled', 'N');
						if(currentService['id'].length !== 3) {
							currentService['active'] = 'N';
							var fabType = context['app']['fabricType'](jobObj['header']['materialSelect']);
							var newCode = currentService['id'].substr(0, 3) + fabType
							// serviceSelected = context['app']['searchForService'](idCode);
							jobObj['header']['serviceSelect'] = newCode;
							var newService = context['app']['findOrCreateMain'](newCode, jobObj);
							copyOver.forEach(function(attr) {
								newService[attr] = currentService[attr];
							})
							context['app']['setJobPrice']();
						}
					}
				}
			break;
			case 'mainSelect':
				if(context['jobOpen']['header']['type'] !== 'carpetJob') {
					return;
				}
				context['app']['createNewCarpetServices'](jobObj);
				break
			case 'subSelect':
				if(['furnJob', 'onloFurnJob'].indexOf(context['jobOpen']['header']['type']) !== -1 && context['jobOpen']['header']['mainSelect'] === 'UM102') {
					var header = jobObj['header'];
					if(header['serviceSelect'] !== '' && typeof header['serviceSelect'] !== 'undefined') {
						var currentService = context['app']['findInArray'](jobObj['mainServices'], 'cancelled', 'N');
						context['app']['addNewMainService'](header['serviceSelect'], currentService['nameOfItem'], header, 'serviceSelect');						
					}
				}
				if(context['jobOpen']['header']['type'] !== 'carpetJob') return;
				context['app']['createNewCarpetServices'](jobObj);
				break
			case 'discountType':
				var clientType = 'normal'
				if(context['model']['currentClient']['ClientInfo']['CustType'][0] === '2') clientType = 'wholesale';
				var serviceBuckets = ['mainServices', 'additionalServices']
				serviceBuckets.forEach(function(bucket) {
					jobObj[bucket].forEach(function(service) {
						if(jobObj['header'][attr] === 'STANDARD') {
							service['discountRate'] = context['app']['searchForDiscount'](clientType, workOrderHeader['orderType'], service['id']);
						} else if(jobObj['header'][attr] === 'NONE') {
							service['discountRate'] = 0;								
						} else if(jobObj['header'][attr] === 'CUSTOM') {
							service['discountRate'] = context['app']['rounder'](jobObj['header']['customDiscount'] / 100);
						}
					});
				});
				context['app']['setJobPrice']();
				break;
		} 
	},
	
	fabricType: function(materialId, obj) {
		var selectionType = 'A'
		var bStart = 111;
		//U198 is the 'other' selection for A types
		if(['', 'U198'].indexOf(materialId) === -1) {
			if(parseInt(materialId.substr(1,3)) > bStart) selectionType = 'B';
		}
		return selectionType
	},
		
	findTaxCode: function() {
		var context = DAB.context();
		var taxCode = 'SEA';
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var currentClient = context['model']['currentClient'];
		if(workOrderHeader['orderType'] === 'ONLO') taxCode = 'EXO';
		if(workOrderHeader['orderType'] === 'BCC') taxCode = 'BEL';
		if(workOrderHeader['taxExempt'] === 'Y') taxCode = 'EX';
		if(workOrderHeader['hasPermit'] === 'Y') taxCode = 'EXW';
		return taxCode;
	},
	
	applyPayment: function() {
		var context = DAB.context();
		var newPayment = context['model']['currentModel']['newPayment'];
		if(parseFloat(newPayment['amount']) <= 0) {
			context['app']['addNotification']('Payment cannot be zero.', 3000);
		} else if(context['model']['currentModel']['workOrderHeader']['total'] < parseFloat(newPayment['amount'])){
			context['app']['addNotification']('Payment cannot be higher than total due.', 3000);
		} else if(context['model']['currentModel']['workOrderHeader']['total'] === 0) {
			context['app']['addNotification']('Payment cannot be applied to zero cost orders.', 3000);
		} else if(parseFloat(newPayment['amount']) > context['model']['currentModel']['workOrderHeader']['due']) {
			context['app']['addNotification']('Payment cannot be more than what is due.', 3000);
		}else {
			newPayment['userId'] = context['model']['currentUser']['User Number'];
			context['model']['currentModel']['workOrderHeader']['hasPayment'] = 'Y';
			context['model']['currentModel']['paymentApplied'].push(newPayment);
			context['model']['currentModel']['newPayment'] = context['model']['newPaymentModel']();
			context['workOrderState']['paymentChange'] = false;
			context['app']['setJobPrice']();
			context['app']['reDraw']();				
		}
	},
			
	addServiceFurniture: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		var index = modelToChange['currentIndex'];
		if(context['model']['currentModel']['currentJobs'][index]['mainServices'].length === 0) {
			var newModel = context['model'].newLineItemModel();
		} else {
			newModel = context['model']['currentModel']['currentJobs'][index]['mainServices'][0];
		}
		var unitType = {
			'Sq Ft': 'sqft',
			'Ea': 'each',
			'Ft': 'feet'
		}
		modelToChange[modelAttr] = id;
		var indexServ = context['app']['searchArray'](context['model']['allServices'], 'id', id);
		var service = context['model']['allServices'][indexServ];
		newModel['unitType'] = unitType[service['unitOfMsr']];
		newModel['type'] = 'mainServices';
		newModel['subType'] = 'rate';
		newModel['rate'] = service['rate'];
		newModel['nameOfItem'] = nameOfItem;
		newModel['id'] = id;
		newModel['partOfSet'] = 'none';
		context['model']['currentModel']['currentJobs'][index]['mainServices'][0] = newModel
		context['model']['currentModel']['discountSet'] = false;
		context['app'].setJobPrice();
		context['app'].reDraw();
	},
	
	selectFurnitureType: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		if(modelToChange[modelAttr] !== id) {
			modelToChange[modelAttr] = id;
			modelToChange['subSelect'] = '';
			header['unitType'] = '';
		}
		context['app']['reDraw']();
	},
	
	addNewMainService: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		var header = modelToChange;
		var jobObj = context['jobOpen'];
		var mainServices = jobObj['mainServices'];
		var serviceSelected = context['app']['searchForService'](id);
		if(header['type'] === 'rugJob') {
			header[modelAttr] = id;
			var newService = context['app']['findOrCreateMain'](id, jobObj);
			context['app']['inheritDimObj'](header, newService);
			context['app']['setJobPrice']();
		} else if(['furnJob', 'onloFurnJob'].indexOf(header['type']) !== -1) {
			header['serviceSelect'] = id;
			var idCode;
			if(header['mainSelect'] === 'UM101') {
				idCode = id;
			} else if(header['mainSelect'] === 'UM102') {
				//These are leather services, descriptive codes are SLXX,
				//where XX is the service number, 3+XX for standard upholstery, 6+XX for onlo upholstery
				var affixByType = {
					'U121': 'A',
					'U122': 'C'
				}
				var baseCode = '3';
				if(jobObj['header']['type'] === 'onloFurnJob') baseCode = '6'
				idCode = baseCode + '67'
				if(affixByType.hasOwnProperty(header['subSelect'])) {
					idCode = baseCode + id.substr(2,2) + affixByType[header['subSelect']];
				}
				if(id.substr(2,2) === '99') {
					idCode = baseCode + '99';
				}
				id = idCode;
				serviceSelected = context['app']['searchForService'](idCode);
			}
			header['unitType'] = serviceSelected['SalUnitMsr'];
			var service = context['app']['findOrCreateMain'](id, jobObj);
			if(header['mainSelect'] !== 'UM102' && header['materialSelect'] === '') {
				service['rate'] = 0;
			}
			if(header['mainSelect'] === 'UM102' && header['subSelect'] === '') {
				service['nameOfItem'] = nameOfItem
				if(header['subSelect'] === '') {
					service['rate'] = 0;					
				}
			}
			dimensionInit(service, header['unitType']);
			context['app']['inheritDimObj'](header, service);
			context['app']['setJobPrice']();
		} else {
			jobObj['mainSelected'].push(id);
			var newService = context['app']['createService'](id, 'mainServices', jobObj);
			if(jobObj['header']['type'] === 'otherJob' && jobObj['header']['dateDue'] !== '') {
				newService['dateDue'] = jobObj['header']['dateDue'];
			}
			dimensionInit(newService, newService['unitType'])
		}
		context['app']['setDueDates'](jobObj);
		
		function dimensionInit(serv, dimType) {
			var dims = {
				'Leneal Foot': {
					'ftHeight': 1
				},
				'Est': {
					'rate': 1
				}
			}
			if(dims.hasOwnProperty(dimType)) {
				Object.keys(dims[dimType]).forEach(function(attr) {
					serv[attr] = dims[dimType][attr];
					header[attr] = dims[dimType][attr];
				})
			}
		}
		context['app']['reDraw']();
	},

	findOrCreateMain: function(id, jobObj) {
		var context = DAB.context();
		var serviceSelected = context['app']['searchForService'](id);
		var mainServices = jobObj['mainServices'];
		var toSplice = null;
		if(mainServices.length === 1 && mainServices[0]['key'] === '') {
			jobObj['mainServices'] = [];
		} else {
			mainServices.forEach(function(serv, index) {
				if(serv['key'] === '') toSplice = index;
				serv['cancelled'] = 'Y';
				serv['rate'] = 0;
			});			
		}
		if(toSplice !== null) {
			jobObj['mainServices'].splice(toSplice, 1);			
		}
		var serviceIndex = context['app']['searchArray'](jobObj['mainServices'], 'id', id);
		var service;
		if(serviceIndex === false) {
			service = context['app']['createService'](id, 'mainServices', jobObj);
		} else {
			service = mainServices[serviceIndex]
			service['cancelled'] = 'N';
			service['active'] = 'Y';
			service['rate'] = serviceSelected['Price'];
			service['unitType'] = serviceSelected['SalUnitMsr']
		}
		return service;
	},
	
	addCarpetRoom: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		var dimensionType = 'Square Foot';
		var type = 'normal'
		var originalId = id;
		if(nameOfItem === 'Stairs') {
			dimensionType = 'Each';
			type = 'stairs';
		}
		var count = 2;
		var baseName = nameOfItem;
		while(context['app']['findInArray'](modelToChange['mainServices'], 'nameOfItem', nameOfItem)) {
			nameOfItem = baseName + ' ' + count;
			count++
		}
		var id = context['app']['findCarpetServiceCode'](modelToChange['header'], type);
		if(type === 'normal') {
			modelToChange['header']['mainCode'] = id;
		}
		if(nameOfItem === 'Spot Cleaning') {
			dimensionType = 'Each';
			type = 'spot';
			id = '580';
		}
		var newProtectant = ['R177', 'R180', 'R181'];
		if(newProtectant.indexOf(originalId) !== -1) {
			id = '584';
			type = 'roomProtectant';
		}
		var newService = context['app']['createService'](id, 'mainServices', modelToChange);
		if(newService['unitType'] === 'Est') newService['rate'] = 1;
		newService['minAmt'] = 0;
		newService['nameOfItem'] = nameOfItem;
		newService['type'] = type;
		newService['unitType'] = dimensionType;
		newService['isEditing']= false;
		if(context['jobOpen']['header']['dateDue'] !== '') {
			newService['dateDue'] = context['jobOpen']['header']['dateDue'];
		} 
		if(id === '580') {
			newService['quantity'] = 1;
			context['app']['setJobPrice']();
		}
		context['app']['reDraw']();
	},
	
	addNewLineItem: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		var jobObj = context['model']['currentModel']['currentJobs'][modelToChange['header']['currentIndex']];
		var additional = modelToChange['additionalServices'];
		modelToChange['additionalSelected'].push(id);
		var service = context['app']['createService'](id, 'additionalServices', modelToChange);
		context['app']['setDueDates'](jobObj);
		if(modelToChange['header']['type'] === 'rugJob' && id[0] === '1') {
			context['app']['inheritDimObj'](modelToChange['header'], service);
			context['app']['setJobPrice']();
		}
		if(service['unitType'] === 'Est') service['rate'] = 1;
		if(service['unitType'] === 'Leneal Foot') service['ftHeight'] = 1;
		if(service['unitType'] === 'Percent') context['app']['setJobPrice']();
		if(service['id'] === '293') {
			service['quantity'] = 1;
		}
		context['app']['setJobPrice']();
		context['app']['reDraw']();
	},
	
	protectantToggle: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		var option;
		if(modelToChange['hasProtectant'] === 'N') {
			option = 'Y';
		} else {
			option = 'N';
		}
		modelToChange['hasProtectant'] = option;
		context['app']['createOrRemoveProtectant'](modelToChange, option)
	},
	
	createOrRemoveProtectant: function(modelToChange, option) {
		var context = DAB.context();
		var job = context['jobOpen']
		var findProtectant = context['app']['findInArray'](job['additionalServices'], 'referentialId', modelToChange['uniqueId']);
		if(option === 'Y') {
			var id = '581';
			if(modelToChange['type'] === 'stairs') {
				id = '583';
			}
			if(findProtectant === false) {
				var newProt = context['app']['createService'](id, 'additionalServices', job);
				newProt['referentialId'] = modelToChange['uniqueId'];
				newProt['nameOfItem'] = modelToChange['nameOfItem'] + ' Protectant'; 
				context['app']['inheritDimObj'](modelToChange, newProt);
			} else {
				findProtectant['active'] = 'Y';
				findProtectant['rate'] = context['app']['findInArray'](QueryResponses['checkBoxes'], 'ItemCode', id)['Price'];
			}
		} else {
			findProtectant['active'] = 'N';
			findProtectant['rate'] = 0;
		}
		context['app']['setJobPrice']();
		context['app']['reDraw']();
	},
	
	findCarpetServiceCode: function(model, type) {
		var context = DAB.context();
		var suffix = {
			'F101': 'A',
			'F102': 'B',
			'F103': 'C'
		}
		var carpetOptions = {
			'L101': '05-01',
			'L102': '05-02',
			'L103': '05-06',
			'L104': '05-03',
			'L105': '05-04',
			'L106': '05-04'
		};
		var range = {
			'05-01': {
				'-01': [0, 800], 
				'-02': [801, 1200],
				'-03': [1201, '']
			},
			'05-02': {
				'-01': [0, 800],
				'-02': [801, 1200],
				'-03': [1201, '']
			},
			'05-06': {
				'-01': [0, 500],
				'-02': [501, 1000],
				'-03': [1001, '']
			}
		}
		var selectedSuffix = suffix[model['subSelect']];
		var categorySelected = carpetOptions[model['mainSelect']];
		// if(type === 'roomProtectant') {
			// return '584';
		// }
		if(type === 'stairs') {
			return context['app']['findInArray'](QueryResponses['checkBoxes'], 'U_Category', categorySelected + '-04')['ItemCode'];
		}
		if(['05-03', '05-04'].indexOf(categorySelected) !== -1) {
			return context['app']['findInArray'](QueryResponses['checkBoxes'], 'U_Category', categorySelected)['ItemCode'];
		}
		var categoryFull;
		var options = range[categorySelected];
		Object.keys(options).forEach(function(suffix) {
			if(between(options[suffix], model.unitTotal)) {	
				categoryFull = categorySelected + suffix;
			}
		});
		var itemCode = context['app']['findInArray'](QueryResponses['checkBoxes'], 'U_Category', categoryFull)['ItemCode'];
		var newCode = itemCode.substring(0, 3) + selectedSuffix;
		return newCode;
		
		function between(arr, compare) {
			var lowRange = compare >= arr[0] ;
			var highRange = true;
			if(arr[1] !== '') {
				highRange = compare <= arr[1];
			}
			return (lowRange && highRange)
		}
	},
	
	carpetRoomAttr: function(value, model, attr) {
		var context = DAB.context();
		model[attr] = parseFloat(value);
		context['app']['setDimension'](model);
		var findProtectant = context['app']['findInArray'](context['jobOpen']['additionalServices'], 'referentialId', model['uniqueId']);
		if(findProtectant) context['app']['inheritDimObj'](model, findProtectant)
		context['app']['setJobPrice']();
		context['app']['reDraw']();
	},
	
	createNewCarpetServices: function(jobObj) {
		var context = DAB.context();
		var indexesToCopy = [];
		jobObj['mainServices'].forEach(function(serv, i) {
			if(serv['cancelled'] === 'N' && serv['active'] !== 'N' && serv['type'] !== 'roomProtectant' && serv['type'] !== 'stairs') {
				indexesToCopy.push(i);
			}
		});
		//If the service code changes while we're typing, i.e. when we reach a SQFT
		//threshold we end up messing up the page focus, hence we need our new service to be
		//mapped to the previous service, and the new service ends up containing the
		//previous service information, we want to keep deleted services so SalesOrder rows are set inactive properly.
		indexesToCopy.forEach(function(index) {
			var currentService = jobObj['mainServices'][index];
			var tempId = currentService['uniqueId'];
			var servId = context['app']['findCarpetServiceCode'](jobObj['header'], currentService['type']);
			var newService = context['app']['createService'](currentService['id'], 'mainServices', jobObj);
			context['app']['inheritDimObj'](currentService, newService);
			currentService['rate'] = context['app']['findInArray'](QueryResponses['checkBoxes'], 'ItemCode', servId)['Price'];
			currentService['id'] = servId;
			currentService['uniqueId'] = newService['uniqueId'];
			currentService['unitType'] = newService['unitType'];
			if(currentService['key'] !== '') {
				newService['key'] = currentService['key'];
				currentService['key'] = '';
			}
			newService['uniqueId'] = tempId;
			newService['active'] = 'N';
			newService['rate'] = 0;
			var findProtectant = context['app']['findInArray'](jobObj['additionalServices'], 'referentialId', tempId);
			if(findProtectant) findProtectant['referentialId'] = currentService['uniqueId']; 
		})
		context['app']['setJobPrice']();
	},
	
	setCustomDiscount: function(jobObj, amount) {
		var context = DAB.context();
		var servContainer = ['mainServices', 'additionalServices'];
		var discRate = context['app']['rounder'](amount / 100);
		servContainer.forEach(function(cont) {
			jobObj[cont].forEach(function(serv) {
				serv['discountRate'] = discRate;
			})
		})
	},

	clientType: function() {
		var context = DAB.context();
		var clientType = 'normal';
		if(context['model']['currentClient']['ClientInfo']['CustType'][0] === '2') clientType = 'wholesale';
		return clientType;
	},
	
	createService: function(id, containerName, jobObj) {
		var prefixesPads = {
			'DuraHold Rug Pad - ': ['706', '767', '768'],
			'Wunder Grip Rug Pad - ': ['711', '712', '713', '714', '769', '770'],
			'No Muv Rug Pad - ': ['721', '771', '772'],
			'Wunder Lock Rug Pad - ': ['732', '733', '734', '735', '773', '774']
		}
		var context = DAB.context();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var clientType = 'normal'
		if(context['model']['currentClient']['ClientInfo']['CustType'][0] === '2') clientType = 'wholesale';
		var currentJob = context['jobOpen'];
		var serviceSelected = context['app']['searchForService'](id);
		var newService = context['model']['newLineItemModel']();
		if(containerName === 'additionalServices') {
			newService['type'] = 'lineItem';
		}
		if(['581', '583'].indexOf(id) !== -1) {
			newService['type'] = 'protectant';
		}
		newService['rate'] = serviceSelected['Price'];
		newService['minAmt'] = serviceSelected['U_MinAmt'];
		if(serviceSelected['U_MinAmt'] === null) newService['minAmt'] = 0;
		newService['discountRate'] = context['app']['searchForDiscount'](clientType, workOrderHeader['orderType'], id);
		if(jobObj['header']['discountType'] === 'CUSTOM') {
			newService['discountRate'] = context['app']['rounder'](jobObj['header']['customDiscount'] / 100);
		}
		if(jobObj['header']['discountType'] === 'NONE') newService['discountRate'] = 0;
		newService['taxCode'] = context['app']['findTaxCode']();
		if(workOrderHeader['taxOverwritten'] === 'Y') newService['taxCode'] = workOrderHeader['taxCode'];
		newService['taxRate'] = QueryResponses['taxRates'][newService['taxCode']]['Rate'];
		newService['id'] = id;
		newService['nameOfItem'] = serviceSelected['ItemName'];
		newService['unitType'] = serviceSelected['SalUnitMsr'];
		newService['container'] = containerName;
		var uniqueId = newService['uniqueId']
		currentJob['commissionAOS'][uniqueId] = [''];
		currentJob['commissionWork'][uniqueId] = [''];
		if(id.indexOf('7') === 0) {
			currentJob['commissionWork'][uniqueId] = '';
			var prefix = '';
			Object.keys(prefixesPads).forEach(function(p) {
				if(prefixesPads[p].indexOf(id) !== -1) {
					prefix = p;
				}
			})
			console.log(newService['nameOfItem'])
			if(newService['nameOfItem'].indexOf(prefix) === -1) {
				newService['nameOfItem'] = prefix + newService['nameOfItem'];				
			}
		}
		jobObj[containerName].push(newService);	
		return newService;
	},
	
	searchForDiscount: function(clientType, orderType, id) {
		var context = DAB.context();
		var discountCode = 'none';
		QueryResponses['discountDefinitions'].forEach(function(def) {
			if(orderType === def['orderType'] && clientType === def['clientType']) {
				discountCode = def['code']; 
			}
		})
		if(discountCode === 'none') return 0;
		var discountArray = QueryResponses['discountCodes']['type'][discountCode];
		var discountObj = context['app']['findInArray'](discountArray, 'id', id);
		if(discountObj === false) {
			return 0
		} else {
			return discountObj['discRate']
		}
	},
	
	setMinimumFee: function() {
		var context = DAB.context();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		if(context['currentModel']['currentJobs'].length === 0) return;
		var rounder = context['app']['rounder'];
		var codeFee = 'M005';
		var codeByPdType = {
			'GSA1': 'M004',
			'GSA': 'M005',
			'OAZ': 'M006'
		}
		var codeByONLO = {
			'L101': 'M001',
			'L102': 'M001',
			'L103': 'M002',
			'L104': 'M002',
			'L105': 'M002',
			'L106': 'M002'
		}
		if(workOrderHeader['orderType'] === 'ONLO') {
			codeFee = 'M001'
			context['currentModel']['currentJobs'].forEach(function(job) {
				if(job['header']['type'] === 'carpetJob' && job['header']['mainSelect'] !== '') {
					codeFee = codeByONLO[job['header']['mainSelect']]
				}
			})
		} else if(workOrderHeader['orderType'] === 'SPD') {
			codeFee = codeByPdType[workOrderHeader['destinationCode']];
			if(context['model']['currentClient']['ClientInfo']['CustType'][0] === '2') {
				return;
			}
		}
		var minAmt = context['app']['findInArray'](QueryResponses['checkBoxes'], 'ItemCode', codeFee)['U_MinAmt'];
		workOrderHeader['minimum'] = minAmt;
		if(workOrderHeader['minimumCode'] === '') workOrderHeader['minimumCode'] = codeFee; 
		var firstJob = context['currentModel']['currentJobs'][0]; 
		var currentMinimum = context['app']['findInArray'](firstJob['additionalServices'], 'id', codeFee);
		var difference = minAmt - workOrderHeader['subTotal'];
		if(workOrderHeader['hasMinimum'] === 'N' || workOrderHeader['minimumWaived'] === 'Y') {
			difference = 0;
			return disableOldMin();
		}
		if(workOrderHeader['subTotal'] < minAmt) {
			if(!currentMinimum) {
				disableOldMin();
				var min = context['app']['createService'](codeFee, 'additionalServices', firstJob);
				min['type'] = 'minimum';
				min['rate'] = 1;
				setPrice(min)
				workOrderHeader['minimumCode'] = codeFee;
			} else {
				currentMinimum['rate'] = 1;
				currentMinimum['active'] = 'Y';
				setPrice(currentMinimum);
			}
		} else {
			disableOldMin();
			workOrderHeader['hasMinimum'] = 'N';
			workOrderHeader['minimum'] = 0;
		}
		
		function disableOldMin() {
			if(workOrderHeader['minimumCode'] !== '') {
				var oldMin = context['app']['findInArray'](firstJob['additionalServices'], 'id', workOrderHeader['minimumCode']);
				if(oldMin) {
					oldMin['quantity'] = 0;
					oldMin['subTotal'] = 0;
					oldMin['active'] = 'N';
					oldMin['rate'] = 0;
					setPrice(oldMin);
				}
				workOrderHeader['minimumCode'] = '';
			}
		}
		
		function setPrice(min) {
			if(difference < 0) difference = 0;
			if(difference > 0) {
				context['currentModel']['currentJobs'].forEach(function(job) {
					job['header']['savings'] = 0;
				})
			}
			min['quantity'] = difference
			min['subTotal'] = rounder(min['quantity'] * rounder(min['rate'] * (1 - min['discountRate'])));
			min['taxes'] = rounder(min['subTotal'] * (min['taxRate'] * .01));
			min['total'] = min['subTotal'] + min['taxes'];
			workOrderHeader['minimum'] = min['subTotal'];
			workOrderHeader['subTotal'] += min['subTotal'];
			workOrderHeader['taxes'] += min['taxes'];
			workOrderHeader['total'] += min['total'];
		}
	},
	
	iterateThroughServices: function(fnApply) {
		var context = DAB.context();
		context['model']['currentModel']['currentJobs'].forEach(function(currentJob) {
			context['app']['iterateThroughJob'](fnApply, currentJob)
		});
	},
	
	iterateThroughJob: function(fnApply, job) {
		var serviceBuckets = ['mainServices', 'additionalServices'];
		serviceBuckets.forEach(function(type) {
			job[type].forEach(function(serv) {
				fnApply(serv);
			})
		});
	},

	setJobPrice: function() {
		var indexes = ['subTotal', 'taxes', 'total', 'due', 'paidToDate'];
		var model = DAB.model; 
		var context = DAB.context();
		var carpetCode;
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		indexes.forEach(function(ind) {
			if(workOrderHeader['totalOverwritten'] === 'Y' && ind === 'total') return;
			context['currentModel']['workOrderHeader'][ind] = 0;				
		})
		var onlyStairs = true;
		var rounder = context['app']['rounder'];
		context['currentModel']['workOrderHeader']['hasMinimum'] = 'N';
		model['currentModel']['currentJobs'].forEach(function(currentJob) {
			var serviceBuckets = ['mainServices', 'additionalServices'];
			var pricing = {};
			if(currentJob['header']['type'] === 'carpetJob') {
				currentJob['header']['unitTotal'] = 0;
			}
			currentJob['header']['subTotal'] = 0;
			currentJob['header']['taxes'] = 0;
			currentJob['header']['total'] = 0;
			currentJob['header']['savings'] = 0;
			serviceBuckets.forEach(function(type) {
				var priceName = type.substring(0, type.indexOf('Services')) + 'SubTotal';
				var baseName = type.substring(0, type.indexOf('Services')) + 'Base';
				currentJob['header'][priceName] = 0;
				currentJob['header'][baseName] = 0;
				if(currentJob[type] === 'isLoading') return;
				currentJob[type].forEach(function(serv) {
					if(serv['type'] === 'minimum') return;
					if(serv['cancelled'] === 'Y') serv['rate'] = 0;
					if(serv['active'] === 'N') serv['rate'] = 0;
					if(serv['unitType'] === 'Percent') serv['quantity'] = currentJob['header']['mainBase'];
					serv['basePrice'] = rounder(serv['quantity'] * serv['rate']);
					if(serv['minAmt'] !== 0) setServiceMin(serv);
					serv['subTotal'] = rounder(serv['quantity'] * serv['rate'] * (1 - serv['discountRate']));
					serv['discount'] = serv['basePrice'] - serv['subTotal'];
					if(!serv.hasOwnProperty('taxRate')) serv['taxRate'] = context['model']['taxCodes'][serv['taxCode']];
					serv['taxes'] = rounder(serv['subTotal'] * (serv['taxRate'] * .01));
					serv['total'] = serv['subTotal'] + serv['taxes'];
					currentJob['header'][baseName] += serv['basePrice'];
					currentJob['header'][priceName] += serv['subTotal'];
					currentJob['header']['taxes'] += serv['taxes'];
					currentJob['header']['total'] += serv['total'];
					currentJob['header']['savings'] += serv['discount'];
					if(currentJob['header']['type'] === 'carpetJob' && type === 'mainServices') carpetOptions(serv, currentJob);
				})
				currentJob['header']['subTotal'] += currentJob['header'][priceName];
				if(currentJob['header']['isDelivery'] === 'Y') {
					workOrderHeader['hasMinimum'] = 'Y';
				}
			});
			if(currentJob['header']['type'] === 'carpetJob' && currentJob['mainServices'].length !== 0) {
				carpetCode = currentJob['mainCode'];
				return hasCarpetChanged(currentJob)
			}
			setHeaderTotal(currentJob);
		});
		
		
		if(['SPD', 'ONLO'].indexOf(workOrderHeader['orderType']) !== -1) {
			workOrderHeader['hasMinimum'] = 'Y';
		}
		if(workOrderHeader['totalOverwritten'] === 'Y') {
			workOrderHeader['hasMinimum'] = 'N';
		}
		if(workOrderHeader['hasMinimum'] === 'Y' || workOrderHeader['minimumCode'] !== '') {
			context['app']['setMinimumFee']();
		}
		if(context['currentModel']['paymentApplied'].length !== 0) {
			context['currentModel']['paymentApplied'].forEach(function(payment) {
				workOrderHeader['paidToDate'] += parseFloat(payment['amount']);
			})
		} else {
			workOrderHeader['paidToDate'] = 0;
		}
		workOrderHeader['due'] = workOrderHeader['total'] - workOrderHeader['paidToDate'];
		indexes.forEach(function(ind) {
			workOrderHeader[ind] = context['app']['rounder'](workOrderHeader[ind]);				
		});
		
		function setServiceMin(serv) {
			if(serv['basePrice'] > serv['minAmt'] || serv['quantity'] === 0 || serv['rate'] === 0) return;
			serv['quantity'] = rounder(serv['minAmt'] / serv['rate']);
			serv['basePrice'] = rounder(serv['quantity'] * serv['rate']);
		}
		
		function setBase(serv) {
			serv['basePrice'] = serv['unitTotal'] * serv['rate'];
		}
		function carpetOptions(service, currentJob) {
			if(service['type'] !== 'stairs' && service['type'] !== 'roomProtectant'){
				onlyStairs = false;
			}
			if(service['cancelled'] === 'Y' || service['active'] === 'N' || service['type'] === 'stairs' || (service['id'].length === 3 
			&& ['521', '531'].indexOf(service['id']) === -1)) return;
			currentJob['header']['unitTotal'] += service['unitTotal'];
			if(service['id'][3] !== 'C' && ['521', '531'].indexOf(service['id']) === -1) {
				var priceBase = context['app']['findInArray'](QueryResponses['checkBoxes'], 'ItemCode', service['id'].substring(0, 3) + 'C')['Price'];
				var savings = context['app']['rounder'](priceBase - service['rate'], 'rate') * service['quantity'];
				service['discount'] = savings;
				currentJob['header']['savings'] += context['app']['rounder'](savings);
			}
		}
		
		function setHeaderTotal(currentJob) {
			workOrderHeader['subTotal'] += currentJob['header']['subTotal'];
			workOrderHeader['taxes'] += currentJob['header']['taxes'];
			if(workOrderHeader['totalOverwritten'] !== 'Y') {
				workOrderHeader['total'] += currentJob['header']['total'];				
			}
		}
		
		function hasCarpetChanged(currentJob) {
			if(onlyStairs) {
				return setHeaderTotal(currentJob);
			}
			var currentCode = context['app']['findCarpetServiceCode'](currentJob['header'], 'normal');
			if(currentJob['header']['mainCode'] !== currentCode) {
				currentJob['header']['mainCode'] = currentCode;
				return context['app']['createNewCarpetServices'](currentJob);
			} else {
				setHeaderTotal(currentJob)
			}
		}
	},
	
	setPanelEditing: function(modelToChange, modelAttr) {
		var context = DAB.context();
		if(modelToChange[modelAttr]['isEditing']) {
			modelToChange[modelAttr] = app.objectCopy(context['state']['addressOrig'][modelAttr]);
			context['app'].removeFromArray(context['state']['addressOrig'], modelAttr);
		} else {
			context['model']['state']['addressOrig'][modelAttr] = context['app'].objectCopy(modelToChange[modelAttr]);
			modelToChange[modelAttr]['isEditing'] = true;
		}
		context['app'].reDraw();
	},
			
	noteChange: function(value, type, modelToChange) {
		var context = DAB.context();
		modelToChange[type] = value;
		if(modelToChange['isEditing'] === true) {
			var user = context['model']['currentUser']['name'];
			modelToChange['updated_by'] = user;
		}
		context['app']['reDraw']();
	},
		
	attachmentAdd: function(files, modelToChange, modelAttr) {
		var app = DAB.app;
		var model = DAB.model;
		
		var currentIndex = 0;
		for(var i=0; i<files.length; i++) {
			var FR = new FileReader();
			FR.readAsDataURL( files[i] );
			FR.onload = function(e) {
				var currFile = e.target
				var imgS = e.target.result;
				var fileName = files[currentIndex].name;
				createFromB64(imgS, fileName, modelAttr);
				if(currentIndex === files.length) {
					app.reDraw();
				}
			}
		}
		function createFromB64(imgS, name, modelAttr) {
			var b64 = imgS.substring(imgS.indexOf(',') + 1);
			modelToChange[modelAttr].push({
				'Data': b64,
				'ParentType': '40',
				'ParentKey': '51',
				'ParentLocation': '',
				'FileName': name,
				'Description': modelAttr,
				'User': 'plebJuice',
				'Active': true
			});	
			
			currentIndex++
		}
	},
	
	setItemInactive: function(item, modelToChange, modelAttr, index) {
		var context = DAB.context();
		context['model']['modalOption'] = 'confirmModal';
		context['model']['confirmMessage'] = 'Are you sure you want to delete this content?';
		context['model']['confirm'] = function() {
			if(modelAttr && modelAttr === 'notes') {
				if(item.hasOwnProperty('key')){
					item['cancelled'] = 'Y';
				} else {
					modelToChange[modelAttr].splice(index, 1);
				}			
				context['app']['reDraw']();
			} else {
				if(item.hasOwnProperty('Active')) item['Active'] = 'N';
				if(item.hasOwnProperty('U_Active')) item['U_Active'] = 'N';
				modelToChange[modelAttr] = item;
				context['app']['writeContactOrAddress'](modelToChange, modelAttr);
			}		
			removeModal();
		}
		context['model']['cancel'] = removeModal
		context['app']['reDraw']();
		
		function removeModal() {
			context['model']['modalOption'] = '';
			context['model']['confirm'] = null;
			context['app']['reDraw']();
		}
		
	},
	
	deleteFileOrImage: function(file, index, modelToChange) {
		var context = DAB.context();
		context['model']['modalOption'] = 'confirmModal';
		context['model']['confirmMessage'] = 'Are you sure you want to delete this content?';
		context['model']['confirm'] = remove;
		context['model']['cancel'] = removeModal;
		context['app']['reDraw']();
		function remove() {	
			if(!file.hasOwnProperty('Key')) {
				modelToChange.splice(index, 1);
				context['app']['removeFromArray'](modelToChange, index);
			} else {
				file['Active'] = false;
			}
			removeModal();
		}
		function removeModal() {
			context['model']['modalOption'] = '';
			context['model']['confirm'] = null;
			context['app']['reDraw']();
		}
	},
	
	setItemEditing: function(item) {
		var context = DAB.context();
		item['isEditing'] = true;
		context['app']['reDraw']();
  },
	
	//Contact and Client FN
			
	verifyClientInfo: function(model, type) {
		var context = DAB.context();
		var needsVerification = false;
		var requiredFields;
		var newClient;
		var attrCheck;
		//the required fields are different for new clients vs. edits to existing clients. 
		//There are also flags that gets set if all info is missing from a set - i.e. name or phone.
		switch(type) {
			case 'newClient':
				newClient = true;
				requiredFields = ['CustType', 'Code', 'Street', 'City', 'State', 'Zip'];
				if(model['FirstName'] === '' && model['LastName'] === '' && model['Name'] === '') {
					model['VerifyName'] = true;
				} else {
					model['VerifyName'] = false;
				}					
				if(model['Phone1'] === '' && model['Phone2'] === '' && model['Cell'] === '') {
					model['VerifyPhone'] = true;
				} else {
					model['VerifyPhone'] = false;
				}
			break;
			case 'client':
				requiredFields = ['CustType', 'Code', 'Name']
				attrCheck = 'ClientInfo';
				if(model['ClientInfo']['Phone1'] === '' && model['ClientInfo']['Phone2'] === '' && model['ClientInfo']['Cell'] === '') {
					model['VerifyPhone'] = true;
				} else {
					model['VerifyPhone'] = false;
				}
			break;
			case 'Address':
				attrCheck = 'Address';
				requiredFields = ['Type', 'ID', 'Street', 'City', 'State', 'Zip']
			break;
			case 'Contact':
				attrCheck = 'Contact';
				requiredFields = ['First']
			break;
		};
		
		requiredFields.forEach(function(field) {
			if(type === 'newClient') {
				if(model[field] === '') {
					needsVerification = true;
					context['model']['requiresVerification'][field] = true;
				}				
				if(model['BillAddress'][field] === '') {
					needsVerification = true;
					context['model']['requiresVerification']['BillAddress'][field] = true;
				}	
				if(model['AddContact'] && model['Contact'][field] === '') {
					needsVerification = true;
					context['model']['requiresVerification'][field] = true;
				}
			} else {	
				if(model[attrCheck][field] === '') {
					needsVerification = true;
					context['model']['requiresVerification'][field] = true;
				}
			}
			
		});
		needsVerification = (type === 'client' && model['VerifyID']) || 
		(model['VerifyName'] || model['VerifyPhone'] || model['VerifyCode']) ||
		needsVerification;
		if(needsVerification) {
			return context['app']['reDraw']();
		}
		if(type === 'client' || type === 'newClient') {
			context['app']['writeClientInfo'](model, newClient);
		} else if(type === 'Address' || type === 'Contact') {
			context['app']['writeContactOrAddress'](model, type);
		}
	},
	
	writeClientInfo: function(model, newClient) {
		var context = DAB.context();
		var cardCode;
		//the passed in contains all the data to be written for the client. newClient is a boolean indicating if this is a new client or not.		
		context['app']['toggleAttribute'](model, 'loading');
		if(newClient) {
			var cardObject = context['model']['createOCRDXML'](model, newClient);
			if(model['AddContact']) {
				var contactObj = context['model']['createOCPRXML'](model['Contact']);
				cardObject['BP']['Contact'] = contactObj;
			}
			cardObject['BP']['Address'] = [];
			cardObject['BP']['Address'].push(model['BillAddress']);
			cardObject['BP']['Address'].push(model['ShipAddress']);
			cardObject['BP']['BillToDef'] = model['BillAddress']['ID'];
			cardObject['BP']['ShipToDef'] = model['ShipAddress']['ID'];
			if(model['Code'] === '') {
				cardCode = context['app']['createNewCardCode'](model['BillAddress']['Street'], model['BillAddress']['Zip'], cardObject['BP']['Name']);				
			} else {
				cardCode = model['Code'];
			}
			cardObject['BP']['Code'] = cardCode;			
		} else {
			cardCode = model['ClientInfo']['CardCode'];
			var cardObject = context['model']['createOCRDXML'](model['ClientInfo']);
			cardObject['BP']['Code'] = cardCode;
			context['model']['writeFileContact'](model, cardCode);
		}
		
		var xml = Utility.objectToXML(cardObject, 'Objects');
		
		console.log(xml);
		
		Websocket.direct(xml, false, 'xml').then(function(result) {
			context['model']['requiresVerification'] = {};
			model['loading'] = false;
			//modal is only used inthe case of updating wholeseller permit. So if there was a modal option set we assume it was that one. Would need to be changed if you used modal for anything else that also used this function.
			if(context['model']['modalOption'] !== '') {
				context['currentModel']['workOrderHeader']['hasPermit'] = 'Y'
				context['model']['modalOption'] = '';
				context['app']['reDraw']();
				return;
			}
			//check if there are notes and write them if there are.
			if(model['notes'].length > 0) {
				context['app']['writeNotes'](model['notes'], cardCode, 'OCRD');
			}
			//set the route depending on where the user should be sent after the write is complete.
			if(newClient) {
				context['app']['setRoute'](['summary', cardCode]);
			} else {
				context['app']['loadHeader'](context['route'][1]);
				context['app']['setRoute'](context['previousRoute']);
			}
		});
	},
	
	writeNotes: function(noteArray, parentKey, parentType) {
		//loop through noteArray and write each note - for edits, the parent key and type should be passed in as well, otherwise a new note is written.
		var context = DAB.context();
		var noteObj = {
				'UserTableEntry': {
						'Name': '@TSNOTE',
						'Row': []
				}
		};
		noteArray.map(function(note) {
				if(!note.hasOwnProperty('parentKey')) note['parentKey'] = parentKey;
				if(!note.hasOwnProperty('parentType')) note['parentType'] = parentType;
				var noteFields = context['model']['notesBaseXML'](note);
				noteObj['UserTableEntry']['Row'].push(noteFields)
		});
		var xml = Utility.objectToXML(noteObj, 'Objects');
		console.log(xml)
		Websocket.direct(xml, false, 'xml');
	},
	
	writeContactOrAddress: function(clientModel, typeToWrite) {
		//this is the write function used for updates to an address or contact person on a client. It won't write the rest of the client's info.
		var context = DAB.context();
		context['app']['toggleAttribute'](clientModel, 'loading');
		var newWrite = clientModel['Add'+typeToWrite];
		//the currently selected client file info lives in this model
		var currentClient = context['model']['currentClient'];	
		var cardCode = currentClient['ClientInfo']['CardCode'];
		var obj = {
			'BP': {
				'AcceptNullsAndEmptyStrings': '',
				'Code': cardCode,
			}
		}
		var cleanObj = context['app']['prepareObjForWrite'](clientModel[typeToWrite]);

		if(typeToWrite === 'Address') {
			obj['BP']['Address'] = []
			obj['BP']['Address'].push(cleanObj);
			//we're updating the object to be written and the model (for display on redraw) with a new default billing address. We also set the previous billing address to inactive. They can only have one active billing address at a time, this is how they wanted it.
			if(newWrite && clientModel[typeToWrite]['Type'] === 'B') {
				obj['BP']['BillToDef'] = clientModel[typeToWrite]['ID']
				currentClient['ClientInfo']['BillToDef'] = clientModel[typeToWrite]['ID']
				currentClient['Addresses'].forEach(function(address){
					if(address['Type'] === 'B' && address['ID'] !== clientModel[typeToWrite]['ID']) {
						address['U_Active'] = 'N';
						var addressToRemove = context['app']['prepareObjForWrite'](address);
						obj['BP']['Address'].push(addressToRemove);
					}
				});
			}
			if(newWrite) currentClient['Addresses'].push(clientModel[typeToWrite]);
		}
		if(typeToWrite === 'Contact') {
			obj['BP']['Contact'] = []
		if(cleanObj['ID'] === '') cleanObj['ID'] = cleanObj['First'] + ' ' + cleanObj['Last'];
			obj['BP']['Contact'].push(cleanObj);				
			if(newWrite) currentClient['Contacts'].push(clientModel[typeToWrite]);
		}
		var xml = Utility.objectToXML(obj, 'Objects');
		
		console.log(xml);
		
		Websocket.direct(xml, false, 'xml').then(function(result) {		
			if(clientModel.hasOwnProperty('attr')) {
				return context['app']['selectAddressWO'](clientModel['Address']['ID'], clientModel['model'], clientModel['attr'])
			}
			if(clientModel['AddAddress'] === true || clientModel['AddContact'] === true) context['app']['toggleAttribute'](clientModel, 'Add' + typeToWrite);
			if(clientModel['EditAddress'] === true || clientModel['EditContact'] === true) context['app']['toggleAttribute'](clientModel, 'Edit' + typeToWrite);
			context['app']['resetClientFileModels'](clientModel);			
		});
	},
		
	createNewCardCode: function(street, zip, cardName) {
		var context = DAB.context();
		var cardCode = cardName.substring(5,0).toUpperCase() + 
				street.substring(2,0).toUpperCase() +
				zip.substring(0,3);
		return cardCode;		
	},
	
	setBPModel: function(bpCode) {
		var context = DAB.context();
		var bpModel = Websocket.query(DAB.wsConfig.repo, 'DAB.Rug.SelectSingleBP', {'CardCode': bpCode});
		bpModel.then(function(res) {
			var bp = Utility.parseResponse(res)[0];
			context['model']['currentModel']['chosenBP'] = bp;
			context['app']['reDraw']();
		});
	},
	
	setClientModels: function() {
		var model = DAB.model;
		var app = DAB.app;
		var contacts = Websocket.query(DAB.wsConfig.repo, 'DAB.Rug.RugClientContacts', {'BPCode': model['currentModel']['workOrderHeader']['cardCode']});
		model['currentModel']['contacts'] = [];
		contacts.then(function(res) {
			var contacts = Utility.parseResponse(res);
			model['currentModel']['contacts'] = contacts;
			contacts.forEach(function(contact, i) {
				app.setClientContactMethods(contact['Code'], i)
			})
		});
		model['currentModel']['headerInfo']['isEditing'] = false;					
		app.reDraw();
	},
	
	setClientContactMethods: function(code, index) {
		var context = DAB.context();
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		var contactMethod = Websocket.query(DAB['wsConfig']['repo'], 'DAB.Rug.RugClientContactPhone', {'ContactCode': code})
		context['model']['currentModel']['contactMethods'][index] = [];
		contactMethod.then(function(res) {
			var phoneMethod = Utility.parseResponse(res);
			if(phoneMethod.length !== 0) {
				context['model']['currentModel']['contactMethods'][index] = phoneMethod;
			}
			if(context['app']['route'][3] === 'new' && workOrderHeader['contactSet'] !== true) {
				setNew();
			} else if(context['app']['route'][3] !== 'new' && workOrderHeader['contactSet'] !== true) {
				setSavedContacts();
			}
			context['app']['reDraw']();
		});
		
		function setSavedContacts() {
			var contactMethod = Websocket.query(DAB.wsConfig.repo, 
				'DAB.Rug.WorkOrderContacts', 
				{'WorkOrder': context['app']['route'][3]});
			contactMethod.then(function(res) {
				var cntctMethod = Utility.parseResponse(res);
				cntctMethod.forEach(function(cntct) {
					console.log(cntct);
					var type = cntct['type'];
					workOrderHeader[type + 'Contact'] = cntct['contactId'];
					workOrderHeader[type + 'ContactPhone'] = cntct['phone'];
					workOrderHeader[type + 'ContactLineId'] = cntct['LineId']
				})
				workOrderHeader['contactSet'] = true;
				context['app']['reDraw']();
			})	
		}
		
		function setNew() {
			workOrderHeader['contactSet'] = true;
			workOrderHeader['serviceContact'] = context['model']['currentModel']['currentClient']['Code'];
			workOrderHeader['billingContact'] = context['model']['currentModel']['currentClient']['Code'];
			var mainMethod = Websocket.query(DAB.wsConfig.repo, 'DAB.Rug.RugClientMainPhone',
			{'ContactCode': code})
			mainMethod.then(function(res) {
				var phoneNum;
				var method = Utility.parseResponse(res);
				console.log(method);
				var contactMethod = context['model']['currentModel']['contactMethods'][index]
				if(method.length !==0) {
					if(method[0]['methodType'] === 'Phone') {
						phoneNum = method[0]['phone']		
					} else {
						phoneNum = contactMethod[0]['phoneNum'];
					}						
				} else {
					phoneNum = contactMethod[0]['phoneNum'];
				}
				workOrderHeader['serviceContactPhone'] = phoneNum
				workOrderHeader['billingContactPhone'] = phoneNum	
				context['app']['reDraw']();
			})
		}
	},
	
	setResale: function(modelToChange, prop) {
		console.log(modelToChange, prop);
		modelToChange['Resale'] = prop;				
		DAB['app']['reDraw']();
	},
	
	toggleAttribute: function(modelToChange, attribute) {
		var context = DAB.context();
		//this function toggles wheter an add/edit form should appear in the client file.
		if(modelToChange[attribute]) {
			modelToChange[attribute] = false;
		} else {
			modelToChange[attribute] = true;
		}
		context['app']['reDraw']();
	},
		
	setPhoneIcons: function(iconType, model, attr) {
		var context = DAB.context();
		if(iconType === 'text' && model[attr] !== '') {
			model[attr + 'Textable'] === 'N' ? model[attr + 'Textable'] = 'Y' : model[attr + 'Textable'] = 'N';
		}
		if(iconType === 'primary' && model[attr] !== '') {
			model['PrefNum'] === attr ? model['PrefNum'] = '' : model['PrefNum'] = attr;
		}
		
		context['app']['reDraw']();
	},
	
	setPrimaryContact: function() {
		var context = DAB.context();
		var clientModel = context['model']['currentClient'];
		var primaryContact = clientModel['Contact'];
		var contactArray = clientModel['Contacts'];
		contactArray.forEach(function(contact) {
			contact['ID'] === primaryContact['ID'] ? contact['U_IsPrimary'] = 'Y' : contact['U_IsPrimary'] = 'N';
			clientModel['Contact'] = contact;
			context['app']['writeContactOrAddress'](clientModel, 'Contact');
		});
		
	},
	
	findCityByZip: function(zip, model) {
		var context = DAB.context();
		return Websocket.query('GetCityByZip', {'Zip': zip}).then(function(result) {
			var result = Utility.parseResponse(result)[0];
			if(result !== undefined) {
				var city = result['U_City'];
				model['City'] = city;
				context['app']['reDraw']();
			}
		});
	},
		
	prepareObjForWrite: function(obj) {
		console.log(obj);
		//makes sure no null values get into the objects we'll be writing to the backend. If they're trying to clear a value on purpose it will be set to an empty string.
		var cleanObj = {
			'UDFs': {}
		};
		
		Object.keys(obj).map(function(key) {
			if(obj[key] !== null && key.indexOf('U_') === -1) cleanObj[key] = obj[key];
			if(obj[key] !== null && key.indexOf('U_') > -1) cleanObj['UDFs'][key] = obj[key];
		});
		
		return cleanObj;
	},
	
	resetClientFileModels: function(clientModel) {
		var context = DAB.context();
		clientModel['Address'] = context['model']['addressModel']();
		clientModel['Contact'] = context['model']['contactModel']();
		clientModel['loading'] = false;
		context['app']['reDraw']();	
	},
	
	//Buttons FN
	
	buttonToggle: function(id, nameOfItem, modelToChange, modelAttr) {
		var app = DAB.app;
		var model = DAB.model;
		var buttonSelected = modelToChange[modelAttr];
		if(!app.removeFromArray(buttonSelected, id)) {
			buttonSelected.push(id);
		}				
		app.reDraw();
	},
	
	buttonRadio: function(id, nameOfItem, modelToChange, modelAttr) {
		var app = DAB.app;
		var model = DAB.model;
		var hasChanged = modelToChange[modelAttr] !== id; 
		if(typeof modelToChange[modelAttr]) {
			modelToChange[modelAttr] = id			
		}
		if(hasChanged) app.fnOnAttrChange(modelAttr);
		app.reDraw();
	},
	
	changeJobStatus:  function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		modelToChange[modelAttr] = id;
		if(id === 'COMP') {
			var job = context['currentModel']['currentJobs'][modelToChange['currentIndex']]
			context['app']['setJobComplete'](job);
			if(['SCC', 'BCC'].indexOf(context['currentModel']['workOrderHeader']['orderType']) !== -1) {
				context['app']['serviceCompleteDocument']();
			}
		}
		context['app'].reDraw();
	},
	
	orderTypeChange: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		if(context['currentModel']['currentJobs'].length === 0) {
			setOrderType();
		} else {
			var options = ['SCC', 'BCC', 'SPD'];
			if(options.indexOf(modelToChange[modelAttr]) !== -1 && options.indexOf(id) !== -1) {
				setOrderType();
			} else {
				context['app']['addNotification']('Cannot change order types to or from ONLO', 3000);
			}
		}
		
		function setOrderType() {
			modelToChange[modelAttr] = id;
			context['currentModel']['workOrderHeader']['taxCode'] = context['app']['findTaxCode']();
			context['app']['reDraw']();
		}
	},

	//LineItems FN
	
	changeLineItemAttr: function(changeTo, modelToChange, changeAttr) {
		var context = DAB.context();
		modelToChange[changeAttr] = changeTo
		context['app']['setDimension'](modelToChange);
		context['app']['setJobPrice']();
		if(changeAttr === 'status' && changeTo === 'COMP') {
			modelToChange['dateComplete'] = context['app']['rightNow']();
			context['app']['commissionCreate'](modelToChange, 'commissionWork', context['jobOpen']);
			if(['SCC', 'BCC'].indexOf(context['currentModel']['workOrderHeader']['orderType']) !== -1) {
				context['app']['serviceCompleteDocument']();
			}
		}
		context['app']['reDraw']();
	},
	
	serviceCompleteDocument: function() {
		var context = DAB.context();
		var complete = true;
		context['currentModel']['currentJobs'].forEach(function(job) {
			servicesToCheck = ['mainServices', 'additionalServices'];
			servicesToCheck.forEach(function(container) {
				job[container].forEach(function(service) {
					if(service['status'] !== 'COMP') {
						complete = false;
					}
				})
			});
		});
		if(complete === true) {
			context['currentModel']['workOrderHeader']['docStatus'] = 'CP';
		}
		context['app'].reDraw();
	},
	
	removeRoom: function(modelToChange) {
		var context = DAB.context();
		var jobOpen = context['jobOpen'];
		var findProtectant = context['app']['searchArray'](jobOpen['additionalServices'], 'referentialId', modelToChange['uniqueId']);
		if(modelToChange['key'] === '') {
			var findIndex = context['app']['searchArray'](jobOpen['mainServices'], 'uniqueId', modelToChange['uniqueId']);
			jobOpen['mainServices'].splice(findIndex, 1);
			if(findProtectant !== false) {
				jobOpen['additionalServices'].splice(findProtectant, 1);
			}
		} else {
			modelToChange['cancelled'] = 'Y';
			modelToChange['rate'] = 0;
			if(findProtectant !== false) {
				jobOpen['additionalServices'][findProtectant]['active'] = 'N';
				jobOpen['additionalServices'][findProtectant]['rate'] = 0;
			}
		}
		context['app']['setJobPrice']();
		context['app']['reDraw']();
	},
	
	setDimension: function(modelToChange) {
		var context = DAB.context();
		var parseData = ['ftWidth', 'inWidth', 'ftHeight', 'inHeight'];
		parseData.forEach(function(unitType) {
			modelToChange[unitType] = parseFloat(modelToChange[unitType]);
		});
		switch (modelToChange['unitType']) {
			case 'Square Foot': 
				setSqFtTotal(modelToChange);
				modelToChange['quantity'] = modelToChange['unitTotal'];
				break;
			case 'Each':
				break;
			case 'Leneal Foot': 
				modelToChange['unitTotal'] = (modelToChange['ftWidth'] + modelToChange['inWidth'] / 12.00);
				modelToChange['quantity'] =  modelToChange['unitTotal'];
				break;
			case 'Est':
				modelToChange['quantity'] = parseFloat(modelToChange['quantity']);
				break;
		}
		if(['521', '531', '741'].indexOf(modelToChange['id']) !== -1) {
			setSqFtTotal(modelToChange);
		}
		
		function setSqFtTotal(modelToChange) {
			var sqftTotal = (modelToChange['ftWidth'] + modelToChange['inWidth'] / 12.00)
				*  (modelToChange['ftHeight'] +  modelToChange['inHeight'] / 12.00) * modelToChange['ratio'];
			modelToChange['unitTotal'] = context['app']['rounder'](sqftTotal, 'unit');
		}
	},
	
	cancelStoneService: function(modelToChange, lineItemAttr, panel) {
		var context = DAB.context();
		var service = modelToChange[lineItemAttr];
		if(service['key'] !== '') {
			if(service['cancelled'] === 'Y') {
				service['active'] = 'N';
				service['rate'] = 1;
			} else {
				service['cancelled'] = 'Y';
				service['rate'] = 0;				
			}
		} else {
			modelToChange.splice(lineItemAttr, 1); 	
			var serviceIndex = context['app']['searchArray'](context['jobOpen']['mainServices'], 'uniqueId', service['uniqueId']);
			context['jobOpen']['mainServices'].splice(serviceIndex, 1); 
			context['app']['removeFromArray'](panel['services'] , service['id']);
		}
		context['app']['setJobPrice']();
		context['app']['reDraw']();
	},
	
	cancelLineItem: function(modelToChange, lineItemAttr) {
		var context = DAB.context();
		var id = modelToChange[lineItemAttr]['id'];
		console.log(context['jobOpen'], id);
		if(modelToChange[lineItemAttr]['key'] !== '') {
			if(modelToChange[lineItemAttr]['cancelled'] === 'Y') {
				modelToChange[lineItemAttr]['active'] = 'N';
				modelToChange[lineItemAttr]['rate'] = context['app']['searchForService'](id)['Price'];
			} else {
				modelToChange[lineItemAttr]['cancelled'] = 'Y';
				modelToChange[lineItemAttr]['rate'] = 0;				
			}
		} else {
			modelToChange.splice(lineItemAttr, 1); 	
			context['app']['removeFromArray'](context['jobOpen']['mainSelected'] , id);
			context['app']['removeFromArray'](context['jobOpen']['additionalSelected'] , id);
		}
		context['app']['setJobPrice']();
		context['app']['reDraw']();
	},

	//stone and tile fn
	addStoneSurface: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		if(modelToChange['state']['mainSelection'] === '') {
			var headerModel = context['model']['newLineItemModel']();
			headerModel['type'] = 'headerItem';
			headerModel['dimensionType'] = 'Square Foot';
			headerModel['unitType'] = 'Square Foot';
			headerModel['container'] = 'mainServices';
			var count = 1;
			var baseName = nameOfItem;
			while(context['app']['findInArray'](modelToChange['mainServices'], 'nameOfItem', nameOfItem)) {
				nameOfItem = baseName + ' ' + count;
				count++
			}
			headerModel['nameOfItem'] = nameOfItem;
			modelToChange['mainServices'].push(headerModel);
			context['app']['newSurfaceConf'](nameOfItem, headerModel, modelToChange);
			modelToChange['state']['mainSelection'] = headerModel['uniqueId'];			
			context['app']['reDraw']();
		} else {
			context['app']['addNotification']('Please collapse current selected surface before adding new surface', 3000);
		}
	},
	
	newSurfaceConf: function(nameOfItem, headerModel, jobObj) {
		var newSurface = {
			'nameOfItem': nameOfItem,
			'uniqueId': headerModel['uniqueId'],
			'header': headerModel,
			'descriptive': [],
			'services': [],
			'mainServices': [],
			'isEditing': false
		}
		jobObj['surfaces'].push(newSurface);
		return newSurface;
	},
	
	addStoneService: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		modelToChange[modelAttr].push(id);
		service = context['app']['createService'](id, 'mainServices', modelToChange);
		service['referentialId'] = modelToChange['uniqueId'];
		service['unitType'] = 'EstStone';
		service['rate'] = 1;
		context['jobOpen']['mainServices'].push(service);
		context['app']['reDraw']();
	},
	
	addStoneDescriptive: function(id, nameOfItem, modelToChange, modelAttr) {
		var context = DAB.context();
		var index = modelToChange[modelAttr].indexOf(id);
		if(index === -1) {
			modelToChange[modelAttr].push(id);			
		} else {
			modelToChange[modelAttr].splice(index, 1);
		}
		context['app']['reDraw']();
	},
	
	//Job Level FN
	setDueDates: function(jobObj) {
		var context = DAB.context();
		var daysDue = 0;
		var itemHeader = jobObj['header'];
		var extraWkCodes = ['170', '172', '183', '192'];
		var wkCodes = ['201', '241'];
		var baseDays = 0
		var extraWeekApplied = false;
		var initDay = itemHeader['dateReceived'];
		if(context['currentModel']['workOrderHeader']['orderType'] === 'SPD') {
			initDay = itemHeader['scheduledPickup'];
		}
		var isDateExisting = typeof initDay !== 'undefined' && initDay !== '';
		var isRugJob = itemHeader['type'] === 'rugJob';
		if(itemHeader['type'] === 'rugJob' || itemHeader['type'] === 'furnJob') {
			baseDays = 7;
			if(itemHeader['receivedLoc'] === 'B' && itemHeader['type'] !== 'furnJob') baseDays = 8;
		}
		var dueDateExists = itemHeader['dateDue'] !== '';
		var currentDate = new Date(context['app']['rightNow']())
		//100 service code auto complete
		// if(isRugJob && dueDateExists) {
			// var compare = context['app']['compareDates'](currentDate, new Date(itemHeader['dateDue']));
			// if(compare === true) {
				// itemHeader['dateComplete'] = itemHeader['dateDue'];
			// }
		// }
		var dateCompleteExists = itemHeader['dateComplete'] !== '';
		var hasServices = jobObj['mainServices'].length !== 0 || jobObj['additionalServices'].length !== 0  
		//don't apply due date if no services are present
		if(hasServices === false) return;
		servicesToCheck = ['mainServices', 'additionalServices'];
		servicesToCheck.forEach(function(servType) {
			var serviceDue = baseDays;
			jobObj[servType].forEach(function(serv) {
				//set service completion date if already set on header;
				if(dateCompleteExists && serv['datecomplete'] === '') {
					serv['dateComplete'] = itemHeader['dateComplete'];
				}
				var individualDay = 0;
				//these guys inherit due dates from header
				var dueOverWrite = false;
				if(['onloFurnJob', 'carpetJob', 'stoneJob', 'furnJob'].indexOf(itemHeader['type']) !== -1 && dueDateExists) {
					dueOverWrite = true;
				}
				if(isRugJob && dueDateExists && servType === 'mainServices') {
					dueOverWrite = true;
				}
				//100 service code auto complete
				if(isRugJob && dueDateExists && serv['id'][0] === '1') {
					var compare = context['app']['compareDates'](currentDate, new Date(serv['dateDue']));
					if(compare === true) {
						serv['dateComplete'] = serv['dateDue'];
					}
				}
				if(dueOverWrite) {
					serv['dateDue'] = itemHeader['dateDue'];
				}
				//these codes have their own due date
				if(wkCodes.indexOf(serv['id']) !== -1 || serv['id'][0] === '1') { 
					individualDay = 7;
					if(serviceDue === 0) serviceDue = 7;
					if(itemHeader['receivedLoc'] === 'B') {
						individualDay = 8;
						if(serviceDue === 7) serviceDue = 8;
					}
				}
				//these codes add a week to due date
				if(extraWkCodes.indexOf(serv['id']) !== -1) {
					individualDay = baseDays + 7;
					if(extraWeekApplied === false) {
						serviceDue += 7;
						extraWeekApplied = true;
					}
				}
				if(isDateExisting && individualDay !== 0) {
					var dateDue = context['app']['futureDate'](initDay, individualDay);						
					if(compareDates(serv, dateDue) && serv['dateDueOverwritten'] === 'N') serv['dateDue'] = dateDue;
				}
			});
			if(serviceDue > daysDue) daysDue = serviceDue;
		})
		if(isDateExisting && daysDue !== 0) {
			var dateDue = context['app']['futureDate'](initDay, daysDue);	
			if(compareDates(itemHeader, dateDue) &&  itemHeader['dateDueOverwritten'] === 'N') itemHeader['dateDue'] = dateDue;	
			if(compareDates(context['currentModel']['workOrderHeader'], dateDue)) {
				context['currentModel']['workOrderHeader']['dateDue'] = dateDue;
			} 
		}
		
		function compareDates(obj, date) {
			if(obj['dateDue'] === '') return true;
			var date1 = new Date(obj['dateDue']);
			var date2 = new Date(date);
			return date2.getTime() > date1.getTime();
		}
	},
	
	inheritDimObj: function(obj1, obj2) {
		var parseData = ['ftWidth', 'inWidth', 'ftHeight', 'inHeight', 'unitTotal', 'quantity'];
		parseData.forEach(function(attr) {
			obj2[attr] = obj1[attr]
		});
	},
	
	inheritDimension: function(modelToChange) {
		var parseData = ['ftWidth', 'inWidth', 'ftHeight', 'inHeight', 'unitTotal', 'quantity'];
		var header = modelToChange['header'];
		if(['rugJob', 'furnJob', 'onloFurnJob'].indexOf(modelToChange['header']['type']) !== -1) {
			modelToChange['mainServices'].forEach(function(serv) {
				parseData.forEach(function(attr) {
					serv[attr] = header[attr];
				})
			})
		}
	},
	
	selectRow: function(row) {
		var context = DAB.context();
		context['model']['state']['jobOpen'] = row['num'];
		context['app']['reDraw']();
		var job = document.getElementById('current_job');
		context['app']['scrollTo'](job);
	},
	
	removeJob: function(index) {
		var context = DAB.context();
		console.log(index);
		var jobToRemove = context['currentModel']['currentJobs'][index];
		if(jobToRemove['header']['key'] === '') {
			context['currentModel']['currentJobs'].splice(index, 1)
			context['currentModel']['currentJobs'].forEach(function(job, i) {
				job['header']['currentIndex'] = i;
			})
			context['model']['state']['jobOpen'] = null;
			context['model']['state']['jobCount'] = context['currentModel']['currentJobs']['length'] + 1;
			context['app']['setJobPrice']();
			context['app']['reDraw']();	
		} else {
			context['app']['cancelItem'](jobToRemove);
			context['app']['setJobPrice']();
			context['app']['reDraw']();
		}
	},
	
	createNotePanel: function(noteArray, noteModel) {
		var context = DAB.context();		
		var note = context['app']['objectCopy'](noteModel);		
		noteArray.push(note);
		context['model']['newNote'] = context['model'].newNoteModel();
		context['model']['newJobNote'] = context['model'].newNoteModel();
		context['app'].reDraw();
	},
			
	colorSelect: function(color, model, attr, status) {
		var context = DAB.context();
		model[attr] = color;
		console.log(attr);
		context['model']['colorPicker'] = '';
		context['app']['reDraw']();
	},
			
	changeOtherState: function(index, modelToChange, changeAttr) {
		var app = DAB.app;
		var indexEl = modelToChange[changeAttr].indexOf(index) 
		if(indexEl === -1) {
			modelToChange[changeAttr].push(index);
		} else {
			modelToChange[changeAttr].splice(indexEl, 1)
		}
		app.reDraw();
	},
	
	setDragDrop: function(fnOnChange, model, modelAttr, element) {
		element['dom'].addEventListener('drop', function(e) {
			e.stopPropagation();
			e.preventDefault();
			if(typeof fnOnChange !== 'undefined') fnOnChange(e.dataTransfer.files, model, modelAttr);
		});
		element['dom'].addEventListener('dragover', function(e) {
			e.preventDefault();
		})
	},
	
	inheritAttrToJobs: function(model, modelAttr, value) {
		var context = DAB['context']();
		context['currentModel']['currentJobs'].forEach(function(job) {
			if(job['header'][modelAttr] === '' || job['header'][modelAttr] === 0) {
				job['header'][modelAttr] = value;
			}
		});
		model[modelAttr] = value;
		context['app']['reDraw']();
	},
	
	setDateOverWritten: function(model) {
		model['dateDueOverwritten'] = 'Y';
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Utility functions--------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	timeFromInt: function(value) {
		var timeHr = '';
		var timeMin = value % 100;
		var amPm = '';
		if(value / 1200 > 1) {
			amPm = 'pm'
		} else {
			amPm = 'am'
		}
		var timeHr = Math.floor(value % 1200 / 100);
		if(timeHr === 0) {
			timeHr = 12;
		}
		return [timeHr, timeMin, amPm];
	},
	
	moveInArray: function(arr, from, to) {
		var newArr = arr.splice(to, 0, arr.splice(from, 1)[0]);
		return newArr
	},
	
	scrollTo: function(el) {
		var content = document.getElementById('content');
		var headerHeight = document.getElementsByTagName('header')[0].offsetHeight;
		var scrollLoc = el.offsetTop - headerHeight - 50;
		content['scrollTop'] = scrollLoc;
	},
	
	compareDates: function(date1, date2) {
		date1.setHours(0, 0, 0, 0);
		date2.setHours(0, 0, 0, 0);
		console.log(date1.getTime(), date2.getTime());
		return date1.getTime() >= date2.getTime();
	},
	
	objIsEmpty: function(obj) {
		for (var x in obj) { return false; }
		return true;
	},
	
	nullsToEmptyString: function(obj) {
		Object.keys(obj).forEach(function(key) {
			if(obj[key] === null) obj[key] = '';
		});	
		return obj;
	},
	
	searchForService: function(id) {
		var context = DAB.context();
		return QueryResponses['checkBoxes'][context['app']['searchArray'](QueryResponses['checkBoxes'], 'ItemCode', id)]
	},
	
	createTableModels: function(data, type) {
		/** This function will eventually utilize an array of object to create the precursors for table views
			Depending of what @type is set, @data has to be set accordingly 
			if @type = 'jsonArray' @data needs to be handed as an array of of objects with column : value pairs.
			if @type = 'tableStructure' @data needs to be handed as an object with the following attributes
			@type.columns must be an array of column titles
			@type.cells has to be an array of arrays that have the same length as columns **/
		var rows;
		var columns = [];
		var objArray = [];
		if(type === 'jsonArray') {
			var rows = data.map(function(obj, i) {
				objArray.push(obj);
				return Object.keys(obj).map(function(col) {
					if(i === 0) {
						columns.push(col);
					}
					return obj[col];
				})
			})
		} else if(type === 'tableStructure') {
			columns = data['columns'];
			rows = data['cells'];
			objArray = rows.map(function(row) {
				var cellObj = {}
				row.forEach(function(cell, i) {
					cellObj[columns[i]] = cell;
				})
				return cellObj
			})
		}

		return {
			'rows': rows,
			'columns': columns,
			'objArray': objArray
		}
	},
	
	objectCopy: function(obj) {
		return JSON.parse(JSON.stringify(obj));
	},
	
	setButtonByCat: function(populate, rows) {
		var columns = rows.forEach(function(row) {
			if(!populate.hasOwnProperty(row[1])) populate[row[1]] = [];
			populate[row[1]].push({
				'id': row[0],
				'display': row[2]
			})
		})
	},
			
	rounder: function(num, type) {
		var sigFig = 2;
		if(type === 'rate') {
			sigFig = 4;
		} 
		if(type === 'unit') {
			sigFig = 3;
		}
		var initialStep = (Math.round(num * Math.pow(10, sigFig + 1))) / Math.pow(10, sigFig + 1)
		return (Math.round(initialStep * Math.pow(10, sigFig))) / Math.pow(10, sigFig)
	},
	
	parseHeaderInfo: function(obj) {
		var headerObj = {
			'Client Code': '',
			'Client Name': '',
			'CustomerType': '',
			'Phone': '',
			'Email': '',
			'Address': '',
			'City': '',
			'Zip Code': '',
			'Permit': '',
			'Permit Expiration': '',
			'Inactive': ''
		}
		Object.keys(obj).map(function(key) {
			if(key === 'Permit Expiration') {
				obj[key] = Utility.formatDate(obj[key]);
			}
			if(headerObj.hasOwnProperty(key)) {
				headerObj[key] = obj[key]
			}
		});
		
		return headerObj;
	},
	
	formatField: function(model, attribute, className, value) {
		var context = DAB.context();
		if(className.indexOf('phone') > -1) {
			value = value.replace(/\D/g, '');
			if(value.length === 10) {
				var formattedVal = value.replace(/(\d{3})(\d{3})(\d{4})/, "$1-$2-$3");
			} else if(value.length === 11)  {
				var formattedVal = value.replace(/(\d{1})(\d{3})(\d{3})(\d{4})/, "$1-$2-$3-$4");
			}

			if(typeof(formattedVal) !== 'undefined') {
				model[attribute] = formattedVal;
				return context['app']['reDraw']();
			}
		}
		
		if(className.indexOf('email') > -1) {
			var regEmail = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
			var isEmail = value.match(regEmail);
			if(!isEmail) model['VerifyEmail'] = true;
			return context['app']['reDraw']();
		}
		
		if(className.indexOf('numbersOnly') > -1) {
			var cleanVal = value.replace(/[^\d-]+/g,'');
			model[attribute] = cleanVal;
			return context['app']['reDraw']();
		}
		
		if(className.indexOf('code') > -1) {
			var baseModel = context['model']['currentClient'];
			var currentInfo = baseModel['ClientInfo'];
			if(context['route'][0] === 'addclient') {
				baseModel = context['model']['newClient'];
				currentInfo = baseModel;
				checkCode(value);
			}
			baseModel['VerifyCode'] = false;
			if(currentInfo['CustomCode'] !== value && currentInfo['CardCode'] !== value) {
				checkCode(value);		
			};
			
			function checkCode(value) {
				return Websocket.query('CheckCustomerCode', {'Code': value}).then(function(result) {
					if(result.Data.Result.Result.Rows.length !== 0) {
						baseModel['VerifyCode'] = true;
					}
					context['app']['reDraw']();
				});		
			}
		}
		
		if(className.indexOf('addressID') > -1) {
			if(typeof context['model']['currentClient'] !== 'undefined') {
				context['model']['currentClient']['VerifyID'] = false;
				context['model']['currentClient']['Addresses'].forEach(function(address){
					if(address['ID'] === value) context['model']['currentClient']['VerifyID'] = true;
				});
				context['app']['reDraw']();
			}
		}
		
	},

	searchArray: function(array, attr, val) {
		var isInArray = false;
		array.forEach(function(obj, i) {
			if(obj[attr] === val) {
				isInArray = i;
			}
		})
		return isInArray;
	},
	
	findInArray: function(array, attr, val) {
		var context = DAB.context();
		var search = context['app']['searchArray'](array, attr, val)
		if(search === false) {
			return false;
		} else {
			return array[search];
		};
	},
	
	filterArrayByKey: function(array, key) {
		var obj = {};
		array.forEach(function(el) {
			if(!obj.hasOwnProperty(el[key])) {
				el[key] = [];
			}
			el[key].push(el);
		})
		return obj;
	},
			
	removeFromArray: function(array, element) {
		var index = array.indexOf(element);
		if (index > -1) {
			array.splice(index, 1);
			return true;
		}
		return false
	},
	
	validateInteger: function(e) {
		DAB.app['validateNum'](e,'integer')
	},
	
	validateFloat: function(e) {
		DAB.app['validateNum'](e,'float')
	},
	
	validateDate: function(e) {
		DAB.app['validateNum'](e,'date')
	},
	
	resizeDiv: function() {
		//Dynamically gets the size of the div pertaining to the main content of the website
		//This function also adds an event listener so the div changes height x width when the window is resized
		var windowHeight = window.innerHeight;
		var headerHeight = document.getElementsByTagName('header')[0].offsetHeight;
		var footerHeight = 0;
		var footer = document.getElementsByTagName('footer');
		if(footer.length !== 0) footerHeight = footer.offsetHeight; 
		var navWrap = document.getElementById('ts-navwrapper');
		var navWrapWidth = 0;
		if(navWrap !== null) navWrapWidth = navWrap.offsetWidth;
		var height = (windowHeight - headerHeight - footerHeight) + 'px';
		var width = (window.innerWidth - (navWrapWidth - 17)) + 'px';
		var content = document.getElementsByClassName('mainContentWrapper')[0]['style'];
		content['height'] = height;
		content['maxHeight'] = height;
		content['width'] = width;
		content['maxWidth'] = width;
	},
	
	validateNum: function(e, type) {
		var validationExtra = false;
		if(type === 'date') validationExtra = e.keyCode === 191
		if(type === 'float') validationExtra = (e.keyCode === 190 || e.keyCode === 110);
		if ([46, 8, 9, 27, 13].indexOf(e.keyCode) !== -1 ||
			(e.keyCode == 65 && e.ctrlKey === true) ||
			(e.keyCode == 67 && e.ctrlKey === true) ||
			(e.keyCode == 88 && e.ctrlKey === true) ||
			(e.keyCode >= 35 && e.keyCode <= 39) ||
			(validationExtra)
		) {
			 return;
		}
		// Ensure that it is a number and stop the keypress
		if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
			e.preventDefault();
		}
	},
	
	uniqueNumber: function() {
		var date = Date.now();
		//we make sure that the timestamp that we're utilizing is unique
		if (date <= DAB['uniqueNumber']) {
			date = DAB['uniqueNumber'] + 1;
		} 
		DAB['uniqueNumber'] = date;
		return date.toString();
	},
	
	timeFromInt: function(value) {
		var timeHr = '';
		var timeMin = value % 100;
		var amPm = '';
		if(value / 1200 > 1) {
			amPm = 'pm'
		} else {
			amPm = 'am'
		}
		var timeHr = Math.floor(value % 1200 / 100);
		if(timeHr === 0) {
			timeHr = 12;
		}
		return [timeHr, timeMin, amPm];
	},
	
	timeDisplay: function(value) {
		var context = DAB['context']();
		var time = context['app']['timeFromInt'](value);
		if(time[1] === 0) {
			time[1] = '00';
		} else if(time[1] < 10) {
			time[1] = '0' + time[1];
		}
		return time[0] + ':' + time[1] + time[2];
	},
	
	futureDate: function(init, days) {
		var initDate = new Date(init);
		var res = new Date(initDate.getTime() + days * 24 * 60 * 60 * 1000)
		res = res.toISOString();
		res = res.substring(5,7) + '/' + res.substring(8,10) + '/' + res.substring(0,4);
		return res;
	},	
	
	capitalizeFirstLetter: function(string) {
			return string.charAt(0).toUpperCase() + string.slice(1);
	},
	
	rightNow: function() {
		//returns right now date as MM/DD/YYYY
		var nowUTC = new Date();
		var offSet = nowUTC.getTimezoneOffset()
		nowUTC.setTime(nowUTC.getTime() - offSet * 60 * 1000);
		var res = nowUTC.toISOString();
		res = res.substring(5,7) + '/' + res.substring(8,10) + '/' + res.substring(0,4);
		return res;
	},
	
	dateFormat: function(dateObj) {
		var res = dateObj.toISOString();
		res = res.substring(5,7) + '/' + res.substring(8,10) + '/' + res.substring(0,4);
		return res;
	},
	
	rightNowObj: function() {
		var nowUTC = new Date();
		var offSet = nowUTC.getTimezoneOffset()
		nowUTC.setTime(nowUTC.getTime() - offSet * 60 * 1000);
		return nowUTC;
	},
	
	setDropZone: function() {
		//pulled from http://stackoverflow.com/questions/6756583/prevent-browser-from-loading-a-drag-and-dropped-file
		var dropzoneId = "dropzone";

		window.addEventListener("dragenter", function(e) {
			if (e.target.id != dropzoneId) {
				e.preventDefault();
				e.dataTransfer.effectAllowed = "none";
				e.dataTransfer.dropEffect = "none";
			}
		}, false);

		window.addEventListener("dragover", function(e) {
			if (e.target.id != dropzoneId) {
				e.preventDefault();
				e.dataTransfer.effectAllowed = "none";
				e.dataTransfer.dropEffect = "none";
			}
		});

		window.addEventListener("drop", function(e) {
			if (e.target.id != dropzoneId) {
				e.preventDefault();
				e.dataTransfer.effectAllowed = "none";
				e.dataTransfer.dropEffect = "none";
			}
		});
	}
}