DAB['model'] = {	
	currentModel: {},
	
	modalOption: '',
	
	confirmDelete: false,
	
	services: {},
	
	notifications: [],
	
	requiresVerification: {
		'BillAddress': {}
	},
	
	tempCode: 0,
	
	removeBindings: null,
	
	modalOnRemove: null,
	
	dateOption: '',
	
	colorPicker: '',
	
	formX: 0,
	
	formY: 0,
	
	state: null,
	
	tableLoading: false,
	
	clientLoadedCardCode: '',
	
	searchModel: ['%%', '%%', '%%'],
	
	transitionTo: '',
	
	fnPostSave: null,
	
	newCurrentState: function() {
		var state = {
			'addressOrig': [],
			'jobCount': 1,
			'contactSelection': false,
			'jobOpen': null,
			'workOrderState': null,
			'currentJobState': []
		}
		return state;
	},
	
	newCurrentModel: function() {
		var	currentModel = {
			'notes': [],
			'paymentApplied': [],
			'contacts': [],
			'contactMethods': [],
			'currentClient': '',
			'headerInfo': '',
			'stickyNotes': [],
			'currentJobs': [],
			'addresses': [],
			'qEmails': [],
			'sapLines': false,
			'sapDocEntry': false,
			'invoiceDocEntry': false
		}
		return currentModel;
	},
	
	newPaymentModel: function() {
		var context = DAB.context();
		return {
			'type': 'cc',
			'amount': 0,
			'reference': '',
			'month': '',
			'year': '',
			'docDate': context['app']['rightNow'](),
			'userId': ''
		}
	},
	
	newUserModel: function() {
		var inputs = [
			['UserName', 'User Name'], 
			['firstName', 'First Name'],
			['lastName', 'Last Name'], 
			['name', 'Display Name'],
			['password', 'User Password'],
			['password2', 'Retype Password']
		];
		var booleans = [
			['sales', 'AOS'],
			['cleanTech', 'Cleaning Technician'],
			['upholstery', 'In Plant Upholstery'],
			['repTech', 'Repair Technician'],
			['rugCutter', 'Rug Pad Cutter Tech'],
			['padComm', 'Rug Pad commission receivable'],
			['servCoord', 'Service Coordinator'],
			['admin', 'Admin'],
			['active', 'Active']
		]
		var model = {};
		inputs.forEach(function(inp) {
			model[inp[0]] = '';
		})
		booleans.forEach(function(bool) {
			model[bool[0]] = 'N';
		})
		model['key'] = '';
		model['active'] = 'Y';
		return model;
	},
	
	commissionModel: function() {
		var commModel = {
			'type': '',
			'id': '',
			'user': '',
			'description': '',
			'measure': '',
			'rate': '',
			'rateDist': '',
			'commTot': '',
			'commDist': '',
			'commAmt': '',
			'dateSet': '',
			'commOrig': '',
			'key': ''			
		}
		return commModel;
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Model Constructor functions----------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	baseWorkOrder: function() {
		var context = DAB.context();
		var model = {
			'key': '',
			'pickupDate': '',
			'deliveryDate': '',
			'cancelledDate': '',
			'dateDue': '',
			'dateInvoice': '',
			'scheduledDate': '',
			'scheduledPickup': '',
			'scheduledDelivery': '',		
			'subTotal': 0,
			'taxes': 0,
			'total': 0,
			'due': 0,
			'paidToDate': 0,
			'minimum': 0,
			'cardCode': context['route'][1],
			'documentName': 'New Document',
			'clientType': 'normal',
			'discountType': '',
			'orderType': 'SCC',
			'docType': 'WO',
			'docStatus': 'IP',
			'jobType': 'residential',
			'invoiceKey': '',
			'poNum': '',
			'sidemark': '',
			'placedBy': '',
			'refBy': '',
			'destinationCode': 'GSA',
			'furnitureMoved': '',
			'contactSelected': '',
			'pickupAddrKey': '',
			'deliveryAddrKey': '',
			'serviceAddrKey': '',
			'servCoord': '',
			'spDate': '',
			'spTime': '',
			'cancelledBy': '',
			'hasMinimum': 'N',
			'taxCode': 'SEA',
			'minimumCode': '',
			'minimumWaived': 'N',
			'pickupDriver': [''],
			'deliveryDriver': [''],
			'hasPermit': 'N',
			'totalOverwritten': 'N',
			'taxOverwritten': 'N',
			'hasPayment': 'N',
			'timeSpecial': 'N',
			'scheduleLimitation': '',
			'techRequested': '',
			'servTimeStart': 0,
			'servTimeEnd': 0,	
			'pickupTimeStart': 0,
			'pickupTimeEnd': 0,	
			'deliveryTimeStart': 0,
			'deliveryTimeEnd': 0,	
			'servTimeHr': '',
			'servTimeMin': '',
			'travelTime': '',
			'createdBy': context['currentUser']['name'],
			'pickupAddress': {},
			'deliveryAddress': {},
			'serviceAddress': {},
			'additionalAddr': [],
			'marinaAddr': [],
			'driverOrigin': [],
			'viewOnly': false
		}
		var state = {
			'pickupState': '',
			'deliveryState': '',
			'serviceState': '',
			'itemState': '',
			'additionalState': '',
			'marinaState': '',
			'taxOver' : 'N',
			'totalOver': 'N',
			'taxTemp': '',
			'totalTemp': 0,
			'inheritChild': 'N',
			'emailNow': null,
			'emailLater': [],
			'emailConfirm': [],
			'paymentChange': false,
			'docStatusPrev': ''
		}
		var timeAttr = [
			'servTimeStart', 
			'servTimeEnd', 
			'pickupTimeStart', 
			'pickupTimeEnd', 
			'deliveryTimeStart', 
			'deliveryTimeEnd'
		];
		timeAttr.forEach(function(attr) {
			state[attr] = context['model']['timeInit'](); 
		})
		var currentModel = DAB.model.currentModel
		context['model']['state']['workOrderState'] = state;
		currentModel['workOrderHeader'] = model;
	},
	
	timeInit: function() {
		return {
			'amPm': '',
			'hr': '',
			'min': '',
			'isSet': false
		}
	},
	
	newJobModel: function(type, baseModel) {
		//This function creates an empty state model for a new job
		var context = DAB.context();
		var dateReceived = context['app']['rightNow']();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var rug = {
			'header': {
				'key': '',
				'title': 'Item ' + context['model']['state']['jobCount'],
				'dateReceived': '',
				'dateDue': '',
				'scheduledPickup': '',
				'dateComplete': '',
				'scheduledDelivery': '',
				'dateDueOverwritten': 'N',
				'serviceAmt': 0,
				'addServiceAmt': 0,
				'savings': 0,
				'subTotal': 0,
				'total': 0,
				'taxes': 0,
				'ftWidth':0, 
				'inWidth':0, 
				'ftHeight':0, 
				'inHeight':0,
				'unitTotal': 0,
				'quantity': 0,
				'mainSubTotal': 0,
				'servTimeStart': 0,
				'servTimeEnd': 0,	
				'pickupTimeStart': 0,
				'pickupTimeEnd': 0,	
				'deliveryTimeStart': 0,
				'deliveryTimeEnd': 0,	
				'additionalSubTotal': 0,
				'customDiscount': 0,
				'ratio': 1.0,
				'status': 'IP',
				'takenBy': context['currentUser']['User Number'],
				'type': type,
				'mainSelect': '',
				'subSelect': '',
				'materialSelect': '',
				'currentIndex': context['model']['state']['jobCount'] - 1,
				'addOnSelect': 'none',
				'color1': 'none',
				'color2': 'none',
				'color3': 'none',
				'active': 'Y',
				'wpi': '',
				'poNum': '',
				'sidemark': '',
				'unitType': 'Square Foot',
				'discountType': 'STANDARD',
				'receivedLoc': '', 
				'serviceLoc': '',
				'returnedLoc': '',
				'dimensionType': 'Square Foot',
				'pickedUp': 'N',
				'delivered': 'N',
				'isDelivery': 'N',
				'furnitureMoved': 'N',
				'mainCode': '',
				'uniqueId': context['app']['uniqueNumber'](),
				'shapeCode': '',
				'techRequested': ''
			},
			'itemAddrKey': '',
			'itemAddress': {},
			'commissionWork': {
				'workBy': ['']
			},
			'commissionPickup': {
				'base': ['']
			},
			'commissionDelivery': {
				'base': ['']
			},
			'commissionAOS': {},
			'commissions': [],
			'additionalServices': [],
			'additionalSelected': [],
			'mainSelected': [],
			'mainServices': [],
			'descriptive': [],
			'otherState': [],
			'descBackEnd': [],
			'attachments': {
				'photo': [],
				'file': []
			},
			'lineItemNotes': [],
			'notes': [],
			'state': {
				'conditionFilter': '',
				'additionalFilter': '',
				'additionalSelection': '',
				'mainFilter': '',
				'mainSelection': '',
				'loading': false
			}
		}		
		var dateReceived = context['app']['rightNow']();
		rug['header']['dateReceived'] = dateReceived;	
		context['conf']['setJobContext'](rug);
		var dates = ['dateReceived', 'dateDue', 'dateComplete', 'scheduledDelivery', 'scheduledPickup'];
		context['model']['newJobNote'] = context['model']['newNoteModel']();
		var timeAttr = [
			'servTimeStart', 
			'servTimeEnd', 
			'pickupTimeStart', 
			'pickupTimeEnd', 
			'deliveryTimeStart', 
			'deliveryTimeEnd'
		];
		timeAttr.forEach(function(attr) {
			rug['state'][attr] = context['model']['timeInit'](); 
		});
		if(type === 'stoneJob') {
			rug['surfaces'] = [];
			rug['descByRef'] = {};
		};
		if(workOrderHeader['orderType'] === 'SPD') {
			timeAttr.forEach(function(attr) {
				if(workOrderHeader[attr] !== 0) {
					rug['header'][attr] = workOrderHeader[attr];
				}
			})
			var dateAttr = ['scheduledPickup', 'scheduledDelivery'];
			dateAttr.forEach(function(attr) {
				if(workOrderHeader[attr] !== '') {
					rug['header'][attr] = workOrderHeader[attr];
				}
			});
		};
		if(baseModel) {
			Object.keys(baseModel).forEach(function(col) {
				if(baseModel[col] === null) return;
				if(dates.indexOf(col) !== -1 && baseModel[col] !== '') {
					console.log(baseModel[col]);
					rug['header'][col] = Utility.formatDate(baseModel[col]);
				} else {
					rug['header'][col] = baseModel[col];						
				}
			})
		}
		context['model']['state']['jobCount']++
		return rug;
	},
	
	newLineItemModel: function() {
		var context = DAB.context();
		var model = {
			'key': '',
			'dateReceived': '',
			'dateDue': '',
			'dateDueOverwritten': 'N',
			'dateComplete': '',
			'ftWidth':0, 
			'inWidth':0, 
			'ftHeight':0, 
			'inHeight':0,
			'taxes': 0,
			'unitTotal': 0,
			'basePrice': 0,
			'subTotal': 0,
			'quantity': 0,
			'rate': 0,
			'ratio': 1.0,
			'minAmt': 0,
			'discountRate': 0,
			'taxRate': 0,
			'status': 'IP',
			'nameOfItem': 'Test Item',
			'unitType': 'sqft',
			'option1': '',
			'option2': '',
			'option3': '',
			'color': '',
			'id': '',
			'type': '',
			'active': 'Y',
			'taxCode': 'SEA',
			'uniqueId': context['app']['uniqueNumber'](),
			'referentialId': '',
			'hasProtectant': 'N',
			'notes': '',
			'container': '',
			'cancelled': 'N'
		}
		return model;
	},
	
	newNoteModel: function() {
		var context = DAB.context();
		var date = context['app']['rightNow']();
		var user = context['model']['currentUser']['name'];
		var model = {
			'id': 0,
			'text': '',
			'type': '',
			'created_by': user,
			'created_on': date,
			'active': 'Y',
			'isEditing': false
		}
		return model;
	},
	
	addressModel: function(type) {
		if(typeof type === 'undefined') {
			type = '';
		}
		var model = {
			'ID': '',
			'Street': '',
			'Block': '',
			'City': '',
			'State': 'WA',
			'Zip': '',
			'Type': type,
			'U_Active': 'Y'
		}
		
		return model;
	},
	
	contactModel: function() {
		var model = {
			'ID': '',
			'Position': '',
			'First': '',
			'Last': '',
			'Phone': '',
			'Phone2': '',
			'Cell': '',
			'Fax': '',
			'Email': '',
			'Active': 'Y',
			'U_PhoneExt': '',
			'U_Phone2Ext': '',
			'U_CellExt': '',
			'U_IsPrimary': 'N'
		}
		
		return model;
	},
	
	newClientModel: function() {
		//make sure these just match schema names so it's easy to write.
		var context = DAB.context();
		var model = {
			'FirstName': '',
			'LastName': '',
			'Name': '',
			'CustType': '',
			'ResalePermit': '',
			'PermitExp': '',
			'Phone1': '',
			'U_Phone1Ext': '',
			'Phone2': '',
			'U_Phone2Ext': '',
			'Cell': '',
			'U_CellExt': '',
			'Email': '',
			'EmailPref': 'A',
			'BillAddress': context['model']['addressModel']('B'),
			'ShipAddress': context['model']['addressModel']('S'),
			'Contact': context['model']['contactModel'](),
			'Code': '',				
			'Resale': false,
			'AddContact': false,
			'VerifyName': false,
			'VerifyPhone': false,
			'VerifyEmail': false,
			'VerifyCode': false,
			'loading': false,
			'notes': []
		};
		
		return model;
	},
	
	clientModel: function() {
		var context = DAB.context();
		var model = {
			'ClientInfo': {},
			'Contact': context['model']['contactModel'](),
			'Address': context['model']['addressModel'](),
			'Addresses': [],
			'Contacts': [],
			'notes': [],
			'attachments': {
				'file': []
			},
			'Resale': false,
			'VerifyPhone': false,
			'VerifyEmail': false,
			'VerifyCode': false,
			'VerifyID': false,
			'AddContact': false,
			'AddAddress': false,
			'EditContact': false,
			'EditAddress': false,
			'loading': false
		}
		
		return model;
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Data Read functions------------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	loadPaidRows: function(docEntry) {
		var context = DAB.context();
		Websocket.query('SalesPaidToRows', {'SalesOrder': docEntry}).then(function(res) {
			var rows = Utility.parseResponse(res);
			var options = ['cash', 'cc', 'check'];
			rows.forEach(function(pay) {
				var type = 'cash';
				options.forEach(function(attr) {
					if(pay[attr] > 0) type = attr;	
				})
				var payObj = {
					'type': type,
					'amount': pay['amt'],
					'reference': pay['ref'],
					'docDate': Utility.formatDate(pay['docDate']),
					'userId': pay['userId'],
					'docEntry': pay['docEntry'],
					'checkNum': pay['CheckNum']
				}
				if(type === 'cc') {
					payObj['month'] = pay['ref2'].substr(0, pay['ref2'].indexOf('/'));
					payObj['year'] = pay['ref2'].substr(pay['ref2'].indexOf('/') + 1);
				}
				context['currentModel']['paymentApplied'].push(payObj);
			})
			context['app']['reDraw']();
		})
	},
	
	loadWorkOrder: function(docEntry) {
		var context = DAB.context();
		context['model']['stateLoaded'] = false;
		var header = Websocket.query('GetWorkOrderHeader', {'WorkOrder': docEntry});
		var items = Websocket.query('GetItemHeader', {'WorkOrder': docEntry});
		var addresses =  Websocket.query('GetWorkOrderAddress', {'WorkOrder': docEntry});
		var notes = Websocket.query('GetWorkOrderNotes', {'WorkOrder': docEntry});
		var drivers =  Websocket.query('GetWorkOrderDrivers', {'WorkOrder': docEntry});
		var emailScheduled = Websocket.query('GetScheduledEmails', {'WorkOrder': docEntry});
		var queries = [header, items, addresses, notes, drivers, emailScheduled];
		Promise.all(queries).then(function(res) {
			var workOrderHeader = Utility.parseResponse(res[0])[0];
			var itemHeaders = Utility.parseResponse(res[1]);
			var addresses = Utility.parseResponse(res[2]);
			var notes = Utility.parseResponse(res[3]);
			var drivers = Utility.parseResponse(res[4]);
			var emailScheduled = Utility.parseResponse(res[5]);
			var dates = ['deliveryDate', 'pickupDate', 'cancelledDate',
			'scheduledPickup', 'scheduledDelivery', 'scheduledDate'];
			Object.keys(workOrderHeader).forEach(function(attr) {
				if(workOrderHeader[attr] !== null) {
					context['currentModel']['workOrderHeader'][attr] = workOrderHeader[attr];
					if(dates.indexOf(attr) !== -1) {
						context['currentModel']['workOrderHeader'][attr] = Utility.formatDate(workOrderHeader[attr]);
					}
				}
			});
			var affix = 'WO'
			if(workOrderHeader['docType'] === 'SP') {
				affix = 'SP';
			}
			Websocket.query('GetSAPLines' + affix, {'WorkOrder': docEntry}).then(function(res) {
				var sapLines = Utility.parseResponse(res);
				if(sapLines.length !== 0) {
					context['currentModel']['sapLines'] = sapLines;
					context['currentModel']['sapDocEntry'] = sapLines[0]['DocEntry'];
					context['model']['loadPaidRows'](sapLines[0]['DocEntry']);
				}
			})
			if(['IC', 'CL'].indexOf(workOrderHeader['docStatus']) !== -1) {
				context['model']['currentModel']['workOrderHeader']['viewOnly'] = true;
				context['app']['reDraw']();
				Websocket.query('GetInvoiceKey', {'WorkOrder': docEntry}).then(function(res) {
					console.log(res);
					var key = res['Data']['Result']['Result']['Rows'][0][0];
					context['currentModel']['invoiceDocEntry'] = key;
				})
			}
			itemHeaders.forEach(function(header) {
				var itemModel = context['model']['newJobModel'](header['type'], header);
				context['model']['currentModel']['currentJobs'].push(itemModel);
				context['model']['loadIndividualJob'](header['key'], itemModel);
				// context['app']['reDraw']();
			});
			console.log(addresses);
			addresses.forEach(function(addr) {
				var filtered = context['app']['nullsToEmptyString'](addr)
				if(addr['mainType'] !== 'item') {
					context['currentModel']['workOrderHeader'][addr['mainType'] + 'Address'] = filtered;
				} else {
					var foreignKey = filtered['subKey'];
					itemHeaders.forEach(function(header, i) {
						if(header['uniqueId'] === foreignKey) {
							context['model']['currentModel']['currentJobs'][i][addr['mainType'] + 'Address'] = filtered;
						}
					})
				}
			})
			notes.forEach(function(note) {
				var filtered = context['app']['nullsToEmptyString'](note);
				var foreignKey = filtered['subKey'];
				if(note['parentType'] === 'workorder') {
					context['currentModel']['notes'].push(filtered)
				} else if(note['parentType'] === 'item') {
					itemHeaders.forEach(function(header, i) {
						if(header['uniqueId'] === foreignKey) {
							context['model']['currentModel']['currentJobs'][i]['notes'].push(filtered);
						}
					})
				} else {
					if(note['parentType'] !== 'lineItem') {
						context['currentModel']['workOrderHeader'][note['parentType']].push(filtered);						
					}
				}
			})
			context['currentModel']['workOrderHeader']['driverOrigin'] = drivers;
			drivers.forEach(function(driverObj) {
				if(context['currentModel']['workOrderHeader'][driverObj['type']][0] === '') {
					context['currentModel']['workOrderHeader'][driverObj['type']][0] = driverObj['id'];
				} else {
					context['currentModel']['workOrderHeader'][driverObj['type']].push(driverObj['id']);					
				}
			})
			context['currentModel']['qEmails'] = emailScheduled;
			context['model']['stateLoaded'] = true;
			context['app']['reDraw']();	
		})
	},
	
	attachmentRetrieve: function(model, parentType, parentKey) {
		var imgParam = {
			'ParentType': parentType,
			'ParentKey': parentKey,
			'MaxFiles': 100,
			'Active': true
		};
		var attachments = Websocket.getAttach(imgParam);
		attachments.then(function(res) {
			res['Files'].forEach(function(file) {
				file['Active'] = true;
				file['Key'] = file['ID'].substr();
				delete file['ID']
				model['attachments'][file['Description']].push(file);
			})
		})
	},
	
	loadIndividualJob: function(docEntry, jobObj) {
		var context = DAB.context();
		jobObj['state']['loading'] = true;
		var queries = [];
		context['model']['attachmentRetrieve'](jobObj, context['currentModel']['workOrderHeader']['key'], jobObj['header']['uniqueId']);
		var attributeByQuery = {
			'additionalServices': {
				'query': 'GetItemServices',
				'params': {
					'DocEntry': docEntry,
					'Container': 'additionalServices'
				}
			}, 
			'mainServices': {
				'query': 'GetItemServices',
				'params': {
					'DocEntry': docEntry,
					'Container': 'mainServices'
				}
			},
			'descBackEnd': {
				'query': 'GetItemDesc',
				'params': {
					'DocEntry': docEntry
				}
			},
			'lineItemNotes': {
				'query': 'GetLineItemNotes',
				'params': {
					'WorkOrder': context['currentModel']['workOrderHeader']['key'],
					'ItemId': jobObj['header']['uniqueId']
				}
			},
			'commissions': {
				'query': 'GetItemComm',
				'params': {
					'DocEntry': docEntry
				}
			}
		}
		var titleNames = Object.keys(attributeByQuery);
		titleNames.forEach(function(attr) {
			var attrObj = attributeByQuery[attr]
			var stateQuery = Websocket.query(attrObj['query'], attrObj['params']);
			queries.push(stateQuery);
		})
		Promise.all(queries).then(function(res) {
			res.forEach(function(resObj, i) {
				var title = titleNames[i];
				var parsed = Utility.parseResponse(res[i]);
				var nullsRemoved = parsed.map(function(obj) {
					return context['app']['nullsToEmptyString'](obj)
				});
				var servicesContainers = ['additionalServices', 'mainServices']
				jobObj[title] = nullsRemoved;
				var pushDef = {
					'mainServices': 'mainSelected',
					'additionalServices': 'additionalSelected'
				}
				var dates = ['dateReceived', 'dateDue', 'dateComplete'];
				if(servicesContainers.indexOf(title) !== -1) {
					jobObj[title].forEach(function(serv) {
						dates.forEach(function(dateName) {
							if(serv[dateName] !== '') serv[dateName] = Utility.formatDate(serv[dateName]);
						})
					})
					nullsRemoved.forEach(function(service) { 
						var uniqueId = service['uniqueId'];
						jobObj[pushDef[title]].push(service['id']);
						jobObj['commissionAOS'][uniqueId] = [''];
						jobObj['commissionWork'][uniqueId] = [''];
						if(service['id'].indexOf('7') === 0) {
							jobObj['commissionWork'][uniqueId] = '';
						}
					})
				}
				if(title === 'descBackEnd') {
					nullsRemoved.forEach(function(desc) {
						if(desc['active'] === 'Y' && desc['refId'] === '') {
							jobObj['descriptive'].push(desc['descCode'])
						}
					})
				}
				if(title === 'lineItemNotes') {
					nullsRemoved.forEach(function(note) {
						var serviceContainers = ['additionalServices', 'mainServices']
						serviceContainers.forEach(function(cName) {
							jobObj[cName].forEach(function(service) {
								if(service['uniqueId'] === note['subKey']) {
									service['notes'] = note['text']
								}
							})
						})						
					})
				}
				if(title === 'commissions') {
					nullsRemoved.forEach(function(comm) {
						if(Array.isArray(jobObj[comm['type']][comm['id']])) {
							if(jobObj[comm['type']][comm['id']][0] === '') {
								jobObj[comm['type']][comm['id']][0] = comm['user'];
							} else {
								jobObj[comm['type']][comm['id']].push(comm['user'])
							}
						} else {
							jobObj[comm['type']][comm['id']] = comm['user']
						}
					})
				}
				jobObj['state']['loading'] = false;
				context['app']['reDraw']();
			})
			context['app']['setDueDates'](jobObj);
			if(jobObj['header']['type'] === 'stoneJob') {
				jobObj['descByRef'] = {};
				jobObj['descBackEnd'].forEach(function(desc) {
					if(desc['refId'] !== '') {
						if(!jobObj['descByRef'].hasOwnProperty(desc['refId'])) jobObj['descByRef'][desc['refId']] = [];
						jobObj['descByRef'][desc['refId']].push(desc);
					}
				})
				jobObj['mainServices'].forEach(function(serv) {
					if(serv['type'] === 'headerItem') {
						var surface = context['app']['newSurfaceConf'](serv['nameOfItem'], serv, jobObj);
						if(jobObj['descByRef'].hasOwnProperty(surface['uniqueId'])) {
							jobObj['descByRef'][surface['uniqueId']].forEach(function(desc) {
								if(desc['active'] === 'Y') {
									surface['descriptive'].push(desc['descCode']);									
								}
							})
						}
					} else {
						var surface = context['app']['findInArray'](jobObj['surfaces'], 'uniqueId', serv['referentialId']);
						surface['services'].push(serv['id']);
						surface['mainServices'].push(serv);
					}
				})
			}
		})
	},
	
	//--------------------------------------------------------------------------------------------|
	//-------------------------------Data Write functions-----------------------------------------|
	//--------------------------------------------------------------------------------------------|
	
	writeWorkOrder: function() {
		var context = DAB.context();
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		var base = baseXML();
		var woTable = '@TSWORKORDER';
		var docKey;
		context['model']['xmlTemp'] = {
			'mainXML': base
		};
		context['model']['sapLines'] = [];
		if(workOrderHeader['key'] === '') {	
			workOrderWrite();
			var xml = Utility.objectToXML(base, 'Objects');
			Websocket.direct(xml, 'false', 'xml').then(function(res) {
				workOrderHeader['key'] = res['Data']['Results'][0]['Key'];
				context['model']['xmlTemp']['mainXML'] = baseXML();
				if(workOrderHeader['docType'] !== 'CS') {
					workOrderHeader['documentName'] = context['model']['createWOId'](workOrderHeader['key']);					
				}
				workOrderChildren()
			})
		} else {
			workOrderChildren()
		}
		// var woChild = context['model']['addChild'](woXML[1][0]);
		function workOrderWrite() {
			if(workOrderHeader['docStatus'] === 'IC') { 
				var prefix = 'INV';
				if(workOrderHeader['docType'] === 'CS') prefix = 'CSINV';
				var newName = prefix + workOrderHeader['documentName'].substring(workOrderHeader['documentName'].indexOf('-'));
				workOrderHeader['documentName'] = newName;
			}	
			var woXML = context['model']['tableXML'](woTable);
			woXML[1].push(context['model']['formatUDO'](workOrderHeader, woTable));
			context['model']['xmlTemp']['mainXML']['UserTableEntry'].push(woXML[0]);
		}
		
		function workOrderChildren() {
			workOrderWrite();
			if(context['currentModel']['invoiceDocEntry'] === false) {
				context['currentModel']['currentJobs'].forEach(function(job) {
					context['app']['setDueDates'](job);
					context['model']['writeItems'](job);
					context['model']['writeAttachments'](job, workOrderHeader['key']);
				})	
				var addressNames = ['pickup', 'delivery', 'service'];
				addressNames.forEach(function(name) {
					var addrName = name + 'Address'
					if(!context['app']['objIsEmpty'](workOrderHeader[addrName])) {
						context['model']['writeAddress'](workOrderHeader[addrName], name)
					}
				})
				var additional = ['additionalAddr', 'marinaAddr'];
				additional.forEach(function(cont) {
					workOrderHeader[cont].forEach(function(note) {
						context['model']['writeNote'](note, cont); 
					})
				})
				context['model']['writeDrivers'](workOrderHeader);				
			}
			context['currentModel']['notes'].forEach(function(note) {
				context['model']['writeNote'](note, 'workorder'); 
			})
			console.log(context['model']['xmlTemp']['mainXML'])
			var xml = Utility.objectToXML(context['model']['xmlTemp']['mainXML'], 'Objects');
			console.log(xml);
			Websocket.direct(xml, 'false', 'xml').then(function(res) {
				if(context['currentModel']['invoiceDocEntry'] !== false) {
					var payments = context['model']['createInvoicePayment']();
					payments.then(function() {
						postSAP();
					})
				} else if(context['model']['sapLines'].length !== 0) {
					var sapBase = context['model']['sapBase'](context['model']['sapLines']); 
					var sapXML = Utility.objectToXML(sapBase, 'Objects');
					console.log(sapXML);
					Websocket.direct(sapXML, 'false', 'xml').then(function(res) {
						docKey = res['Data']['Results'][0]['Key']; 
						context['currentModel']['sapDocEntry'] = docKey;
						if(context['currentModel']['paymentApplied'].length !== 0) {
							var payments = context['model']['currentModel']['paymentApplied'].map(function(payment) {
								return context['model']['createDownPayment'](context['model']['sapLines'], docKey, payment)							
							});
							Promise.all(payments).then(function(res) {
								res.forEach(function(resultObj, i) {
									if(resultObj.hasOwnProperty('docEntry')) {
										return;
									} else {
										var paymentKey = resultObj['Data']['Results'][0]['ChildResults'][1]['Key'];
										console.log(paymentKey, i , context['model']['currentModel']['paymentApplied']);
										context['model']['currentModel']['paymentApplied'][i]['docEntry'] = paymentKey;	
									}
								});
								postSAP();
							})
						} else {
							postSAP();
						}
					});
				} else {
					postSAP() 
				}
		
				function postSAP() {
					var soKey = res['Data']['Results'][0]['Key'];
					if(context['model']['fnPostSave'] !== null) {
						return context['model']['fnPostSave'](docKey);
					}
					if(context['model']['toInvoice'] === true) {
						context['model']['createInvoiceDoc'](context['model']['sapLines'], docKey);
						context['model']['sapLines'] = [];
						context['model']['toInvoice']= false;
					} else if(context['model']['transitionTo'] === '') {
						return context['model']['standardPostSave']();
					} else {
						var docName = context['currentModel']['workOrderHeader']['documentName'];
						console.log(docName);
						context['currentModel']['workOrderHeader']['docType'] = context['model']['transitionTo'];
						context['currentModel']['workOrderHeader']['documentName'] = context['model']['transitionTo'] + docName.substr(2);
						context['model']['transitionTo'] = '';
						context['model']['setWorkOrderCopy'](context['currentModel']);
						context['model']['stateLoaded'] = true;
						context['app']['reDraw']();
					}					
				}
			})
		}
		
		function baseXML() {
			return {
				'UserTableEntry': []
			}
		}
	},
	
	standardPostSave: function() {
		var context = DAB.context();
		context['model']['xmlTemp'] = {};
		context['app']['setRoute'](context['model']['routeToGo'])					
		context['model']['stateLoaded'] = true;
	},
	
	writeDrivers: function(header) {
		var context = DAB.context();
		var driverTable = '@TSDISPATCHWOEMP';
		var drivers = ['pickupDriver', 'deliveryDriver'];
		drivers.forEach(function(attr) {
			var counter = 0;
			header[attr].forEach(function(driver) {
				if(driver !== '') {
					context['model']['findCreateTable'](context['model']['xmlTemp']['mainXML']['UserTableEntry'], driverTable);
					var precursor = driverObj(driver, attr, counter);
					header['driverOrigin'].forEach(function(drObj) {
						if(drObj['type'] === attr && drObj['description'] === counter.toString()) {
							precursor = drObj;
							precursor['id'] = driver;
						}
					})
					context['model']['xmlTemp'][driverTable].push(context['model']['formatUDO'](precursor, driverTable));
					counter++
				}
			})
		})
		
		function driverObj(driverCode, attr, counter) {
			var obj = {
				'parentKey': header['key'],
				'id': driverCode,
				'type': attr,
				'description': counter.toString(),
				'key': ''
			}
			return obj;
		}
	},
	
	writeAddress: function(addrObj, addrType, subKey) {
		var context = DAB.context();
		var tableAddr = '@TSADDRESS';
		context['model']['findCreateTable'](context['model']['xmlTemp']['mainXML']['UserTableEntry'], tableAddr);
		addrObj['mainType'] = addrType;
		addrObj['parentKey'] = context['currentModel']['workOrderHeader']['key'];
		if(subKey) addrObj['subKey'] = subKey
		context['model']['xmlTemp'][tableAddr].push(context['model']['formatUDO'](addrObj, tableAddr))
	},
	
	writeNote: function(noteObj, noteType, subKey, foreignKey) {
		var context = DAB.context();
		var table = '@TSNOTE';
		context['model']['findCreateTable'](context['model']['xmlTemp']['mainXML']['UserTableEntry'], table);
		noteObj['parentType'] = noteType;
		noteObj['parentKey'] = context['currentModel']['workOrderHeader']['key'];
		if(subKey) noteObj['subKey'] = subKey;
		if(foreignKey) noteObj['foreignKey'] = foreignKey;
		context['model']['xmlTemp'][table].push(context['model']['notesBaseXML'](noteObj))
	},
	
	writeAttachments: function(item, key) {
		var containers = ['file', 'photo'];
		containers.forEach(function(cName) {
			item['attachments'][cName].forEach(function(file) {
				if(!file.hasOwnProperty('Key')) {
					file['ParentType'] = key;
					file['ParentKey'] = item['header']['uniqueId']
					Websocket.setAttach(file);
				} else if(file['Active'] === false) {
					var deleteRequest = {
						'Key': file['Key'],
						'Active': false
					}
					Websocket.setAttach(deleteRequest);
				}
			});			
		});
	},
	
	writeFileContact: function(model, cardCode) {
		model['attachments']['file'].forEach(function(file) {
			if(!file.hasOwnProperty('Key')) {
				file['ParentType'] = 'ContactFile';
				file['ParentKey'] = cardCode
				Websocket.setAttach(file);
			} else if(file['Active'] === false) {
				var deleteRequest = {
					'Key': file['Key'],
					'Active': false
				}
				Websocket.setAttach(deleteRequest);
			}
		});		
	},
	
	writeItems: function(item) {
		var context = DAB.context();
		var itemTable = '@TSWOROW';
		context['model']['findCreateTable'](context['model']['xmlTemp']['mainXML']['UserTableEntry'], itemTable);
		item['header']['parentKey'] = context['currentModel']['workOrderHeader']['key']
		var itemRow = context['model']['formatUDO'](item['header'], itemTable);
		context['model']['xmlTemp'][itemTable].push(itemRow);
		var childRow;
		var serviceContainers = ['additionalServices', 'mainServices']
		serviceContainers.forEach(function(cName) {
			var tName = '@TSWOROWDETAIL';
			item[cName].forEach(function(service) {
				context['model']['sapLines'].push(service);
				hasChildren()
				if(service['notes'] !== '') {
					var note = context['app']['findInArray'](item['lineItemNotes'], 'subKey', service['uniqueId']);
					if(note === false) {
						note = context['model']['newNoteModel']();
					}
					note['text'] = service['notes'];
					context['model']['writeNote'](note, 'lineItem', service['uniqueId'], item['header']['uniqueId']); 
				}
				context['model']['findCreateTable'](childRow, tName);
				context['model']['xmlTemp'][tName].push(context['model']['formatUDO'](service, tName))
			})
		});
		var dName = '@TSWOROWDESCRIPTIVE';
		item['descBackEnd'].forEach(function(dObj) {
			dObj['active'] = 'N';
		})
				
		item['notes'].forEach(function(note) {
			context['model']['writeNote'](note, 'item', item['header']['uniqueId']); 
		})
		
		item['descriptive'].forEach(function(dCode) {
			hasChildren()
			context['model']['findCreateTable'](childRow, dName);
			var descObj = context['app']['findInArray'](item['descBackEnd'], 'descCode', dCode);
			if(!descObj) {
				descObj = createNewDesc(dCode);
			} else {
				descObj['active'] = 'Y';
			}
			context['model']['xmlTemp'][dName].push(context['model']['formatUDO'](descObj, dName))
		})
		var comms = ['commissionWork','commissionAOS', 'commissionPickup', 'commissionDelivery'];
		var commToWrite = [];
		var commTable = '@TSWOROWCOMISSION';
		comms.forEach(function(cName, i) {
			Object.keys(item[cName]).forEach(function(id) {
				var commItem = item[cName][id];
				if(typeof commItem === 'string') {
					if(commItem !== '') {
						return writeComm(cName, 0, id, commItem);						
					} else {
						return;
					}
				}
				commItem.forEach(function(code, i) {
					if(code !== '') {
						writeComm(cName, i, id, code)
					}
				})
			})
		})
		
		function writeComm(cName, i, id, code) {
			commToWrite.push({
				'type': cName,
				'description': i.toString(),
				'id': id,
				'user': code,
				'key': ''
			})
		}
		
		if(item['header']['type'] === 'stoneJob') {
			var writes = [];
			Object.keys(item['descByRef']).forEach(function(ref) {
				item['descByRef'][ref].forEach(function(descObj) {
					descObj['active'] = 'N';
				})
			});
			
			item['surfaces'].forEach(function(surface) {
				surface['descriptive'].forEach(function(dCode) {
					hasChildren()
					context['model']['findCreateTable'](childRow, dName);
					var descObj = false;
					if(item['descByRef'].hasOwnProperty(surface['uniqueId'])) {
						descObj = context['app']['findInArray'](item['descByRef'][surface['uniqueId']], 'descCode', dCode);						
					}
					console.log(descObj);
					if(!descObj) {
						descObj = createNewDesc(dCode);
						descObj['refId'] = surface['uniqueId'];
						writes.push(descObj);
					} else {
						descObj['active'] = 'Y';
					}
					
				})
			});
			
			Object.keys(item['descByRef']).forEach(function(ref) {
				item['descByRef'][ref].forEach(function(descObj) {
					writes.push(descObj)
				})
			})
			
			writes.forEach(function(descObj) {
				context['model']['xmlTemp'][dName].push(context['model']['formatUDO'](descObj, dName))
			})
		}
		
		commToWrite.forEach(function(comm) {
			hasChildren()
			item['commissions'].forEach(function(commObj) {
				if(commObj['id'] === comm['id'] 
				&& commObj['description'] === comm['description'] 
				&& commObj['type'] === comm['type']) {
					commObj['user'] = comm['user'];
					comm = commObj;
				}
			})
			context['model']['findCreateTable'](childRow, commTable);
			context['model']['xmlTemp'][commTable].push(context['model']['formatUDO'](comm, commTable))
		})
		
		if(!context['app']['objIsEmpty'](item['itemAddress'])) {
			context['model']['writeAddress'](item['itemAddress'], 'item', item['header']['uniqueId'])
		}
		
		function createLineNote() {
			var note = context['model']['newNoteModel'];
		}
			
		function createNewDesc(code) {
			var newDesc = {
				'active': 'Y',
				'descCode': code,
				'key': ''
			}
			return newDesc;
		}
		
		function hasChildren() {
			//we add child if it does not exist;
			if(!itemRow.hasOwnProperty('Children')) {
				childRow = context['model']['addChild'](itemRow);
			}
		}
	},
	
	findCreateTable: function(objPop, tableName) {
		var context = DAB.context();
		if(context['app']['searchArray'](objPop, 'Name', tableName) === false) {
			var table = context['model']['tableXML'](tableName);
			objPop.push(table[0]);
			context['model']['xmlTemp'][tableName] = table[1];
		}
	},
	
	createWOId: function(woKey) {
		var context = DAB.context();
		var leadZ = '';
		if(woKey === null) return '';
		if(woKey.length < 5) {
			for(var i = woKey.length; i < 6; i++) {
				leadZ += '0';
			}
		}
		var dabWo = context['currentModel']['workOrderHeader']['docType'] 
		+ '-' + context['app']['rightNow']().substring(8) + '-' + leadZ + woKey;
		return dabWo;
	},
	
	formatUDO: function(obj, tableName) {
		var context = DAB.context();
		var dictionary = {
			'@TSWORKORDER': {
				'pickupDate': 'U_DatePickup',
				'deliveryDate': 'U_DateDelivery',
				'cancelledDate': 'U_DateCancelled',
				'scheduledDate': 'U_DateScheduled',
				'scheduledPickup': 'U_DateToPickup',
				'scheduledDelivery': 'U_DateToDelivery',	
				'spDate': 'U_SPDate',
				'subTotal': 'U_SubTotal',
				'taxes': 'U_Taxes',
				'total': 'U_Total',
				'due': 'U_Due',
				'paidToDate': 'U_PaidToDate',
				'minimum': 'U_Minimum',
				'documentName': 'U_DocumentName',
				'cardCode': 'U_CardCode',
				'clientType': 'U_ClientType',
				'discountType': 'U_DiscountType',
				'orderType': 'U_OrderType',
				'docType': 'U_DocType',
				'docStatus': 'U_DocStatus',
				'invoiceKey': 'U_InvoiceKey',
				'poNum': 'U_PONum',
				'sidemark': 'U_Sidemark',
				'placedBy': 'U_PlacedBy',
				'refBy': 'U_RefBy',
				'cancelledBy': 'U_CancelledBy',
				'destinationCode': 'U_DestinationCode',
				'furnitureMoved': 'U_FurnitureMoved',
				'contactSelected': 'U_ContactSelected',
				'pickupAddrKey': 'U_PickupAddrKey',
				'deliveryAddrKey': 'U_DeliveryAddrKey',
				'serviceAddrKey': 'U_ServiceAddrKey',
				'servCoord': 'U_ServCoord',
				'spTime': 'U_SPTime',
				'hasMinimum': 'U_HasMinimum',
				'minimumCode': 'U_MinimumCode',
				'minimumWaived': 'U_MinimumWaived',
				'hasPermit': 'U_HasPermit',
				'servTimeStart': 'U_ServTimeStart',
				'servTimeEnd': 'U_ServTimeEnd',
				'servTimeHr': 'U_ServTimeHr',
				'servTimeMin': 'U_ServTimeMin',
				'travelTime': 'U_TravelTime',
				'taxCode': 'U_TaxCode',
				'totalOverwritten': 'U_TotalOverWrite',
				'taxOverwritten': 'U_TaxOverWrite',
				'createdBy': 'U_CreatedBy',
				'dateDue': 'U_DateDue',
				'dateInvoice': 'U_InvoiceDate',
				'hasPayment': 'U_HasPayment',
				'timeSpecial': 'U_TimeSpecial',
				'scheduleLimitation': 'U_ScheduleLimitation',
				'techRequested': 'U_TechRequested',
				'pickupTimeStart': 'U_PickupTimeStart',
				'pickupTimeEnd': 'U_PickupTimeEnd',
				'deliveryTimeStart': 'U_DeliveryTimeStart',
				'deliveryTimeEnd': 'U_DeliveryTimeEnd'
			},
			'@TSWOROW': {
				'dateReceived': 'U_DateReceived',
				'dateDue': 'U_DateDue',
				'scheduledPickup': 'U_DatePickup',
				'dateComplete': 'U_DateComplete',
				'scheduledDelivery': 'U_DateDelivery',
				'serviceAmt': 'U_ServiceAmt',
				'addServiceAmt': 'U_AdditionalAmt',
				'savings': 'U_Savings',
				'subTotal': 'U_SubTotal',
				'total': 'U_Total',
				'taxes': 'U_Taxes',
				'ftWidth': 'U_WidthFt', 
				'inWidth': 'U_WidthIn', 
				'ftHeight': 'U_HeightFt', 
				'inHeight': 'U_HeightIn',
				'unitTotal': 'U_UnitTotal',
				'quantity': 'U_Quantity',
				'mainSubTotal': 'U_ServiceAmtSubtotal',
				'additionalSubTotal': 'U_AddtlAmtSubtotal',
				'customDiscount': 'U_CustomDisc',
				'ratio': 'U_Ratio',
				'title': 'U_NameOfItem',
				'status': 'U_Status',
				'takenBy': 'U_TakenBy',
				'type': 'U_Type',
				'mainSelect': 'U_MainSelect',
				'subSelect': 'U_SubSelect',
				'materialSelect': 'U_MaterialSelect',
				'serviceSelect': 'U_ServiceSelect',
				'currentIndex': 'U_Index',
				'color1': 'U_Color1',
				'color2': 'U_Color2',
				'color3': 'U_Color3',
				'active': 'U_Active',
				'wpi': 'U_WPI',
				'poNum': 'U_PONum',
				'sidemark': 'U_Sidemark',
				'unitType': 'U_UnitType',
				'discountType': 'U_DiscountType',
				'receivedLoc': 'U_ReceivedLoc', 
				'serviceLoc': 'U_ServiceLoc',
				'returnedLoc': 'U_ReturnedLoc',
				'dimensionType': 'U_DimensionType',
				'pickedUp': 'U_PickedUp',
				'delivered': 'U_Delivered',
				'isDelivery': 'U_IsDelivery',
				'furnitureMoved': 'U_FurnitureMoved',
				'mainCode': 'U_MainCode',
				'uniqueId': 'U_UniqueId',
				'parentKey': 'U_ParentKey',
				'shapeCode': 'U_ShapeCode',
				'techRequested': 'U_TechRequested',
				'dateDueOverwritten': 'U_DateDueOW',
				'pickupTimeStart': 'U_PickupTimeStart',
				'pickupTimeEnd': 'U_PickupTimeEnd',
				'deliveryTimeStart': 'U_DeliveryTimeStart',
				'deliveryTimeEnd': 'U_DeliveryTimeEnd'
			},
			'@TSWOROWDETAIL': {
				'dateReceived': 'U_DateReceived',
				'dateDue': 'U_DateDue',
				'dateComplete': 'U_DateComplete',
				'ftWidth': 'U_WidthFt', 
				'inWidth': 'U_WidthIn', 
				'ftHeight': 'U_HeightFt', 
				'inHeight': 'U_HeightIn',
				'unitTotal': 'U_UnitTotal',
				'taxes': 'U_Taxes',
				'basePrice': 'U_BasePrice',
				'subTotal': 'U_SubTotal',
				'quantity': 'U_Quantity',
				'rate': 'U_Rate',
				'ratio': 'U_Ratio',
				'minAmt': 'U_MinAmt',
				'discountRate': 'U_DiscountRate',
				'taxRate': 'U_TaxRate',
				'status': 'U_Status',
				'discount': 'U_Discount',
				'nameOfItem': 'U_NameOfItem',
				'unitType': 'U_UnitType',
				'option1': 'U_Option1',
				'option2': 'U_Option2',
				'option3': 'U_Option3',
				'color': 'U_Color',
				'id': 'U_Id',
				'type': 'U_Type',
				'active': 'U_Active',
				'taxCode': 'U_TaxCode',
				'uniqueId': 'U_UniqueId',
				'referentialId': 'U_ReferentialId',
				'hasProtectant': 'U_HasProtectant',
				'container': 'U_Container',
				'cancelled': 'U_Cancelled',
				'dateDueOverwritten': 'U_DateDueOW'
			},
			'@TSWOROWDESCRIPTIVE': {
				'descCode': 'U_DescriptiveCode',
				'active': 'U_Active',
				'refId': 'U_ReferentialId'
			},
			'@TSADDRESS': {
				'ID': 'U_AddressBase',
				'Street': 'U_AddressInfo1',
				'Block': 'U_AddressInfo2',
				'City': 'U_City',
				'State': 'U_State',
				'Zip': 'U_Zip',
				'Type': 'U_Type',
				'U_Active': 'U_Active',
				'mainType': 'U_AddressType',
				'parentKey': 'U_ParentKey',
				'subKey': 'U_ParentSubKey'
			},
			'@TSUSERMANAGE': {
				'UserName': 'U_UserName', 
				'firstName': 'U_EmployeeFirst',
				'lastName': 'U_EmployeeLast', 
				'name': 'U_EmployeeName',
				'sales': 'U_SalesAssoc',
				'cleanTech': 'U_CleaningTech',
				'upholstery': 'U_Upholstery',
				'repTech': 'U_RepairTech',
				'rugCutter': 'U_RugCutTech',
				'padComm': 'U_CutReceivable',
				'servCoord': 'U_ServCoord',
				'admin': 'U_IsAdmin',
				'manager': 'U_IsManager',
				'active': 'U_Active',
				'password': 'U_EmployeePass'
			},
			'@TSDISPATCHWOEMP': {
				'type': 'U_Type',
				'id': 'U_EmployeeId',
				'parentKey': 'U_WONumber',
				'description': 'U_Description'
			},
			'@TSWOROWCOMISSION': {
				'type': 'U_RelatedType',		
				'id': 'U_RelatedKey',
				'user': 'U_CommisionID',
				'description': 'U_Description',
				'measure': 'U_ItemQuantity',
				'rate': 'U_CommisionPercent',
				'rateDist': 'U_CommPercentApply',
				'commTot': 'U_CommisionTotal',
				'commDist': 'U_UserSplit',
				'commAmt': 'U_CommisTotalApplied',
				'dateSet': 'U_CreatedDate'
			},
			'@TSMANAGERGROUP': {
				'managerCode': 'U_ManagerCode',
				'userCode': 'U_UserCode',
				'active': 'U_Active'
			}
		}
		var main = dictionary[tableName];
		var objToReturn = {
			'Fields': {}
		}
		Object.keys(main).forEach(function(attr) {
			if([null, undefined].indexOf(obj[attr]) === -1) {
				objToReturn['Fields'][main[attr]] = obj[attr]
			}
		})
		if(obj['key'] !== '') objToReturn['Key'] = obj['key'];
		return objToReturn;
	},
	
	tableXML: function(tableName) {
		var base = {
			'AcceptNullsAndEmptyStrings': '',
			'Name': tableName,
			'Row': []
		}
		return [base, base['Row']]
	},
	
	addChild: function(rowObj) {
		console.log(rowObj);
		rowObj['Children'] = {
			'UserTableEntry': []
		}
		return rowObj['Children']['UserTableEntry'];
	},
	
	setWorkOrderCopy: function(model) {
		var context = DAB.context();
		var datesReset = ['dateReceived', 'dateDue', 'scheduledPickup', 'dateComplete', 'scheduledDelivery'];
		var workOrderHeader = context['currentModel']['workOrderHeader'];
		context['currentModel']['workOrderHeader']['key'] = '';
		context['currentModel']['workOrderHeader']['docStatus'] = 'IP';
		context['currentModel']['workOrderHeader']['createdBy'] = context['currentUser']['name'];
		model['paymentApplied'] = [];
		var clientType = 'normal'
		if(context['model']['currentClient']['ClientInfo']['CustType'][0] === '2') {
			clientType = 'wholesale';
		}
		model['currentJobs'].forEach(function(item) {
			datesReset['forEach'](function(dateName) {
				if(item['header'].hasOwnProperty(dateName)) item['header'][dateName] = '';
			})
			item['header']['dateReceived'] = context['app']['rightNow']();
			item['header']['key'] = '';
			item['header']['status'] = 'IP'
			var iterateThru = ['mainServices', 'additionalServices', 'notes'];
			var resetToEmptyArray = ['descBackEnd', 'lineItemNotes', 'commissions'];
			iterateThru.forEach(function(container) {
				item[container].forEach(function(el) {
					el['key'] = '';
					datesReset['forEach'](function(dateName) {
						if(el.hasOwnProperty(dateName)) el[dateName] = '';
					})
					if(container !== 'notes' && el['active'] === 'Y' && el['type'] !== 'headerItem') {
						var selService = context['app']['searchForService'](el['id']);
						el['status'] = 'IP';
						el['active'] = 'Y';
						el['taxRate'] = QueryResponses['taxRates'][el['taxCode']]['Rate'];
						el['discountRate'] = context['app']['searchForDiscount'](clientType, workOrderHeader['orderType'], el['id']);
						el['rate'] = selService['Price'];
						el['minAmt'] = selService['U_MinAmt'];
					}
				})
			})
			if(context['model']['transitionTo'] === 'CS') {
				item['header']['discountType'] = 'CUSTOM';
				item['header']['customDiscount'] = 100;
				context['app']['setCustomDiscount'](item, 100);
			}
			resetToEmptyArray.forEach(function(name) {
				item[name] = [];
			})
		})
	},
	
	setCloneState: function(model) {
		var context = DAB.context();
		model['currentJobs'].forEach(function(item) {
			context['conf']['setRoutingCodes'](item['header']);
			item['header']['takenBy'] = context['currentUser']['User Number'];
			item['header']['pickedUp'] = 'N';
			item['header']['delivered'] = 'N';
			item['header']['techRequested'] = '';
			item['commissionWork'] = {
				'workBy': ['']
			}
			item['commissionPickup'] = {
				'base': ['']
			}
			item['commissionDelivery'] = {
				'base': ['']
			}
			item['descriptive'] = [];
			item['commissionAOS'] = {},
			item['commissions'] = [];
			item['notes'] = [];
			context['app']['setDueDates'](item);
		});
		var setEmpty = ['placedBy', 'contactSelected', 'servTimeHr', 'servTimeMin', 'travelTime'];
		setEmpty.forEach(function(attr) {
			model['workOrderHeader'][attr] = '';
		})
		model['notes'] = [];
		model['lineItemNotes'] = [];
	},
	
	createOCRDXML: function(bpObj, newClient) {
		var context = DAB.context();
		if(bpObj['Name'] === '') {
			bpObj['Name'] = bpObj['FirstName'] + ' ' + bpObj['LastName'];
		}
		var bpFields = {
			'Name': 'Name',
			'Phone1': 'Phone1',
			'Phone2': 'Phone2',
			'Cell': 'Cell',
			'Email': 'Email',
		}
		if(newClient) {
			var UDOFields = {
				'U_CustType': 'CustType',
				'U_ResalePermitNo': 'ResalePermit',
				'U_PermitExpDate': 'PermitExp',
				'U_EmailPref': 'EmailPref',
				// 'U_CustomerCode': 'Code',
				'U_Phone1Ext': 'U_Phone1Ext',
				'U_Phone2Ext': 'U_Phone2Ext',
				'U_CellExt': 'U_CellExt'
			}
		} else {
			var UDOFields = {
				'U_CustType': 'CustType',
				'U_ResalePermitNo': 'ResalePermit',
				'U_PermitExpDate': 'PermitExp',
				'U_EmailPref': 'EmailPref',
				// 'U_CustomerCode': 'CustomCode',
				'U_Phone1Ext': 'U_Phone1Ext',
				'U_Phone2Ext': 'U_Phone2Ext',
				'U_CellExt': 'U_CellExt',
				'U_Phone1Textable': 'Phone1Textable',
				'U_Phone2Textable': 'Phone2Textable',
				'U_CellTextable': 'CellTextable',
				'U_PreferredNumberDef': 'PrefNum'
			}			
		}
		
		var fieldObj = {
			'BP': {
				'AcceptNullsAndEmptyStrings': '',
				'UDFs': {},
			}
		};
		Object.keys(bpFields).forEach(function(col) {
			if(bpObj[col] !== null && typeof bpObj[col] !== 'object') {
				fieldObj['BP'][bpFields[col]] = bpObj[col]
			}
		});
		Object.keys(UDOFields).forEach(function(col) {
			if(bpObj[UDOFields[col]] !== null && typeof bpObj[UDOFields[col]] !== 'object') {
				if(col === 'U_PermitExpDate' && bpObj[UDOFields[col]] !== '') {
					bpObj[UDOFields[col]] = Utility.formatDate(bpObj[UDOFields[col]], true);
				}
				fieldObj['BP']['UDFs'][col] = bpObj[UDOFields[col]]
			}
		});
		
		if(!newClient) {
			if(bpObj['CardCode'] !== bpObj['CustomCode']) {
				fieldObj['BP']['UDFs']['U_HasCustomCode'] = 'Y';
				fieldObj['BP']['UDFs']['U_CustomerCode'] = bpObj['CustomCode'];
			} else {
				fieldObj['BP']['UDFs']['U_HasCustomCode'] = 'N'
			}
		}

		return fieldObj;
	},
	
	createOCPRXML: function(cntct) {
		console.log(cntct);
		var context = DAB.context();
		cntct['ID'] = cntct['First'] + ' ' + cntct['Last'];
		var contactFields = {
			'ID': 'ID',
			'First': 'First',
			'Last': 'Last',
			'Position': 'Position',
			'Phone': 'Phone',
			'Phone2': 'Phone2',
			'Cell': 'Cell',
			'Email': 'Email',
			'Fax': 'Fax'
		};

		UDOFields = {
			'U_Active': 'Active',
			'U_Tel1Ext': 'PhoneExt',
			'U_Tel2Ext': 'Phone2Ext',
			'U_CellolarExt': 'CellExt',
			'U_PreferredNumberDef': 'PreferredNumberDef',
			'U_Phone1Textable': 'Phone1Textable',
			'U_Phone2Textable': 'Phone2Textable',
			'U_CellTextable': 'CellTextable'
		}

		var fieldObj = {
			'UDFs': {}
		};
		
		Object.keys(contactFields).forEach(function(col) {
			if(cntct[col] !== '' && cntct[col] !== null && typeof cntct[col] !== 'undefined') {
				fieldObj[contactFields[col]] = cntct[col];					
			}
		});
		Object.keys(UDOFields).forEach(function(col) {
			if(cntct[UDOFields[col]] !== '' && cntct[UDOFields[col]] !== null && typeof cntct[UDOFields[col]] !== 'undefined') {
				fieldObj['UDFs'][col] = cntct[UDOFields[col]];					
			}
		});
		return [fieldObj];
	},
	
	createCRD1XML: function(addr) {
		var context = DAB.context();
		var addressFields = {
			'Code': 'ID',
			'Address': 'Street',
			'AddressLine2': 'Block',
			'City': 'City',
			'State': 'State',
			'Zipcode': 'Zipcode'
		};
		var shipAndBill = ['S', 'B'].map(function(type) {
			var fieldObj = {
				'UDFs': {}
			};
			Object.keys(addressFields).forEach(function(col) {
				if(addr[col] !== '' && addr[col] !== null && typeof addr[col] !== 'undefined') {
					fieldObj[addressFields[col]] = addr[col];
				}
			})
			fieldObj['Type'] = type;
			fieldObj['UDFs']['U_Active'] = addr['Active'];
			return fieldObj;
		})
		return shipAndBill;
	},
	
	disableClient: function(model) {
		context = DAB.context();
		var xmlObj = {
			'BP': {
				'AcceptNullsAndEmptyStrings': '',
				'CardCode': model['ClientInfo']['CardCode'],
				'frozenFor': 'Y'
			}
		}
		var xml = Utility.objectToXML(xmlObj, 'Objects');
		Websocket.direct(xml, 'false', 'xml').then(function(res) {
			context['app']['setRoute'](['search']);			
		})
	},
	
	notesBaseXML: function(row) {
		var context = DAB.context();
		var fields = {
			'active': 'U_Active',
			'created_by': 'U_CreatedBy',
			'created_on': 'U_CreatedDate',
			'type': 'U_NoteType',
			'text': 'U_Note',
			'parentKey': 'U_ParentKey',
			'parentType': 'U_ParentType',
			'subKey': 'U_ParentSubKey',
			'foreignKey': 'U_ForeignKey',
			'updated_by': 'U_UpdatedBy'
		}
		var fieldObj = context['model']['fieldBase'](row, fields);
		
		if(row.hasOwnProperty('key')) {
			fieldObj['Key'] = row['key'];
		}
		console.log(fieldObj);
		return fieldObj;
	},
	
	fieldBase: function(row, fieldDict) {
		var fieldObj = {
			'Fields': {}
		};
		var newRow = fieldObj['Fields'];
		Object.keys(fieldDict).forEach(function(col) {
			if(row[col] !== undefined) newRow[fieldDict[col]] = row[col];
		})
		return fieldObj;
	},
	
	sapBase: function(lines) {
		var context = DAB.context();
		var baseDoc = 'SalesOrder';
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		if(workOrderHeader['docType'] === 'SP') {
			baseDoc = 'Quote'
		}
		// if(workOrderHeader['docStatus'] === 'IC') {
			// baseDoc = 'ARInvoice'
		// }
		var xml = {}
		xml[baseDoc] = {
			'CardCode': workOrderHeader['cardCode'],
			'Line': [],
			'DueDate': '01/24/2016',
			'UDFs': {
				'U_TsWrkOrdrKey': workOrderHeader['key']
			},
			'DocTotal': context['app']['rounder'](workOrderHeader['total'])
		}
		var linesXML = lines.map(function(line) {
			return context['model']['sapLine'](line)
		})
		var sapKey = context['model']['currentModel']['sapDocEntry']; 
		if(sapKey !== false) {
			xml[baseDoc]['Key'] = sapKey; 
		}
		xml[baseDoc]['Line'] = linesXML;
		return xml;
	},
	
	sapLine: function(item) {
		var context = DAB.context();
		var sapLines = context['model']['currentModel']['sapLines'];
		var itemQty = item['quantity'];
		var rate = item['rate'];
		if(itemQty <= 0) {
			rate = 0;
			itemQty = 1;
		}
		var line = {
			'Item': item['id'],		
			'Qty': itemQty,
			'UnitPrice': rate,
			'Taxcode': item['taxCode'],
			'UDFs': {}
		};
		if(typeof item['disocuntRate'] === 'undefined') item['disocuntRate'] = 0;
		var rate = context['app']['rounder'](item['rate'] * (1 - item['discountRate']));
		line['UnitPrice'] = rate;
		var udf = {
			'uniqueId': 'U_TSLineKey'
		};
		Object.keys(udf).forEach(function(field) {
			line['UDFs'][udf[field]] = item[field];
		});
		if(sapLines !== false) {
			sapLines.forEach(function(sapLine) {
				if(item['uniqueId'] === sapLine['uniqueId']) {
					line['Key'] = sapLine['key'];
				}
			});
		}
		return line;
	},
	
	createInvoiceDoc: function(lines, docEntry) {
		var context = DAB.context();
		var invoice = {
			'ARInvoice': {
				'CardCode': context['model']['currentModel']['workOrderHeader']['cardCode'],
				'Line': [],
				'AppliedDownPayment': []
			}
		}
		lines.forEach(function(line, i) {
			invoice['ARInvoice']['Line'].push({
				'BaseType': 'SalesOrder',
				'BaseLineNum': i,
				'BaseDocEntry': docEntry
			})
		})
		context['model']['currentModel']['paymentApplied'].forEach(function(payment) {
			if(payment['type'] === 'gift') return;
			invoice['ARInvoice']['AppliedDownPayment'].push({
				'DownPaymentKey': payment['docEntry'],
				'DrawAmount': payment['amount']
			})
		});
		var inv = Utility.objectToXML(invoice, 'Objects');
		var createInvoice = Websocket.direct(inv, false, 'xml');
		createInvoice.then(function(res) {
			var invKey = res['Data']['Results'][0]['Key'];
			context['currentModel']['invoiceDocEntry'] = invKey;
			// context['model']['modalOption'] = 'invoicePanel';
			context['model']['currentModel']['workOrderHeader']['viewOnly'] = true;
			context['model']['stateLoaded'] = true;
			context['app']['reDraw']();
		})
	},
	
	createDownPayment: function(lines, salesOrderKey, paymentObj) {
		var context = DAB.context();
		if(paymentObj['hasOwnProperty']('docEntry')) {
			return Promise.resolve({'docEntry': paymentObj['docEntry']});
		}
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		var downPayment = {
			'ARDownPayment': {
				'CardCode': workOrderHeader['cardCode'],
				'DownPaymentType': 'Invoice',
				'DownPaymentAmount': paymentObj['amount'],
				'Line': [],
				'IncomingPayment': {
					'Payments': {},
					'UDFs': {}
				}
			}
		}
		lines.forEach(function(line, i ) {
			var lineObj = {
				'BaseType': 'SalesOrder',
				'BaseLineNum': i,
				'BaseDocEntry': salesOrderKey
			}
			downPayment['ARDownPayment']['Line'].push(lineObj);		
		});
		var incPayment = downPayment['ARDownPayment']['IncomingPayment']
		return context['model']['createPayment'](downPayment, incPayment, paymentObj) 
	},
	
	createInvoicePayment: function() {
		var context = DAB.context();
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		var payArray = [];
		context['model']['stateLoaded'] = false;
		context['model']['modalOption'] = '';
		context['app']['reDraw']();
		context['model']['currentModel']['paymentApplied'].forEach(function(payment) {
			if(payment.hasOwnProperty('docEntry') || payment['type'] === 'gift') return;
			var standardPayment = {
				'IncomingPayment': {
					'CardCode': workOrderHeader['cardCode'],
					'Documents': {
						'Document': {
							'DocEntry': context['currentModel']['invoiceDocEntry'],
							'InvoiceType': 'Invoices',
							'AppliedAmount': payment['amount']
						}
					},
					'Payments': {},
					'UDFs': {}
				}
			}
			payArray.push(context['model']['createPayment'](standardPayment, standardPayment['IncomingPayment'], payment));
		});
		return Promise.all(payArray);
	},
	
	createPayment: function(paymentParent, incPayment, paymentObj) {
		var context = DAB.context();
		var paymentLoc = incPayment['Payments'];
		if(paymentObj['hasOwnProperty']('docEntry')) {
			return Promise.resolve({'docEntry': paymentObj['docEntry']});
		}
		var workOrderHeader = context['model']['currentModel']['workOrderHeader'];
		var paymentTypes = {
			'cash': 'Cash',
			'check': 'CheckPayment',
			'cc': 'Bank'
		}
		paymentLoc[paymentTypes[paymentObj['type']]] = {
			'Amount': paymentObj['amount'],
			'GLAccountCode': '_SYS00000000157'
		};
		var dPayment = paymentLoc[paymentTypes[paymentObj['type']]];
		if(paymentObj['type'] === 'cc') {
			dPayment['GLAccountCode'] =  '_SYS00000000313';
			dPayment['EffectiveDate'] = context['app']['rightNow']();
			dPayment['Reference'] = paymentObj['reference']
			incPayment['UDFs']['U_Reference'] = paymentObj['month'] + '/' + paymentObj['year'];
		}
		if(paymentObj['type'] === 'check') {
			dPayment['GLAccountCode'] = '_SYS00000000315';
			dPayment['CountryCode'] = 'US';
			dPayment['CheckNum'] = paymentObj['reference'];
			dPayment['BankCode'] =  'BOA';
		}
		incPayment['UDFs']['U_SubmittedBy'] = paymentObj['userId'];
		var payment = Utility.objectToXML(paymentParent, 'Objects');
		console.log(payment);
		var sendPayment = Websocket.direct(payment, false, 'xml');
		return sendPayment;
	},
	
	saveUser: function(userObj) {
		var context = DAB.context();
		var tName = '@TSUSERMANAGE';
		var base = {
			'UserTableEntry': []
		}
		context['model']['xmlTemp'] = {
			'mainXML': base
		};
		var userXML = context['model']['tableXML'](tName);
		userXML[1].push(context['model']['formatUDO'](userObj, tName));
		context['model']['xmlTemp']['mainXML']['UserTableEntry'].push(userXML[0]);
		var user = Utility.objectToXML(context['model']['xmlTemp']['mainXML'], 'Objects');
		var userWrite = Websocket.direct(user, false, 'xml');
		console.log(userWrite);
		context['currentModel']['userSelected'] = '';
		context['app']['reDraw']();
		userWrite.then(function(res) {
			context['currentModel']['isLoading'] = false;
			context['app']['reDraw']();
			context['app']['users']();
		});
	},
	
	saveManagerGroup: function() {
		var context = DAB.context();
		var tName = '@TSMANAGERGROUP';
		var base = {
			'UserTableEntry': []
		}
		context['model']['xmlTemp'] = {
			'mainXML': base
		};
		var userXML = context['model']['tableXML'](tName);
		var groupsToWrite = [];
		context['currentModel']['group'].forEach(function(group,i) {
			if(group !== '') {
				var currentWrite = context['currentModel']['currentGroups'][i] 
				if(typeof currentWrite !== 'undefined') {
					currentWrite['userCode'] = group;
					currentWrite['active'] = 'Y';
					groupsToWrite.push(currentWrite);
				} else {
					groupsToWrite.push(createNewGroup(group));
				}
			}
		});
		var groupLength = context['currentModel']['group'].length;
		var currentLength = context['currentModel']['currentGroups'].length
		if(currentLength > groupLength) {
			var i = groupLength;
			for(i; i < currentLength; i++) {
				console.log(i);
				context['currentModel']['currentGroups'][i]['active'] = 'N';
				groupsToWrite.push(context['currentModel']['currentGroups'][i]);
			}
		}
		groupsToWrite.forEach(function(obj) {
			userXML[1].push(context['model']['formatUDO'](obj, tName));			
		})
		context['model']['xmlTemp']['mainXML']['UserTableEntry'].push(userXML[0]);
		var user = Utility.objectToXML(context['model']['xmlTemp']['mainXML'], 'Objects');
		console.log(user)
		var userWrite = Websocket.direct(user, false, 'xml');
		context['currentModel']['currentGroups'] = 'isLoading';
		context['currentModel']['group'] = ['']
		context['app']['reDraw']();
		userWrite.then(function(res) {
			context['app']['loadGroups'](context['currentModel']['userObj']['key']);
		})
		
		function createNewGroup(code) {
			return {
				'managerCode': context['currentModel']['userObj']['key'],
				'userCode': code,
				'active': 'Y',
				'key': ''
			}
		}
	},
	
	saveCommission: function(e) {
		e.stopPropagation();
		var context = DAB.context();
		var comm = context['currentModel']['selectedComm'];
		var base = {
			'UserTableEntry': {
				'Name': '@TSWOROW',
				'Row': {
					'Key': context['currentModel']['selectedComm']['parentKey'],
					'Children': {
						'UserTableEntry': {
							'Name': '@TSWOROWCOMISSION',
							'Row': {
								'Key': context['currentModel']['selectedComm']['key'],
								'Fields': {}
							}
						}
					}
					
				}
			}
		}
		var fields = base['UserTableEntry']['Row']['Children']['UserTableEntry']['Row']['Fields'];
		var dictionary = {
			'overWrite': 'U_OverrideBy',
			'commOrig': 'U_CommisionOriginal',
			'commAmt': 'U_CommisTotalApplied'
		}
		Object.keys(dictionary).forEach(function(attr) {
			if(attr !== 'overWrite') {
				fields[dictionary[attr]] = parseFloat(comm[attr]);				
			} else {
				fields[dictionary[attr]] = comm[attr];
			}
		})
		var xml = Utility.objectToXML(base, 'Objects');
		console.log(xml);
		var commissionSet = Websocket.direct(xml, false, 'xml');
		context['model']['table'].unDraw();
		context['model']['tableLoading'] = true;
		context['currentModel']['selectedComm'] = '';
		context['app']['reDraw']();
		commissionSet.then(function(res) {		
			context['app']['createCommissionTable'](context['currentModel']['lastSearch'])
		})
		
	}
}